/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import java.io.PrintStream;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoSystemCommand
extends BaseJdmpviewCommand {
    public InfoSystemCommand() {
        this.addCommand("info sys", "", "shortened form of info system");
        this.addCommand("info system", "", "displays information about the system the core dump is from");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        if (stringArray.length != 0) {
            printStream.println("\"info system\" command does not take any parameters");
            return;
        }
        this.doCommand();
    }

    public void doCommand() {
        Object object;
        try {
            this.out.println("\nMachine OS:\t" + this.ctx.getImage().getSystemType());
        }
        catch (DataUnavailable dataUnavailable) {
            this.out.println("\nMachine OS:\tdata unavailable");
        }
        catch (CorruptDataException corruptDataException) {
            this.out.println("\nMachine OS:\tdata corrupted");
        }
        Properties properties = this.ctx.getImage().getProperties();
        if (properties.containsKey("Hypervisor")) {
            this.out.println("Hypervisor:\t" + properties.getProperty("Hypervisor"));
        }
        try {
            this.out.println("Machine name:\t" + this.ctx.getImage().getHostName());
        }
        catch (DataUnavailable dataUnavailable) {
            this.out.println("Machine name:\tdata unavailable");
        }
        catch (CorruptDataException corruptDataException) {
            this.out.println("Machine name:\tdata corrupted");
        }
        this.out.println("Machine IP address(es):");
        try {
            Iterator iterator = this.ctx.getImage().getIPAddresses();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof InetAddress) {
                    this.out.println("\t\t" + ((InetAddress)e).getHostAddress());
                    continue;
                }
                if (!(e instanceof CorruptData)) continue;
                this.out.println("\t\tdata corrupted");
            }
        }
        catch (DataUnavailable dataUnavailable) {
            this.out.println("\t\tdata unavailable");
        }
        try {
            this.out.println("System memory:\t" + this.ctx.getImage().getInstalledMemory());
        }
        catch (DataUnavailable dataUnavailable) {
            this.out.println("System memory:\tdata unavailable");
        }
        try {
            long l = this.ctx.getImage().getCreationTime();
            if (l != 0L) {
                String[] stringArray = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
                object = stringArray.format(new Date(l));
                this.out.println("\nDump creation time: " + (String)object);
            } else {
                this.out.println("\nDump creation time: data unavailable");
            }
        }
        catch (DataUnavailable dataUnavailable) {
            this.out.println("\nDump creation time: data unavailable");
        }
        try {
            long l = this.ctx.getImage().getCreationTimeNanos();
            if (l != 0L) {
                this.out.println("Dump creation time (nanoseconds): " + l);
            } else {
                this.out.println("Dump creation time (nanoseconds): data unavailable");
            }
        }
        catch (DataUnavailable dataUnavailable) {
            this.out.println("Dump creation time (nanoseconds): data unavailable");
        }
        catch (CorruptDataException corruptDataException) {
            this.out.println("Dump creation time (nanoseconds): data corrupted");
        }
        JavaRuntime javaRuntime = this.ctx.getRuntime();
        this.out.println("\nJava version:");
        if (javaRuntime == null) {
            this.out.println("\tmissing, unknown or unsupported JRE");
        } else {
            try {
                this.out.println(javaRuntime.getVersion());
            }
            catch (CorruptDataException corruptDataException) {
                this.out.println("version data corrupted");
            }
            try {
                long l = javaRuntime.getStartTime();
                if (l != 0L) {
                    object = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
                    String string = ((DateFormat)object).format(new Date(l));
                    this.out.println("\nJVM start time: " + string);
                } else {
                    this.out.println("\nJVM start time: data unavailable");
                }
            }
            catch (DataUnavailable dataUnavailable) {
                this.out.println("\nJVM start time: data unavailable");
            }
            catch (CorruptDataException corruptDataException) {
                this.out.println("\nJVM start time (nanoseconds): data corrupted");
            }
            try {
                long l = javaRuntime.getStartTimeNanos();
                if (l != 0L) {
                    this.out.println("JVM start time (nanoseconds): " + l);
                } else {
                    this.out.println("JVM start time (nanoseconds): data unavailable");
                }
            }
            catch (DataUnavailable dataUnavailable) {
                this.out.println("JVM start time (nanoseconds): data unavailable");
            }
            catch (CorruptDataException corruptDataException) {
                this.out.println("JVM start time (nanoseconds): data corrupted");
            }
        }
        boolean bl = false;
        for (String string : new String[]{"/proc/sys/kernel/sched_compat_yield", "/proc/sys/kernel/core_pattern", "/proc/sys/kernel/core_uses_pid"}) {
            if (!properties.containsKey(string)) continue;
            if (!bl) {
                this.out.println("\nLinux Kernel Settings:");
            }
            this.out.println(string + " = " + properties.getProperty(string));
            bl = true;
        }
        this.out.println();
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("displays information about the system the core dump is from\n\nparameters: none\n\nprints information about the system the core dump is from:\n  - operating system\n  - host name and IP addresses\n  - amount of memory\n  - virtual machine(s) present\n");
    }
}

