/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.lang.ArgumentHelper;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.ReflectPermissions;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.VM;
import com.ibm.oti.vm.VMLangAccess;
import java.io.Serializable;
import java.lang.invoke.CacheKey;
import java.lang.invoke.CatchHandle;
import java.lang.invoke.ConstantHandle;
import java.lang.invoke.ConstructorHandle;
import java.lang.invoke.ConvertHandle;
import java.lang.invoke.DefaultMethodConflictException;
import java.lang.invoke.DirectHandle;
import java.lang.invoke.ExplicitCastHandle;
import java.lang.invoke.FieldGetterHandle;
import java.lang.invoke.FieldSetterHandle;
import java.lang.invoke.FilterArgumentsHandle;
import java.lang.invoke.FilterReturnHandle;
import java.lang.invoke.FoldHandle;
import java.lang.invoke.GuardWithTestHandle;
import java.lang.invoke.HandleCache;
import java.lang.invoke.Insert1Handle;
import java.lang.invoke.Insert1IntHandle;
import java.lang.invoke.Insert2Handle;
import java.lang.invoke.Insert3Handle;
import java.lang.invoke.InsertHandle;
import java.lang.invoke.InterfaceHandle;
import java.lang.invoke.InvokeGenericHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandleInfoImpl;
import java.lang.invoke.MethodType;
import java.lang.invoke.OpenJDKCompileStub;
import java.lang.invoke.PrimitiveHandle;
import java.lang.invoke.SecurityFrameInjector;
import java.lang.invoke.StaticFieldGetterHandle;
import java.lang.invoke.StaticFieldSetterHandle;
import java.lang.invoke.VarargsCollectorHandle;
import java.lang.invoke.VirtualHandle;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import sun.reflect.CallerSensitive;
import sun.security.util.SecurityConstants;

public class MethodHandles {
    static final int[] EMPTY_ARG_POSITIONS = new int[0];

    @CallerSensitive
    static final native Class<?> getStackClass(int var0);

    MethodHandles() {
    }

    static MethodHandle filterArgument(MethodHandle methodHandle, int n, MethodHandle methodHandle2) {
        return MethodHandles.filterArguments(methodHandle, n, methodHandle2);
    }

    @CallerSensitive
    public static Lookup lookup() {
        Class<?> clazz = MethodHandles.getStackClass(1);
        return new Lookup(clazz);
    }

    public static Lookup publicLookup() {
        return Lookup.PUBLIC_LOOKUP;
    }

    public static <T extends Member> T reflectAs(Class<T> clazz, MethodHandle methodHandle) throws SecurityException, NullPointerException, IllegalArgumentException, ClassCastException {
        if (null == clazz || null == methodHandle) {
            throw new NullPointerException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (null != securityManager) {
            securityManager.checkPermission(ReflectPermissions.permissionSuppressAccessChecks);
        }
        MethodHandleInfo methodHandleInfo = Lookup.IMPL_LOOKUP.revealDirect(methodHandle);
        T t = methodHandleInfo.reflectAs(clazz, Lookup.IMPL_LOOKUP);
        return t;
    }

    public static MethodHandle exactInvoker(MethodType methodType) throws IllegalArgumentException {
        return methodType.getInvokeExactHandle();
    }

    public static MethodHandle invoker(MethodType methodType) throws IllegalArgumentException {
        methodType.getClass();
        return new InvokeGenericHandle(methodType);
    }

    public static MethodHandle spreadInvoker(MethodType methodType, int n) throws IllegalArgumentException, NullPointerException {
        int n2 = methodType.parameterCount();
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException(Msg.getString("K039c"));
        }
        MethodHandle methodHandle = MethodHandles.invoker(methodType);
        int n3 = n2 - n;
        return methodHandle.asSpreader(Object[].class, n3);
    }

    public static MethodHandle guardWithTest(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) throws NullPointerException, IllegalArgumentException {
        MethodType methodType = methodHandle.type;
        MethodType methodType2 = methodHandle2.type;
        MethodType methodType3 = methodHandle3.type;
        if (methodType2 != methodType3) {
            throw new IllegalArgumentException();
        }
        int n = methodType.parameterCount();
        if (methodType.returnType != Boolean.TYPE || n > methodType2.parameterCount()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < n; ++i) {
            if (methodType.arguments[i] == methodType2.arguments[i]) continue;
            throw new IllegalArgumentException();
        }
        MethodHandle methodHandle4 = GuardWithTestHandle.get(methodHandle, methodHandle2, methodHandle3);
        return methodHandle4;
    }

    public static MethodHandle catchException(MethodHandle methodHandle, Class<? extends Throwable> clazz, MethodHandle methodHandle2) throws NullPointerException, IllegalArgumentException {
        if (methodHandle == null || clazz == null || methodHandle2 == null) {
            throw new NullPointerException();
        }
        if (!Throwable.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(clazz.getName());
        }
        MethodType methodType = methodHandle.type;
        MethodType methodType2 = methodHandle2.type;
        if (methodType.returnType != methodType2.returnType) {
            throw new IllegalArgumentException();
        }
        if (methodType2.parameterType(0) != clazz) {
            throw new IllegalArgumentException();
        }
        int n = methodType2.parameterCount();
        if (n - 1 > methodType.parameterCount()) {
            throw new IllegalArgumentException();
        }
        Class<?>[] classArray = methodType.arguments;
        Class<?>[] classArray2 = methodType2.arguments;
        for (int i = 1; i < n; ++i) {
            if (classArray2[i] == classArray[i - 1]) continue;
            throw new IllegalArgumentException();
        }
        MethodHandle methodHandle3 = MethodHandles.buildTransformHandle(new CatchHelper(methodHandle.asFixedArity(), methodHandle2.asFixedArity(), clazz), methodType);
        CatchHandle catchHandle = CatchHandle.get(methodHandle, clazz, methodHandle2, methodHandle3);
        assert (catchHandle.type() == methodHandle3.type());
        methodHandle3 = catchHandle;
        return methodHandle3;
    }

    public static MethodHandle identity(Class<?> clazz) throws NullPointerException, IllegalArgumentException {
        if (clazz == Void.TYPE) {
            throw new IllegalArgumentException();
        }
        try {
            MethodType methodType = MethodType.methodType(clazz, clazz);
            if (clazz.isPrimitive()) {
                return Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, "identity", methodType);
            }
            MethodHandle methodHandle = Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, "identity", MethodType.methodType(Object.class, Object.class));
            return methodHandle.cloneWithNewType(methodType);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new Error(reflectiveOperationException);
        }
    }

    private static boolean identity(boolean bl) {
        return bl;
    }

    private static byte identity(byte by) {
        return by;
    }

    private static short identity(short s) {
        return s;
    }

    private static char identity(char c) {
        return c;
    }

    private static int identity(int n) {
        return n;
    }

    private static float identity(float f) {
        return f;
    }

    private static double identity(double d) {
        return d;
    }

    private static long identity(long l) {
        return l;
    }

    private static Object identity(Object object) {
        return object;
    }

    public static MethodHandle constant(Class<?> clazz, Object object) throws NullPointerException, ClassCastException, IllegalArgumentException {
        clazz.getClass();
        if (clazz == Void.TYPE) {
            throw new IllegalArgumentException();
        }
        if (clazz.isPrimitive()) {
            if (object == null) {
                throw new IllegalArgumentException();
            }
            Class<?> clazz2 = MethodType.unwrapPrimitive(object.getClass());
            if (clazz != clazz2 && !ConvertHandle.FilterHelpers.checkIfWideningPrimitiveConversion(clazz2, clazz)) {
                throw new ClassCastException();
            }
        } else {
            clazz.cast(object);
        }
        return ConstantHandle.get(clazz, object);
    }

    public static MethodHandle arrayElementGetter(Class<?> clazz) throws IllegalArgumentException {
        if (!clazz.isArray()) {
            throw new IllegalArgumentException();
        }
        try {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                String string = clazz2.getCanonicalName();
                MethodType methodType = MethodType.methodType(clazz2, clazz, Integer.TYPE);
                return Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, string + "ArrayGetter", methodType);
            }
            MethodType methodType = MethodType.methodType(Object.class, Object[].class, Integer.TYPE);
            MethodHandle methodHandle = Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, "objectArrayGetter", methodType);
            MethodType methodType2 = MethodType.methodType(clazz2, clazz, Integer.TYPE);
            return methodHandle.cloneWithNewType(methodType2);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new Error(reflectiveOperationException);
        }
    }

    public static MethodHandle arrayElementSetter(Class<?> clazz) throws IllegalArgumentException {
        if (!clazz.isArray()) {
            throw new IllegalArgumentException();
        }
        try {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                String string = clazz2.getCanonicalName();
                MethodType methodType = MethodType.methodType(Void.TYPE, clazz, Integer.TYPE, clazz2);
                return Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, string + "ArraySetter", methodType);
            }
            MethodType methodType = MethodType.methodType(Void.TYPE, Object[].class, Integer.TYPE, Object.class);
            MethodHandle methodHandle = Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, "objectArraySetter", methodType);
            MethodType methodType2 = MethodType.methodType(Void.TYPE, clazz, Integer.TYPE, clazz2);
            return methodHandle.cloneWithNewType(methodType2);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new Error(reflectiveOperationException);
        }
    }

    public static MethodHandle throwException(Class<?> clazz, Class<? extends Throwable> clazz2) {
        MethodType methodType = MethodType.methodType(clazz, clazz2);
        try {
            MethodHandle methodHandle;
            if (clazz.isPrimitive() || clazz.equals(Void.TYPE)) {
                MethodType methodType2 = MethodType.methodType(clazz, Throwable.class);
                String string = clazz.getCanonicalName();
                methodHandle = Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, string + "ExceptionThrower", methodType2);
            } else {
                MethodType methodType3 = MethodType.methodType(Object.class, Throwable.class);
                methodHandle = Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, "objectExceptionThrower", methodType3);
            }
            return methodHandle.cloneWithNewType(methodType);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new Error(reflectiveOperationException);
        }
    }

    public static MethodHandle filterReturnValue(MethodHandle methodHandle, MethodHandle methodHandle2) throws NullPointerException, IllegalArgumentException {
        MethodType methodType = methodHandle2.type;
        int n = methodType.parameterCount();
        Class<?> clazz = methodHandle.type.returnType;
        if (clazz == Void.TYPE && n == 0) {
            return new FilterReturnHandle(methodHandle, methodHandle2);
        }
        if (n == 1 && methodType.parameterType(0) == methodHandle.type.returnType) {
            return new FilterReturnHandle(methodHandle, methodHandle2);
        }
        throw new IllegalArgumentException();
    }

    private static void voidExceptionThrower(Throwable throwable) throws Throwable {
        throw throwable;
    }

    private static int intExceptionThrower(Throwable throwable) throws Throwable {
        throw throwable;
    }

    private static char charExceptionThrower(Throwable throwable) throws Throwable {
        throw throwable;
    }

    private static byte byteExceptionThrower(Throwable throwable) throws Throwable {
        throw throwable;
    }

    private static boolean booleanExceptionThrower(Throwable throwable) throws Throwable {
        throw throwable;
    }

    private static short shortExceptionThrower(Throwable throwable) throws Throwable {
        throw throwable;
    }

    private static long longExceptionThrower(Throwable throwable) throws Throwable {
        throw throwable;
    }

    private static double doubleExceptionThrower(Throwable throwable) throws Throwable {
        throw throwable;
    }

    private static float floatExceptionThrower(Throwable throwable) throws Throwable {
        throw throwable;
    }

    private static Object objectExceptionThrower(Throwable throwable) throws Throwable {
        throw throwable;
    }

    private static int intArrayGetter(int[] nArray, int n) {
        return nArray[n];
    }

    private static char charArrayGetter(char[] cArray, int n) {
        return cArray[n];
    }

    private static short shortArrayGetter(short[] sArray, int n) {
        return sArray[n];
    }

    private static byte byteArrayGetter(byte[] byArray, int n) {
        return byArray[n];
    }

    private static long longArrayGetter(long[] lArray, int n) {
        return lArray[n];
    }

    private static double doubleArrayGetter(double[] dArray, int n) {
        return dArray[n];
    }

    private static float floatArrayGetter(float[] fArray, int n) {
        return fArray[n];
    }

    private static boolean booleanArrayGetter(boolean[] blArray, int n) {
        return blArray[n];
    }

    private static Object objectArrayGetter(Object[] objectArray, int n) {
        return objectArray[n];
    }

    private static void intArraySetter(int[] nArray, int n, int n2) {
        nArray[n] = n2;
    }

    private static void charArraySetter(char[] cArray, int n, char c) {
        cArray[n] = c;
    }

    private static void shortArraySetter(short[] sArray, int n, short s) {
        sArray[n] = s;
    }

    private static void byteArraySetter(byte[] byArray, int n, byte by) {
        byArray[n] = by;
    }

    private static void longArraySetter(long[] lArray, int n, long l) {
        lArray[n] = l;
    }

    private static void doubleArraySetter(double[] dArray, int n, double d) {
        dArray[n] = d;
    }

    private static void floatArraySetter(float[] fArray, int n, float f) {
        fArray[n] = f;
    }

    private static void booleanArraySetter(boolean[] blArray, int n, boolean bl) {
        blArray[n] = bl;
    }

    private static void objectArraySetter(Object[] objectArray, int n, Object object) {
        objectArray[n] = object;
    }

    public static MethodHandle filterArguments(MethodHandle methodHandle, int n, MethodHandle ... methodHandleArray) throws NullPointerException, IllegalArgumentException {
        MethodHandle methodHandle2;
        int n2;
        methodHandleArray.getClass();
        MethodType methodType = methodHandle.type;
        if (n < 0 || n + methodHandleArray.length > methodType.parameterCount()) {
            throw new IllegalArgumentException();
        }
        if (methodHandleArray.length == 0) {
            return methodHandle;
        }
        methodHandleArray = (MethodHandle[])methodHandleArray.clone();
        Class<?>[] classArray = methodType.parameterArray();
        boolean bl = false;
        for (n2 = 0; n2 < methodHandleArray.length; ++n2) {
            methodHandle2 = methodHandleArray[n2];
            if (methodHandle2 == null) continue;
            bl = true;
            MethodType methodType2 = methodHandle2.type;
            if (classArray[n + n2] != methodType2.returnType) {
                throw new IllegalArgumentException();
            }
            if (methodType2.parameterCount() != 1) {
                throw new IllegalArgumentException();
            }
            classArray[n + n2] = methodType2.arguments[0];
        }
        if (!bl) {
            return methodHandle;
        }
        for (n2 = 0; n2 < methodHandleArray.length; ++n2) {
            methodHandle2 = methodHandleArray[n2];
            if (methodHandle2 != null) {
                if (n2 == 0) break;
                methodHandleArray = Arrays.copyOfRange(methodHandleArray, n2, methodHandleArray.length);
                break;
            }
            ++n;
        }
        MethodType methodType3 = MethodType.methodType(methodType.returnType, classArray);
        methodHandle2 = FilterArgumentsHandle.get(methodHandle, n, methodHandleArray, methodType3);
        return methodHandle2;
    }

    public static MethodHandle foldArguments(MethodHandle methodHandle, MethodHandle methodHandle2) throws NullPointerException, IllegalArgumentException {
        return MethodHandles.foldArgumentsCommon(methodHandle, 0, methodHandle2, EMPTY_ARG_POSITIONS);
    }

    private static final MethodHandle foldArgumentsCommon(MethodHandle methodHandle, int n, MethodHandle methodHandle2, int ... nArray) throws NullPointerException, IllegalArgumentException {
        MethodType methodType = methodHandle.type;
        MethodType methodType2 = methodHandle2.type;
        Class<?> clazz = methodType2.returnType;
        int n2 = methodType.parameterCount();
        int n3 = methodType2.parameterCount();
        int n4 = nArray.length;
        int[] nArray2 = EMPTY_ARG_POSITIONS;
        if (n < 0 || n > n2 || n == n2 && n2 != 0) {
            throw new IllegalArgumentException(Msg.getString("K0637", new Object[]{"the fold position", Integer.toString(n), Integer.toString(n2)}));
        }
        if (n4 > 0 && n3 != n4) {
            throw new IllegalArgumentException(Msg.getString("K0638", new Object[]{Integer.toString(n4), Integer.toString(n3)}));
        }
        for (int i = 0; i < n4; ++i) {
            if (nArray[i] < 0 || nArray[i] >= n2) {
                throw new IllegalArgumentException(Msg.getString("K0637", new Object[]{"argument index", Integer.toString(nArray[i]), Integer.toString(n2)}));
            }
            if (n + i + 1 == nArray[i]) continue;
            nArray2 = nArray;
            break;
        }
        if (Void.TYPE == clazz) {
            if (n2 < n3) {
                throw new IllegalArgumentException(Msg.getString("K0650", new Object[]{Integer.toString(n3), "<=", Integer.toString(n2)}));
            }
            MethodHandles.validateParametersOfCombiner(n4, n3, methodType2, methodType, nArray, n, 0);
            FoldHandle foldHandle = FoldHandle.get(methodHandle, methodHandle2, methodType, n, nArray2);
            return foldHandle;
        }
        if (n2 <= n3) {
            throw new IllegalArgumentException(Msg.getString("K0650", new Object[]{Integer.toString(n3), "<", Integer.toString(n2)}));
        }
        if (clazz != methodType.arguments[n]) {
            throw new IllegalArgumentException(Msg.getString("K063A1", new Object[]{clazz.getSimpleName(), "filter", methodType.arguments[n].getSimpleName(), "filter", Integer.toString(n)}));
        }
        MethodHandles.validateParametersOfCombiner(n4, n3, methodType2, methodType, nArray, n, 1);
        MethodType methodType3 = methodType.dropParameterTypes(n, n + 1);
        FoldHandle foldHandle = FoldHandle.get(methodHandle, methodHandle2, methodType3, n, nArray2);
        return foldHandle;
    }

    private static void validateParametersOfCombiner(int n, int n2, MethodType methodType, MethodType methodType2, int[] nArray, int n3, int n4) {
        if (0 == n) {
            for (int i = 0; i < n2; ++i) {
                if (methodType.arguments[i] == methodType2.arguments[n3 + i + n4]) continue;
                throw new IllegalArgumentException(Msg.getString("K05d0", methodType.toString(), methodType2.toString(), Integer.toString(n3)));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (methodType.arguments[i] == methodType2.arguments[nArray[i]]) continue;
                throw new IllegalArgumentException(Msg.getString("K05d0", methodType.toString(), methodType2.toString(), Integer.toString(n3)));
            }
        }
    }

    public static MethodHandle permuteArguments(MethodHandle methodHandle, MethodType methodType, int ... nArray) throws NullPointerException, IllegalArgumentException {
        MethodType methodType2 = methodHandle.type;
        Class<?> clazz = methodType.returnType;
        if (nArray.length != methodType2.parameterCount()) {
            throw new IllegalArgumentException();
        }
        if (clazz != methodType2.returnType) {
            throw new IllegalArgumentException();
        }
        nArray = (int[])nArray.clone();
        MethodHandles.validatePermutationArray(methodType, methodType2, nArray);
        return methodHandle.permuteArguments(methodType, nArray);
    }

    public static MethodHandle collectArguments(MethodHandle methodHandle, int n, MethodHandle methodHandle2) throws NullPointerException, IllegalArgumentException {
        MethodType methodType = methodHandle.type;
        MethodType methodType2 = methodHandle2.type;
        Class<?> clazz = methodType2.returnType;
        if (clazz == Void.TYPE) {
            if (n < 0 || n > methodType.argSlots) {
                throw new IllegalArgumentException(Msg.getString("K0580", methodType.argSlots));
            }
            MethodType methodType3 = methodType.insertParameterTypes(n, methodType2.arguments);
            MethodHandle methodHandle3 = MethodHandles.buildTransformHandle(new VoidCollectHelper(methodHandle, n, methodHandle2), methodType3);
            return methodHandle3;
        }
        if (n < 0 || n >= methodType.argSlots) {
            throw new IllegalArgumentException(Msg.getString("K0580", methodType.argSlots));
        }
        if (clazz != methodType.arguments[n]) {
            throw new IllegalArgumentException(Msg.getString("K0581", n));
        }
        MethodType methodType4 = methodType.dropParameterTypes(n, n + 1).insertParameterTypes(n, methodType2.arguments);
        MethodHandle methodHandle4 = MethodHandles.buildTransformHandle(new CollectHelper(methodHandle, n, methodHandle2), methodType4);
        return methodHandle4;
    }

    private static boolean validatePermutationArray(MethodType methodType, MethodType methodType2, int[] nArray) throws IllegalArgumentException {
        Class<?>[] classArray = methodType.arguments;
        Class<?>[] classArray2 = methodType2.arguments;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n < 0 || n >= classArray.length) {
                throw new IllegalArgumentException();
            }
            if (classArray2[i] == classArray[n]) continue;
            throw new IllegalArgumentException();
        }
        return true;
    }

    private static MethodHandle dropArgumentsUnsafe(MethodHandle methodHandle, int n, Class<?> ... classArray) {
        int n2 = classArray.length;
        MethodType methodType = methodHandle.type;
        if (n < 0 || n > methodType.parameterCount()) {
            throw new IllegalArgumentException(Msg.getString("K039c"));
        }
        MethodType methodType2 = methodType.insertParameterTypes(n, classArray);
        int[] nArray = new int[methodType.parameterCount()];
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (n3 == n) {
                n3 += n2;
            }
            nArray[i] = n3++;
        }
        assert (MethodHandles.validatePermutationArray(methodType2, methodType, nArray));
        return methodHandle.permuteArguments(methodType2, nArray);
    }

    public static MethodHandle dropArguments(MethodHandle methodHandle, int n, Class<?> ... classArray) {
        classArray = (Class[])classArray.clone();
        return MethodHandles.dropArgumentsUnsafe(methodHandle, n, classArray);
    }

    public static MethodHandle dropArguments(MethodHandle methodHandle, int n, List<Class<?>> list) {
        list.getClass();
        Class[] classArray = new Class[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            classArray[i] = list.get(i);
        }
        return MethodHandles.dropArgumentsUnsafe(methodHandle, n, classArray);
    }

    private static MethodHandle buildTransformHandle(ArgumentHelper argumentHelper, MethodType methodType) {
        MethodType methodType2 = MethodType.methodType(Object.class, Object[].class);
        try {
            return Lookup.internalPrivilegedLookup.bind(argumentHelper, "helper", methodType2).asCollector(Object[].class, methodType.parameterCount()).asType(methodType);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new Error(reflectiveOperationException);
        }
    }

    public static MethodHandle explicitCastArguments(MethodHandle methodHandle, MethodType methodType) throws NullPointerException, WrongMethodTypeException {
        MethodType methodType2 = methodHandle.type;
        Class<?> clazz = methodType.returnType;
        if (methodType2 == methodType) {
            return methodHandle;
        }
        MethodHandle methodHandle2 = methodHandle;
        if (methodType2.returnType != clazz) {
            MethodHandle methodHandle3 = ConvertHandle.FilterHelpers.getReturnFilter(methodType2.returnType, clazz, true);
            methodHandle2 = new FilterReturnHandle(methodHandle, methodHandle3);
            if (methodHandle2.type == methodType) {
                return methodHandle2;
            }
        }
        return new ExplicitCastHandle(methodHandle2, methodType);
    }

    public static MethodHandle insertArguments(MethodHandle methodHandle, int n, Object ... objectArray) {
        Object object;
        Serializable serializable;
        boolean bl;
        MethodType methodType = methodHandle.type;
        Class<?>[] classArray = methodType.parameterArray();
        boolean bl2 = bl = objectArray.length == 0;
        if (n < 0 || n > methodType.parameterCount() - objectArray.length) {
            throw new IllegalArgumentException();
        }
        if (bl) {
            return methodHandle;
        }
        objectArray = (Object[])objectArray.clone();
        for (int i = 0; i < objectArray.length; ++i) {
            serializable = classArray[n + i];
            object = objectArray[i];
            Class<Object> clazz = serializable;
            if (object != null) {
                clazz = object.getClass();
            }
            if (((Class)serializable).isPrimitive()) {
                Objects.requireNonNull(object);
                Class<?> clazz2 = MethodType.unwrapPrimitive(clazz);
                if (serializable != clazz2 && !ConvertHandle.FilterHelpers.checkIfWideningPrimitiveConversion(clazz2, serializable)) {
                    ((Class)serializable).cast(object);
                }
            } else {
                ((Class)serializable).cast(object);
            }
            classArray[n + i] = clazz;
        }
        MethodHandle methodHandle2 = methodHandle.asType(MethodType.methodType(methodType.returnType, classArray));
        serializable = methodType.dropParameterTypes(n, n + objectArray.length);
        switch (objectArray.length) {
            case 1: {
                if (methodType.parameterType(n) == Integer.TYPE) {
                    object = new Insert1IntHandle((MethodType)serializable, methodHandle2, n, objectArray, methodHandle);
                    break;
                }
                object = new Insert1Handle((MethodType)serializable, methodHandle2, n, objectArray);
                break;
            }
            case 2: {
                object = new Insert2Handle((MethodType)serializable, methodHandle2, n, objectArray);
                break;
            }
            case 3: {
                object = new Insert3Handle((MethodType)serializable, methodHandle2, n, objectArray);
                break;
            }
            default: {
                object = new InsertHandle((MethodType)serializable, methodHandle2, n, objectArray);
            }
        }
        return methodHandle.insertArguments((MethodHandle)object, methodHandle2, n, objectArray);
    }

    static MethodHandle basicInvoker(MethodType methodType) {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    private static final class VoidCollectHelper
    implements ArgumentHelper {
        private final MethodHandle target;
        private final MethodHandle filter;
        private final int pos;

        VoidCollectHelper(MethodHandle methodHandle, int n, MethodHandle methodHandle2) {
            this.target = methodHandle;
            this.filter = methodHandle2;
            this.pos = n;
        }

        @Override
        public Object helper(Object[] objectArray) throws Throwable {
            int n = this.filter.type.parameterCount();
            this.filter.invokeWithArguments(Arrays.copyOfRange(objectArray, this.pos, this.pos + n));
            Object[] objectArray2 = new Object[objectArray.length - n];
            System.arraycopy((Object)objectArray, 0, (Object)objectArray2, 0, this.pos);
            int n2 = this.pos + n;
            System.arraycopy((Object)objectArray, n2, (Object)objectArray2, this.pos, objectArray.length - n2);
            return this.target.invokeWithArguments(objectArray2);
        }
    }

    private static final class CollectHelper
    implements ArgumentHelper {
        private final MethodHandle target;
        private final MethodHandle filter;
        private final int pos;

        CollectHelper(MethodHandle methodHandle, int n, MethodHandle methodHandle2) {
            this.target = methodHandle;
            this.filter = methodHandle2;
            this.pos = n;
        }

        @Override
        public Object helper(Object[] objectArray) throws Throwable {
            int n = this.filter.type.parameterCount();
            Object object = this.filter.invokeWithArguments(Arrays.copyOfRange(objectArray, this.pos, this.pos + n));
            Object[] objectArray2 = new Object[objectArray.length - n + 1];
            System.arraycopy((Object)objectArray, 0, (Object)objectArray2, 0, this.pos);
            int n2 = this.pos + n;
            objectArray2[this.pos] = object;
            System.arraycopy((Object)objectArray, n2, (Object)objectArray2, this.pos + 1, objectArray.length - n2);
            return this.target.invokeWithArguments(objectArray2);
        }
    }

    private static final class CatchHelper
    implements ArgumentHelper {
        private final MethodHandle tryTarget;
        private final MethodHandle catchTarget;
        private final Class<? extends Throwable> exceptionClass;

        CatchHelper(MethodHandle methodHandle, MethodHandle methodHandle2, Class<? extends Throwable> clazz) {
            this.tryTarget = methodHandle;
            this.catchTarget = methodHandle2;
            this.exceptionClass = clazz;
        }

        @Override
        public Object helper(Object[] objectArray) throws Throwable {
            try {
                return this.tryTarget.invokeWithArguments(objectArray);
            }
            catch (Throwable throwable) {
                if (this.exceptionClass.isInstance(throwable)) {
                    int n = this.catchTarget.type.parameterCount();
                    Object[] objectArray2 = new Object[n];
                    objectArray2[0] = throwable;
                    System.arraycopy((Object)objectArray, 0, (Object)objectArray2, 1, n - 1);
                    return this.catchTarget.invokeWithArguments(objectArray2);
                }
                throw throwable;
            }
        }
    }

    public static final class Lookup {
        public static final int PUBLIC = 1;
        public static final int PRIVATE = 2;
        public static final int PROTECTED = 4;
        public static final int PACKAGE = 8;
        static final int INTERNAL_PRIVILEGED = 64;
        private static final int FULL_ACCESS_MASK = 15;
        private static final int NO_ACCESS = 0;
        private static final String INVOKE_EXACT = "invokeExact";
        private static final String INVOKE = "invoke";
        static final int VARARGS = 128;
        static final int mhMask = 1;
        static Lookup PUBLIC_LOOKUP = new Lookup(Object.class, 1);
        static Lookup internalPrivilegedLookup;
        static Lookup IMPL_LOOKUP;
        final Class<?> prevAccessClass;
        final Class<?> accessClass;
        final int accessMode;
        private final boolean performSecurityCheck;

        Lookup(Class<?> clazz, Class<?> clazz2, int n, boolean bl) {
            this.performSecurityCheck = bl;
            if (bl && 64 != n && clazz.getName().startsWith("java.lang.invoke.")) {
                throw new IllegalArgumentException(Msg.getString("K0588", clazz.getName()));
            }
            this.accessClass = clazz;
            this.prevAccessClass = clazz2;
            this.accessMode = n;
        }

        Lookup(Class<?> clazz, Class<?> clazz2, int n) {
            this(clazz, clazz2, n, true);
        }

        Lookup(Class<?> clazz, int n, boolean bl) {
            this(clazz, null, n, bl);
        }

        Lookup(Class<?> clazz, int n) {
            this(clazz, n, true);
        }

        Lookup(Class<?> clazz) {
            this(clazz, 15, true);
        }

        Lookup(Class<?> clazz, boolean bl) {
            this(clazz, 15, bl);
        }

        public int lookupModes() {
            return this.accessMode;
        }

        static boolean isVarargs(int n) {
            return (n & 0x80) != 0;
        }

        private static MethodHandle convertToVarargsIfRequired(MethodHandle methodHandle) {
            if (Lookup.isVarargs(methodHandle.getModifiers())) {
                Class<?> clazz = methodHandle.type.lastParameterType();
                return methodHandle.asVarargsCollector(clazz);
            }
            return methodHandle;
        }

        public MethodHandle bind(Object object, String string, MethodType methodType) throws IllegalAccessException, NoSuchMethodException {
            Lookup.nullCheck(object, string, methodType);
            Class<? extends Object> clazz = object.getClass();
            MethodHandle methodHandle = this.handleForMHInvokeMethods(clazz, string, methodType);
            if (methodHandle == null) {
                try {
                    methodHandle = this.findSpecialImpl(clazz, string, methodType, clazz);
                    methodHandle = methodHandle.asFixedArity();
                    methodHandle = Lookup.convertToVarargsIfRequired(methodHandle.bindTo(object));
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalAccessException(classCastException.getMessage());
                }
            }
            this.checkAccess(methodHandle, false);
            this.checkSecurity(methodHandle.getDefc(), clazz, methodHandle.getModifiers());
            methodHandle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrameIfRequired(this, methodHandle);
            return methodHandle;
        }

        private static void nullCheck(Object object, Object object2) {
            object.getClass();
            object2.getClass();
        }

        private static void nullCheck(Object object, Object object2, Object object3) {
            object.getClass();
            object2.getClass();
            object3.getClass();
        }

        private static void nullCheck(Object object, Object object2, Object object3, Object object4) {
            object.getClass();
            object2.getClass();
            object3.getClass();
            object4.getClass();
        }

        private static void initCheck(String string) throws NoSuchMethodException {
            if ("<init>".equals(string) || "<clinit>".equals(string)) {
                throw new NoSuchMethodException(Msg.getString("K05ce", string));
            }
        }

        static final VMLangAccess getVMLangAccess() {
            return VMLangAccessGetter.vma;
        }

        private static boolean isSamePackage(Class<?> clazz, Class<?> clazz2) {
            ClassLoader classLoader;
            if (clazz == clazz2) {
                return true;
            }
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            while (clazz2.isArray()) {
                clazz2 = clazz2.getComponentType();
            }
            VMLangAccess vMLangAccess = Lookup.getVMLangAccess();
            String string = vMLangAccess.getPackageName(clazz);
            String string2 = vMLangAccess.getPackageName(clazz2);
            if (string == null || string2 == null || !string.equals(string2)) {
                return false;
            }
            ClassLoader classLoader2 = vMLangAccess.getClassloader(clazz);
            if (classLoader2 == (classLoader = vMLangAccess.getClassloader(clazz2))) {
                return true;
            }
            return vMLangAccess.isAncestor(classLoader2, classLoader) || vMLangAccess.isAncestor(classLoader, classLoader2);
        }

        void checkAccess(MethodHandle methodHandle, boolean bl) throws IllegalAccessException {
            if (64 == this.accessMode) {
                return;
            }
            if (0 == this.accessMode) {
                throw new IllegalAccessException(this.toString());
            }
            this.checkAccess(methodHandle.getDefc(), methodHandle.getReferenceClass(), methodHandle.getMethodName(), methodHandle.getModifiers(), methodHandle, bl);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void checkAccess(Class<?> clazz, Class<?> clazz2, String string, int n, MethodHandle methodHandle, boolean bl) throws IllegalAccessException {
            Class<?> clazz3;
            if (null == clazz2) {
                clazz2 = clazz;
            }
            this.checkClassAccess(clazz2);
            if (Modifier.isPublic(n)) {
                return;
            }
            if (Modifier.isPrivate(n)) {
                if (Modifier.isPrivate(this.accessMode) && clazz == this.accessClass) {
                    return;
                }
            } else if (Modifier.isProtected(n)) {
                if (this.accessMode != 1) {
                    if (clazz.isArray()) {
                        return;
                    }
                    if (Lookup.isSamePackage(this.accessClass, clazz2)) {
                        return;
                    }
                    if (!this.accessClass.isInterface() && Modifier.isProtected(this.accessMode) && clazz.isAssignableFrom(this.accessClass)) {
                        if (null == methodHandle) return;
                        byte by = methodHandle.kind;
                        if (8 != by && (7 != by || methodHandle.directHandleOriginatedInFindVirtual())) return;
                        clazz3 = methodHandle.getReferenceClass();
                        if (7 == by) {
                            clazz3 = methodHandle.getSpecialCaller();
                        }
                        if (this.accessClass.isAssignableFrom(clazz3)) {
                            return;
                        }
                    }
                }
            } else if (8 == (this.accessMode & 8) && Lookup.isSamePackage(this.accessClass, clazz2)) {
                return;
            }
            String string2 = "";
            string2 = null != methodHandle ? string + ":" + methodHandle.type + "/" + methodHandle.mapKindToBytecode() : "." + string;
            clazz3 = Msg.getString("K0587", (Object)this.toString(), clazz.getName() + string2);
            throw new IllegalAccessException((String)((Object)clazz3));
        }

        private void checkClassAccess(Class<?> clazz) throws IllegalAccessException {
            if (0 != this.accessMode) {
                boolean bl;
                int n = clazz.getModifiers();
                boolean bl2 = bl = Modifier.isPublic(n) || Modifier.isProtected(n);
                if (this.accessClass == clazz) {
                    return;
                }
                if (bl) {
                    return;
                }
                if ((8 == (this.accessMode & 8) || Modifier.isPrivate(this.accessMode)) && Lookup.isSamePackage(this.accessClass, clazz)) {
                    return;
                }
            }
            throw new IllegalAccessException(Msg.getString("K0680", (Object)this.accessClass.getName(), clazz.getName()));
        }

        private void checkSpecialAccess(Class<?> clazz, Class<?> clazz2) throws IllegalAccessException {
            if (64 == this.accessMode) {
                return;
            }
            if (this.isWeakenedLookup() || this.accessClass != clazz2 && (!clazz.isInterface() || !clazz.isAssignableFrom(clazz2))) {
                throw new IllegalAccessException(Msg.getString("K0585", (Object)this.accessClass.getName(), clazz2.getName()));
            }
        }

        public MethodHandle findSpecial(Class<?> clazz, String string, MethodType methodType, Class<?> clazz2) throws IllegalAccessException, NoSuchMethodException, SecurityException, NullPointerException {
            Lookup.nullCheck(clazz, string, methodType, clazz2);
            this.checkSpecialAccess(clazz, clazz2);
            MethodHandle methodHandle = null;
            try {
                methodHandle = this.findSpecialImpl(clazz, string, methodType, clazz2);
                Class<?> clazz3 = methodHandle.getDefc();
                if (this.accessClass.isAssignableFrom(clazz2) && !clazz3.isAssignableFrom(this.accessClass)) {
                    throw new IllegalAccessException(Msg.getString("K0586", this.accessClass, clazz3));
                }
                this.checkAccess(methodHandle, false);
                this.checkSecurity(clazz3, clazz, methodHandle.getModifiers());
                methodHandle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrameIfRequired(this, methodHandle);
            }
            catch (DefaultMethodConflictException defaultMethodConflictException) {
                methodHandle = Lookup.throwExceptionWithMethodTypeAndMessage(IncompatibleClassChangeError.class, methodType.insertParameterTypes(0, clazz2), defaultMethodConflictException.getCause().getMessage());
            }
            return methodHandle;
        }

        private MethodHandle findSpecialImpl(Class<?> clazz, String string, MethodType methodType, Class<?> clazz2) throws IllegalAccessException, NoSuchMethodException, SecurityException, NullPointerException {
            Map<CacheKey, WeakReference<MethodHandle>> map = HandleCache.getSpecialCache(clazz);
            MethodHandle methodHandle = HandleCache.getMethodWithSpecialCallerFromPerClassCache(map, string, methodType, clazz2);
            if (methodHandle == null) {
                Lookup.initCheck(string);
                methodHandle = new DirectHandle(clazz, string, methodType, 7, clazz2);
                if (internalPrivilegedLookup != this) {
                    methodHandle = this.restrictReceiver(methodHandle);
                }
                methodHandle = Lookup.convertToVarargsIfRequired(methodHandle);
                HandleCache.putMethodWithSpecialCallerInPerClassCache(map, string, methodType, methodHandle, clazz2);
            }
            return methodHandle;
        }

        public MethodHandle findStatic(Class<?> clazz, String string, MethodType methodType) throws IllegalAccessException, NoSuchMethodException {
            Lookup.nullCheck(clazz, string, methodType);
            Map<CacheKey, WeakReference<MethodHandle>> map = HandleCache.getStaticCache(clazz);
            MethodHandle methodHandle = HandleCache.getMethodFromPerClassCache(map, string, methodType);
            if (methodHandle == null) {
                Lookup.initCheck(string);
                methodHandle = new DirectHandle(clazz, string, methodType, 6, null);
                methodHandle = HandleCache.putMethodInPerClassCache(map, string, methodType, Lookup.convertToVarargsIfRequired(methodHandle));
            }
            this.checkAccess(methodHandle, false);
            this.checkSecurity(methodHandle.getDefc(), clazz, methodHandle.getModifiers());
            methodHandle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrameIfRequired(this, methodHandle);
            return methodHandle;
        }

        public MethodHandle findVirtual(Class<?> clazz, String string, MethodType methodType) throws IllegalAccessException, NoSuchMethodException {
            Lookup.nullCheck(clazz, string, methodType);
            Map<CacheKey, WeakReference<MethodHandle>> map = HandleCache.getVirtualCache(clazz);
            MethodHandle methodHandle = HandleCache.getMethodFromPerClassCache(map, string, methodType);
            if (methodHandle == null) {
                methodHandle = this.handleForMHInvokeMethods(clazz, string, methodType);
            }
            if (methodHandle == null) {
                Lookup.initCheck(string);
                if (clazz.isInterface()) {
                    methodHandle = Lookup.findInterface(clazz, string, methodType);
                } else {
                    int n;
                    methodHandle = new DirectHandle(clazz, string, methodType, 5, clazz, true);
                    if (!(Modifier.isFinal(clazz.getModifiers()) || Modifier.isPrivate(n = methodHandle.getModifiers()) || Modifier.isFinal(n))) {
                        methodHandle = new VirtualHandle((DirectHandle)methodHandle);
                    }
                }
                methodHandle = Lookup.convertToVarargsIfRequired(methodHandle);
                HandleCache.putMethodInPerClassCache(map, string, methodType, methodHandle);
            }
            methodHandle = this.restrictReceiver(methodHandle);
            this.checkAccess(methodHandle, false);
            this.checkSecurity(methodHandle.getDefc(), clazz, methodHandle.getModifiers());
            methodHandle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrameIfRequired(this, methodHandle);
            return methodHandle;
        }

        private MethodHandle restrictReceiver(MethodHandle methodHandle) {
            int n = methodHandle.getModifiers();
            Class<?> clazz = methodHandle.getDefc();
            if (!Modifier.isStatic(n) && Modifier.isProtected(n) && clazz != this.accessClass && clazz.isAssignableFrom(this.accessClass) && !Lookup.isSamePackage(clazz, this.accessClass)) {
                methodHandle = methodHandle.cloneWithNewType(methodHandle.type.changeParameterType(0, this.accessClass));
            }
            return methodHandle;
        }

        private static MethodHandle findInterface(Class<?> clazz, String string, MethodType methodType) throws NoSuchMethodException, IllegalAccessException {
            MethodHandle methodHandle = new DirectHandle(clazz, string, methodType, 5, clazz, true);
            Class<?> clazz2 = ((MethodHandle)methodHandle).getDefc();
            if (Object.class == clazz2) {
                if (!Modifier.isPublic(((MethodHandle)methodHandle).getModifiers())) {
                    throw new NoSuchMethodException(clazz + "." + string + methodType);
                }
                methodHandle = new DirectHandle(Object.class, string, methodType, 7, Object.class);
                if (!Modifier.isFinal(((MethodHandle)methodHandle).getModifiers())) {
                    methodHandle = new VirtualHandle((DirectHandle)methodHandle);
                }
                methodHandle = ((MethodHandle)methodHandle).cloneWithNewType(methodHandle.type.changeParameterType(0, clazz));
            } else {
                if (!Modifier.isPublic(((MethodHandle)methodHandle).getModifiers())) {
                    throw new IllegalAccessException();
                }
                methodHandle = new InterfaceHandle(clazz, string, methodType);
            }
            return methodHandle;
        }

        final void accessCheckArgRetTypes(MethodType methodType) throws IllegalAccessException {
            if (64 != this.accessMode) {
                for (Class<?> clazz : methodType.arguments) {
                    if (clazz.isPrimitive()) continue;
                    this.checkClassAccess(clazz);
                }
                Class<?> clazz = methodType.returnType();
                if (!clazz.isPrimitive()) {
                    this.checkClassAccess(clazz);
                }
            }
        }

        MethodHandle handleForMHInvokeMethods(Class<?> clazz, String string, MethodType methodType) throws IllegalAccessException {
            if (MethodHandle.class.isAssignableFrom(clazz)) {
                if (INVOKE_EXACT.equals(string)) {
                    this.accessCheckArgRetTypes(methodType);
                    return methodType.getInvokeExactHandle();
                }
                if (INVOKE.equals(string)) {
                    this.accessCheckArgRetTypes(methodType);
                    return new InvokeGenericHandle(methodType);
                }
            }
            return null;
        }

        public MethodHandle findGetter(Class<?> clazz, String string, Class<?> clazz2) throws IllegalAccessException, NoSuchFieldException, SecurityException, NullPointerException {
            Lookup.nullCheck(clazz, string, clazz2);
            Map<CacheKey, WeakReference<MethodHandle>> map = HandleCache.getFieldGetterCache(clazz);
            MethodHandle methodHandle = HandleCache.getFieldFromPerClassCache(map, string, clazz2);
            if (methodHandle == null) {
                methodHandle = new FieldGetterHandle(clazz, string, clazz2, this.accessClass);
                HandleCache.putFieldInPerClassCache(map, string, clazz2, methodHandle);
            }
            this.checkAccess(methodHandle, false);
            this.checkSecurity(methodHandle.getDefc(), clazz, methodHandle.getModifiers());
            return methodHandle;
        }

        public MethodHandle findStaticGetter(Class<?> clazz, String string, Class<?> clazz2) throws IllegalAccessException, NoSuchFieldException, SecurityException, NullPointerException {
            Lookup.nullCheck(clazz, string, clazz2);
            Map<CacheKey, WeakReference<MethodHandle>> map = HandleCache.getStaticFieldGetterCache(clazz);
            MethodHandle methodHandle = HandleCache.getFieldFromPerClassCache(map, string, clazz2);
            if (methodHandle == null) {
                methodHandle = new StaticFieldGetterHandle(clazz, string, clazz2, this.accessClass);
                HandleCache.putFieldInPerClassCache(map, string, clazz2, methodHandle);
            }
            this.checkAccess(methodHandle, false);
            this.checkSecurity(methodHandle.getDefc(), clazz, methodHandle.getModifiers());
            return methodHandle;
        }

        public MethodHandle findSetter(Class<?> clazz, String string, Class<?> clazz2) throws IllegalAccessException, NoSuchFieldException, SecurityException, NullPointerException {
            Lookup.nullCheck(clazz, string, clazz2);
            if (clazz2 == Void.TYPE) {
                throw new NoSuchFieldException();
            }
            Map<CacheKey, WeakReference<MethodHandle>> map = HandleCache.getFieldSetterCache(clazz);
            MethodHandle methodHandle = HandleCache.getFieldFromPerClassCache(map, string, clazz2);
            if (methodHandle == null) {
                methodHandle = new FieldSetterHandle(clazz, string, clazz2, this.accessClass);
                HandleCache.putFieldInPerClassCache(map, string, clazz2, methodHandle);
            }
            if (Modifier.isFinal(methodHandle.getModifiers())) {
                throw new IllegalAccessException(Msg.getString("K05cf"));
            }
            this.checkAccess(methodHandle, false);
            this.checkSecurity(methodHandle.getDefc(), clazz, methodHandle.getModifiers());
            return methodHandle;
        }

        public MethodHandle findStaticSetter(Class<?> clazz, String string, Class<?> clazz2) throws IllegalAccessException, NoSuchFieldException, SecurityException, NullPointerException {
            Lookup.nullCheck(clazz, string, clazz2);
            if (clazz2 == Void.TYPE) {
                throw new NoSuchFieldException();
            }
            Map<CacheKey, WeakReference<MethodHandle>> map = HandleCache.getStaticFieldSetterCache(clazz);
            MethodHandle methodHandle = HandleCache.getFieldFromPerClassCache(map, string, clazz2);
            if (methodHandle == null) {
                methodHandle = new StaticFieldSetterHandle(clazz, string, clazz2, this.accessClass);
                HandleCache.putFieldInPerClassCache(map, string, clazz2, methodHandle);
            }
            if (Modifier.isFinal(methodHandle.getModifiers())) {
                throw new IllegalAccessException(Msg.getString("K05cf"));
            }
            this.checkAccess(methodHandle, false);
            this.checkSecurity(methodHandle.getDefc(), clazz, methodHandle.getModifiers());
            return methodHandle;
        }

        public Lookup in(Class<?> clazz) {
            int n;
            boolean bl;
            Class<?> clazz2;
            Class<?> clazz3;
            Objects.requireNonNull(clazz);
            if (clazz == this.accessClass) {
                return this;
            }
            int n2 = this.accessMode;
            n2 &= 0xFFFFFFFB;
            if (!Lookup.isSamePackage(this.accessClass, clazz)) {
                n2 &= 0xFFFFFFF3;
            }
            if (2 == (n2 & 2) && (clazz3 = Lookup.getUltimateEnclosingClassOrSelf(this.accessClass)) != (clazz2 = Lookup.getUltimateEnclosingClassOrSelf(clazz))) {
                n2 &= 0xFFFFFFFD;
            }
            boolean bl2 = bl = Modifier.isPublic(n = clazz.getModifiers()) || Modifier.isProtected(n);
            if (!bl) {
                if (Lookup.isSamePackage(this.accessClass, clazz)) {
                    if (0 == (this.accessMode & 8)) {
                        n2 = 0;
                    }
                } else {
                    n2 = 0;
                }
            } else {
                VMLangAccess vMLangAccess = Lookup.getVMLangAccess();
                if (vMLangAccess.getClassloader(this.accessClass) != vMLangAccess.getClassloader(clazz)) {
                    n2 &= 0xFFFFFFF1;
                }
            }
            return new Lookup(clazz, n2);
        }

        private static Class<?> getUltimateEnclosingClassOrSelf(Class<?> clazz) {
            Class<?> clazz2 = clazz;
            for (Class<?> clazz3 = clazz.getEnclosingClass(); clazz3 != null; clazz3 = clazz3.getEnclosingClass()) {
                clazz2 = clazz3;
            }
            return clazz2;
        }

        public Class<?> lookupClass() {
            return this.accessClass;
        }

        public MethodHandle unreflect(Method method) throws IllegalAccessException {
            MethodType methodType;
            String string;
            int n = method.getModifiers();
            Class<?> clazz = method.getDeclaringClass();
            Map<CacheKey, WeakReference<MethodHandle>> map = Modifier.isStatic(n) ? HandleCache.getStaticCache(clazz) : HandleCache.getVirtualCache(clazz);
            MethodHandle methodHandle = HandleCache.getMethodFromPerClassCache(map, string = method.getName(), methodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes()));
            if (methodHandle == null) {
                if (Modifier.isStatic(n)) {
                    methodHandle = new DirectHandle(method, 6, null);
                } else if (clazz.isInterface()) {
                    if (Modifier.isPrivate(n)) {
                        MethodHandle methodHandle2;
                        if (!method.isAccessible()) {
                            if (this.accessMode == 0) {
                                throw new IllegalAccessException(this.toString());
                            }
                            if (clazz != this.accessClass || !Modifier.isPrivate(this.accessMode)) {
                                String string2 = Msg.getString("K0678", (Object)this.toString(), clazz + "." + method.getName() + ":" + 9 + "/invokeinterface");
                                throw new IllegalAccessException(string2);
                            }
                        }
                        methodType = methodType.insertParameterTypes(0, clazz);
                        MethodHandle methodHandle3 = MethodHandles.throwException(methodType.returnType(), AbstractMethodError.class);
                        try {
                            methodHandle2 = IMPL_LOOKUP.findConstructor(AbstractMethodError.class, MethodType.methodType(Void.TYPE));
                        }
                        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                            throw new InternalError("Unable to find AbstractMethodError.<init>()");
                        }
                        methodHandle = MethodHandles.foldArguments(methodHandle3, methodHandle2);
                        methodHandle = MethodHandles.dropArguments(methodHandle, 0, methodType.parameterList());
                        if (Lookup.isVarargs(n)) {
                            Class<?> clazz2 = methodHandle.type.lastParameterType();
                            methodHandle = methodHandle.asVarargsCollector(clazz2);
                        }
                        return methodHandle;
                    }
                    methodHandle = new InterfaceHandle(method);
                } else {
                    methodHandle = !Modifier.isPrivate(n) && !Modifier.isFinal(n) ? new VirtualHandle(method) : new DirectHandle(method, 7, clazz, true);
                }
                methodHandle = Lookup.convertToVarargsIfRequired(methodHandle);
                HandleCache.putMethodInPerClassCache(map, string, methodType, methodHandle);
            }
            if (!method.isAccessible()) {
                methodHandle = this.restrictReceiver(methodHandle);
                this.checkAccess(methodHandle, true);
            }
            methodHandle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrameIfRequired(this, methodHandle);
            return methodHandle;
        }

        public MethodHandle unreflectConstructor(Constructor<?> constructor) throws IllegalAccessException {
            MethodType methodType;
            String string = constructor.getName();
            Map<CacheKey, WeakReference<MethodHandle>> map = HandleCache.getConstructorCache(constructor.getDeclaringClass());
            MethodHandle methodHandle = HandleCache.getMethodFromPerClassCache(map, string, methodType = MethodType.methodType(Void.TYPE, constructor.getParameterTypes()));
            if (methodHandle == null) {
                methodHandle = new ConstructorHandle(constructor);
                methodHandle = Lookup.convertToVarargsIfRequired(methodHandle);
                HandleCache.putMethodInPerClassCache(map, string, methodType, methodHandle);
            }
            if (!constructor.isAccessible()) {
                this.checkAccess(methodHandle, true);
            }
            return methodHandle;
        }

        public MethodHandle findConstructor(Class<?> clazz, MethodType methodType) throws IllegalAccessException, NoSuchMethodException {
            Lookup.nullCheck(clazz, methodType);
            Map<CacheKey, WeakReference<MethodHandle>> map = HandleCache.getConstructorCache(clazz);
            MethodHandle methodHandle = HandleCache.getMethodFromPerClassCache(map, "<init>", methodType);
            if (methodHandle == null) {
                methodHandle = new ConstructorHandle(clazz, methodType);
                if (methodType.returnType() != Void.TYPE) {
                    throw new NoSuchMethodException();
                }
                methodHandle = HandleCache.putMethodInPerClassCache(map, "<init>", methodType, Lookup.convertToVarargsIfRequired(methodHandle));
            }
            this.checkAccess(methodHandle, false);
            this.checkSecurity(methodHandle.getDefc(), clazz, methodHandle.getModifiers());
            return methodHandle;
        }

        public MethodHandle unreflectSpecial(Method method, Class<?> clazz) throws IllegalAccessException {
            Lookup.nullCheck(method, clazz);
            Class<?> clazz2 = method.getDeclaringClass();
            this.checkSpecialAccess(clazz2, clazz);
            String string = method.getName();
            Map<CacheKey, WeakReference<MethodHandle>> map = HandleCache.getSpecialCache(clazz2);
            MethodType methodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
            MethodHandle methodHandle = HandleCache.getMethodWithSpecialCallerFromPerClassCache(map, string, methodType, clazz);
            if (methodHandle == null) {
                if (Modifier.isStatic(method.getModifiers())) {
                    throw new IllegalAccessException();
                }
                methodHandle = Lookup.convertToVarargsIfRequired(new DirectHandle(method, 7, clazz));
                HandleCache.putMethodWithSpecialCallerInPerClassCache(map, string, methodType, methodHandle, clazz);
            }
            if (!method.isAccessible()) {
                this.checkAccess(methodHandle, true);
            }
            methodHandle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrameIfRequired(this, methodHandle);
            return methodHandle;
        }

        public MethodHandle unreflectGetter(Field field) throws IllegalAccessException {
            int n = field.getModifiers();
            String string = field.getName();
            Class<?> clazz = field.getDeclaringClass();
            Class<?> clazz2 = field.getType();
            Map<CacheKey, WeakReference<MethodHandle>> map = Modifier.isStatic(n) ? HandleCache.getStaticFieldGetterCache(clazz) : HandleCache.getFieldGetterCache(clazz);
            MethodHandle methodHandle = HandleCache.getFieldFromPerClassCache(map, string, clazz2);
            if (methodHandle == null) {
                methodHandle = Modifier.isStatic(n) ? new StaticFieldGetterHandle(field) : new FieldGetterHandle(field);
                HandleCache.putFieldInPerClassCache(map, string, clazz2, methodHandle);
            }
            if (!field.isAccessible()) {
                this.checkAccess(methodHandle, true);
            }
            return methodHandle;
        }

        public MethodHandle unreflectSetter(Field field) throws IllegalAccessException {
            int n = field.getModifiers();
            Class<?> clazz = field.getDeclaringClass();
            Class<?> clazz2 = field.getType();
            String string = field.getName();
            if (Modifier.isFinal(n) && (!field.isAccessible() || Modifier.isStatic(n))) {
                throw new IllegalAccessException(Msg.getString("K05cf"));
            }
            Map<CacheKey, WeakReference<MethodHandle>> map = Modifier.isStatic(n) ? HandleCache.getStaticFieldSetterCache(clazz) : HandleCache.getFieldSetterCache(clazz);
            MethodHandle methodHandle = HandleCache.getFieldFromPerClassCache(map, string, clazz2);
            if (methodHandle == null) {
                methodHandle = Modifier.isStatic(n) ? new StaticFieldSetterHandle(field) : new FieldSetterHandle(field);
                HandleCache.putFieldInPerClassCache(map, string, clazz2, methodHandle);
            }
            if (!field.isAccessible()) {
                this.checkAccess(methodHandle, true);
            }
            return methodHandle;
        }

        public MethodHandleInfo revealDirect(MethodHandle methodHandle) throws IllegalArgumentException, NullPointerException, SecurityException {
            if (!(methodHandle.canRevealDirect() || (methodHandle = SecurityFrameInjector.penetrateSecurityFrame(methodHandle, this)) != null && methodHandle.canRevealDirect())) {
                throw new IllegalArgumentException(Msg.getString("K0584"));
            }
            try {
                this.checkAccess(methodHandle, false);
                this.checkSecurity(methodHandle.getDefc(), methodHandle.getReferenceClass(), methodHandle.getModifiers());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException(illegalAccessException);
            }
            if (methodHandle instanceof VarargsCollectorHandle) {
                methodHandle = ((VarargsCollectorHandle)methodHandle).next;
            }
            return new MethodHandleInfoImpl((PrimitiveHandle)methodHandle);
        }

        public String toString() {
            String string = this.accessClass.getName();
            switch (this.accessMode) {
                case 0: {
                    string = string + "/noaccess";
                    break;
                }
                case 1: {
                    string = string + "/public";
                    break;
                }
                case 9: {
                    string = string + "/package";
                    break;
                }
                case 11: {
                    string = string + "/private";
                }
            }
            return string;
        }

        boolean isWeakenedLookup() {
            return 2 != (this.accessMode & 2);
        }

        void checkSecurity(Class<?> clazz, Class<?> clazz2, int n) throws IllegalAccessException {
            SecurityManager securityManager;
            if (this.accessMode == 64) {
                return;
            }
            if (null == clazz) {
                throw new IllegalAccessException();
            }
            if (this.performSecurityCheck && (securityManager = System.getSecurityManager()) != null) {
                while (clazz.isArray()) {
                    clazz = clazz.getComponentType();
                }
                while (clazz2.isArray()) {
                    clazz2 = clazz2.getComponentType();
                }
                VMLangAccess vMLangAccess = Lookup.getVMLangAccess();
                ClassLoader classLoader = clazz2.getClassLoader();
                if (this.isWeakenedLookup() || !Util.doesClassLoaderDescendFrom(classLoader, this.accessClass.getClassLoader())) {
                    String string = vMLangAccess.getPackageName(clazz2);
                    securityManager.checkPackageAccess(string);
                }
                if (!Modifier.isPublic(n)) {
                    if (vMLangAccess.getClassloader(clazz) != vMLangAccess.getClassloader(this.accessClass)) {
                        securityManager.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
                    }
                    if (clazz.getClassLoader() != classLoader && !Util.doesClassLoaderDescendFrom(clazz.getClassLoader(), this.accessClass.getClassLoader())) {
                        securityManager.checkPackageAccess(vMLangAccess.getPackageName(clazz));
                    }
                }
            }
        }

        private static MethodHandle throwExceptionWithMethodTypeAndMessage(Class<? extends Throwable> clazz, MethodType methodType, String string) throws IllegalAccessException, NoSuchMethodException {
            MethodHandle methodHandle = MethodHandles.throwException(methodType.returnType(), clazz);
            MethodHandle methodHandle2 = IMPL_LOOKUP.findConstructor(clazz, MethodType.methodType(Void.TYPE, String.class));
            MethodHandle methodHandle3 = MethodHandles.foldArguments(methodHandle, methodHandle2.bindTo(string));
            methodHandle3 = methodHandle3.asType(MethodType.methodType(methodType.returnType));
            methodHandle3 = MethodHandles.dropArguments(methodHandle3, 0, methodType.parameterList());
            return methodHandle3;
        }

        static {
            IMPL_LOOKUP = internalPrivilegedLookup = new Lookup(MethodHandle.class, 64);
        }

        private static final class VMLangAccessGetter {
            public static final VMLangAccess vma = VM.getVMLangAccess();

            private VMLangAccessGetter() {
            }
        }
    }
}

