/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.InvalidSpannedRecordException;
import com.ibm.jvm.format.Merge;
import com.ibm.jvm.format.Message;
import com.ibm.jvm.format.MessageFile;
import com.ibm.jvm.format.TraceArgs;
import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.TracePoint;
import com.ibm.jvm.format.TraceRecord;
import com.ibm.jvm.format.TraceRecord50;
import com.ibm.jvm.format.TraceThread;
import com.ibm.jvm.format.Util;
import com.ibm.jvm.trace.TraceFileHeader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;

public final class TraceFormat {
    protected static final int traceFormatMajorVersion = 1;
    protected static final int traceFormatMinorVersion = 0;
    private TraceArgs traceArgs = null;
    private Vector traceFiles = new Vector();
    private TraceFile traceFile = null;
    private BufferedWriter out;
    private static int generations;
    protected static long lostRecordCount;
    protected static MessageFile messageFile;
    protected static Vector threads;
    protected static int invalidBuffers;
    protected static float verMod;
    protected static BigInteger overallStartSystem;
    protected static BigInteger overallStartPlatform;
    protected static BigInteger first;
    protected static BigInteger last;
    protected static BigInteger lastWritePlatform;
    protected static BigInteger lastWriteSystem;
    protected static BigInteger timeConversion;
    protected static String headings;
    protected static PrintStream outStream;
    protected static PrintStream errStream;
    protected static int expectedRecords;
    private boolean traceFileIsTruncatedOrCorrupt = false;
    private boolean primed = false;
    protected static final String usageMessage = "Usage:\ntraceformat input_filespec [output_filespec] \n\t[-summary] [-datdir datfiledirectory] [-uservmid vmid] [-thread:id] [-indent] \n\t[-overridetimezone noOfHours] [-help]\n\nwhere:\n\tinput_filespec = trace file generated by the jvm to be processed\n\toutput_filespec = name of the formatted file - default is\n\t      input_filespec.fmt\n\tsummary = print summary information to screen without generating\n\t      formatted file\n\n\tdatdir = used when the formatter is used to format a pre 5.0 vm's\n\t      tracefile. The datfilelocation tells the formatter where to\n\t      find the .dat files of the older vm's dat files. Default is\n\t      current directory, and the .dat files can be safely copied\n\t      into the current directory (as long as they don't overwrite\n\t      the current vm's .dat files).\n\tuservmid = users can specify a string to be inserted into each\n\t      tracepoint's formatted output, to help track and compare\n\t      tracefiles from multiple jvm runs.\n\t      e.g. traceformat 142trcfile /\n\t           -datdir /142sdk/jre/lib\n\tthread = only trace information for the specified thread will \n\t      be formatted. Any number of thread IDs can be specified, \n\t      separated by commas.\n\toverridetimezone = specify an integer number of hours to be\n\t      added to the formatted tracepoints (can be negative).\n\t      This option allows the user to override the default time\n\t      zone used in the formatter (GMT)\n\t      e.g. traceformat 142trcfile /\n\t           -overridetimezone -4\n\tindent = specify indentation at Entry/Exit trace points.\n\t      Default is not to indent.\n\thelp \t= display this message and stop.";
    protected static final String header = "                Trace Formatted Data ";
    private static final int FAIL = -1;
    private static final int OK = 0;
    private static String userVMIdentifier;
    public static final boolean SUPPRESS_VERSION_WARNINGS = false;
    long globalNumberOfBuffers;
    TraceThread[] tempThreadArray;
    TraceThread[] tracedThreads;
    int numberOfThreads;
    BigInteger[] timeStamps;
    private int tracedThreadWithNewestTracePoint = -1;

    public static void main(String[] stringArray) {
        TraceFormat traceFormat = new TraceFormat();
        traceFormat.readAndFormat(stringArray, true);
    }

    public TraceFormat() {
        this.initStatics();
        outStream = System.out;
        errStream = new PrintStream(new PipedOutputStream());
    }

    public TraceFormat(PrintStream printStream, String[] stringArray) {
        this.initStatics();
        outStream = printStream;
        errStream = new PrintStream(new PipedOutputStream());
        this.readAndFormat(stringArray, true);
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            outStream.println("Error closing formatted trace file.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void initStatics() {
        threads = new Vector();
        invalidBuffers = 0;
        overallStartSystem = BigInteger.ZERO;
        overallStartPlatform = BigInteger.ZERO;
        first = new BigInteger("FFFFFFFFFFFFFFFF", 16);
        last = BigInteger.ZERO;
        lastWritePlatform = BigInteger.ZERO;
        lastWriteSystem = BigInteger.ZERO;
        timeConversion = BigInteger.ZERO;
        headings = new String("  ThreadID         TP id  Type         TraceEntry ");
        expectedRecords = 0;
        Util.initStatics();
        TraceArgs.initStatics();
        TraceRecord.initStatics();
        MessageFile.initStatics();
    }

    public void readAndFormat(String[] stringArray, boolean bl) {
        try {
            this.traceArgs = new TraceArgs(stringArray);
        }
        catch (TraceArgs.UsageException usageException) {
            outStream.println(usageException.getMessage());
            outStream.println("TraceFormat Usage:\ntraceformat input_filespec [output_filespec] \n\t[-summary] [-datdir datfiledirectory] [-uservmid vmid] [-thread:id] [-indent] \n\t[-overridetimezone noOfHours] [-help]\n\nwhere:\n\tinput_filespec = trace file generated by the jvm to be processed\n\toutput_filespec = name of the formatted file - default is\n\t      input_filespec.fmt\n\tsummary = print summary information to screen without generating\n\t      formatted file\n\n\tdatdir = used when the formatter is used to format a pre 5.0 vm's\n\t      tracefile. The datfilelocation tells the formatter where to\n\t      find the .dat files of the older vm's dat files. Default is\n\t      current directory, and the .dat files can be safely copied\n\t      into the current directory (as long as they don't overwrite\n\t      the current vm's .dat files).\n\tuservmid = users can specify a string to be inserted into each\n\t      tracepoint's formatted output, to help track and compare\n\t      tracefiles from multiple jvm runs.\n\t      e.g. traceformat 142trcfile /\n\t           -datdir /142sdk/jre/lib\n\tthread = only trace information for the specified thread will \n\t      be formatted. Any number of thread IDs can be specified, \n\t      separated by commas.\n\toverridetimezone = specify an integer number of hours to be\n\t      added to the formatted tracepoints (can be negative).\n\t      This option allows the user to override the default time\n\t      zone used in the formatter (GMT)\n\t      e.g. traceformat 142trcfile /\n\t           -overridetimezone -4\n\tindent = specify indentation at Entry/Exit trace points.\n\t      Default is not to indent.\n\thelp \t= display this message and stop.");
            return;
        }
        if (TraceArgs.isHelpOnly) {
            outStream.println("TraceFormat Usage:\ntraceformat input_filespec [output_filespec] \n\t[-summary] [-datdir datfiledirectory] [-uservmid vmid] [-thread:id] [-indent] \n\t[-overridetimezone noOfHours] [-help]\n\nwhere:\n\tinput_filespec = trace file generated by the jvm to be processed\n\toutput_filespec = name of the formatted file - default is\n\t      input_filespec.fmt\n\tsummary = print summary information to screen without generating\n\t      formatted file\n\n\tdatdir = used when the formatter is used to format a pre 5.0 vm's\n\t      tracefile. The datfilelocation tells the formatter where to\n\t      find the .dat files of the older vm's dat files. Default is\n\t      current directory, and the .dat files can be safely copied\n\t      into the current directory (as long as they don't overwrite\n\t      the current vm's .dat files).\n\tuservmid = users can specify a string to be inserted into each\n\t      tracepoint's formatted output, to help track and compare\n\t      tracefiles from multiple jvm runs.\n\t      e.g. traceformat 142trcfile /\n\t           -datdir /142sdk/jre/lib\n\tthread = only trace information for the specified thread will \n\t      be formatted. Any number of thread IDs can be specified, \n\t      separated by commas.\n\toverridetimezone = specify an integer number of hours to be\n\t      added to the formatted tracepoints (can be negative).\n\t      This option allows the user to override the default time\n\t      zone used in the formatter (GMT)\n\t      e.g. traceformat 142trcfile /\n\t           -overridetimezone -4\n\tindent = specify indentation at Entry/Exit trace points.\n\t      Default is not to indent.\n\thelp \t= display this message and stop.");
            return;
        }
        if (TraceArgs.verbose) {
            errStream = System.err;
        }
        userVMIdentifier = TraceArgs.userVMIdentifier;
        try {
            if (this.getTraceFiles() != 0) {
                return;
            }
            if ((double)verMod >= 0.0) {
                this.out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(TraceArgs.outputFile)));
                Util.Debug.println("TraceFormat.verMod = " + verMod);
                if (!TraceArgs.is50orNewer && (double)verMod < 5.0 || TraceArgs.override) {
                    this.readAndFormatOldStyle();
                } else if (bl) {
                    this.readAndFormatNewStyle();
                } else {
                    this.prime();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(outStream);
        }
    }

    private void readAndFormatOldStyle() throws IOException {
        for (TraceFile this.traceFile : this.traceFiles) {
            this.instantiateMessageFileOldStyle();
            this.traceFile.traceFileHeader.processTraceBufferHeaders();
        }
        for (Object object : threads) {
            Collections.sort(object);
        }
        if (TraceArgs.summary) {
            this.doSummary(new BufferedWriter(new OutputStreamWriter(outStream)));
            return;
        }
        if (this.doSummary(this.out) != 0) {
            return;
        }
        outStream.println("*** starting formatting of entries");
        this.out.write(header, 0, header.length());
        this.out.newLine();
        this.out.newLine();
        if (Integer.valueOf(Util.getProperty("POINTER_SIZE")) == 4) {
            headings = "ThreadID TP id  Type         TraceEntry ";
        }
        this.out.write(Util.getTimerDescription() + headings, 0, headings.length() + Util.getTimerDescription().length());
        this.out.newLine();
        try {
            String string;
            Merge merge = new Merge(threads);
            String string2 = System.getProperty("line.separator");
            while ((string = merge.getNextEntry()) != null) {
                this.out.write(string + string2);
            }
        }
        catch (InvalidSpannedRecordException invalidSpannedRecordException) {
            outStream.println("\n" + invalidSpannedRecordException.getMessage());
            return;
        }
        this.out.flush();
        outStream.println("*** formatted ");
        outStream.println("Formatted output written to file: " + TraceArgs.outputFile);
    }

    private void instantiateMessageFileOldStyle() {
        try {
            outStream.println("Processing pre 50 trace file with 50 formatter. Searching for the .dat files supplied with the traced vm.");
            outStream.println("****Will look in current directory and directory specified by ibm.dg.trc.format environment variable. ***");
            String string = System.getProperty("ibm.dg.trc.format");
            this.instantiateMessageFiles(string);
        }
        catch (Exception exception) {
            outStream.println("Can't open dat files - you need to copy the dat files from the traced vm to the current directory");
            outStream.println(" or use the -datdir flag to tell the formatter which directory it can find them in");
            Util.Debug.println(exception);
            return;
        }
    }

    private MessageFile tryMessageFileInstantiation(String string) {
        if (string != null) {
            try {
                return new MessageFile(string);
            }
            catch (IOException iOException) {
                outStream.println("*** Unable to open " + string + ": " + iOException);
            }
        }
        return null;
    }

    private String findDatFile(String[] stringArray, String string) {
        String string2 = null;
        if (stringArray == null || string == null) {
            return null;
        }
        String string3 = string;
        while (string3 != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = this.constructFullyQualifiedName(stringArray[i], string3);
                File file = new File(string4);
                errStream.println("*** Looking for " + string3 + " in " + stringArray[i] + ".");
                if (!file.exists()) continue;
                outStream.println("*** Found " + file);
                return string4;
            }
            string3 = this.traceFile.getNextFormatFileName(string3);
        }
        return string2;
    }

    private void instantiateMessageFiles(String string) {
        String string2;
        String string3;
        String string4 = this.traceFile.formatFileName();
        outStream.println("*** Locating formatting template files");
        String[] stringArray = TraceArgs.datFileDirectory == null ? new String[]{".", string} : new String[]{TraceArgs.datFileDirectory, ".", string};
        String string5 = this.findDatFile(stringArray, string4);
        if (string5 == null) {
            string5 = this.findDatFile(stringArray, "J9TraceFormat.dat");
        }
        if (string5 != null) {
            messageFile = this.tryMessageFileInstantiation(string5);
        }
        if (messageFile == null) {
            outStream.println("*** Could not find a J9TraceFormat.dat file. JVM trace points may be formatted incorrectly.");
        }
        if ((string3 = this.findDatFile(stringArray, "OMRTraceFormat.dat")) != null) {
            this.tryMessageFileInstantiation(string3);
        }
        if ((string2 = this.findDatFile(stringArray, "TraceFormat.dat")) != null) {
            outStream.println("*** Loading further formatting templates from " + string2);
            MessageFile messageFile = this.tryMessageFileInstantiation(string2);
            if (TraceFormat.messageFile == null) {
                TraceFormat.messageFile = messageFile;
            }
        }
        if (messageFile == null) {
            outStream.println("Could not find a dat file. No trace point parameters will be formatted.");
        }
    }

    private void instantiateMessageFilesNewStyle() {
        String string = System.getProperty("java.home");
        string = string.concat(File.separator).concat("lib");
        this.instantiateMessageFiles(string);
    }

    private final String constructFullyQualifiedName(String string, String string2) {
        return string + File.separator + string2;
    }

    private void prime() throws IOException {
        this.globalNumberOfBuffers = 0L;
        this.tempThreadArray = null;
        this.tracedThreads = null;
        this.numberOfThreads = 0;
        this.timeStamps = null;
        long l = 0L;
        int n = 0;
        Hashtable<Long, TraceThread> hashtable = new Hashtable<Long, TraceThread>();
        outStream.println("*** Starting data extraction from binary trace file(s) ");
        for (TraceFile this.traceFile : this.traceFiles) {
            this.instantiateMessageFilesNewStyle();
            long l2 = this.traceFile.traceFileHeader.getTraceDataStart();
            n = this.traceFile.traceFileHeader.getBufferSize();
            long l3 = this.traceFile.length();
            int n2 = this.traceFile.traceFileHeader.traceSection.getTraceType();
            l = (l3 - l2) / (long)n;
            this.globalNumberOfBuffers += l;
            if ((l3 - l2) / (long)n >= Integer.MAX_VALUE) {
                outStream.println("Trace file " + this.traceFile + " contains more than INT_MAX (" + Integer.MAX_VALUE + ") trace buffers, will only process INT_MAX buffers");
            }
            if ((l3 - l2) % (long)n != 0L) {
                outStream.println("*** TraceFile is truncated, or corrupted, will ignore some incomplete data at the end, but process everything that is available");
                this.traceFileIsTruncatedOrCorrupt = true;
            }
            if (l == 0L) {
                outStream.println("\n\n*** " + this.traceFile + " CONTAINS NO TRACE DATA - skipping file.\n\n");
                continue;
            }
            Util.Debug.println("TP data starts at " + l2 + ", buffer size is " + n + ": file contains " + l + " buffers.");
            outStream.println("*** Extracting " + l + " buffers from " + this.traceFile);
            int n3 = 0;
            while ((long)n3 < l) {
                TraceThread traceThread;
                Util.Debug.println("Processing buffer " + n3 + " at " + (l2 + (long)(n3 * n)));
                TraceRecord50 traceRecord50 = new TraceRecord50();
                traceRecord50.setTraceType(n2);
                Util.Debug.println(" buffer is " + (n2 == 0 ? "internal" : "external"));
                traceRecord50.processTraceBufferHeader(this.traceFile, l2 + (long)n3 * (long)n, n);
                Long l4 = traceRecord50.getThreadIDAsLong();
                if (hashtable.containsKey(l4)) {
                    traceThread = (TraceThread)hashtable.get(l4);
                    traceThread.add(traceRecord50);
                } else {
                    traceThread = new TraceThread(l4, traceRecord50.getThreadName());
                    traceThread.addElement(traceRecord50);
                    threads.addElement(traceThread);
                    hashtable.put(l4, traceThread);
                }
                ++n3;
            }
        }
        if (lastWritePlatform.equals(BigInteger.ZERO)) {
            lastWritePlatform = overallStartPlatform;
            lastWriteSystem = overallStartSystem;
            first = overallStartPlatform;
            last = overallStartPlatform;
        }
        outStream.println("*** Sorting buffers");
        for (Object object : threads) {
            Collections.sort(object);
        }
        if (TraceArgs.summary) {
            this.doSummary(new BufferedWriter(new OutputStreamWriter(outStream)));
            return;
        }
        if (this.doSummary(this.out) != 0) {
            outStream.println("*** Problem printing summary to file - may be incomplete ... continuing");
        }
        outStream.println("*** Starting formatting of entries into text file " + TraceArgs.outputFile);
        this.out.write(header, 0, header.length());
        this.out.newLine();
        this.out.newLine();
        int n4 = Integer.valueOf(Util.getProperty("POINTER_SIZE"));
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; userVMIdentifier != null && i <= userVMIdentifier.length(); ++i) {
            stringBuffer.append(" ");
        }
        headings = n4 == 4 ? stringBuffer + "  ThreadID       TP id     Type        TraceEntry " : stringBuffer + "  ThreadID               TP id     Type        TraceEntry ";
        this.out.write(Util.getTimerDescription() + headings, 0, headings.length() + Util.getTimerDescription().length());
        this.out.newLine();
        this.tempThreadArray = new TraceThread[0];
        this.tracedThreads = threads.toArray(this.tempThreadArray);
        this.numberOfThreads = this.tracedThreads.length;
        System.out.println("*** Number of traced threads = " + this.numberOfThreads);
        this.timeStamps = new BigInteger[this.numberOfThreads];
        this.populateTimeStamps(this.tracedThreads, this.timeStamps, this.numberOfThreads);
        this.primed = true;
    }

    private void readAndFormatNewStyle() throws IOException {
        TracePoint tracePoint;
        if (!this.primed) {
            this.prime();
        }
        double d = (double)this.globalNumberOfBuffers / 10.0;
        int n = 0;
        int n2 = 0;
        long l = 0L;
        int n3 = 0;
        while ((tracePoint = this.findNextTracePoint(this.tracedThreads, this.timeStamps, this.numberOfThreads)) != null) {
            if (!tracePoint.isNormalTracepoint()) {
                this.out.write(tracePoint.toString());
                this.out.newLine();
                continue;
            }
            n2 = TraceThread.getBuffersProcessed();
            StringBuffer stringBuffer = new StringBuffer();
            if ((double)n2 >= (double)n * d) {
                outStream.print(n * 10 + "% ");
                ++n;
            }
            TraceThread traceThread = this.getCurrentTraceThread(this.tracedThreads);
            Message message = MessageFile.getMessageFromID(tracePoint.getComponentName(), tracePoint.getTPID());
            ++n3;
            long l2 = tracePoint.getThreadID();
            if (Util.findThreadID(l2)) {
                String string = tracePoint.getFormattedTime();
                stringBuffer.append(string);
                if (l2 != l) {
                    tracePoint.setIsChangeOfThread(true);
                }
                l = l2;
                stringBuffer.append(tracePoint.toString());
                stringBuffer.append(" ");
                if (message == null) {
                    Util.Debug.println("No message for tracepoint [" + tracePoint.getComponentName() + "." + tracePoint.getTPID() + "]");
                } else {
                    stringBuffer.append(tracePoint.getType());
                    int n4 = tracePoint.getTypeAsInt();
                    if (TraceArgs.indent) {
                        if (n4 == 2 || n4 == 3) {
                            traceThread.indent();
                        }
                        for (int i = 0; i < traceThread.getIndent(); ++i) {
                            stringBuffer.append(" ");
                        }
                        if (n4 == 4 || n4 == 5) {
                            traceThread.outdent();
                        }
                    }
                    String string2 = tracePoint.getFormattedParameters();
                    stringBuffer.append(string2);
                    if (TraceArgs.debug) {
                        stringBuffer.append(" " + tracePoint.from());
                    }
                }
                this.out.write(stringBuffer.toString());
                this.out.newLine();
            }
            this.populateTimeStamps(this.tracedThreads, this.timeStamps, this.numberOfThreads);
        }
        if (n < 11) {
            outStream.print("... 100%");
        }
        outStream.print("\n");
        outStream.println("*** Number of formatted tracepoints = " + n3);
        if ((long)n2 < this.globalNumberOfBuffers) {
            outStream.println("\n" + n2 + "/" + this.globalNumberOfBuffers + " buffers processed successfully\n");
        }
        if (this.traceFileIsTruncatedOrCorrupt) {
            this.out.write(" NOTE - PROBLEMS WERE ENCOUNTERED PROCESSING THE TRACE FILE(S), MOST LIKELY DUE TO TRACE FILE CORRUPTION OR TRUNCATION");
            this.out.newLine();
            this.out.write(" THE CONTENT OF THIS FORMATTED FILE COULD THEREFORE BE TRUNCATED OR CORRUPTED ALSO - REFER TO FORMATTER OUTPUT FOR FURTHER DETAILS");
            this.out.newLine();
        }
        this.out.flush();
        if (lostRecordCount > 0L) {
            outStream.println("*** " + lostRecordCount + " buffers were discarded during trace data generation");
        }
        outStream.println("*** Formatting complete");
        outStream.println("*** Formatted output written to file: " + TraceArgs.outputFile);
    }

    protected int doSummary(BufferedWriter bufferedWriter) throws IOException {
        Object object;
        Object object2;
        bufferedWriter.write("                Trace Summary");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        TraceFile traceFile = (TraceFile)this.traceFiles.firstElement();
        traceFile.traceFileHeader.summarize(bufferedWriter);
        bufferedWriter.write("Active Threads :");
        bufferedWriter.newLine();
        for (TraceThread traceThread : threads) {
            bufferedWriter.write("        " + Util.formatAsHexString(traceThread.threadID));
            bufferedWriter.write("  ");
            bufferedWriter.write(traceThread.threadName);
            bufferedWriter.newLine();
        }
        bufferedWriter.newLine();
        if ((double)verMod >= 1.1) {
            object2 = lastWritePlatform.subtract(overallStartPlatform);
            object = lastWriteSystem.subtract(overallStartSystem);
            Util.Debug.println("lastWritePlatform:    " + lastWritePlatform);
            Util.Debug.println("lastWriteSystem:      " + lastWriteSystem);
            Util.Debug.println("overallStartPlatform: " + overallStartPlatform);
            Util.Debug.println("overallStartSystem:   " + overallStartSystem);
            Util.Debug.println("spanPlatform:         " + object2);
            Util.Debug.println("spanSystem:           " + object);
            timeConversion = overallStartSystem.compareTo(BigInteger.ZERO) != 0 && ((BigInteger)object).compareTo(BigInteger.ZERO) != 0 ? ((BigInteger)object2).divide((BigInteger)object) : BigInteger.ONE;
            Util.Debug.println("timeConversion:         " + timeConversion);
            bufferedWriter.write("JVM started      : " + Util.getFormattedTime(overallStartPlatform));
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("Last buffer write: " + Util.getFormattedTime(lastWritePlatform));
            bufferedWriter.newLine();
            bufferedWriter.newLine();
        }
        object2 = "First tracepoint:  " + Util.getFormattedTime(first);
        object = "Last tracepoint :  " + Util.getFormattedTime(last);
        bufferedWriter.write((String)object2, 0, ((String)object2).length());
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write((String)object, 0, ((String)object).length());
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.flush();
        return 0;
    }

    static final void setStartSystem(BigInteger bigInteger) {
        if (overallStartSystem.equals(BigInteger.ZERO)) {
            overallStartSystem = bigInteger;
        }
        if (overallStartSystem.compareTo(bigInteger) == -1) {
            overallStartSystem = bigInteger;
        }
    }

    static final void setStartPlatform(BigInteger bigInteger) {
        if (overallStartPlatform.equals(BigInteger.ZERO)) {
            overallStartPlatform = bigInteger;
        }
        if (overallStartPlatform.compareTo(bigInteger) == -1) {
            overallStartPlatform = bigInteger;
        }
    }

    final int getTraceFiles() {
        int n = 36;
        int n2 = TraceArgs.traceFile.indexOf("#");
        if (n2 == -1) {
            try {
                this.traceFiles.addElement(new TraceFile(TraceArgs.traceFile, "r"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                outStream.println("Trace file " + TraceArgs.traceFile + " not found");
                return -1;
            }
            catch (Exception exception) {
                exception.printStackTrace(errStream);
                return -1;
            }
        } else {
            int n3 = 0;
            char c = '\u0000';
            for (n3 = 0; n3 < n; ++n3) {
                c = Integer.toString(n3, n).toUpperCase().charAt(0);
                try {
                    this.traceFiles.addElement(new TraceFile(TraceArgs.traceFile.replace('#', c), "r"));
                    continue;
                }
                catch (Exception exception) {
                    Util.Debug.println("TraceFormat: generations found " + n3);
                    break;
                }
            }
            if (n3 == 0) {
                outStream.println("Trace file is missing");
                return -1;
            }
            if (n3 != generations) {
                Util.Debug.println("TraceFormat: generations = " + generations);
                outStream.println("Trace file " + TraceArgs.traceFile.replace('#', c) + " is missing");
            }
            outStream.println("Processing " + (n3 != generations ? Integer.toString(n3) : "all") + " of the " + generations + " generations specified at runtime");
        }
        return 0;
    }

    static final void setGenerations(int n) {
        generations = n;
    }

    public static String getUserVMIdentifier() {
        return userVMIdentifier;
    }

    private boolean populateTimeStamps(TraceThread[] traceThreadArray, BigInteger[] bigIntegerArray, int n) {
        for (int i = 0; i < n; ++i) {
            bigIntegerArray[i] = traceThreadArray[i].getTimeOfNextTracePoint();
        }
        return true;
    }

    private TraceThread getCurrentTraceThread(TraceThread[] traceThreadArray) {
        if (this.tracedThreadWithNewestTracePoint < 0) {
            return null;
        }
        return traceThreadArray[this.tracedThreadWithNewestTracePoint];
    }

    public com.ibm.jvm.trace.TraceThread[] getTraceThreads() {
        return this.tracedThreads;
    }

    public com.ibm.jvm.trace.TracePoint getNextTracePoint() {
        TracePoint tracePoint = this.findNextTracePoint(this.tracedThreads, this.timeStamps, this.numberOfThreads);
        this.populateTimeStamps(this.tracedThreads, this.timeStamps, this.numberOfThreads);
        return tracePoint;
    }

    private TracePoint findNextTracePoint(TraceThread[] traceThreadArray, BigInteger[] bigIntegerArray, int n) {
        this.tracedThreadWithNewestTracePoint = 0;
        if (bigIntegerArray.length == 0 || traceThreadArray == null || n == 0) {
            this.tracedThreadWithNewestTracePoint = -1;
            return null;
        }
        BigInteger bigInteger = bigIntegerArray[0];
        for (int i = 1; i < n; ++i) {
            if (bigInteger == null) {
                bigInteger = bigIntegerArray[i];
                this.tracedThreadWithNewestTracePoint = i;
                continue;
            }
            if (bigIntegerArray[i] == null || bigInteger.compareTo(bigIntegerArray[i]) <= 0) continue;
            bigInteger = bigIntegerArray[i];
            this.tracedThreadWithNewestTracePoint = i;
        }
        if (bigInteger == null) {
            this.tracedThreadWithNewestTracePoint = -1;
            return null;
        }
        return traceThreadArray[this.tracedThreadWithNewestTracePoint].getNextTracePoint();
    }

    public TraceFileHeader getTraceFileHeader() {
        TraceFile traceFile = (TraceFile)this.traceFiles.firstElement();
        if (traceFile == null) {
            return null;
        }
        return traceFile.getHeader();
    }

    static {
        lostRecordCount = 0L;
        verMod = -1.0f;
        userVMIdentifier = null;
    }
}

