/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9;

import com.ibm.dtfj.javacore.parser.framework.tag.ITagManager;
import com.ibm.dtfj.javacore.parser.framework.tag.ITagParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class J9TagManager
implements ITagManager {
    private HashMap fAllTags = new HashMap();
    private HashMap fTagParsers = new HashMap();
    private static J9TagManager fTagManager;
    public static final String CHECK_ALL = "check_all";
    private String fCommentType = "NULL";

    public static J9TagManager getCurrent() {
        if (fTagManager == null) {
            fTagManager = new J9TagManager();
        }
        return fTagManager;
    }

    public void loadTagParsers(ArrayList arrayList) {
        if (arrayList == null) {
            return;
        }
        this.fAllTags.clear();
        this.fTagParsers.clear();
        for (ITagParser iTagParser : arrayList) {
            if (iTagParser == null) continue;
            this.fTagParsers.put(iTagParser.getSectionName(), iTagParser);
        }
        this.fillAllTags();
    }

    private void fillAllTags() {
        for (ITagParser iTagParser : this.fTagParsers.values()) {
            Iterator iterator = iTagParser.getTags();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string == null) continue;
                this.fAllTags.put(string, string);
            }
        }
    }

    @Override
    public boolean hasTag(String string) {
        return this.fAllTags.containsKey(string);
    }

    @Override
    public ITagParser getTagParser(String string) {
        return (ITagParser)this.fTagParsers.get(string);
    }

    @Override
    public boolean isTagInSection(String string, String string2) {
        boolean bl = false;
        if (string2.equals(CHECK_ALL)) {
            bl = this.fAllTags.containsKey(string);
        } else {
            ITagParser iTagParser = (ITagParser)this.fTagParsers.get(string2);
            if (iTagParser != null) {
                bl = iTagParser.hasTag(string);
            }
        }
        return bl;
    }

    @Override
    public boolean isComment(CharSequence charSequence) {
        boolean bl = false;
        int n = 0;
        if (charSequence != null && (n = this.fCommentType.length()) == charSequence.length()) {
            for (int i = 0; i < n && (bl = this.fCommentType.charAt(i) == charSequence.charAt(i)); ++i) {
            }
        }
        return bl;
    }
}

