/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;

public class PHDCorruptData
implements CorruptData {
    private final String reason;
    private final ImagePointer address;
    private final Exception cause;

    PHDCorruptData(ImageAddressSpace imageAddressSpace, CorruptDataException corruptDataException) {
        this(corruptDataException.getCorruptData().toString(), PHDCorruptData.convPointer(imageAddressSpace, corruptDataException.getCorruptData().getAddress()), corruptDataException);
    }

    PHDCorruptData(ImageAddressSpace imageAddressSpace, CorruptData corruptData) {
        this(corruptData.toString(), PHDCorruptData.convPointer(imageAddressSpace, corruptData.getAddress()));
    }

    PHDCorruptData(String string, ImagePointer imagePointer) {
        this(string, imagePointer, null);
    }

    PHDCorruptData(String string, ImagePointer imagePointer, Exception exception) {
        this.reason = string;
        this.address = imagePointer;
        this.cause = exception;
    }

    @Override
    public ImagePointer getAddress() {
        return this.address;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.reason != null) {
            stringBuffer.append(this.reason);
        }
        if (this.address != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" at ");
            }
            stringBuffer.append("0x").append(Long.toHexString(this.address.getAddress()));
        }
        if (this.cause != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(": ");
            }
            stringBuffer.append(this.cause);
        }
        return stringBuffer.toString();
    }

    static CorruptDataException newCorruptDataException(PHDCorruptData pHDCorruptData) {
        CorruptDataException corruptDataException = new CorruptDataException(pHDCorruptData);
        pHDCorruptData.initCause(corruptDataException);
        return corruptDataException;
    }

    CorruptDataException initCause(CorruptDataException corruptDataException) {
        if (this.cause != null) {
            corruptDataException.initCause(this.cause);
        }
        return corruptDataException;
    }

    private static ImagePointer convPointer(ImageAddressSpace imageAddressSpace, ImagePointer imagePointer) {
        if (imagePointer != null) {
            return imageAddressSpace.getPointer(imagePointer.getAddress());
        }
        return null;
    }
}

