/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.util.RuntimeTypeResolutionUtils;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U32;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;

public abstract class StructurePointer
extends AbstractPointer {
    private static final String nl = System.getProperty("line.separator");

    protected StructurePointer(long l) {
        super(l);
    }

    public final long nonNullFieldEA(long l) throws NullPointerDereference {
        return this.nonNullAddress() + l;
    }

    @Override
    public DataType at(long l) {
        throw new UnsupportedOperationException("StructurePointers are implicitly dereferenced.  Use add(long count) instead.");
    }

    @Override
    public DataType at(Scalar scalar) {
        throw new UnsupportedOperationException("StructurePointers are implicitly dereferenced.  Use add(Scalar count) instead.");
    }

    protected int getStartingBit(int n, int n2) {
        switch (BITFIELD_FORMAT) {
            case 1: {
                return n2 + n % 32;
            }
            case 2: {
                return 32 - n % 32;
            }
        }
        throw new IllegalArgumentException("Unsupported bitfield format");
    }

    protected U32 getU32Bitfield(int n, int n2) throws CorruptDataException {
        int n3 = n / 32;
        U32 u32 = new U32(this.getIntAtOffset(n3 * 32 / 8));
        int n4 = this.getStartingBit(n, n2);
        U32 u322 = u32.leftShift(32 - n4);
        u322 = u322.rightShift(32 - n2);
        return u322;
    }

    protected I32 getI32Bitfield(int n, int n2) throws CorruptDataException {
        int n3 = n / 32;
        I32 i32 = new I32(this.getIntAtOffset(n3 * 32 / 8));
        int n4 = this.getStartingBit(n, n2);
        I32 i322 = i32.leftShift(32 - n4);
        i322 = i322.rightShift(32 - n2);
        return i322;
    }

    public StructurePointer getAsRuntimeType() {
        try {
            Method method = this.getClass().getMethod("_typeId", new Class[0]);
            U8Pointer u8Pointer = (U8Pointer)method.invoke((Object)this, new Object[0]);
            String string = u8Pointer.getCStringAtOffset(0L);
            if (u8Pointer.notNull()) {
                string = RuntimeTypeResolutionUtils.cleanTypeStr(string);
                Class<?> clazz = Class.forName(this.getClass().getPackage().getName() + "." + string + "Pointer");
                Method method2 = clazz.getMethod("cast", AbstractPointer.class);
                Object object = method2.invoke(null, this);
                return (StructurePointer)object;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public String formatFullInteractive() {
        StructureField[] structureFieldArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTargetName());
        stringBuilder.append(" at ");
        stringBuilder.append("0x");
        stringBuilder.append(Long.toHexString(this.getAddress()));
        stringBuilder.append(" {");
        stringBuilder.append(nl);
        for (StructureField structureField : structureFieldArray = this.getStructureFields()) {
            stringBuilder.append("\t0x");
            stringBuilder.append(Integer.toHexString(structureField.offset));
            stringBuilder.append(": ");
            stringBuilder.append(structureField.type);
            stringBuilder.append(" ");
            stringBuilder.append(structureField.name);
            stringBuilder.append(" = ");
            if (structureField.cde != null) {
                stringBuilder.append("<FAULT: " + structureField.cde.getMessage() + ">");
            } else if (structureField.value != null) {
                stringBuilder.append(structureField.value.formatShortInteractive());
            } else {
                stringBuilder.append("null");
            }
            stringBuilder.append(nl);
        }
        stringBuilder.append("}");
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public StructureField[] getStructureFields() {
        StructureField[] structureFieldArray;
        LinkedList<StructureField> linkedList = new LinkedList<StructureField>();
        for (Class<?> clazz = this.getClass(); clazz != null && null != (structureFieldArray = clazz.getAnnotation(GeneratedPointerClass.class)); clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getMethods()) {
                if (!method.isAnnotationPresent(GeneratedFieldAccessor.class)) continue;
                GeneratedFieldAccessor generatedFieldAccessor = method.getAnnotation(GeneratedFieldAccessor.class);
                Field field = null;
                try {
                    field = structureFieldArray.structureClass().getField(generatedFieldAccessor.offsetFieldName());
                }
                catch (SecurityException securityException) {
                    throw new Error("Unexpected security exception", securityException);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
                int n = -1;
                try {
                    n = field.getInt(null);
                }
                catch (Exception exception) {
                    throw new Error(exception);
                }
                DataType dataType = null;
                CorruptDataException corruptDataException = null;
                try {
                    dataType = (DataType)method.invoke((Object)this, new Object[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getCause();
                    if (throwable instanceof CorruptDataException) {
                        corruptDataException = (CorruptDataException)throwable;
                    }
                    throw new RuntimeException(invocationTargetException);
                }
                linkedList.add(new StructureField(method.getName(), generatedFieldAccessor.declaredType(), n, dataType, corruptDataException));
            }
        }
        Collections.sort(linkedList);
        structureFieldArray = new StructureField[linkedList.size()];
        linkedList.toArray(structureFieldArray);
        return structureFieldArray;
    }

    public static class StructureField
    implements Comparable<StructureField> {
        public final int offset;
        public final String name;
        public final DataType value;
        public final String type;
        public final CorruptDataException cde;

        StructureField(String string, String string2, int n, DataType dataType, CorruptDataException corruptDataException) {
            this.name = string;
            this.offset = n;
            this.value = dataType;
            this.type = string2;
            this.cde = corruptDataException;
        }

        @Override
        public int compareTo(StructureField structureField) {
            return this.offset - structureField.offset;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.type);
            stringBuilder.append(" ");
            stringBuilder.append(this.name);
            stringBuilder.append(" (");
            if (this.cde == null) {
                stringBuilder.append(Integer.toHexString(this.offset));
            } else {
                stringBuilder.append("<FAULT: " + this.cde.getMessage() + ">");
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }
}

