/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.internal.ProcessorUsageUtil;
import com.ibm.oti.util.Msg;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;

public class ProcessorUsage {
    private static final int HASHMASK = 0xFFFFFFF;
    private long user;
    private long system;
    private long idle;
    private long wait;
    private long busy;
    private int id;
    private int online;
    private long timestamp;

    public ProcessorUsage() {
    }

    private ProcessorUsage(long l, long l2, long l3, long l4, long l5, int n, int n2, long l6) throws IllegalArgumentException {
        if (l < -1L || l2 < -1L || l3 < -1L || l4 < -1L || l5 < -1L || n < -1 || n2 < 0 || n2 > 1 || l6 < 0L || l >= 0L && l2 >= 0L && l4 >= 0L && l5 >= 0L && l5 < l + l2 + l4) {
            throw new IllegalArgumentException();
        }
        this.user = l;
        this.system = l2;
        this.idle = l3;
        this.wait = l4;
        this.busy = l5;
        this.id = n;
        this.online = n2;
        this.timestamp = l6;
    }

    public long getUser() {
        return this.user;
    }

    public long getSystem() {
        return this.system;
    }

    public long getIdle() {
        return this.idle;
    }

    public long getWait() {
        return this.wait;
    }

    public long getBusy() {
        return this.busy;
    }

    public int getId() {
        return this.id;
    }

    public int getOnline() {
        return this.online;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    void updateValues(long l, long l2, long l3, long l4, long l5, int n, int n2, long l6) {
        this.user = l;
        this.system = l2;
        this.idle = l3;
        this.wait = l4;
        this.busy = l5;
        this.id = n;
        this.online = n2;
        this.timestamp = l6;
    }

    public static ProcessorUsage from(CompositeData compositeData) {
        ProcessorUsage processorUsage = null;
        if (null != compositeData) {
            long l;
            int n;
            int n2;
            long l2;
            long l3;
            long l4;
            long l5;
            long l6;
            if (!ProcessorUsageUtil.getCompositeType().isValue(compositeData)) {
                throw new IllegalArgumentException(Msg.getString("K05E5"));
            }
            try {
                l6 = (Long)compositeData.get("user");
                l5 = (Long)compositeData.get("system");
                l4 = (Long)compositeData.get("idle");
                l3 = (Long)compositeData.get("wait");
                l2 = (Long)compositeData.get("busy");
                n2 = (Integer)compositeData.get("id");
                n = (Integer)compositeData.get("online");
                l = (Long)compositeData.get("timestamp");
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IllegalArgumentException(Msg.getString("K05E6"));
            }
            processorUsage = new ProcessorUsage(l6, l5, l4, l3, l2, n2, n, l);
        }
        return processorUsage;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n========== ");
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" ==========\n\n");
        stringBuilder.append("timestamp = ");
        stringBuilder.append(this.timestamp);
        stringBuilder.append("\n");
        stringBuilder.append("id = ");
        stringBuilder.append(this.id);
        stringBuilder.append("\n");
        stringBuilder.append("online = ");
        stringBuilder.append(this.online);
        stringBuilder.append("\n");
        stringBuilder.append("user = ");
        stringBuilder.append(this.user);
        stringBuilder.append("\n");
        stringBuilder.append("system = ");
        stringBuilder.append(this.system);
        stringBuilder.append("\n");
        stringBuilder.append("wait = ");
        stringBuilder.append(this.wait);
        stringBuilder.append("\n");
        stringBuilder.append("busy = ");
        stringBuilder.append(this.busy);
        stringBuilder.append("\n");
        stringBuilder.append("idle = ");
        stringBuilder.append(this.idle);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object) {
            return false;
        }
        if (!(object instanceof ProcessorUsage)) {
            return false;
        }
        ProcessorUsage processorUsage = (ProcessorUsage)object;
        if (processorUsage.getUser() != this.getUser()) {
            return false;
        }
        if (processorUsage.getSystem() != this.getSystem()) {
            return false;
        }
        if (processorUsage.getIdle() != this.getIdle()) {
            return false;
        }
        if (processorUsage.getWait() != this.getWait()) {
            return false;
        }
        if (processorUsage.getBusy() != this.getBusy()) {
            return false;
        }
        if (processorUsage.getId() != this.getId()) {
            return false;
        }
        if (processorUsage.getOnline() != this.getOnline()) {
            return false;
        }
        return processorUsage.getTimestamp() == this.getTimestamp();
    }

    public int hashCode() {
        long l = this.getUser() + this.getSystem() + this.getIdle() + this.getWait() + this.getBusy() + (long)this.getId() + (long)this.getOnline() + this.getTimestamp();
        return (int)(((l >> 32) + l & 0xFFFFFFFL) * 23L);
    }
}

