/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import sun.security.jca.JCAUtil;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

abstract class DSA
extends SignatureSpi {
    private static final boolean debug = false;
    private static final int BLINDING_BITS = 7;
    private static final BigInteger BLINDING_CONSTANT = BigInteger.valueOf(128L);
    private DSAParams params;
    private BigInteger presetP;
    private BigInteger presetQ;
    private BigInteger presetG;
    private BigInteger presetY;
    private BigInteger presetX;
    private SecureRandom signingRandom;
    private final MessageDigest md;

    DSA(MessageDigest messageDigest) {
        this.md = messageDigest;
    }

    private static void checkKey(DSAParams dSAParams, int n, String string) throws InvalidKeyException {
        int n2 = dSAParams.getQ().bitLength();
        if (n2 > n) {
            throw new InvalidKeyException("The security strength of " + string + " digest algorithm is not sufficient for this key size");
        }
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("not a DSA private key: " + privateKey);
        }
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
        DSAParams dSAParams = dSAPrivateKey.getParams();
        if (dSAParams == null) {
            throw new InvalidKeyException("DSA private key lacks parameters");
        }
        if (this.md.getAlgorithm() != "NullDigest20") {
            DSA.checkKey(dSAParams, this.md.getDigestLength() * 8, this.md.getAlgorithm());
        }
        this.params = dSAParams;
        this.presetX = dSAPrivateKey.getX();
        this.presetY = null;
        this.presetP = dSAParams.getP();
        this.presetQ = dSAParams.getQ();
        this.presetG = dSAParams.getG();
        this.md.reset();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("not a DSA public key: " + publicKey);
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        DSAParams dSAParams = dSAPublicKey.getParams();
        if (dSAParams == null) {
            throw new InvalidKeyException("DSA public key lacks parameters");
        }
        this.params = dSAParams;
        this.presetY = dSAPublicKey.getY();
        this.presetX = null;
        this.presetP = dSAParams.getP();
        this.presetQ = dSAParams.getQ();
        this.presetG = dSAParams.getG();
        this.md.reset();
    }

    @Override
    protected void engineUpdate(byte by) {
        this.md.update(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.md.update(byArray, n, n2);
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.md.update(byteBuffer);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        BigInteger bigInteger = this.generateK(this.presetQ);
        BigInteger bigInteger2 = this.generateR(this.presetP, this.presetQ, this.presetG, bigInteger);
        BigInteger bigInteger3 = this.generateS(this.presetX, this.presetQ, bigInteger2, bigInteger);
        try {
            DerOutputStream derOutputStream = new DerOutputStream(100);
            derOutputStream.putInteger(bigInteger2);
            derOutputStream.putInteger(bigInteger3);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new SignatureException("error encoding signature");
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.engineVerify(byArray, 0, byArray.length);
    }

    @Override
    protected boolean engineVerify(byte[] byArray, int n, int n2) throws SignatureException {
        Object object;
        Object object2;
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        try {
            object2 = new DerInputStream(byArray, n, n2, false);
            object = ((DerInputStream)object2).getSequence(2);
            if (((DerValue[])object).length != 2 || ((DerInputStream)object2).available() != 0) {
                throw new IOException("Invalid encoding for signature");
            }
            bigInteger = object[0].getBigInteger();
            bigInteger2 = object[1].getBigInteger();
        }
        catch (IOException iOException) {
            throw new SignatureException("Invalid encoding for signature", iOException);
        }
        if (bigInteger.signum() < 0) {
            bigInteger = new BigInteger(1, bigInteger.toByteArray());
        }
        if (bigInteger2.signum() < 0) {
            bigInteger2 = new BigInteger(1, bigInteger2.toByteArray());
        }
        if (bigInteger.compareTo(this.presetQ) == -1 && bigInteger2.compareTo(this.presetQ) == -1) {
            object2 = this.generateW(this.presetP, this.presetQ, this.presetG, bigInteger2);
            object = this.generateV(this.presetY, this.presetP, this.presetQ, this.presetG, (BigInteger)object2, bigInteger);
            return ((BigInteger)object).equals(bigInteger);
        }
        throw new SignatureException("invalid signature: out of range values");
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) {
        throw new InvalidParameterException("No parameter accepted");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("No parameter accepted");
        }
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    private BigInteger generateR(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        SecureRandom secureRandom = this.getSigningRandom();
        BigInteger bigInteger5 = new BigInteger(7, secureRandom);
        bigInteger5 = bigInteger5.add(BLINDING_CONSTANT);
        bigInteger4 = bigInteger4.add(bigInteger2.multiply(bigInteger5));
        BigInteger bigInteger6 = bigInteger3.modPow(bigInteger4, bigInteger);
        return bigInteger6.mod(bigInteger2);
    }

    private BigInteger generateS(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws SignatureException {
        byte[] byArray;
        try {
            byArray = this.md.digest();
        }
        catch (RuntimeException runtimeException) {
            throw new SignatureException(runtimeException.getMessage());
        }
        int n = bigInteger2.bitLength() / 8;
        if (n < byArray.length) {
            byArray = Arrays.copyOfRange(byArray, 0, n);
        }
        BigInteger bigInteger5 = new BigInteger(1, byArray);
        BigInteger bigInteger6 = bigInteger4.modInverse(bigInteger2);
        return bigInteger.multiply(bigInteger3).add(bigInteger5).multiply(bigInteger6).mod(bigInteger2);
    }

    private BigInteger generateW(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        return bigInteger4.modInverse(bigInteger2);
    }

    private BigInteger generateV(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6) throws SignatureException {
        byte[] byArray;
        try {
            byArray = this.md.digest();
        }
        catch (RuntimeException runtimeException) {
            throw new SignatureException(runtimeException.getMessage());
        }
        int n = bigInteger3.bitLength() / 8;
        if (n < byArray.length) {
            byArray = Arrays.copyOfRange(byArray, 0, n);
        }
        BigInteger bigInteger7 = new BigInteger(1, byArray);
        BigInteger bigInteger8 = bigInteger7.multiply(bigInteger5).mod(bigInteger3);
        BigInteger bigInteger9 = bigInteger6.multiply(bigInteger5).mod(bigInteger3);
        BigInteger bigInteger10 = bigInteger4.modPow(bigInteger8, bigInteger2);
        BigInteger bigInteger11 = bigInteger.modPow(bigInteger9, bigInteger2);
        BigInteger bigInteger12 = bigInteger10.multiply(bigInteger11);
        BigInteger bigInteger13 = bigInteger12.mod(bigInteger2);
        return bigInteger13.mod(bigInteger3);
    }

    protected BigInteger generateK(BigInteger bigInteger) {
        SecureRandom secureRandom = this.getSigningRandom();
        byte[] byArray = new byte[(bigInteger.bitLength() + 7) / 8 + 8];
        secureRandom.nextBytes(byArray);
        return new BigInteger(1, byArray).mod(bigInteger.subtract(BigInteger.ONE)).add(BigInteger.ONE);
    }

    protected SecureRandom getSigningRandom() {
        if (this.signingRandom == null) {
            this.signingRandom = this.appRandom != null ? this.appRandom : JCAUtil.getSecureRandom();
        }
        return this.signingRandom;
    }

    public String toString() {
        String string = "DSA Signature";
        if (this.presetP != null && this.presetQ != null && this.presetG != null) {
            string = string + "\n\tp: " + Debug.toHexString(this.presetP);
            string = string + "\n\tq: " + Debug.toHexString(this.presetQ);
            string = string + "\n\tg: " + Debug.toHexString(this.presetG);
        } else {
            string = string + "\n\t P, Q or G not initialized.";
        }
        if (this.presetY != null) {
            string = string + "\n\ty: " + Debug.toHexString(this.presetY);
        }
        if (this.presetY == null && this.presetX == null) {
            string = string + "\n\tUNINIIALIZED";
        }
        return string;
    }

    public static final class RawDSA
    extends DSA {
        public RawDSA() throws NoSuchAlgorithmException {
            super(new NullDigest20());
        }

        public static final class NullDigest20
        extends MessageDigest {
            private final byte[] digestBuffer = new byte[20];
            private int ofs = 0;

            protected NullDigest20() {
                super("NullDigest20");
            }

            @Override
            protected void engineUpdate(byte by) {
                if (this.ofs == this.digestBuffer.length) {
                    this.ofs = Integer.MAX_VALUE;
                } else {
                    this.digestBuffer[this.ofs++] = by;
                }
            }

            @Override
            protected void engineUpdate(byte[] byArray, int n, int n2) {
                if (n2 > this.digestBuffer.length - this.ofs) {
                    this.ofs = Integer.MAX_VALUE;
                } else {
                    System.arraycopy((Object)byArray, n, (Object)this.digestBuffer, this.ofs, n2);
                    this.ofs += n2;
                }
            }

            @Override
            protected final void engineUpdate(ByteBuffer byteBuffer) {
                int n = byteBuffer.remaining();
                if (n > this.digestBuffer.length - this.ofs) {
                    this.ofs = Integer.MAX_VALUE;
                } else {
                    byteBuffer.get(this.digestBuffer, this.ofs, n);
                    this.ofs += n;
                }
            }

            @Override
            protected byte[] engineDigest() throws RuntimeException {
                if (this.ofs != this.digestBuffer.length) {
                    throw new RuntimeException("Data for RawDSA must be exactly 20 bytes long");
                }
                this.reset();
                return this.digestBuffer;
            }

            @Override
            protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
                if (this.ofs != this.digestBuffer.length) {
                    throw new DigestException("Data for RawDSA must be exactly 20 bytes long");
                }
                if (n2 < this.digestBuffer.length) {
                    throw new DigestException("Output buffer too small; must be at least 20 bytes");
                }
                System.arraycopy((Object)this.digestBuffer, 0, (Object)byArray, n, this.digestBuffer.length);
                this.reset();
                return this.digestBuffer.length;
            }

            @Override
            protected void engineReset() {
                this.ofs = 0;
            }

            @Override
            protected final int engineGetDigestLength() {
                return this.digestBuffer.length;
            }
        }
    }

    public static final class SHA1withDSA
    extends DSA {
        public SHA1withDSA() throws NoSuchAlgorithmException {
            super(MessageDigest.getInstance("SHA-1"));
        }
    }

    public static final class SHA256withDSA
    extends DSA {
        public SHA256withDSA() throws NoSuchAlgorithmException {
            super(MessageDigest.getInstance("SHA-256"));
        }
    }

    public static final class SHA224withDSA
    extends DSA {
        public SHA224withDSA() throws NoSuchAlgorithmException {
            super(MessageDigest.getInstance("SHA-224"));
        }
    }
}

