/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview;

import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.jvm.dtfjview.CombinedContext;
import com.ibm.jvm.dtfjview.spi.ICombinedContext;
import com.ibm.jvm.dtfjview.spi.ISessionContextManager;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class JdmpviewContextManager
implements ISessionContextManager {
    private Map<URI, ArrayList<ICombinedContext>> contextTracker = new LinkedHashMap<URI, ArrayList<ICombinedContext>>();
    private int maxContextID = 0;
    private boolean hasChanged = false;

    public ICombinedContext createContext(Image image, int n, int n2, ImageAddressSpace imageAddressSpace, ImageProcess imageProcess, JavaRuntime javaRuntime) {
        ArrayList<ICombinedContext> arrayList = this.contextTracker.get(image.getSource());
        CombinedContext combinedContext = new CombinedContext(n, n2, image, imageAddressSpace, imageProcess, javaRuntime, this.maxContextID);
        combinedContext.refresh();
        ++this.maxContextID;
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.contextTracker.put(image.getSource(), arrayList);
        }
        arrayList.add(combinedContext);
        this.hasChanged = true;
        return combinedContext;
    }

    @Override
    public void removeContexts(Image image) {
        this.removeContexts(image.getSource());
    }

    @Override
    public void removeContexts(URI uRI) {
        if (this.contextTracker.containsKey(uRI)) {
            for (ICombinedContext iCombinedContext : this.contextTracker.get(uRI)) {
                iCombinedContext.getImage().close();
            }
            this.contextTracker.remove(uRI);
            this.hasChanged = true;
        }
    }

    @Override
    public void removeAllContexts() {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        for (URI uRI : this.contextTracker.keySet()) {
            arrayList.add(uRI);
        }
        for (URI uRI : arrayList) {
            this.removeContexts(uRI);
        }
    }

    @Override
    public Map<URI, ArrayList<ICombinedContext>> getContexts() {
        return Collections.unmodifiableMap(this.contextTracker);
    }

    @Override
    public boolean hasMultipleContexts() {
        switch (this.contextTracker.size()) {
            case 0: {
                return false;
            }
            case 1: {
                return this.contextTracker.values().size() > 1;
            }
        }
        return true;
    }

    @Override
    public ICombinedContext getContext(int n) {
        if (n < 0 || n > this.maxContextID) {
            return null;
        }
        for (ArrayList<ICombinedContext> arrayList : this.contextTracker.values()) {
            for (ICombinedContext iCombinedContext : arrayList) {
                if (iCombinedContext.getID() != n) continue;
                return iCombinedContext;
            }
        }
        return null;
    }

    @Override
    public boolean hasChanged() {
        boolean bl = this.hasChanged;
        this.hasChanged = false;
        return bl;
    }
}

