/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import java.io.PrintStream;
import java.util.Iterator;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoHeapCommand
extends BaseJdmpviewCommand {
    public InfoHeapCommand() {
        this.addCommand("info heap", "[*|heap name]", "Displays information about Java heaps");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        printStream.print("\n");
        if (stringArray.length == 0) {
            this.printHeapInfo(null, this.ctx.getRuntime(), printStream);
            printStream.print("\nUse \"info heap *\" or \"info heap <heap_name>\" for more information.\n");
            return;
        }
        if (stringArray[0].equals("*") || stringArray[0].equals("ALL")) {
            this.printHeapInfo(stringArray[0], this.ctx.getRuntime(), printStream);
            return;
        }
        boolean bl = this.searchForHeap(stringArray[0], this.ctx.getRuntime(), printStream);
        if (!bl) {
            printStream.print("Unable to locate heap: \"" + stringArray[0] + "\".");
            printStream.print("\tAvailable heaps: \n");
            this.printHeapInfo(null, this.ctx.getRuntime(), printStream);
        }
    }

    private void printHeapInfo(String string, JavaRuntime javaRuntime, PrintStream printStream) {
        Iterator iterator = javaRuntime.getHeaps();
        int n = 1;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof CorruptData) {
                printStream.println("[skipping corrupt heap");
                continue;
            }
            JavaHeap javaHeap = (JavaHeap)e;
            printStream.print("\t Heap #" + n + ":  " + javaHeap.getName() + "\n");
            if (string != null) {
                this.printSectionInfo(javaHeap, printStream);
            }
            ++n;
        }
    }

    private void printSectionInfo(JavaHeap javaHeap, PrintStream printStream) {
        Iterator iterator = javaHeap.getSections();
        int n = 1;
        while (iterator.hasNext()) {
            ImageSection imageSection = (ImageSection)iterator.next();
            printStream.print("\t  Section #" + n + ":  " + imageSection.getName() + "\n");
            printStream.print("\t   Size:        " + imageSection.getSize() + " bytes\n");
            try {
                printStream.print("\t   Shared:      " + imageSection.isShared() + "\n");
                printStream.print("\t   Executable:  " + imageSection.isExecutable() + "\n");
                printStream.print("\t   Read Only:   " + imageSection.isReadOnly() + "\n");
            }
            catch (DataUnavailable dataUnavailable) {
                printStream.print("\t   Shared:      <unknown>\n");
                printStream.print("\t   Executable:  <unknown>\n");
                printStream.print("\t   Read Only:   <unknown>\n");
            }
            ++n;
        }
    }

    private boolean searchForHeap(String string, JavaRuntime javaRuntime, PrintStream printStream) {
        boolean bl = false;
        Iterator iterator = javaRuntime.getHeaps();
        int n = 1;
        while (iterator.hasNext()) {
            JavaHeap javaHeap = (JavaHeap)iterator.next();
            if (javaHeap.getName().indexOf(string) == 0) {
                printStream.print("\t Heap #" + n + ":  " + javaHeap.getName() + "\n");
                this.printOccupancyInfo(javaHeap, printStream);
                this.printSectionInfo(javaHeap, printStream);
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private void printOccupancyInfo(JavaHeap javaHeap, PrintStream printStream) {
        Object object;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        Iterator iterator = javaHeap.getSections();
        Object var12_8 = null;
        CorruptData corruptData = null;
        while (iterator.hasNext()) {
            var12_8 = iterator.next();
            if (var12_8 instanceof CorruptData) {
                corruptData = var12_8;
                printStream.print("\t\t Warning - corrupt image section found");
                if (corruptData.getAddress() != null) {
                    printStream.print(" at 0x" + corruptData.getAddress().toString());
                }
                printStream.print("\n");
                continue;
            }
            object = var12_8;
            l += object.getSize();
        }
        printStream.print("\t  Size of heap: " + l + " bytes\n");
        object = javaHeap.getObjects();
        try {
            while (object.hasNext()) {
                var12_8 = object.next();
                ++l3;
                if (var12_8 instanceof CorruptData) {
                    ++l4;
                    corruptData = var12_8;
                    printStream.print("\t\t Warning - corrupt heap object found at position " + l3);
                    if (corruptData.getAddress() != null) {
                        printStream.print(" address 0x" + corruptData.getAddress().toString());
                    }
                    printStream.print("\n");
                    continue;
                }
                JavaObject javaObject = var12_8;
                l2 += javaObject.getSize();
            }
            float f = (float)l2 / (float)l * 10000.0f;
            int n = (int)f;
            f = (float)n / 100.0f;
            printStream.print("\t  Occupancy               :   " + l2 + " bytes  (" + f + "%)\n");
            printStream.print("\t  Total objects           :   " + l3 + "\n");
            printStream.print("\t  Total corrupted objects :   " + l4 + "\n");
        }
        catch (CorruptDataException corruptDataException) {
            printStream.print("\t  Occupancy :   <unknown>\n");
        }
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("displays information about Java heaps\n\nparameters: none, \"*\", or heap name\n\n none prints:\n - heap name\n - heap section\n \"*\" or heap name prints the following information\n about all heaps or the specified heap, respectively:\n - heap name\n - (heap size and occupancy)\n - heap sections\n  - section name\n  - section size\n  - whether the section is shared\n  - whether the section is executable\n  - whether the section is read only\n");
    }
}

