/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.AESCrypt;
import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.SymmetricCipher;
import java.security.InvalidKeyException;
import java.security.ProviderException;
import java.util.ArrayDeque;
import jdk.crypto.jniprovider.NativeCrypto;
import sun.misc.Cleaner;

class NativeCipherBlockChaining
extends FeedbackCipher {
    protected static final int numContexts = 4096;
    protected static long[] contexts;
    protected static ArrayDeque<Integer> avStack;
    private static final NativeCrypto nativeCrypto;
    private int mode;
    protected byte[] r = new byte[this.blockSize];
    protected byte[] rSave = null;
    protected byte[] key;
    protected long nativeContext = NativeCipherBlockChaining.getContext(this);
    protected int ctxIndx;

    static synchronized long getContext(NativeCipherBlockChaining nativeCipherBlockChaining) {
        if (avStack.isEmpty()) {
            nativeCipherBlockChaining.ctxIndx = -1;
            long l = nativeCrypto.CBCCreateContext();
            if (l == -1L) {
                throw new ProviderException("Error in Native CipherBlockChaining");
            }
            nativeCipherBlockChaining.nativeContext = l;
        } else {
            nativeCipherBlockChaining.ctxIndx = avStack.pop();
            nativeCipherBlockChaining.nativeContext = contexts[nativeCipherBlockChaining.ctxIndx];
        }
        return nativeCipherBlockChaining.nativeContext;
    }

    NativeCipherBlockChaining(SymmetricCipher symmetricCipher) {
        super(symmetricCipher);
        Cleaner.create((Object)this, (Runnable)new CBCCleanerRunnable(this.ctxIndx, this.nativeContext));
    }

    @Override
    String getFeedback() {
        return "CBC";
    }

    @Override
    void init(boolean bl, String string, byte[] byArray, byte[] byArray2) throws InvalidKeyException {
        if (byArray == null || byArray2 == null || byArray2.length != this.blockSize) {
            throw new InvalidKeyException("Internal error");
        }
        if (!AESCrypt.isKeySizeValid(byArray.length)) {
            throw new InvalidKeyException("Invalid AES key length: " + byArray.length + " bytes");
        }
        this.iv = (byte[])byArray2.clone();
        this.key = (byte[])byArray.clone();
        System.arraycopy(this.iv, 0, this.r, 0, this.blockSize);
        this.mode = bl ? 0 : 1;
        int n = nativeCrypto.CBCInit(this.nativeContext, this.mode, byArray2, byArray2.length, byArray, byArray.length);
        if (n == -1) {
            throw new ProviderException("Error in Native CipherBlockChaining");
        }
    }

    @Override
    void reset() {
        System.arraycopy(this.iv, 0, this.r, 0, this.blockSize);
        int n = nativeCrypto.CBCInit(this.nativeContext, this.mode, this.iv, this.iv.length, this.key, this.key.length);
        if (n == -1) {
            throw new ProviderException("Error in Native CipherBlockChaining");
        }
    }

    @Override
    void save() {
        if (this.rSave == null) {
            this.rSave = new byte[this.blockSize];
        }
        System.arraycopy(this.r, 0, this.rSave, 0, this.blockSize);
    }

    @Override
    void restore() {
        System.arraycopy(this.rSave, 0, this.r, 0, this.blockSize);
        int n = nativeCrypto.CBCInit(this.nativeContext, this.mode, this.r, this.r.length, this.key, this.key.length);
        if (n == -1) {
            throw new ProviderException("Error in Native CipherBlockChaining");
        }
    }

    @Override
    int encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n2 <= 0) {
            return n2;
        }
        if (n2 % this.blockSize != 0) {
            throw new ProviderException("Internal error in input buffering");
        }
        int n4 = nativeCrypto.CBCUpdate(this.nativeContext, byArray, n, n2, byArray2, n3);
        if (n4 == -1) {
            throw new ProviderException("Error in Native CipherBlockChaining");
        }
        System.arraycopy(byArray2, n3 + n2 - this.blockSize, this.r, 0, this.blockSize);
        return n4;
    }

    @Override
    int decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        return this.encrypt(byArray, n, n2, byArray2, n3);
    }

    @Override
    int encryptFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = -1;
        n4 = byArray == byArray2 ? nativeCrypto.CBCFinalEncrypt(this.nativeContext, (byte[])byArray.clone(), n, n2, byArray2, n3) : nativeCrypto.CBCFinalEncrypt(this.nativeContext, byArray, n, n2, byArray2, n3);
        if (n4 == -1) {
            throw new ProviderException("Error in Native CipherBlockChaining");
        }
        return n4;
    }

    static {
        avStack = new ArrayDeque(4096);
        nativeCrypto = NativeCrypto.getNativeCrypto();
        contexts = new long[4096];
        for (int i = 0; i < 4096; ++i) {
            long l = nativeCrypto.CBCCreateContext();
            if (l == -1L) {
                throw new ProviderException("Error in Native CipherBlockChaining");
            }
            NativeCipherBlockChaining.contexts[i] = l;
            avStack.push(i);
        }
    }

    private static final class CBCCleanerRunnable
    implements Runnable {
        private final int ctxIndx;
        private final long nativeContext;

        public CBCCleanerRunnable(int n, long l) {
            this.ctxIndx = n;
            this.nativeContext = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Class<NativeCipherBlockChaining> clazz = NativeCipherBlockChaining.class;
            synchronized (NativeCipherBlockChaining.class) {
                if (this.ctxIndx == -1) {
                    long l = nativeCrypto.CBCDestroyContext(this.nativeContext);
                    if (l == -1L) {
                        throw new ProviderException("Error in Native CipherBlockChaining");
                    }
                } else {
                    avStack.push(this.ctxIndx);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

