/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.memory;

import com.ibm.dtfj.javacore.parser.framework.tag.LineRule;
import com.ibm.dtfj.javacore.parser.framework.tag.TagParser;
import com.ibm.dtfj.javacore.parser.j9.section.common.CommonPatternMatchers;
import com.ibm.dtfj.javacore.parser.j9.section.memory.IMemoryTypes;

public class MemoryTagParser
extends TagParser
implements IMemoryTypes {
    public MemoryTagParser() {
        super("MEMINFO");
    }

    @Override
    protected void initTagAttributeRules() {
        this.addSectionName();
        this.addSectionDetails();
    }

    protected void addSectionName() {
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String string, int n) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                this.addToken("memory_segment_name", CommonPatternMatchers.allButLineFeed);
            }
        };
        this.addTag("1STSEGTYPE", lineRule);
    }

    protected void addSectionDetails() {
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String string, int n) {
                if (this.addPrefixedHexToken("memory_segment_id") == null) {
                    this.addNonPrefixedHexToken("memory_segment_id");
                    this.addNonPrefixedHexToken("memory_segment_head");
                    this.addNonPrefixedHexToken("memory_segment_free");
                    this.addNonPrefixedHexToken("memory_segment_tail");
                    this.addNonPrefixedHexToken("memory_segment_type");
                    this.addNonPrefixedHexToken("memory_segment_size");
                } else {
                    this.addPrefixedHexToken("memory_segment_head");
                    this.addPrefixedHexToken("memory_segment_free");
                    this.addPrefixedHexToken("memory_segment_tail");
                    this.addPrefixedHexToken("memory_segment_type");
                    this.addPrefixedHexToken("memory_segment_size");
                }
            }
        };
        this.addTag("1STSEGMENT", lineRule);
    }
}

