/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageFactory;
import com.ibm.dtfj.phd.PHDImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.stream.ImageInputStream;

public class PHDImageFactory
implements ImageFactory {
    static final Date earliestDump = new Date(946684800000L);
    static final Date latestDump = new Date(2147483647000L);

    @Override
    public Image getImage(ImageInputStream imageInputStream, URI uRI) throws IOException {
        return new PHDImage(uRI, imageInputStream);
    }

    @Override
    public Image getImage(ImageInputStream imageInputStream, ImageInputStream imageInputStream2, URI uRI) throws IOException {
        ImageFactory imageFactory = this.getMetaFactory();
        Image image = imageFactory.getImage(imageInputStream2, uRI);
        return new PHDImage(uRI, imageInputStream, image);
    }

    @Override
    public Image[] getImagesFromArchive(File file, boolean bl) throws IOException {
        throw new IOException("Not supported for PHD files");
    }

    private ImageFactory getMetaFactory() throws IOException {
        ImageFactory imageFactory = null;
        try {
            Class<?> clazz = Class.forName("com.ibm.dtfj.image.javacore.JCImageFactory");
            imageFactory = (ImageFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            IOException iOException = new IOException("Unable to create javacore image factory");
            iOException.initCause(classNotFoundException);
            throw iOException;
        }
        catch (InstantiationException instantiationException) {
            IOException iOException = new IOException("Unable to create javacore image factory");
            iOException.initCause(instantiationException);
            throw iOException;
        }
        catch (IllegalAccessException illegalAccessException) {
            IOException iOException = new IOException("Unable to create javacore image factory");
            iOException.initCause(illegalAccessException);
            throw iOException;
        }
        return imageFactory;
    }

    @Override
    public int getDTFJMajorVersion() {
        return 1;
    }

    @Override
    public int getDTFJMinorVersion() {
        return 12;
    }

    @Override
    public Image getImage(File file) throws IOException {
        Object object;
        File file2 = this.findMetaFile(file);
        if (file2 == null) {
            object = file;
            try {
                object = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!file.equals(object)) {
                file2 = this.findMetaFile((File)object);
            }
        }
        if (file2 != null) {
            try {
                object = this.getMetaImage(file, file2);
                return new PHDImage(file, (Image)object);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new PHDImage(file);
    }

    /*
     * WARNING - void declaration
     */
    private File findMetaFile(File file) {
        String string = file.getName();
        String string2 = "heapdump";
        int n = Math.max(0, string.indexOf(string2));
        String string3 = string.substring(0, n);
        if ((string = string.substring(n)).startsWith(string2)) {
            Object object;
            Object object2;
            String[] stringArray = string.split("\\.");
            stringArray[0] = string3 + "javacore" + stringArray[0].substring(string2.length());
            int[] nArray = stringArray.length >= 6 ? new int[]{0, 1, -1} : new int[]{0};
            for (int n2 : nArray) {
                object2 = this.genJavacoreName(stringArray, n2, 4);
                object = new File(file.getParent(), (String)object2);
                if (!((File)object).exists()) continue;
                return object;
            }
            if (stringArray.length == 5 || stringArray.length == 6 && stringArray[5].equals("gz")) {
                String i = "yyyyMMdd.HHmmss";
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(i);
                ParsePosition parsePosition = new ParsePosition(0);
                for (int n2 = string2.length(); n2 < string.length(); ++n2) {
                    parsePosition.setIndex(n2);
                    object2 = simpleDateFormat.parse(string, parsePosition);
                    if (object2 == null || ((Date)object2).before(earliestDump) || !((Date)object2).before(latestDump)) continue;
                    object = string.substring(0, n2).replace("heapdump", "javacore");
                    String string4 = string.substring(parsePosition.getIndex()).replaceAll("\\.phd$", ".txt").replaceAll("\\.phd\\.gz$", ".txt");
                    for (long j = ((Date)object2).getTime(); j < ((Date)object2).getTime() + 120000L; j += 1000L) {
                        String string5 = simpleDateFormat.format(new Date(j));
                        String string6 = string3 + (String)object + string5 + string4;
                        File file2 = new File(file.getParent(), string6);
                        if (!file2.exists()) continue;
                        return file2;
                    }
                }
            }
            if (stringArray.length == 3 || stringArray.length == 4 && stringArray[3].equals("gz")) {
                void var8_12;
                boolean bl = true;
                while (var8_12 < 300) {
                    String string7 = this.genJavacoreName(stringArray, (int)var8_12, 1);
                    File file3 = new File(file.getParent(), string7);
                    if (file3.exists()) {
                        return file3;
                    }
                    ++var8_12;
                }
            }
        }
        return null;
    }

    private String genJavacoreName(String[] stringArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < stringArray.length - 1; ++i) {
            String string = stringArray[i];
            if (i == n2) {
                try {
                    int n3 = Integer.parseInt(string);
                    String string2 = Integer.toString(n3 + n);
                    string = string.substring(0, Math.max(0, string.length() - string2.length())) + string2;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (i == stringArray.length - 2 && stringArray[i + 1].equals("gz")) break;
            stringBuffer.append('.');
            stringBuffer.append(string);
        }
        stringBuffer.append(".txt");
        return stringBuffer.toString();
    }

    @Override
    public Image getImage(File file, File file2) throws IOException {
        Image image = this.getMetaImage(file, file2);
        return new PHDImage(file, image);
    }

    private Image getMetaImage(File file, File file2) throws IOException, FileNotFoundException {
        Image image;
        ImageFactory imageFactory = this.getMetaFactory();
        try {
            image = imageFactory.getImage(file2);
        }
        catch (RuntimeException runtimeException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(MessageFormat.format("Problem opening dump {0} metafile {1}", file, file2));
            fileNotFoundException.initCause(runtimeException);
            throw fileNotFoundException;
        }
        return image;
    }

    @Override
    public int getDTFJModificationLevel() {
        return 28002;
    }
}

