/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.utils.file;

import com.ibm.dtfj.utils.file.FileSniffer;
import com.ibm.dtfj.utils.file.GZipFileManager;
import com.ibm.dtfj.utils.file.ManagedImageSource;
import com.ibm.dtfj.utils.file.SimpleFileManager;
import com.ibm.dtfj.utils.file.ZipFileManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public abstract class FileManager {
    public static final long MIN_CORE_SIZE = 0x1400000L;
    protected static final Logger logger = Logger.getLogger("com.ibm.dtfj.log");

    public abstract List<ManagedImageSource> getImageSources() throws IOException;

    public abstract ImageInputStream getStream() throws IOException;

    public static File createTempDir(File file) throws IOException {
        if (!file.exists() || !file.isDirectory()) {
            throw new IOException("The specified parent temporary directory does not exist or is not a directory : " + file.getAbsolutePath());
        }
        File file2 = File.createTempFile("dtfj", "cprss", file);
        file2.delete();
        file2.mkdirs();
        file2.deleteOnExit();
        logger.fine("Created temporary directory for extracted files : " + file2.getAbsolutePath());
        return file2;
    }

    public static boolean fileExists(File file) {
        return file.exists();
    }

    public static FileManager getManager(File file) {
        String string = file.getName().toLowerCase();
        try {
            if (FileSniffer.isZipFile(file)) {
                return new ZipFileManager(file);
            }
        }
        catch (Exception exception) {
            logger.log(Level.FINEST, "Error encountered sampling potential zip file", exception);
        }
        if (string.endsWith(".gz")) {
            return new GZipFileManager(file);
        }
        return new SimpleFileManager(file);
    }

    public static boolean isArchive(File file) {
        String string = file.getName().toLowerCase();
        try {
            if (FileSniffer.isZipFile(file)) {
                return true;
            }
        }
        catch (Exception exception) {
            logger.log(Level.FINEST, "Error encountered sampling potential zip file", exception);
        }
        return string.endsWith(".gz");
    }

    protected String[] getJavaCoreNameFromPHD(String string) {
        String string2 = "heapdump";
        int n = Math.max(0, string.indexOf(string2));
        String string3 = string.substring(0, n);
        if ((string = string.substring(n)).startsWith(string2)) {
            String[] stringArray = string.split("\\.");
            stringArray[0] = string3 + "javacore" + stringArray[0].substring(string2.length());
            int[] nArray = stringArray.length >= 6 ? new int[]{0, 1, -1} : new int[]{0};
            String[] stringArray2 = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                stringArray2[i] = this.genJavacoreName(stringArray, nArray[i], 4);
            }
            return stringArray2;
        }
        return new String[0];
    }

    protected String genJavacoreName(String[] stringArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < stringArray.length - 1; ++i) {
            String string = stringArray[i];
            if (i == n2) {
                try {
                    int n3 = Integer.parseInt(string);
                    String string2 = Integer.toString(n3 + n);
                    string = string.substring(0, Math.max(0, string.length() - string2.length())) + string2;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (i == stringArray.length - 2 && stringArray[i + 1].equals("gz")) break;
            stringBuffer.append('.');
            stringBuffer.append(string);
        }
        stringBuffer.append(".txt");
        return stringBuffer.toString();
    }
}

