/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.util.Arrays;
import javax.security.auth.kerberos.KeyTab;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KdcComm;
import sun.security.krb5.KrbAsRep;
import sun.security.krb5.KrbAsReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.crypto.EType;

public final class KrbAsReqBuilder {
    private KDCOptions options;
    private PrincipalName cname;
    private PrincipalName refCname;
    private PrincipalName sname;
    private KerberosTime from;
    private KerberosTime till;
    private KerberosTime rtime;
    private HostAddresses addresses;
    private final char[] password;
    private final KeyTab ktab;
    private PAData[] paList;
    private KrbAsReq req;
    private KrbAsRep rep;
    private State state;

    private void init(PrincipalName principalName) throws KrbException {
        this.cname = principalName;
        this.refCname = principalName;
        this.state = State.INIT;
    }

    public KrbAsReqBuilder(PrincipalName principalName, KeyTab keyTab) throws KrbException {
        this.init(principalName);
        this.ktab = keyTab;
        this.password = null;
    }

    public KrbAsReqBuilder(PrincipalName principalName, char[] cArray) throws KrbException {
        this.init(principalName);
        this.password = (char[])cArray.clone();
        this.ktab = null;
    }

    public EncryptionKey[] getKeys(boolean bl) throws KrbException {
        this.checkState(bl ? State.REQ_OK : State.INIT, "Cannot get keys");
        if (this.password != null) {
            int[] nArray = EType.getDefaults("default_tkt_enctypes");
            EncryptionKey[] encryptionKeyArray = new EncryptionKey[nArray.length];
            String string = null;
            try {
                int n;
                for (n = 0; n < nArray.length; ++n) {
                    PAData.SaltAndParams saltAndParams = PAData.getSaltAndParams(nArray[n], this.paList);
                    if (saltAndParams == null) continue;
                    if (nArray[n] != 23 && saltAndParams.salt != null) {
                        string = saltAndParams.salt;
                    }
                    encryptionKeyArray[n] = EncryptionKey.acquireSecretKey(this.cname, this.password, nArray[n], saltAndParams);
                }
                if (string == null) {
                    string = this.cname.getSalt();
                }
                for (n = 0; n < nArray.length; ++n) {
                    if (encryptionKeyArray[n] != null) continue;
                    encryptionKeyArray[n] = EncryptionKey.acquireSecretKey(this.password, string, nArray[n], null);
                }
            }
            catch (IOException iOException) {
                KrbException krbException = new KrbException(909);
                krbException.initCause(iOException);
                throw krbException;
            }
            return encryptionKeyArray;
        }
        throw new IllegalStateException("Required password not provided");
    }

    public void setOptions(KDCOptions kDCOptions) {
        this.checkState(State.INIT, "Cannot specify options");
        this.options = kDCOptions;
    }

    public void setTill(KerberosTime kerberosTime) {
        this.checkState(State.INIT, "Cannot specify till");
        this.till = kerberosTime;
    }

    public void setRTime(KerberosTime kerberosTime) {
        this.checkState(State.INIT, "Cannot specify rtime");
        this.rtime = kerberosTime;
    }

    public void setTarget(PrincipalName principalName) {
        this.checkState(State.INIT, "Cannot specify target");
        this.sname = principalName;
    }

    public void setAddresses(HostAddresses hostAddresses) {
        this.checkState(State.INIT, "Cannot specify addresses");
        this.addresses = hostAddresses;
    }

    private KrbAsReq build(EncryptionKey encryptionKey, ReferralsState referralsState) throws KrbException, IOException {
        int[] nArray;
        PAData[] pADataArray = null;
        if (this.password != null) {
            nArray = EType.getDefaults("default_tkt_enctypes");
        } else {
            EncryptionKey[] encryptionKeyArray = Krb5Util.keysFromJavaxKeyTab(this.ktab, this.cname);
            nArray = EType.getDefaults("default_tkt_enctypes", encryptionKeyArray);
            for (EncryptionKey encryptionKey2 : encryptionKeyArray) {
                encryptionKey2.destroy();
            }
        }
        KDCOptions kDCOptions = this.options = this.options == null ? new KDCOptions() : this.options;
        if (referralsState.isEnabled()) {
            this.options.set(15, true);
            pADataArray = new PAData[]{new PAData(149, new byte[0])};
        } else {
            this.options.set(15, false);
        }
        return new KrbAsReq(encryptionKey, this.options, this.refCname, this.sname, this.from, this.till, this.rtime, nArray, this.addresses, pADataArray);
    }

    private KrbAsReqBuilder resolve() throws KrbException, Asn1Exception, IOException {
        if (this.ktab != null) {
            this.rep.decryptUsingKeyTab(this.ktab, this.req, this.cname);
        } else {
            this.rep.decryptUsingPassword(this.password, this.req, this.cname);
        }
        if (this.rep.getPA() != null) {
            if (this.paList == null || this.paList.length == 0) {
                this.paList = this.rep.getPA();
            } else {
                int n = this.rep.getPA().length;
                if (n > 0) {
                    int n2 = this.paList.length;
                    this.paList = Arrays.copyOf(this.paList, this.paList.length + n);
                    System.arraycopy((Object)this.rep.getPA(), 0, (Object)this.paList, n2, n);
                }
            }
        }
        return this;
    }

    private KrbAsReqBuilder send() throws KrbException, IOException {
        boolean bl = false;
        KdcComm kdcComm = null;
        EncryptionKey encryptionKey = null;
        ReferralsState referralsState = new ReferralsState();
        while (true) {
            if (referralsState.refreshComm()) {
                kdcComm = new KdcComm(this.refCname.getRealmAsString());
            }
            try {
                this.req = this.build(encryptionKey, referralsState);
                this.rep = new KrbAsRep(kdcComm.send(this.req.encoding()));
                return this;
            }
            catch (KrbException krbException) {
                if (!(bl || krbException.returnCode() != 24 && krbException.returnCode() != 25)) {
                    if (Krb5.DEBUG) {
                        System.out.println("KrbAsReqBuilder: PREAUTH FAILED/REQ, re-send AS-REQ");
                    }
                    bl = true;
                    KRBError kRBError = krbException.getError();
                    int n = PAData.getPreferredEType(kRBError.getPA(), EType.getDefaults("default_tkt_enctypes")[0]);
                    if (this.password == null) {
                        EncryptionKey[] encryptionKeyArray = Krb5Util.keysFromJavaxKeyTab(this.ktab, this.cname);
                        encryptionKey = EncryptionKey.findKey(n, encryptionKeyArray);
                        if (encryptionKey != null) {
                            encryptionKey = (EncryptionKey)encryptionKey.clone();
                        }
                        for (EncryptionKey encryptionKey2 : encryptionKeyArray) {
                            encryptionKey2.destroy();
                        }
                    } else {
                        encryptionKey = EncryptionKey.acquireSecretKey(this.cname, this.password, n, PAData.getSaltAndParams(n, kRBError.getPA()));
                    }
                    this.paList = kRBError.getPA();
                    continue;
                }
                if (referralsState.handleError(krbException)) {
                    encryptionKey = null;
                    bl = false;
                    continue;
                }
                throw krbException;
            }
            break;
        }
    }

    public KrbAsReqBuilder action() throws KrbException, Asn1Exception, IOException {
        this.checkState(State.INIT, "Cannot call action");
        this.state = State.REQ_OK;
        return this.send().resolve();
    }

    public Credentials getCreds() {
        this.checkState(State.REQ_OK, "Cannot retrieve creds");
        return this.rep.getCreds();
    }

    public sun.security.krb5.internal.ccache.Credentials getCCreds() {
        this.checkState(State.REQ_OK, "Cannot retrieve CCreds");
        return this.rep.getCCreds();
    }

    public void destroy() {
        this.state = State.DESTROYED;
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
        }
    }

    private void checkState(State state, String string) {
        if (this.state != state) {
            throw new IllegalStateException(string + " at " + (Object)((Object)state) + " state");
        }
    }

    private final class ReferralsState {
        private boolean enabled;
        private int count;
        private boolean refreshComm;

        ReferralsState() throws KrbException {
            if (Config.DISABLE_REFERRALS) {
                if (KrbAsReqBuilder.this.refCname.getNameType() == 10) {
                    throw new KrbException("NT-ENTERPRISE principals only allowed when referrals are enabled.");
                }
                this.enabled = false;
            } else {
                this.enabled = true;
            }
            this.refreshComm = true;
        }

        boolean handleError(KrbException krbException) throws RealmException {
            if (this.enabled) {
                if (krbException.returnCode() == 68) {
                    Realm realm = krbException.getError().getClientRealm();
                    if (((KrbAsReqBuilder)KrbAsReqBuilder.this).req.getMessage().reqBody.kdcOptions.get(15) && realm != null && realm.toString().length() > 0 && this.count < Config.MAX_REFERRALS) {
                        KrbAsReqBuilder.this.refCname = new PrincipalName(KrbAsReqBuilder.this.refCname.getNameType(), KrbAsReqBuilder.this.refCname.getNameStrings(), realm);
                        this.refreshComm = true;
                        ++this.count;
                        return true;
                    }
                }
                if (this.count < Config.MAX_REFERRALS && KrbAsReqBuilder.this.refCname.getNameType() != 10) {
                    this.enabled = false;
                    return true;
                }
            }
            return false;
        }

        boolean refreshComm() {
            boolean bl = this.refreshComm;
            this.refreshComm = false;
            return bl;
        }

        boolean isEnabled() {
            return this.enabled;
        }
    }

    private static enum State {
        INIT,
        REQ_OK,
        DESTROYED;

    }
}

