/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.DataEntry;
import com.ibm.j9ddr.corereaders.elf.ELFDumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ELFAMD64DumpReader
extends ELFDumpReader {
    protected ELFAMD64DumpReader(ELFFileReader eLFFileReader) throws IOException, InvalidDumpFormatException {
        super(eLFFileReader);
    }

    @Override
    protected long readUID() throws IOException {
        return (long)this._reader.readInt() & 0xFFFFFFFFL;
    }

    @Override
    protected String getProcessorType() {
        return "amd64";
    }

    @Override
    protected long getBasePointerFrom(Map<String, Number> map) {
        return map.get("rbp").longValue();
    }

    @Override
    protected long getInstructionPointerFrom(Map<String, Number> map) {
        return map.get("rip").longValue();
    }

    @Override
    protected long getLinkRegisterFrom(Map<String, Number> map) {
        return 0L;
    }

    @Override
    protected String getStackPointerRegisterName() {
        return "rsp";
    }

    @Override
    protected String[] getDwarfRegisterKeys() {
        String[] stringArray = new String[17];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "r" + i;
        }
        stringArray[0] = "rax";
        stringArray[1] = "rdx";
        stringArray[2] = "rcx";
        stringArray[3] = "rbx";
        stringArray[4] = "rsi";
        stringArray[5] = "rdi";
        stringArray[6] = "rbp";
        stringArray[7] = "rsp";
        stringArray[16] = "rip";
        return stringArray;
    }

    @Override
    protected SortedMap<String, Number> readRegisters() throws IOException {
        int n;
        String[] stringArray = new String[]{"r15", "r14", "r13", "r12", "rbp", "rbx", "r11", "r10", "r9", "r8", "rax", "rcx", "rdx", "rsi", "rdi"};
        String[] stringArray2 = new String[]{"rip", "cs", "eflags", "rsp", "ss", "fs_base", "gs_base", "ds", "es", "fs", "gs"};
        TreeMap<String, Number> treeMap = new TreeMap<String, Number>(new ELFDumpReader.RegisterComparator());
        for (n = 0; n < stringArray.length; ++n) {
            treeMap.put(stringArray[n], this._reader.readLong());
        }
        this._reader.readLong();
        for (n = 0; n < stringArray2.length; ++n) {
            treeMap.put(stringArray2[n], this._reader.readLong());
        }
        return treeMap;
    }

    @Override
    protected void readHighwordRegisters(DataEntry dataEntry, Map<String, Number> map) throws IOException, InvalidDumpFormatException {
        throw new InvalidDumpFormatException("Unexpected data entry in AMD64 ELF dump");
    }
}

