/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.ProtectedMemoryRange;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BufferedMemorySource
extends ProtectedMemoryRange
implements IMemorySource {
    private final ByteBuffer source;

    public BufferedMemorySource(long l, ByteBuffer byteBuffer) {
        super(l, byteBuffer.capacity());
        this.source = byteBuffer;
    }

    public int getUnsignedShort(long l) throws MemoryFault {
        return this.getShort(l) & 0xFFFF;
    }

    public short getShort(long l) throws MemoryFault {
        return this.source.getShort(this.checkIndex(l, 2));
    }

    public int getInt(long l) throws MemoryFault {
        return this.source.getInt(this.checkIndex(l, 4));
    }

    public double getDouble(long l) throws MemoryFault {
        return this.source.getDouble(this.checkIndex(l, 8));
    }

    public long getLong(long l) throws MemoryFault {
        return this.source.getLong(this.checkIndex(l, 8));
    }

    public byte getByte(long l) throws MemoryFault {
        return this.source.get(this.checkIndex(l, 1));
    }

    @Override
    public int getBytes(long l, byte[] byArray, int n, int n2) throws MemoryFault {
        int n3 = this.checkIndex(l, n2);
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = this.source.get(n3 + i);
        }
        return n2;
    }

    private int checkIndex(long l, int n) throws MemoryFault {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        long l2 = this.baseAddress + Math.min(this.getSize(), Integer.MAX_VALUE) - (long)n;
        if (l < this.baseAddress || l > l2) {
            throw new MemoryFault(l);
        }
        return (int)(l - this.baseAddress);
    }

    public ByteOrder getByteOrder() {
        return this.source.order();
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public int getAddressSpaceId() {
        return 0;
    }
}

