/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.ModuleHashTable;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModulePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.JavaVersionHelper;
import java.io.PrintStream;
import java.util.Iterator;

public class DumpModuleReadsCommand
extends Command {
    public DumpModuleReadsCommand() {
        this.addCommand("dumpmodulereads", "<targetModuleAddress>", "display all modules read by the target module");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length != 1) {
            CommandUtils.dbgPrint(printStream, "Usage: !dumpmodulereads <targetModuleAddress>\n");
            return;
        }
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (JavaVersionHelper.ensureJava9AndUp(j9JavaVMPointer, printStream)) {
                String string2 = stringArray[0];
                J9ModulePointer j9ModulePointer = J9ModulePointer.cast(Long.decode(string2));
                J9HashTablePointer j9HashTablePointer = j9ModulePointer.readAccessHashTable();
                HashTable<J9ModulePointer> hashTable = ModuleHashTable.fromJ9HashTable(j9HashTablePointer);
                Iterator iterator = hashTable.iterator();
                while (iterator.hasNext()) {
                    J9ModulePointer j9ModulePointer2 = (J9ModulePointer)iterator.next();
                    String string3 = J9ObjectHelper.stringValue(j9ModulePointer2.moduleName());
                    String string4 = j9ModulePointer2.getHexAddress();
                    printStream.printf("%-30s !j9module %s%n", string3, string4);
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

