/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import com.ibm.j9ddr.corereaders.elf.ELFMemorySource;
import com.ibm.j9ddr.corereaders.memory.IDetailedMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.ProtectedMemoryRange;
import com.ibm.j9ddr.corereaders.memory.UnbackedMemorySource;
import java.util.Properties;

public class ProgramHeaderEntry {
    private static final int PT_LOAD = 1;
    private static final int PT_DYNAMIC = 2;
    private static final int PT_NOTE = 4;
    private static final int PT_GNU_EH_FRAME = 1685382480;
    private static final int PF_X = 1;
    private static final int PF_W = 2;
    private static final int PF_R = 4;
    private int _type;
    public final long fileOffset;
    public final long fileSize;
    public final long virtualAddress;
    public final long physicalAddress;
    public final long memorySize;
    private int _flags;
    private final ELFFileReader reader;

    ProgramHeaderEntry(int type, long fileOffset, long fileSize, long virtualAddress, long physicalAddress, long memorySize, int flags, long alignment, ELFFileReader reader) {
        this._type = type;
        this.fileOffset = fileOffset;
        this.fileSize = fileSize;
        this.virtualAddress = virtualAddress;
        this.physicalAddress = physicalAddress;
        this.memorySize = memorySize;
        this._flags = flags;
        this.reader = reader;
    }

    boolean isEmpty() {
        return 0L == this.fileSize;
    }

    boolean isDynamic() {
        return 2 == this._type;
    }

    boolean isLoadable() {
        return 1 == this._type;
    }

    boolean isNote() {
        return 4 == this._type;
    }

    public boolean isEhFrame() {
        return 1685382480 == this._type;
    }

    IMemorySource asMemorySource() {
        ProtectedMemoryRange source = null;
        if (!this.isEmpty()) {
            boolean isExecutable = (this._flags & 1) != 0;
            source = new ELFMemorySource(this.virtualAddress, this.memorySize, this.fileOffset, this.reader);
        } else {
            source = new UnbackedMemorySource(this.virtualAddress, this.memorySize, "ELF ProgramHeaderEntry storage declared but data not included");
        }
        Properties memoryProps = ((IDetailedMemoryRange)((Object)source)).getProperties();
        memoryProps.setProperty("IN_CORE", "" + !this.isEmpty());
        if ((this._flags & 2) != 0) {
            memoryProps.setProperty("writable", Boolean.TRUE.toString());
        }
        if ((this._flags & 1) != 0) {
            memoryProps.setProperty("executable", Boolean.TRUE.toString());
        }
        if ((this._flags & 4) != 0) {
            memoryProps.setProperty("readable", Boolean.TRUE.toString());
        }
        return source;
    }

    boolean validInProcess(long address) {
        return this.virtualAddress <= address && address < this.virtualAddress + this.memorySize;
    }

    boolean contains(long address) {
        return false == this.isEmpty() && this.validInProcess(address);
    }
}

