/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.logging;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Filter;
import java.util.logging.LogRecord;

public class LogFilter
implements Filter {
    private static final String SYSTEM_PROP_LOGGING = "java.util.logging.config.file";
    private static final String KEY_CATEGORIES = "com.ibm.j9ddr.tools.logging.categories";
    private HashSet<String> idlist = null;

    public LogFilter() {
        String logFile = System.getProperty(SYSTEM_PROP_LOGGING);
        File file = new File(logFile);
        if (file.exists()) {
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(file));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("The configuration file " + file.getPath() + " specified in java.util.logging.config.file could not be read");
            }
            if (props.containsKey(KEY_CATEGORIES)) {
                String[] categories = props.getProperty(KEY_CATEGORIES).trim().split(",");
                if (categories.length == 0) {
                    return;
                }
                this.idlist = new HashSet();
                for (int i = 0; i < categories.length; ++i) {
                    this.idlist.add(categories[i].trim());
                }
            }
        }
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        return this.idlist == null || this.idlist.contains(record.getLoggerName());
    }
}

