/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public final class J9ConstantHelper {
    private static Field getStaticFinalField(Class<?> clazz, String name, Class<?> expectedFieldType) throws NoSuchFieldException {
        try {
            Field field = clazz.getField(name);
            int modifiers = field.getModifiers();
            if (!(Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers))) {
                String message = String.format("%s.%s is not public static final", clazz.getName(), name);
                throw new IllegalArgumentException(message);
            }
            if (field.getType() != expectedFieldType) {
                String message = String.format("%s.%s is not type %s", clazz.getName(), name, expectedFieldType.getName());
                throw new IllegalArgumentException(message);
            }
            return field;
        }
        catch (SecurityException e) {
            throw new InternalError("unexpected exception", e);
        }
    }

    public static long getLong(Class<?> clazz, String name, long defaultValue) {
        try {
            return J9ConstantHelper.getStaticFinalField(clazz, name, Long.TYPE).getLong(null);
        }
        catch (IllegalAccessException e) {
            throw new InternalError("unexpected exception", e);
        }
        catch (NoSuchFieldException e) {
            return defaultValue;
        }
    }

    public static boolean getBoolean(Class<?> clazz, String name, boolean defaultValue) {
        try {
            return J9ConstantHelper.getStaticFinalField(clazz, name, Boolean.TYPE).getBoolean(null);
        }
        catch (IllegalAccessException e) {
            throw new InternalError("unexpected exception", e);
        }
        catch (NoSuchFieldException e) {
            return defaultValue;
        }
    }
}

