/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.J9ConstantHelper;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMNameAndSignaturePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9JavaClassFlags;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ValueTypeHelper {
    protected static final Logger logger = Logger.getLogger("j9ddr.interactive.context");
    private static ValueTypeHelper helper = null;

    private ValueTypeHelper() {
    }

    private static boolean checkIfValueTypesAreSupported() {
        return J9ConstantHelper.getBoolean(J9BuildFlags.class, "J9VM_OPT_VALHALLA_VALUE_TYPES", false) || J9ConstantHelper.getBoolean(J9BuildFlags.class, "opt_valhallaValueTypes", false);
    }

    public static ValueTypeHelper getValueTypeHelper() {
        if (helper == null) {
            helper = ValueTypeHelper.checkIfValueTypesAreSupported() ? new ValueTypeSupportEnabledHelper() : new ValueTypeHelper();
        }
        return helper;
    }

    public boolean areValueTypesSupported() {
        return false;
    }

    public J9ClassPointer findJ9ClassInFlattenedClassCacheWithFieldName(J9ClassPointer clazz, String fieldName) throws CorruptDataException {
        logger.log(Level.SEVERE, "Value types were not enabled in the JVM that produced this core file.");
        throw new RuntimeException("Invalid operation");
    }

    public J9ClassPointer[] findNestedClassHierarchy(J9ClassPointer containerClazz, String[] nestingHierarchy) throws CorruptDataException {
        logger.log(Level.SEVERE, "Value types were not enabled in the JVM that produced this core file.");
        throw new RuntimeException("Invalid operation");
    }

    public J9ClassPointer findJ9ClassInFlattenedClassCacheWithSigName(J9ClassPointer clazz, String fieldSig) throws CorruptDataException {
        logger.log(Level.SEVERE, "Value types were not enabled in the JVM that produced this core file.");
        throw new RuntimeException("Invalid operation");
    }

    public boolean isRomClassAValueType(J9ROMClassPointer romClass) throws CorruptDataException {
        return false;
    }

    public boolean isJ9ClassAValueType(J9ClassPointer clazz) throws CorruptDataException {
        return false;
    }

    public boolean isFieldInClassFlattened(J9ClassPointer clazz, String fieldName) throws CorruptDataException {
        return false;
    }

    public boolean isFlattenableFieldSignature(String signature) {
        return false;
    }

    public boolean isJ9ClassLargestAlignmentConstraintDouble(J9ClassPointer clazz) throws CorruptDataException {
        return false;
    }

    public boolean isJ9ClassLargestAlignmentConstraintReference(J9ClassPointer clazz) throws CorruptDataException {
        return false;
    }

    private static class ValueTypeSupportEnabledHelper
    extends ValueTypeHelper {
        private static final long J9AccValueType = J9ConstantHelper.getLong(J9JavaAccessFlags.class, "J9AccValueType", 0L);
        private static final long J9ClassIsValueType = J9ConstantHelper.getLong(J9JavaClassFlags.class, "J9ClassIsValueType", 0L);
        private static final long J9ClassLargestAlignmentConstraintDouble = J9ConstantHelper.getLong(J9JavaClassFlags.class, "J9ClassLargestAlignmentConstraintDouble", 0L);
        private static final long J9ClassLargestAlignmentConstraintReference = J9ConstantHelper.getLong(J9JavaClassFlags.class, "J9ClassLargestAlignmentConstraintReference", 0L);
        private static final long J9ClassIsFlattened = J9ConstantHelper.getLong(J9JavaClassFlags.class, "J9ClassIsFlattened", 0L);
        private MethodHandle getFlattenedClassCachePointer = null;
        private Class<?> flattenedClassCachePointer = null;
        private MethodHandle flattenedClassCache_numberOfEntries = null;
        private MethodHandle flattenedClassCacheEntry_NaS = null;
        private MethodHandle flattenedClassCacheEntry_clazz = null;
        private MethodHandle flattenedClassCacheEntry_cast = null;
        private Class<?> flattenedClassCacheEntryPointer = null;

        ValueTypeSupportEnabledHelper() {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                this.flattenedClassCachePointer = Class.forName("com.ibm.j9ddr.vm29.pointer.generated.J9FlattenedClassCachePointer");
                this.getFlattenedClassCachePointer = lookup.findVirtual(J9ClassPointer.class, "flattenedClassCache", MethodType.methodType(this.flattenedClassCachePointer));
                this.flattenedClassCache_numberOfEntries = lookup.findVirtual(this.flattenedClassCachePointer, "numberOfEntries", MethodType.methodType(UDATA.class));
                this.flattenedClassCacheEntryPointer = Class.forName("com.ibm.j9ddr.vm29.pointer.generated.J9FlattenedClassCacheEntryPointer");
                this.flattenedClassCacheEntry_NaS = lookup.findVirtual(this.flattenedClassCacheEntryPointer, "nameAndSignature", MethodType.methodType(J9ROMNameAndSignaturePointer.class));
                this.flattenedClassCacheEntry_clazz = lookup.findVirtual(this.flattenedClassCacheEntryPointer, "clazz", MethodType.methodType(J9ClassPointer.class));
                this.flattenedClassCacheEntry_cast = lookup.findStatic(this.flattenedClassCacheEntryPointer, "cast", MethodType.methodType(this.flattenedClassCacheEntryPointer, AbstractPointer.class));
            }
            catch (Throwable t) {
                ValueTypeSupportEnabledHelper.throwUncheckedExceptions(t);
                logger.log(Level.SEVERE, "ValueTypeHelper: failed to get ValueTypeHelper method handles", t);
            }
        }

        private static void throwUncheckedExceptions(Throwable t) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
        }

        private static CorruptDataException handleThrowable(Throwable t) throws CorruptDataException {
            ValueTypeSupportEnabledHelper.throwUncheckedExceptions(t);
            throw new CorruptDataException(t);
        }

        @Override
        public boolean areValueTypesSupported() {
            return true;
        }

        private J9ClassPointer findJ9ClassInFlattenedClassCacheWithFieldNameImpl(StructurePointer flattenedClassCache, String fieldName) throws CorruptDataException {
            J9ClassPointer resultClazz = J9ClassPointer.NULL;
            try {
                UDATA length = this.flattenedClassCache_numberOfEntries.invoke(flattenedClassCache);
                StructurePointer entry = this.flattenedClassCacheEntry_cast.invoke(flattenedClassCache.add(1L));
                int cacheLength = length.intValue();
                for (int i = 0; i < cacheLength; ++i) {
                    String field = J9UTF8Helper.stringValue(this.flattenedClassCacheEntry_NaS.invoke(entry).name());
                    if (field.equals(fieldName)) {
                        resultClazz = this.flattenedClassCacheEntry_clazz.invoke(entry);
                        break;
                    }
                    entry = (StructurePointer)entry.add(1L);
                }
            }
            catch (ClassCastException | WrongMethodTypeException e) {
                logger.log(Level.SEVERE, "ValueTypeHelper: failed to find field in flattened class cache with field name.", e);
            }
            catch (Throwable t) {
                throw ValueTypeSupportEnabledHelper.handleThrowable(t);
            }
            return resultClazz;
        }

        @Override
        public J9ClassPointer findJ9ClassInFlattenedClassCacheWithFieldName(J9ClassPointer clazz, String fieldName) throws CorruptDataException {
            J9ClassPointer resultClazz = J9ClassPointer.NULL;
            try {
                StructurePointer flattenedClassCache = this.getFlattenedClassCachePointer.invoke(clazz);
                if (!flattenedClassCache.isNull()) {
                    resultClazz = this.findJ9ClassInFlattenedClassCacheWithFieldNameImpl(flattenedClassCache, fieldName);
                }
            }
            catch (ClassCastException | WrongMethodTypeException e) {
                logger.log(Level.SEVERE, "ValueTypeHelper: failed to find field in flattened class cache with field name", e);
            }
            catch (Throwable t) {
                throw ValueTypeSupportEnabledHelper.handleThrowable(t);
            }
            return resultClazz;
        }

        private J9ClassPointer findJ9ClassInFlattenedClassCacheWithFieldSigImpl(StructurePointer flattenedClassCache, String fieldSig) throws CorruptDataException {
            J9ClassPointer resultClazz = J9ClassPointer.NULL;
            try {
                UDATA length = this.flattenedClassCache_numberOfEntries.invoke(flattenedClassCache);
                StructurePointer entry = this.flattenedClassCacheEntry_cast.invoke(flattenedClassCache.add(1L));
                int cacheLength = length.intValue();
                for (int i = 0; i < cacheLength; ++i) {
                    String field = J9UTF8Helper.stringValue(this.flattenedClassCacheEntry_NaS.invoke(entry).signature());
                    if ((field = field.substring(1, field.length() - 1)).equals(fieldSig)) {
                        resultClazz = this.flattenedClassCacheEntry_clazz.invoke(entry);
                        break;
                    }
                    entry = (StructurePointer)entry.add(1L);
                }
            }
            catch (ClassCastException | WrongMethodTypeException e) {
                logger.log(Level.SEVERE, "ValueTypeHelper: failed to find field in flattened class cache with field signature", e);
            }
            catch (Throwable t) {
                throw ValueTypeSupportEnabledHelper.handleThrowable(t);
            }
            return resultClazz;
        }

        @Override
        public J9ClassPointer[] findNestedClassHierarchy(J9ClassPointer containerClazz, String[] nestingHierarchy) throws CorruptDataException {
            J9ClassPointer[] resultClasses = new J9ClassPointer[nestingHierarchy.length + 1];
            J9ClassPointer clazz = containerClazz;
            resultClasses[0] = containerClazz;
            for (int i = 0; i < nestingHierarchy.length; ++i) {
                resultClasses[i + 1] = clazz = this.findJ9ClassInFlattenedClassCacheWithFieldName(clazz, nestingHierarchy[i]);
            }
            return resultClasses;
        }

        @Override
        public J9ClassPointer findJ9ClassInFlattenedClassCacheWithSigName(J9ClassPointer clazz, String fieldSig) throws CorruptDataException {
            J9ClassPointer resultClazz = J9ClassPointer.NULL;
            try {
                StructurePointer flattenedClassCache = this.getFlattenedClassCachePointer.invoke(clazz);
                if (!flattenedClassCache.isNull()) {
                    resultClazz = this.findJ9ClassInFlattenedClassCacheWithFieldSigImpl(flattenedClassCache, fieldSig);
                }
            }
            catch (ClassCastException | WrongMethodTypeException e) {
                logger.log(Level.SEVERE, "ValueTypeHelper: failed to find field in flattened class cache with field signature", e);
            }
            catch (Throwable t) {
                throw ValueTypeSupportEnabledHelper.handleThrowable(t);
            }
            return resultClazz;
        }

        @Override
        public boolean isRomClassAValueType(J9ROMClassPointer romClass) throws CorruptDataException {
            if (J9AccValueType != 0L) {
                return romClass.modifiers().allBitsIn(J9AccValueType);
            }
            return false;
        }

        @Override
        public boolean isJ9ClassAValueType(J9ClassPointer clazz) throws CorruptDataException {
            if (J9ClassIsValueType != 0L) {
                return clazz.classFlags().allBitsIn(J9ClassIsValueType);
            }
            return false;
        }

        @Override
        public boolean isFieldInClassFlattened(J9ClassPointer clazz, String fieldName) throws CorruptDataException {
            boolean result = false;
            try {
                J9ClassPointer flattenableClazz;
                StructurePointer flattenedClassCache = this.getFlattenedClassCachePointer.invoke(clazz);
                if (!flattenedClassCache.isNull() && !(flattenableClazz = this.findJ9ClassInFlattenedClassCacheWithFieldNameImpl(flattenedClassCache, fieldName)).isNull()) {
                    result = this.isJ9ClassIsFlattened(flattenableClazz);
                }
            }
            catch (ClassCastException | WrongMethodTypeException e) {
                logger.log(Level.SEVERE, "ValueTypeHelper: failed to determine if field is flattened", e);
                throw new RuntimeException(e);
            }
            catch (Throwable t) {
                throw ValueTypeSupportEnabledHelper.handleThrowable(t);
            }
            return result;
        }

        @Override
        public boolean isJ9ClassLargestAlignmentConstraintDouble(J9ClassPointer clazz) throws CorruptDataException {
            if (J9ClassLargestAlignmentConstraintDouble != 0L) {
                return J9ClassHelper.extendedClassFlags(clazz).allBitsIn(J9ClassLargestAlignmentConstraintDouble);
            }
            return false;
        }

        @Override
        public boolean isJ9ClassLargestAlignmentConstraintReference(J9ClassPointer clazz) throws CorruptDataException {
            if (J9ClassLargestAlignmentConstraintReference != 0L) {
                return J9ClassHelper.extendedClassFlags(clazz).allBitsIn(J9ClassLargestAlignmentConstraintReference);
            }
            return false;
        }

        private boolean isJ9ClassIsFlattened(J9ClassPointer clazz) throws CorruptDataException {
            if (J9ClassIsFlattened != 0L) {
                return J9ClassHelper.extendedClassFlags(clazz).allBitsIn(J9ClassIsFlattened);
            }
            return false;
        }

        @Override
        public boolean isFlattenableFieldSignature(String signature) {
            return signature.startsWith("Q");
        }
    }
}

