/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.structure.MM_HeapRegionDescriptor;
import java.io.PrintStream;

public class DumpAllRegionsCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");
    private static String[] regionTypesString = new String[(int)MM_HeapRegionDescriptor.RegionType.LAST_REGION_TYPE];

    public DumpAllRegionsCommand() {
        this.initializeRegionTypes();
        this.addCommand("dumpallregions", "cmd|help", "dump all regions in the GC");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        boolean statsRequested = false;
        boolean skipReport = false;
        if (0 != args.length) {
            String argument = args[0];
            if (argument.equalsIgnoreCase("help")) {
                this.help(out);
                return;
            }
            skipReport = statsRequested = argument.equalsIgnoreCase("stats");
        }
        try {
            String footer;
            String formatString;
            String header3;
            String header2;
            String header1;
            GCHeapRegionIterator gcHeapRegionIterator = GCHeapRegionIterator.from();
            int[] stats = new int[regionTypesString.length];
            int total = 0;
            this.initializeStats(stats);
            if (J9BuildFlags.env_data64) {
                header1 = "+----------------+----------------+----------------+----------------+--------+----------------+----------------------\n";
                header2 = "|    region      |     start      |      end       |    subspace    | flags  |      size      |      region type     \n";
                header3 = "+----------------+----------------+----------------+----------------+--------+----------------+----------------------\n";
                formatString = " %016x %016x %016x %016x %08x %16x %s\n";
                footer = "+----------------+----------------+----------------+----------------+--------+----------------+----------------------\n";
            } else {
                header1 = "+--------+--------+--------+--------+--------+--------+----------------------\n";
                header2 = "| region | start  |  end   |subspace| flags  |  size  |      region type     \n";
                header3 = "+--------+--------+--------+--------+--------+--------+----------------------\n";
                formatString = " %08x %08x %08x %08x %08x %8x %s\n";
                footer = "+--------+--------+--------+--------+--------+--------+----------------------\n";
            }
            if (!skipReport) {
                out.append(header1);
                out.append(header2);
                out.append(header3);
            }
            while (gcHeapRegionIterator.hasNext()) {
                String regionType;
                GCHeapRegionDescriptor heapRegionDescriptor = gcHeapRegionIterator.next();
                int index = (int)heapRegionDescriptor.getRegionType();
                ++total;
                if (index < regionTypesString.length) {
                    regionType = regionTypesString[index];
                    int n = index;
                    stats[n] = stats[n] + 1;
                } else {
                    regionType = "Unknown";
                }
                if (skipReport) continue;
                out.append(String.format(formatString, heapRegionDescriptor.getHeapRegionDescriptorPointer().getAddress(), heapRegionDescriptor.getLowAddress().getAddress(), heapRegionDescriptor.getHighAddress().getAddress(), heapRegionDescriptor.getSubSpace().getAddress(), heapRegionDescriptor.getTypeFlags().longValue(), heapRegionDescriptor.getSize().longValue(), regionType));
            }
            if (!skipReport) {
                out.append(footer);
            }
            if (statsRequested) {
                String formatStringStats = " \t%s: %d\n";
                for (int i = 0; i < regionTypesString.length; ++i) {
                    if (0 == stats[i]) continue;
                    out.append(String.format(formatStringStats, regionTypesString[i], stats[i]));
                }
                out.append(String.format(formatStringStats, "++++ TOTAL", total));
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void initializeStats(int[] stats) {
        for (int i = 0; i < stats.length; ++i) {
            stats[i] = 0;
        }
    }

    private void initializeRegionTypes() {
        for (int i = 0; i < regionTypesString.length; ++i) {
            DumpAllRegionsCommand.regionTypesString[i] = "Unknown";
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.RESERVED] = "RESERVED";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.FREE] = "FREE";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.SEGREGATED_SMALL] = "SEGREGATED_SMALL";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.SEGREGATED_LARGE] = "SEGREGATED_LARGE";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.ARRAYLET_LEAF] = "ARRAYLET_LEAF";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.ADDRESS_ORDERED] = "ADDRESS_ORDERED";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.ADDRESS_ORDERED_IDLE] = "ADDRESS_ORDERED_IDLE";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.ADDRESS_ORDERED_MARKED] = "ADDRESS_ORDERED_MARKED";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.BUMP_ALLOCATED] = "BUMP_ALLOCATED";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.BUMP_ALLOCATED_IDLE] = "BUMP_ALLOCATED_IDLE";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.BUMP_ALLOCATED_MARKED] = "BUMP_ALLOCATED_MARKED";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
    }

    private void help(PrintStream out) {
        out.append("!dumpallregions       -- dump all regions");
        out.append(nl);
        out.append("!dumpallregions stats -- calculate regions stats");
        out.append(nl);
    }
}

