/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.PrintObjectFieldsHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ValueTypeHelper;
import java.io.PrintStream;

public class FlatObjectCommand
extends Command {
    public FlatObjectCommand() {
        this.addCommand("flatobject", "<addressOfContainer> [<fieldName1>[.<fieldName2>]...]", "Display a flattened representation of a j9object given an address.");
    }

    private void printHelp(PrintStream out) {
        out.println("Usage:");
        out.println("  !flatobject <addressOfContainer> [<fieldName1>[.<fieldName2>]...]");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length == 0) {
            this.printHelp(out);
            return;
        }
        this.printFlatObject(command, args, context, out);
    }

    private void printFlatObject(String command, String[] args, Context context, PrintStream out) {
        J9ClassPointer clazz = null;
        AbstractPointer object = null;
        String[] argElements = args[0].split("\\.");
        if (!ValueTypeHelper.getValueTypeHelper().areValueTypesSupported()) {
            out.println("<this core file does not support flattened types>");
            return;
        }
        try {
            long address = CommandUtils.parsePointer(argElements[0], J9BuildFlags.env_data64);
            String nestingHeirarchy = null;
            if (1 < args.length) {
                nestingHeirarchy = args[1];
            }
            if ((clazz = J9ObjectHelper.clazz((J9ObjectPointer)(object = J9ObjectPointer.cast(address)))).isNull()) {
                out.println("<can not read RAM class address>");
                return;
            }
            if (J9ClassHelper.isArrayClass(clazz)) {
                out.println("<instance an array and not a flatobject>");
                return;
            }
            U8Pointer dataStart = U8Pointer.cast(object).add(ObjectModel.getHeaderSize((J9ObjectPointer)object));
            if (null != nestingHeirarchy) {
                out.format("!flatobject %s %s {%n", object.getHexAddress(), nestingHeirarchy);
            } else {
                out.format("!flatobject %s {%n", object.getHexAddress());
            }
            PrintObjectFieldsHelper.printJ9ObjectFields(out, 1, clazz, dataStart, (J9ObjectPointer)object, address, nestingHeirarchy == null ? null : nestingHeirarchy.split("\\."), true);
            out.println("}");
        }
        catch (MemoryFault ex2) {
            if (object == null || clazz == null) {
                out.format("Unable to read object with command !flatobject %s%n", argElements[0]);
            } else {
                out.format("Unable to read object clazz at %s (clazz = %s) with command !flatoject %s%n", object.getHexAddress(), clazz.getHexAddress(), argElements[0]);
            }
        }
        catch (CorruptDataException | DDRInteractiveCommandException ex) {
            out.println("Error for");
            ex.printStackTrace(out);
        }
    }
}

