/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.J9ConstantHelper;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.IDATAPointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.AttachedDataWrapperPointer;
import com.ibm.j9ddr.vm29.pointer.generated.ByteDataWrapperPointer;
import com.ibm.j9ddr.vm29.pointer.generated.CacheletHintsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.CacheletWrapperPointer;
import com.ibm.j9ddr.vm29.pointer.generated.ClasspathEntryItemPointer;
import com.ibm.j9ddr.vm29.pointer.generated.ClasspathItemPointer;
import com.ibm.j9ddr.vm29.pointer.generated.ClasspathWrapperPointer;
import com.ibm.j9ddr.vm29.pointer.generated.CompiledMethodWrapperPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SharedCacheHeaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SharedClassCacheDescriptorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SharedClassConfigPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.OrphanWrapperPointer;
import com.ibm.j9ddr.vm29.pointer.generated.ROMClassWrapperPointer;
import com.ibm.j9ddr.vm29.pointer.generated.SH_CacheMapPointer;
import com.ibm.j9ddr.vm29.pointer.generated.SH_CompositeCacheImplPointer;
import com.ibm.j9ddr.vm29.pointer.generated.SH_OSCachePointer;
import com.ibm.j9ddr.vm29.pointer.generated.ScopedROMClassWrapperPointer;
import com.ibm.j9ddr.vm29.pointer.generated.ShcItemHdrPointer;
import com.ibm.j9ddr.vm29.pointer.generated.ShcItemPointer;
import com.ibm.j9ddr.vm29.pointer.helper.AttachedDataWrapperHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ByteDataWrapperHelper;
import com.ibm.j9ddr.vm29.pointer.helper.CacheletWrapperHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ClasspathEntryItemHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ClasspathItemHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ClasspathWrapperHelper;
import com.ibm.j9ddr.vm29.pointer.helper.CompiledMethodWrapperHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMMethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.pointer.helper.OrphanWrapperHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ROMClassWrapperHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ScopedROMClassWrapperHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ShcItemHdrHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ShcItemHelper;
import com.ibm.j9ddr.vm29.structure.AttachedDataWrapper;
import com.ibm.j9ddr.vm29.structure.ByteDataWrapper;
import com.ibm.j9ddr.vm29.structure.CacheletHints;
import com.ibm.j9ddr.vm29.structure.CompiledMethodWrapper;
import com.ibm.j9ddr.vm29.structure.J9GenericByID;
import com.ibm.j9ddr.vm29.structure.J9SharedCacheHeader;
import com.ibm.j9ddr.vm29.structure.J9UTF8;
import com.ibm.j9ddr.vm29.structure.OrphanWrapper;
import com.ibm.j9ddr.vm29.structure.ROMClassWrapper;
import com.ibm.j9ddr.vm29.structure.ScopedROMClassWrapper;
import com.ibm.j9ddr.vm29.structure.ShCFlags;
import com.ibm.j9ddr.vm29.structure.SharedconstsConstants;
import com.ibm.j9ddr.vm29.structure.ShcItem;
import com.ibm.j9ddr.vm29.structure.ShcItemHdr;
import com.ibm.j9ddr.vm29.structure.ShcdatatypesConstants;
import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.types.UScalar;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ShrCCommand
extends Command {
    private static final long ORPHAN_STATS = 1L;
    private static final long ROMCLASS_STATS = 2L;
    private static final long CLASSPATH_STATS = 4L;
    private static final long AOT_STATS = 8L;
    private static final long SCOPE_STATS = 16L;
    private static final long BYTE_STATS = 32L;
    private static final long UNINDEXED_BYTE_STATS = 64L;
    private static final long INV_AOT_STATS = 128L;
    private static final long CACHELET_STATS = 256L;
    private static final long FIND_METHOD = 4096L;
    private static final long JITPROFILE_STATS = 8192L;
    private static final long JITHINT_STATS = 16384L;
    private static final long ALL_STALE_STATS = 32768L;
    private static final long ALL_STATS = 57855L;
    private static final int J9SHR_ATTACHED_DATA_TYPE_JITPROFILE = 1;
    private static final int J9SHR_ATTACHED_DATA_TYPE_JITHINT = 2;
    private static final String rangeDelim = "..";
    private static long cacheTotalSize = 0L;
    private static final long TYPE_PREREQ_CACHE = J9ConstantHelper.getLong(ShcdatatypesConstants.class, "TYPE_PREREQ_CACHE", -1L);

    public ShrCCommand() {
        this.addCommand("shrc", "[command]", "shared class cache operations");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            if (!J9BuildFlags.opt_sharedClasses) {
                CommandUtils.dbgPrint(out, "no shared cache\n");
                return;
            }
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9SharedClassConfigPointer sharedClassConfig = vm.sharedClassConfig();
            CommandUtils.dbgPrint(out, "!j9sharedclassconfig %s\n\n", sharedClassConfig.getHexAddress());
            if (args.length == 0) {
                this.printHelp(out);
            } else if (sharedClassConfig.notNull()) {
                String methodName;
                String className;
                U8Pointer metaStartInCache = this.getSharedCacheMetadataStart(vm, out);
                U8Pointer metaEndInCache = this.getSharedCacheMetadataEnd(vm, out);
                U8Pointer metaStart = metaStartInCache;
                U8Pointer metaEnd = metaEndInCache;
                this.initTotalCacheSize(out, sharedClassConfig);
                if (args.length > 1 && args[1].indexOf(rangeDelim) != -1) {
                    String addr = args[1].substring(0, args[1].indexOf(rangeDelim));
                    metaStart = U8Pointer.cast(CommandUtils.parsePointer(addr, J9BuildFlags.env_data64));
                    addr = args[1].substring(args[1].indexOf(rangeDelim) + rangeDelim.length());
                    metaEnd = U8Pointer.cast(CommandUtils.parsePointer(addr, J9BuildFlags.env_data64));
                }
                if (metaStart != null && metaStart.longValue() < metaStartInCache.longValue()) {
                    CommandUtils.dbgPrint(out, "User specified start boundary is before metadata start in cache\n");
                    metaStart = metaStartInCache;
                }
                if (metaEnd != null && metaEnd.longValue() > metaEndInCache.longValue()) {
                    CommandUtils.dbgPrint(out, "User specified end boundary is beyond metadata end in cache\n");
                    metaEnd = metaEndInCache;
                }
                if (metaStart != null && metaEnd != null && metaEnd.longValue() < metaStart.longValue()) {
                    CommandUtils.dbgPrint(out, "User specified metadata region boundary is not valid. Ensure 'end' > 'start'\n");
                    return;
                }
                CommandUtils.dbgPrint(out, "Meta data region to be used: %s..%s\n", metaStart.getHexAddress(), metaEnd.getHexAddress());
                if (args[0].equals("allstats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStart, metaEnd, 57855L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("rcstats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStart, metaEnd, 2L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("cpstats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStart, metaEnd, 4L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("aotstats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStart, metaEnd, 8L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("invaotstats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStart, metaEnd, 128L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("orphanstats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStart, metaEnd, 1L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("scopestats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStart, metaEnd, 16L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("bytestats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStart, metaEnd, 32L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("ubytestats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStart, metaEnd, 64L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("clstats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStart, metaEnd, 256L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("stalestats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStart, metaEnd, 32768L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("classpath")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc classpath <address>\n");
                    } else {
                        long address = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
                        this.dbgShrcPrintClasspath(out, ClasspathWrapperPointer.cast(address));
                    }
                } else if (args[0].equals("findclass")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc findclass <name>\n");
                    } else {
                        className = args[1];
                        CommandUtils.dbgPrint(out, "Looking for class \"%s\"\n", className);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStartInCache, metaEndInCache, 3L, className, false, VoidPointer.NULL, false);
                    }
                } else if (args[0].equals("findclassp")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc findclassp <name>\n");
                    } else {
                        className = args[1];
                        CommandUtils.dbgPrint(out, "Looking for class prefix \"%s\"\n", className);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStartInCache, metaEndInCache, 3L, className, true, VoidPointer.NULL, false);
                    }
                } else if (args[0].equals("findaot")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc findaot <name>\n");
                    } else {
                        methodName = args[1];
                        CommandUtils.dbgPrint(out, "Looking for AOT method \"%s\"\n", methodName);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStartInCache, metaEndInCache, 136L, methodName, false, VoidPointer.NULL, false);
                    }
                } else if (args[0].equals("findaotp")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc findaot <name>\n");
                    } else {
                        methodName = args[1];
                        CommandUtils.dbgPrint(out, "Looking for AOT method prefix \"%s\"\n", methodName);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStartInCache, metaEndInCache, 136L, methodName, true, VoidPointer.NULL, false);
                    }
                } else if (args[0].equals("aotfor")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc aotfor <address>\n");
                    } else {
                        long addr = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStartInCache, metaEndInCache, 136L, null, true, VoidPointer.cast(addr), false);
                    }
                } else if (args[0].equals("rcfor")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc rcfor <address>\n");
                    } else {
                        long addr = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStartInCache, metaEndInCache, 3L, null, false, VoidPointer.cast(addr), false);
                    }
                } else if (args[0].equals("incache")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc incache <address>\n");
                    } else {
                        long addr = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
                        this.dbgShrcInCache(out, vm, sharedClassConfig, VoidPointer.cast(addr));
                    }
                } else if (args[0].equals("stats")) {
                    if (sharedClassConfig.notNull()) {
                        this.dbgShrcInCache(out, vm, sharedClassConfig, VoidPointer.NULL);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStartInCache, metaEndInCache, 0L, null, false, VoidPointer.NULL, false);
                    }
                } else if (args[0].equals("method")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc method <address>\n");
                    } else {
                        long addr = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStartInCache, metaEndInCache, 4096L, null, false, VoidPointer.cast(addr), false);
                    }
                } else if (args[0].equals("cachelet")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc incache <address>\n");
                    } else {
                        long addr = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
                        this.dbgShrcPrintCachelet(out, CacheletWrapperPointer.cast(addr));
                    }
                } else if (args[0].equals("jitpstats")) {
                    if (sharedClassConfig.notNull()) {
                        this.dbgShrcInCache(out, vm, sharedClassConfig, VoidPointer.NULL);
                        boolean corrupt = args.length > 1 && "corrupt".equals(args[1]);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStart, metaEnd, 8192L, null, false, VoidPointer.NULL, corrupt);
                    }
                } else if (args[0].equals("findjitp")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc findjitp <name>\n");
                    } else {
                        methodName = args[1];
                        CommandUtils.dbgPrint(out, "Looking for JIT PROFILE method \"%s\"\n", methodName);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStartInCache, metaEndInCache, 8192L, methodName, false, VoidPointer.NULL, false);
                    }
                } else if (args[0].equals("findjitpp")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc findjitpp <name>\n");
                    } else {
                        methodName = args[1];
                        CommandUtils.dbgPrint(out, "Looking for JIT PROFILE method prefix \"%s\"\n", methodName);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStartInCache, metaEndInCache, 8192L, methodName, true, VoidPointer.NULL, false);
                    }
                } else if (args[0].equals("jitpfor")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc jitpfor <address>\n");
                    } else {
                        long addr = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStartInCache, metaEndInCache, 8192L, null, false, VoidPointer.cast(addr), false);
                    }
                } else if (args[0].equals("jithstats")) {
                    if (sharedClassConfig.notNull()) {
                        this.dbgShrcInCache(out, vm, sharedClassConfig, VoidPointer.NULL);
                        boolean corrupt = args.length > 1 && "corrupt".equals(args[1]);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStart, metaEnd, 16384L, null, false, VoidPointer.NULL, corrupt);
                    }
                } else if (args[0].equals("findjith")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc findjith <name>\n");
                    } else {
                        methodName = args[1];
                        CommandUtils.dbgPrint(out, "Looking for JIT HINT method \"%s\"\n", methodName);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStartInCache, metaEndInCache, 16384L, methodName, false, VoidPointer.NULL, false);
                    }
                } else if (args[0].equals("findjithp")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc findjithp <name>\n");
                    } else {
                        methodName = args[1];
                        CommandUtils.dbgPrint(out, "Looking for JIT HINT method prefix \"%s\"\n", methodName);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStartInCache, metaEndInCache, 16384L, methodName, true, VoidPointer.NULL, false);
                    }
                } else if (args[0].equals("jithfor")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc jithfor <address>\n");
                    } else {
                        long addr = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, metaStartInCache, metaEndInCache, 16384L, null, false, VoidPointer.cast(addr), false);
                    }
                } else if (args[0].equals("rtflags")) {
                    if (sharedClassConfig.notNull()) {
                        UDATA runtimeFlags = sharedClassConfig.runtimeFlags();
                        CommandUtils.dbgPrint(out, "Printing the shared classes runtime flags %s\n", runtimeFlags.getHexValue());
                        this.printShCFlags(out, runtimeFlags, "RUNTIMEFLAG");
                    }
                } else if (args[0].equals("extraflags")) {
                    if (sharedClassConfig.notNull()) {
                        ShrcConfig config = this.dbgShrcReadConfig(sharedClassConfig, out);
                        UDATA extraFlags = config.getCacheStartAddress().extraFlags();
                        CommandUtils.dbgPrint(out, "Printing the shared classes extra flags present in cache header %s\n", extraFlags.getHexValue());
                        this.printShCFlags(out, extraFlags, "EXTRA_FLAGS");
                    }
                } else if (args[0].equals("write")) {
                    if (args.length != 2 && args.length != 3) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc write <cachedir> [<cachename>]\n");
                    } else {
                        String cacheDir = args[1];
                        String cacheName = args.length == 3 ? args[2] : null;
                        try {
                            this.dbgShrcWriteCache(out, sharedClassConfig, cacheDir, cacheName);
                        }
                        catch (CorruptDataException e) {
                            CommandUtils.dbgPrint(out, "Unable to write complete cache: %s", e.getMessage());
                            CommandUtils.dbgPrint(out, "Attempting to write only populated areas of cache.\n");
                            this.dbgShrcWriteCacheByAreas(out, sharedClassConfig, cacheDir, cacheName);
                        }
                    }
                } else if (args[0].equals("name")) {
                    this.dbgShrcCacheName(out, sharedClassConfig);
                } else {
                    CommandUtils.dbgPrint(out, "Unknown arg(s) : ");
                    for (int i = 0; i < args.length; ++i) {
                        CommandUtils.dbgPrint(out, args[i] + " ");
                    }
                    CommandUtils.dbgPrint(out, "\nType !shrc to see all the valid options.\n");
                }
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void printShCFlags(PrintStream out, UScalar flags, String type2) {
        Field[] ShCFlagsfields;
        for (Field field : ShCFlagsfields = ShCFlags.class.getFields()) {
            String flagName = field.getName();
            try {
                Long flagValue = (Long)field.get(null);
                if (!flagName.contains(type2) || !flags.anyBitsIn(flagValue)) continue;
                if (flags.sizeof() == 8) {
                    CommandUtils.dbgPrint(out, "%-65s 0x%016X\n", flagName, flagValue);
                    continue;
                }
                CommandUtils.dbgPrint(out, "%-65s 0x%08X\n", flagName, flagValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void dbgShrcCacheName(PrintStream out, J9SharedClassConfigPointer sharedClassConfig) throws CorruptDataException {
        SH_OSCachePointer osCache = this.getOSCache(out, sharedClassConfig);
        if (osCache.notNull()) {
            U8Pointer cacheNamePointer = osCache._cacheNameWithVGen();
            U8Pointer cachePathNamePointer = osCache._cachePathName();
            if (cacheNamePointer.notNull()) {
                String cacheNameString = cacheNamePointer.getCStringAtOffset(0L);
                CommandUtils.dbgPrint(out, "Cache name is %s\n", cacheNameString);
            }
            if (cachePathNamePointer.notNull()) {
                String cachePathNameString = cachePathNamePointer.getCStringAtOffset(0L);
                CommandUtils.dbgPrint(out, "Cache path is %s\n", cachePathNameString);
            }
        }
    }

    private int dbgShrcCacheTopLayer(PrintStream out, J9SharedClassConfigPointer sharedClassConfig) throws CorruptDataException {
        U8Pointer cacheNamePointer;
        SH_OSCachePointer osCache = this.getOSCache(out, sharedClassConfig);
        int topLayer = 0;
        if (osCache.notNull() && (cacheNamePointer = osCache._cacheNameWithVGen()).notNull()) {
            String cacheNameString = cacheNamePointer.getCStringAtOffset(0L);
            Pattern p = Pattern.compile(".*L(\\d\\d)$");
            Matcher m = p.matcher(cacheNameString);
            if (m.matches()) {
                String layerNumberString = m.group(1);
                topLayer = Integer.parseInt(layerNumberString);
            } else {
                topLayer = -1;
            }
        }
        return topLayer;
    }

    CacheFileOutputStream createDbgShrcCacheFile(PrintStream out, J9SharedClassConfigPointer sharedClassConfig, String cacheDir, String cacheName) throws CorruptDataException {
        CacheFileOutputStream fout = null;
        SH_OSCachePointer osCache = this.getOSCache(out, sharedClassConfig);
        if (osCache.notNull()) {
            String cacheNameString = "default";
            U8Pointer cacheNamePointer = osCache._cacheNameWithVGen();
            if (cacheNamePointer.notNull()) {
                cacheNameString = cacheNamePointer.getCStringAtOffset(0L);
                CommandUtils.dbgPrint(out, "Cache name is %s\n", cacheNameString);
            }
            if (cacheName != null) {
                cacheNameString = cacheName;
            }
            VoidPointer headerStart = osCache._headerStart();
            UDATA cacheSize = osCache._cacheSize();
            CommandUtils.dbgPrint(out, "Cache start 0x%x size %d\n", headerStart.getAddress(), cacheSize.longValue());
            File outFile = new File(cacheDir, cacheNameString);
            CommandUtils.dbgPrint(out, "Writing cache to %s\n", outFile.getAbsolutePath());
            try {
                fout = new CacheFileOutputStream(outFile);
            }
            catch (FileNotFoundException e) {
                CommandUtils.dbgPrint(out, "Could not create %s: %s", outFile.getAbsolutePath(), e.getMessage());
            }
        }
        return fout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbgShrcWriteCache(PrintStream out, J9SharedClassConfigPointer sharedClassConfig, String cacheDir, String cacheName) throws CorruptDataException {
        CacheFileOutputStream fout = this.createDbgShrcCacheFile(out, sharedClassConfig, cacheDir, cacheName);
        ShrcConfig config = this.dbgShrcReadConfig(sharedClassConfig, out);
        J9SharedCacheHeaderPointer header = config.getCacheStartAddress();
        J9SharedCacheHeaderInfo helper = new J9SharedCacheHeaderInfo(header);
        try {
            this.dbgShrcWriteCacheArea(fout, helper.getHeaderStart(), helper.getDebugAreaEnd(), false);
        }
        catch (IOException e) {
            CommandUtils.dbgPrint(out, "Error writing %s: %s", fout.getFileName(), e.getMessage());
        }
        finally {
            try {
                fout.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbgShrcWriteCacheByAreas(PrintStream out, J9SharedClassConfigPointer sharedClassConfig, String cacheDir, String cacheName) throws CorruptDataException {
        CacheFileOutputStream fout = this.createDbgShrcCacheFile(out, sharedClassConfig, cacheDir, cacheName);
        ShrcConfig config = this.dbgShrcReadConfig(sharedClassConfig, out);
        J9SharedCacheHeaderPointer header = config.getCacheStartAddress();
        J9SharedCacheHeaderInfo helper = new J9SharedCacheHeaderInfo(header);
        try {
            this.dbgShrcWriteCacheArea(fout, helper.getHeaderStart(), helper.getRomClassesEnd(), false);
            this.dbgShrcWriteCacheArea(fout, helper.getRomClassesEnd(), helper.getMetaDataEnd(), true);
            this.dbgShrcWriteCacheArea(fout, helper.getMetaDataEnd(), helper.getMetaDataStart(), false);
            this.dbgShrcWriteCacheArea(fout, helper.getLineNumberAreaStart(), helper.getLineNumberAreaEnd(), false);
            this.dbgShrcWriteCacheArea(fout, helper.getLineNumberAreaEnd(), helper.getLocalVariableAreaEnd(), true);
            this.dbgShrcWriteCacheArea(fout, helper.getLocalVariableAreaEnd(), helper.getLocalVariableAreaStart(), false);
            CommandUtils.dbgPrint(out, "Cache successfully written to %s\n", fout.getFileName());
        }
        catch (IOException e) {
            CommandUtils.dbgPrint(out, "Error writing %s: %s", fout.getFileName(), e.getMessage());
        }
        finally {
            try {
                fout.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void dbgShrcWriteCacheArea(FileOutputStream fout, UDATA areaStart, UDATA areaEnd, boolean zeroFill) throws CorruptDataException, IOException {
        long offset = 0L;
        long start = areaStart.longValue();
        long end = areaEnd.longValue();
        long areaSize = end - start;
        SH_OSCachePointer hStart = SH_OSCachePointer.cast(start);
        byte[] buffer = new byte[4096];
        if (zeroFill) {
            Arrays.fill(buffer, (byte)0);
        }
        while (offset < areaSize) {
            if (areaSize - offset < (long)buffer.length) {
                buffer = new byte[(int)(areaSize - offset)];
                if (zeroFill) {
                    Arrays.fill(buffer, (byte)0);
                }
            }
            if (!zeroFill) {
                hStart.getBytesAtOffset(offset, buffer);
            }
            fout.write(buffer);
            offset += (long)buffer.length;
        }
    }

    private SH_OSCachePointer getOSCache(PrintStream out, J9SharedClassConfigPointer sharedClassConfig) throws CorruptDataException {
        if (sharedClassConfig.notNull()) {
            SH_CacheMapPointer structPointer = sharedClassConfig.sharedClassCache();
            if (structPointer.notNull()) {
                long pointer = structPointer.getAddress();
                SH_CacheMapPointer cacheMap = SH_CacheMapPointer.cast(pointer);
                SH_CompositeCacheImplPointer compositeCache = cacheMap._cc();
                if (compositeCache.notNull()) {
                    SH_OSCachePointer osCache = compositeCache._oscache();
                    if (osCache.notNull()) {
                        return osCache;
                    }
                    CommandUtils.dbgPrint(out, "SH_OSCache is NULL\n");
                } else {
                    CommandUtils.dbgPrint(out, "SH_CompositeCacheImpl is NULL\n");
                }
            } else {
                CommandUtils.dbgPrint(out, "SH_CacheMap is NULL\n");
            }
        } else {
            CommandUtils.dbgPrint(out, "J9SharedClassConfig is NULL\n");
        }
        return null;
    }

    private void printHelp(PrintStream out) {
        CommandUtils.dbgPrint(out, "!shrc stats [range]                  -- Print cache stats\n");
        CommandUtils.dbgPrint(out, "!shrc allstats [range]               -- Print all cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc rcstats [range]                -- Print romclass cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc cpstats [range]                -- Print classpath cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc aotstats [range]               -- Print aot cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc invaotstats [range]            -- Print invalidated aot cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc orphanstats [range]            -- Print orphan cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc scopestats [range]             -- Print scope cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc bytestats [range]              -- Print byte data cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc ubytestats [range]             -- Print unindexed byte data cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc stalestats [range]             -- Print all the stale cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc clstats [range]                -- Print cachelet cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc classpath <address>            -- Print classpath at address\n");
        CommandUtils.dbgPrint(out, "!shrc findclass <name>               -- Find named class\n");
        CommandUtils.dbgPrint(out, "!shrc findclassp <name>              -- Find named class prefix\n");
        CommandUtils.dbgPrint(out, "!shrc findaot <name>                 -- Find AOT for named method\n");
        CommandUtils.dbgPrint(out, "!shrc findaotp <name>                -- Find AOT for named method prefix\n");
        CommandUtils.dbgPrint(out, "!shrc aotfor <address>               -- Find AOT for rom method\n");
        CommandUtils.dbgPrint(out, "!shrc rcfor <address>                -- Find romclass metadata from romclass address\n");
        CommandUtils.dbgPrint(out, "!shrc method <address>               -- Lookup rom method in cache\n");
        CommandUtils.dbgPrint(out, "!shrc incache <address>              -- Lookup address in cache\n");
        CommandUtils.dbgPrint(out, "!shrc cachelet <address>             -- Print cachelet at address\n");
        CommandUtils.dbgPrint(out, "!shrc jitpstats [range] [corrupt]    -- Print jit profile cache contents, add corrupt to only display the corrupted caches\n");
        CommandUtils.dbgPrint(out, "!shrc findjitp <name>                -- Find jit profile for named method\n");
        CommandUtils.dbgPrint(out, "!shrc findjitpp <name>               -- Find jit profile for named method prefix\n");
        CommandUtils.dbgPrint(out, "!shrc jitpfor <address>              -- Find jit profile for rom method\n");
        CommandUtils.dbgPrint(out, "!shrc jithstats [range] [corrupt]    -- Print jit hint cache contents, add corrupt to only display the corrupted caches\n");
        CommandUtils.dbgPrint(out, "!shrc findjith <name>                -- Find jit hint for named method\n");
        CommandUtils.dbgPrint(out, "!shrc findjithp <name>               -- Find jit hint for named method prefix\n");
        CommandUtils.dbgPrint(out, "!shrc jithfor <address>              -- Find jit hint for rom method\n");
        CommandUtils.dbgPrint(out, "!shrc rtflags                        -- Display shared classes runtime flags\n");
        CommandUtils.dbgPrint(out, "!shrc extraflags                     -- Display shared classes extra flags present in cache header\n");
        CommandUtils.dbgPrint(out, "!shrc write <dir> [<name>]           -- Write the shared cache to the given directory\n");
        CommandUtils.dbgPrint(out, "!shrc name                           -- Display the name of the shared cache\n");
        CommandUtils.dbgPrint(out, "\nNote: [range] is specified as <start addr>..<end addr> eg 0x1000..0x2000\n");
    }

    private void dbgShrcPrintAllStats(PrintStream out, J9JavaVMPointer vm, J9SharedClassConfigPointer sharedClassConfig, U8Pointer metaStart, U8Pointer metaEnd, long statTypes, String searchName, boolean prefix, VoidPointer searchAddress, boolean findCorrupt) throws CorruptDataException {
        ArrayList<J9ROMClassPointer> romClassList = new ArrayList<J9ROMClassPointer>();
        boolean entryFound = false;
        int numRC = 0;
        int numOrphans = 0;
        int numStale = 0;
        int numCP = 0;
        int numURL = 0;
        int numToken = 0;
        int numAOT = 0;
        int numScope = 0;
        int numByte = 0;
        int numUnindexed = 0;
        int numChararray = 0;
        int numCachelets = 0;
        int numCacheletsNoSegments = 0;
        int numJITProfile = 0;
        int numJITHint = 0;
        int[] numByteOfType = new int[(int)ShCFlags.J9SHR_DATA_TYPE_MAX + 1];
        int aotDataLen = 0;
        int aotCodeLen = 0;
        int aotMetaLen = 0;
        int rcMetaLen = 0;
        int scopeMetaLen = 0;
        int scopeDataLen = 0;
        int byteMetaLen = 0;
        int byteDataLen = 0;
        int byteDataRWLen = 0;
        int unindexedByteMetaLen = 0;
        int unindexedByteDataLen = 0;
        int chararrayMetaLen = 0;
        int chararrayDataLen = 0;
        int cacheletMetaLen = 0;
        int jitProfileDataLen = 0;
        int jitProfileMetaLen = 0;
        int jitHintDataLen = 0;
        int jitHintMetaLen = 0;
        long totalROMClassBytes = 0L;
        long totalStaleBytes = 0L;
        boolean showAllStaleFlag = (statTypes & 0x8000L) != 0L;
        int topLayer = -1;
        ShrcConfig config = this.dbgShrcReadConfig(sharedClassConfig, out);
        topLayer = this.dbgShrcCacheTopLayer(out, sharedClassConfig);
        J9SharedCacheHeaderPointer cacheHeader = config.getCacheStartAddress();
        U8Pointer[] cacheHeaderPtr = null;
        if (topLayer >= 0) {
            cacheHeaderPtr = new U8Pointer[]{U8Pointer.cast(cacheHeader)};
        }
        UDATA romclassStartAddress = config.getRomclassStartAddress();
        UDATA segmentPtr = config.getSegmentPtr();
        int i = 0;
        while ((long)i <= ShCFlags.J9SHR_DATA_TYPE_MAX) {
            numByteOfType[i] = 0;
            ++i;
        }
        SharedClassMetadataIterator iterator = new SharedClassMetadataIterator(vm, metaStart, metaEnd, 0L, true, out);
        while (iterator.hasNext()) {
            UDATA len;
            J9UTF8Pointer utf8;
            UDATA dataLen;
            J9ROMMethodPointer romMethod;
            UDATA cpiType;
            ClasspathItemPointer cpi;
            ClasspathWrapperPointer cpw;
            J9UTF8Pointer romClassName;
            J9ROMClassPointer romClass;
            ShcItemPointer it = iterator.next();
            U16 itemType = it.dataType();
            J9UTF8Pointer rcPartition = J9UTF8Pointer.NULL;
            J9UTF8Pointer rcModContext = J9UTF8Pointer.NULL;
            boolean isStale = ShcItemHdrHelper.CCITEMSTALE(ShcItemHdrPointer.cast(ShcItemHelper.ITEMEND(it)));
            if (isStale) {
                totalStaleBytes += ShcItemHdrHelper.CCITEMLEN(ShcItemHdrPointer.cast(ShcItemHelper.ITEMEND(it))).longValue();
                ++numStale;
            }
            if (itemType.eq(ShcdatatypesConstants.TYPE_ORPHAN)) {
                String className;
                rcMetaLen = (int)((long)rcMetaLen + (OrphanWrapper.SIZEOF + ShcItem.SIZEOF + ShcItemHdr.SIZEOF));
                romClass = OrphanWrapperHelper.romClass(OrphanWrapperPointer.cast(ShcItemHelper.ITEMDATA(it)), cacheHeaderPtr);
                romClassName = romClass.className();
                if (romClassName.isNull()) {
                    CommandUtils.dbgPrint(out, "-- could not read romClassName, OW ShcItem %s romClass %s --\n", it.getHexAddress(), romClass.getHexAddress());
                    return;
                }
                romClassList.add(romClass);
                if ((searchAddress.isNull() || romClass.eq(searchAddress)) && (statTypes & 1L) != 0L && this.matchClassName(searchName, className = J9UTF8Helper.stringValue(romClassName), prefix)) {
                    entryFound = true;
                    CommandUtils.dbgPrint(out, "%d: %s ORPHAN: %s at !j9romclass %s\n", it.jvmID().longValue(), UDATA.cast(it).getHexValue(), className, romClass.getHexAddress());
                }
                ++numOrphans;
                continue;
            }
            if (itemType.eq(ShcdatatypesConstants.TYPE_ROMCLASS) || itemType.eq(ShcdatatypesConstants.TYPE_SCOPED_ROMCLASS)) {
                ROMClassWrapperPointer rcw = ROMClassWrapperPointer.cast(ShcItemHelper.ITEMDATA(it));
                rcMetaLen = (int)((long)rcMetaLen + (ShcItem.SIZEOF + ShcItemHdr.SIZEOF));
                if (itemType.eq(ShcdatatypesConstants.TYPE_ROMCLASS)) {
                    rcMetaLen = (int)((long)rcMetaLen + ROMClassWrapper.SIZEOF);
                } else {
                    rcMetaLen = (int)((long)rcMetaLen + ScopedROMClassWrapper.SIZEOF);
                    ScopedROMClassWrapperPointer srcw = ScopedROMClassWrapperPointer.cast(rcw);
                    rcPartition = J9UTF8Pointer.cast(ScopedROMClassWrapperHelper.RCWPARTITION(srcw, cacheHeaderPtr));
                    rcModContext = J9UTF8Pointer.cast(ScopedROMClassWrapperHelper.RCWMODCONTEXT(srcw, cacheHeaderPtr));
                }
                romClass = J9ROMClassPointer.cast(ROMClassWrapperHelper.RCWROMCLASS(rcw, cacheHeaderPtr));
                romClassName = romClass.className();
                if (romClassName.isNull()) {
                    CommandUtils.dbgPrint(out, "-- could not read romClassName, RC ShcItem %s romClass %s --\n", it.getHexAddress(), romClass.getHexAddress());
                    return;
                }
                romClassList.add(romClass);
                if (searchAddress.isNull() || romClass.eq(searchAddress)) {
                    String className;
                    cpw = ClasspathWrapperPointer.cast(ROMClassWrapperHelper.RCWCLASSPATH(ROMClassWrapperPointer.cast(ShcItemHelper.ITEMDATA(it)), cacheHeaderPtr));
                    if (((statTypes & 2L) != 0L || showAllStaleFlag && isStale) && this.matchClassName(searchName, className = J9UTF8Helper.stringValue(romClassName), prefix)) {
                        entryFound = true;
                        CommandUtils.dbgPrint(out, "%d: %s ROMCLASS: %s at !j9romclass %s ", it.jvmID().longValue(), it.getHexAddress(), className, romClass.getHexAddress());
                        if (isStale) {
                            if (!romClass.isNull()) {
                                totalStaleBytes += romClass.romSize().longValue();
                            }
                            CommandUtils.dbgPrint(out, "!STALE!");
                        }
                        CommandUtils.dbgPrint(out, "\n");
                        cpi = ClasspathItemPointer.cast(ClasspathWrapperHelper.CPWDATA(cpw));
                        cpiType = new UDATA(cpi.type());
                        if (cpiType.eq(J9GenericByID.CP_TYPE_CLASSPATH)) {
                            CommandUtils.dbgPrint(out, "\tIndex %d in !shrc classpath %s\n", rcw.cpeIndex().longValue(), cpw.getHexAddress());
                        } else if (cpiType.eq(J9GenericByID.CP_TYPE_URL)) {
                            CommandUtils.dbgPrint(out, "\tURL !shrc classpath %s\n", cpw.getHexAddress());
                        } else if (cpiType.eq(J9GenericByID.CP_TYPE_TOKEN)) {
                            CommandUtils.dbgPrint(out, "\tToken !shrc classpath %s\n", cpw.getHexAddress());
                        }
                        if (itemType.eq(ShcdatatypesConstants.TYPE_SCOPED_ROMCLASS)) {
                            if (rcPartition.notNull() && rcModContext.isNull()) {
                                CommandUtils.dbgPrint(out, "\tPartition !j9utf8 %s %s\n", rcPartition.getHexAddress(), this.dbgShrcPrintableString(rcPartition));
                            } else if (rcModContext.notNull() && rcPartition.isNull()) {
                                CommandUtils.dbgPrint(out, "\tModContext !j9utf8 %s %s\n", rcModContext.getHexAddress(), this.dbgShrcPrintableString(rcModContext));
                            } else if (rcModContext.notNull() && rcPartition.notNull()) {
                                CommandUtils.dbgPrint(out, "\tPartition !j9utf8 %s %s in ModContext !j9utf8 %s %s\n", rcPartition.getHexAddress(), this.dbgShrcPrintableString(rcPartition), rcModContext.getHexAddress(), this.dbgShrcPrintableString(rcModContext));
                            }
                        }
                    }
                }
                ++numRC;
                continue;
            }
            if (itemType.eq(ShcdatatypesConstants.TYPE_CLASSPATH)) {
                cpw = ClasspathWrapperPointer.cast(ShcItemHelper.ITEMDATA(it));
                cpi = ClasspathItemPointer.cast(ClasspathWrapperHelper.CPWDATA(cpw));
                if ((statTypes & 4L) != 0L) {
                    entryFound = true;
                    this.dbgShrcPrintClasspath(out, cpw);
                }
                if ((cpiType = new UDATA(cpi.type())).eq(J9GenericByID.CP_TYPE_CLASSPATH)) {
                    ++numCP;
                    continue;
                }
                if (cpiType.eq(J9GenericByID.CP_TYPE_URL)) {
                    ++numURL;
                    continue;
                }
                if (!cpiType.eq(J9GenericByID.CP_TYPE_TOKEN)) continue;
                ++numToken;
                continue;
            }
            if (itemType.eq(ShcdatatypesConstants.TYPE_COMPILED_METHOD) || itemType.eq(ShcdatatypesConstants.TYPE_INVALIDATED_COMPILED_METHOD)) {
                CompiledMethodWrapperPointer cmw = CompiledMethodWrapperPointer.cast(ShcItemHelper.ITEMDATA(it));
                romMethod = J9ROMMethodPointer.cast(CompiledMethodWrapperHelper.CMWROMMETHOD(cmw, cacheHeaderPtr));
                dataLen = new UDATA(cmw.dataLength());
                UDATA codeLen = new UDATA(cmw.codeLength());
                aotDataLen = (int)((long)aotDataLen + dataLen.longValue());
                aotCodeLen = (int)((long)aotCodeLen + codeLen.longValue());
                aotMetaLen = (int)((long)aotMetaLen + (CompiledMethodWrapper.SIZEOF + ShcItem.SIZEOF + ShcItemHdr.SIZEOF));
                if (((statTypes & 8L) != 0L && itemType.eq(ShcdatatypesConstants.TYPE_COMPILED_METHOD) || (statTypes & 0x80L) != 0L && itemType.eq(ShcdatatypesConstants.TYPE_INVALIDATED_COMPILED_METHOD) || showAllStaleFlag && isStale) && (searchAddress.isNull() || romMethod.eq(searchAddress))) {
                    String methodName = J9ROMMethodHelper.getName(romMethod) + J9ROMMethodHelper.getSignature(romMethod);
                    if (this.matchRomMethodName(searchName, J9ROMMethodHelper.getName(romMethod), J9ROMMethodHelper.getSignature(romMethod), prefix)) {
                        entryFound = true;
                        CommandUtils.dbgPrint(out, "%d: %s AOT data !j9x %s,%s code !j9x %s,%s ", it.jvmID().longValue(), it.getHexAddress(), CompiledMethodWrapperHelper.CMWDATA(cmw).getHexAddress(), dataLen.getHexValue(), CompiledMethodWrapperHelper.CMWCODE(cmw).getHexAddress(), codeLen.getHexValue());
                        if (isStale) {
                            CommandUtils.dbgPrint(out, "!STALE!");
                        }
                        if (itemType.eq(ShcdatatypesConstants.TYPE_INVALIDATED_COMPILED_METHOD)) {
                            CommandUtils.dbgPrint(out, "INVALIDATED");
                        }
                        CommandUtils.dbgPrint(out, "\n\t%s !j9rommethod %s\n", methodName, romMethod.getHexAddress());
                        ListIterator iter = romClassList.listIterator(romClassList.size());
                        while (iter.hasPrevious()) {
                            J9ROMClassPointer lastRomClass = (J9ROMClassPointer)iter.previous();
                            if (!romMethod.gt(lastRomClass) || !romMethod.lt(lastRomClass.addOffset(lastRomClass.romSize()))) continue;
                            CommandUtils.dbgPrint(out, "\t%s !j9romclass %s\n", J9UTF8Helper.stringValue(lastRomClass.className()), lastRomClass.getHexAddress());
                            break;
                        }
                    }
                }
                ++numAOT;
                continue;
            }
            if (itemType.eq(ShcdatatypesConstants.TYPE_ATTACHED_DATA)) {
                AttachedDataWrapperPointer adw = AttachedDataWrapperPointer.cast(ShcItemHelper.ITEMDATA(it));
                romMethod = J9ROMMethodPointer.cast(AttachedDataWrapperHelper.ADWCACHEOFFSET(adw, cacheHeaderPtr));
                dataLen = new UDATA(adw.dataLength());
                int adType = adw.type().intValue();
                boolean jitHint = 2 == adType;
                int adUpdateCount = adw.updateCount().intValue();
                int adCorrupt = adw.corrupt().intValue();
                if (jitHint) {
                    jitHintDataLen = (int)((long)jitHintDataLen + dataLen.longValue());
                    jitHintMetaLen = (int)((long)jitHintMetaLen + (AttachedDataWrapper.SIZEOF + ShcItem.SIZEOF + ShcItemHdr.SIZEOF));
                } else {
                    jitProfileDataLen = (int)((long)jitProfileDataLen + dataLen.longValue());
                    jitProfileMetaLen = (int)((long)jitProfileMetaLen + (AttachedDataWrapper.SIZEOF + ShcItem.SIZEOF + ShcItemHdr.SIZEOF));
                }
                if ((jitHint && 0L != (statTypes & 0x4000L) || !jitHint && 0L != (statTypes & 0x2000L) || showAllStaleFlag && isStale) && (!findCorrupt && searchAddress.isNull() || romMethod.eq(searchAddress) || findCorrupt && adCorrupt != -1)) {
                    String methodName = J9ROMMethodHelper.getName(romMethod) + J9ROMMethodHelper.getSignature(romMethod);
                    if (this.matchRomMethodName(searchName, J9ROMMethodHelper.getName(romMethod), J9ROMMethodHelper.getSignature(romMethod), prefix)) {
                        entryFound = true;
                        CommandUtils.dbgPrint(out, "%d: %s %s data !j9x %s,%s  type %d updates %d corrupt %d", it.jvmID().longValue(), it.getHexAddress(), jitHint ? "JITHINT" : "JITPROFILE", AttachedDataWrapperHelper.ADWDATA(adw).getHexAddress(), dataLen.getHexValue(), adType, adUpdateCount, adCorrupt);
                        if (isStale) {
                            CommandUtils.dbgPrint(out, "!STALE!");
                        }
                        CommandUtils.dbgPrint(out, "\n\t%s !j9rommethod %s\n", methodName, romMethod.getHexAddress());
                        ListIterator iter = romClassList.listIterator(romClassList.size());
                        while (iter.hasPrevious()) {
                            J9ROMClassPointer lastRomClass = (J9ROMClassPointer)iter.previous();
                            if (!romMethod.gt(lastRomClass) || !romMethod.lt(lastRomClass.addOffset(lastRomClass.romSize()))) continue;
                            CommandUtils.dbgPrint(out, "\t%s !j9romclass %s\n", J9UTF8Helper.stringValue(lastRomClass.className()), lastRomClass.getHexAddress());
                            break;
                        }
                    }
                }
                if (jitHint) {
                    ++numJITHint;
                    continue;
                }
                ++numJITProfile;
                continue;
            }
            if (itemType.eq(ShcdatatypesConstants.TYPE_SCOPE)) {
                utf8 = J9UTF8Pointer.cast(ShcItemHelper.ITEMDATA(it));
                scopeMetaLen = (int)((long)scopeMetaLen + (ShcItem.SIZEOF + ShcItemHdr.SIZEOF));
                scopeDataLen = (int)((long)scopeDataLen + (J9UTF8.SIZEOF + utf8.length().longValue()));
                if ((statTypes & 0x10L) != 0L) {
                    entryFound = true;
                    CommandUtils.dbgPrint(out, "%d: %s SCOPE !j9utf8 %s %s\n", it.jvmID().longValue(), it.getHexAddress(), utf8.getHexAddress(), J9UTF8Helper.stringValue(utf8));
                }
                ++numScope;
                continue;
            }
            if (itemType.eq(ShcdatatypesConstants.TYPE_BYTE_DATA)) {
                ByteDataWrapperPointer bdw = ByteDataWrapperPointer.cast(ShcItemHelper.ITEMDATA(it));
                byteMetaLen = (int)((long)byteMetaLen + (ShcItem.SIZEOF + ShcItemHdr.SIZEOF + ByteDataWrapper.SIZEOF));
                UDATA rwOffset = new UDATA(ByteDataWrapperHelper.BDWEXTBLOCK(bdw, cacheHeaderPtr));
                len = new UDATA(ByteDataWrapperHelper.BDWLEN(bdw));
                UDATA byteDataType = new UDATA(ByteDataWrapperHelper.BDWTYPE(bdw));
                if (byteDataType.longValue() <= ShCFlags.J9SHR_DATA_TYPE_MAX) {
                    int n = (int)byteDataType.longValue();
                    numByteOfType[n] = (int)((long)numByteOfType[n] + len.longValue());
                } else {
                    int n = (int)ShCFlags.J9SHR_DATA_TYPE_UNKNOWN;
                    numByteOfType[n] = (int)((long)numByteOfType[n] + len.longValue());
                }
                if (rwOffset.eq(0L)) {
                    byteDataLen = (int)((long)byteDataLen + len.longValue());
                    if ((statTypes & 0x20L) != 0L) {
                        entryFound = true;
                        CommandUtils.dbgPrint(out, "%d: %s %s BYTEDATA !j9x %s,%s", it.jvmID().longValue(), it.getHexAddress(), this.getType(byteDataType), ByteDataWrapperHelper.getDataFromByteDataWrapper(bdw, cacheHeaderPtr).getHexAddress(), len.getHexValue());
                    }
                } else {
                    byteDataRWLen = (int)((long)byteDataRWLen + len.longValue());
                    if ((statTypes & 0x20L) != 0L) {
                        entryFound = true;
                        CommandUtils.dbgPrint(out, "%d: %s BYTEDATA RW !j9x %s,%s", it.jvmID().longValue(), it.getHexAddress(), ByteDataWrapperHelper.getDataFromByteDataWrapper(bdw, cacheHeaderPtr).getHexAddress(), len.getHexValue());
                    }
                }
                if ((statTypes & 0x20L) != 0L || showAllStaleFlag && isStale) {
                    if (isStale) {
                        CommandUtils.dbgPrint(out, "!STALE!");
                    }
                    UDATA inPrivateUse = new UDATA(ByteDataWrapperHelper.BDWINPRIVATEUSE(bdw));
                    UDATA privateOwnerID = new UDATA(ByteDataWrapperHelper.BDWPRIVATEOWNERID(bdw));
                    utf8 = J9UTF8Pointer.cast(ByteDataWrapperHelper.BDWTOKEN(bdw, cacheHeaderPtr));
                    if (utf8.notNull()) {
                        CommandUtils.dbgPrint(out, "\n\tkey: !j9utf8 %s %s\n", utf8.getHexAddress(), J9UTF8Helper.stringValue(utf8));
                    }
                    if (!inPrivateUse.eq(0L) || !privateOwnerID.eq(0L)) {
                        CommandUtils.dbgPrint(out, "\n\tinPrivateUse %d privateOwnerID %d\n", inPrivateUse.longValue(), privateOwnerID.longValue());
                    }
                }
                ++numByte;
                continue;
            }
            if (itemType.eq(ShcdatatypesConstants.TYPE_UNINDEXED_BYTE_DATA)) {
                len = new UDATA(it.dataLen());
                unindexedByteMetaLen = (int)((long)unindexedByteMetaLen + (ShcItem.SIZEOF + ShcItemHdr.SIZEOF));
                unindexedByteDataLen = (int)((long)unindexedByteDataLen + len.longValue());
                if ((statTypes & 0x40L) != 0L) {
                    entryFound = true;
                    CommandUtils.dbgPrint(out, "%d: %s UNINDEXEDBYTEDATA !j9x %s,%s\n", it.jvmID().longValue(), it.getHexAddress(), ShcItemHelper.ITEMDATA(it).getHexAddress(), len.getHexValue());
                }
                ++numUnindexed;
                continue;
            }
            if (itemType.eq(ShcdatatypesConstants.TYPE_CACHELET)) {
                CacheletWrapperPointer cachelet = CacheletWrapperPointer.cast(ShcItemHelper.ITEMDATA(it));
                J9SharedCacheHeaderPointer header = J9SharedCacheHeaderPointer.cast(CacheletWrapperHelper.CLETDATA(cachelet));
                UDATA cacheletRomClassStartAddress = UDATA.cast(header).add(header.readWriteBytes());
                UDATA cacheletSegmentPtr = UDATA.cast(header).add(header.segmentSRP());
                totalROMClassBytes += cacheletSegmentPtr.sub(cacheletRomClassStartAddress).longValue();
                cacheletMetaLen = (int)((long)cacheletMetaLen + it.dataLen().longValue());
                if ((statTypes & 0x100L) != 0L) {
                    entryFound = true;
                    this.dbgShrcPrintCachelet(out, cachelet);
                }
                if (cachelet.numSegments().eq(0L)) {
                    ++numCacheletsNoSegments;
                }
                ++numCachelets;
                continue;
            }
            if (!itemType.eq(TYPE_PREREQ_CACHE)) continue;
        }
        if ((statTypes & 0x1000L) != 0L) {
            Iterator lastRomClassIterator = romClassList.iterator();
            J9ROMClassPointer lastRomClass = J9ROMClassPointer.NULL;
            while (lastRomClassIterator.hasNext()) {
                lastRomClass = (J9ROMClassPointer)lastRomClassIterator.next();
                if (!searchAddress.gt(lastRomClass) || !searchAddress.lt(lastRomClass.addOffset(lastRomClass.romSize()))) continue;
                entryFound = true;
                break;
            }
            if (!entryFound) {
                CommandUtils.dbgPrint(out, "!j9rommethod %s not found in cache\n", J9ROMMethodPointer.cast(searchAddress).getHexAddress());
                if (searchAddress.lt(VoidPointer.cast(romclassStartAddress))) {
                    CommandUtils.dbgPrint(out, "\taddress is < cache romclassStartAddress %s\n", romclassStartAddress.getHexValue());
                }
                if (searchAddress.gt(VoidPointer.cast(segmentPtr))) {
                    CommandUtils.dbgPrint(out, "\taddress is > cache romclass segment %s\n", segmentPtr.getHexValue());
                }
            } else {
                CommandUtils.dbgPrint(out, "!j9rommethod %s found in %s !j9romclass %s\n", J9ROMMethodPointer.cast(searchAddress).getHexAddress(), J9UTF8Helper.stringValue(lastRomClass.className()), lastRomClass.getHexAddress());
            }
        } else if (!entryFound) {
            CommandUtils.dbgPrint(out, "No entry found in the cache\n");
        }
        if (searchAddress.isNull() && searchName == null) {
            CommandUtils.dbgPrint(out, "\nCache contains %d classes, %d orphans, %d classpaths, %d URLs, %d tokens\n", numRC, numOrphans, numCP, numURL, numToken);
            CommandUtils.dbgPrint(out, "%d AOT, %d SCOPES, %d BYTE data, %d UNINDEXED DATA, %d CHARARRAY, %d stale\n", numAOT, numScope, numByte, numUnindexed, numChararray, numStale);
            CommandUtils.dbgPrint(out, "stale bytes %d\n", totalStaleBytes);
            CommandUtils.dbgPrint(out, "%d JITPROFILE, %d JITHINT\n", numJITProfile, numJITHint);
            CommandUtils.dbgPrint(out, "AOT data length %d code length %d metadata %d total %d\n", aotDataLen, aotCodeLen, aotMetaLen, aotDataLen + aotCodeLen, aotMetaLen);
            CommandUtils.dbgPrint(out, "JITPROFILE data length %d metadata %d \n", jitProfileDataLen, jitProfileMetaLen);
            CommandUtils.dbgPrint(out, "JITHINT data length %d metadata %d \n", jitHintDataLen, jitHintMetaLen);
            if (cacheHeader.containsCachelets().eq(0L)) {
                totalROMClassBytes = segmentPtr.sub(romclassStartAddress).longValue();
            }
            CommandUtils.dbgPrint(out, "ROMClass data %d metadata %d\n", totalROMClassBytes, rcMetaLen);
            CommandUtils.dbgPrint(out, "SCOPE data %d metadata %d total %d\n", scopeDataLen, scopeMetaLen, scopeMetaLen + scopeDataLen);
            CommandUtils.dbgPrint(out, "BYTE data %d metadata %d rwarea %d\n", byteDataLen, byteMetaLen, byteDataRWLen);
            CommandUtils.dbgPrint(out, "UNINDEXEDBYTE data %d metadata %d\n", unindexedByteDataLen, unindexedByteMetaLen);
            CommandUtils.dbgPrint(out, "CHARARRAY data %d metadata %d\n", chararrayDataLen, chararrayMetaLen);
            CommandUtils.dbgPrint(out, "BYTEDATA Summary\n");
            CommandUtils.dbgPrint(out, "\tUNKNOWN %d  HELPER %d  POOL %d  AOTHEADER %d\n", numByteOfType[(int)ShCFlags.J9SHR_DATA_TYPE_UNKNOWN], numByteOfType[(int)ShCFlags.J9SHR_DATA_TYPE_HELPER], numByteOfType[(int)ShCFlags.J9SHR_DATA_TYPE_POOL], numByteOfType[(int)ShCFlags.J9SHR_DATA_TYPE_AOTHEADER]);
            CommandUtils.dbgPrint(out, "\tJCL %d  VM %d  ROMSTRING %d  ZIPCACHE %d  STARTUPHINTS %d\n", numByteOfType[(int)ShCFlags.J9SHR_DATA_TYPE_JCL], numByteOfType[(int)ShCFlags.J9SHR_DATA_TYPE_VM], numByteOfType[(int)ShCFlags.J9SHR_DATA_TYPE_ROMSTRING], numByteOfType[(int)ShCFlags.J9SHR_DATA_TYPE_ZIPCACHE], numByteOfType[(int)ShCFlags.J9SHR_DATA_TYPE_STARTUP_HINTS]);
            CommandUtils.dbgPrint(out, "\tJITHINT %d  AOTCLASSCHAIN %d AOTTHUNK %d\n", numByteOfType[(int)ShCFlags.J9SHR_DATA_TYPE_JITHINT], numByteOfType[(int)ShCFlags.J9SHR_DATA_TYPE_AOTCLASSCHAIN], numByteOfType[(int)ShCFlags.J9SHR_DATA_TYPE_AOTTHUNK]);
            if (cacheletMetaLen > 0) {
                CommandUtils.dbgPrint(out, "CACHELET count %d (without segments %d) metadata %d\n", numCachelets, numCacheletsNoSegments, cacheletMetaLen);
            }
            J9SharedCacheHeaderInfo helper = new J9SharedCacheHeaderInfo(cacheHeader);
            UDATA debugLNTUsed = helper.getDebugLNTUsed();
            UDATA debugLVTUsed = helper.getDebugLVTUsed();
            CommandUtils.dbgPrint(out, "DEBUG Area Summary\n");
            CommandUtils.dbgPrint(out, "\tLineNumberTable bytes    : %d\n", debugLNTUsed.longValue());
            CommandUtils.dbgPrint(out, "\tLocalVariableTable bytes : %d\n", debugLVTUsed.longValue());
        }
    }

    ShrcConfig dbgShrcReadConfig(J9SharedClassConfigPointer sharedClassConfig, PrintStream out) throws CorruptDataException {
        UDATA segmentSRP;
        SH_OSCachePointer osCache;
        SH_CompositeCacheImplPointer compositeCacheImpl;
        SH_CacheMapPointer cacheMap;
        AbstractPointer cacheStartAddress = null;
        Scalar romclassStartAddress = null;
        Scalar segmentPtr = null;
        J9SharedClassCacheDescriptorPointer cacheDescriptor = sharedClassConfig.cacheDescriptorList();
        if (null != cacheDescriptor) {
            cacheStartAddress = cacheDescriptor.cacheStartAddress();
        }
        if (cacheStartAddress.isNull() && (cacheMap = sharedClassConfig.sharedClassCache()).notNull() && (compositeCacheImpl = cacheMap._cc()).notNull() && (cacheStartAddress = compositeCacheImpl._theca()).isNull() && (osCache = compositeCacheImpl._oscache()).notNull()) {
            cacheStartAddress = J9SharedCacheHeaderPointer.cast(osCache._dataStart().longValue());
        }
        if (cacheStartAddress.isNull()) {
            CommandUtils.dbgPrint(out, "cacheStartAddress is zero");
            return null;
        }
        if (cacheDescriptor.notNull()) {
            romclassStartAddress = UDATA.cast(cacheDescriptor.romclassStartAddress());
        }
        if (0L == romclassStartAddress.longValue() && 0L != ((J9SharedCacheHeaderPointer)cacheStartAddress).readWriteBytes().longValue()) {
            romclassStartAddress = new UDATA(((J9SharedCacheHeaderPointer)cacheStartAddress).addOffset(((J9SharedCacheHeaderPointer)cacheStartAddress).readWriteBytes()).longValue());
        }
        if (0L == romclassStartAddress.longValue()) {
            CommandUtils.dbgPrint(out, "romclassStartAddress is zero");
        }
        if (0L != (segmentSRP = ((J9SharedCacheHeaderPointer)cacheStartAddress).segmentSRP()).longValue()) {
            segmentPtr = UDATA.cast(cacheStartAddress).add(segmentSRP);
        }
        if (0L == segmentPtr.longValue()) {
            CommandUtils.dbgPrint(out, "segmentPtr is zero");
        }
        return new ShrcConfig((J9SharedCacheHeaderPointer)cacheStartAddress, (UDATA)romclassStartAddress, (UDATA)segmentPtr);
    }

    U8Pointer getSharedCacheMetadataStart(J9JavaVMPointer vm, PrintStream out) throws CorruptDataException {
        J9SharedClassConfigPointer sharedConfig = vm.sharedClassConfig();
        if (sharedConfig.isNull()) {
            CommandUtils.dbgPrint(out, "SharedClassConfig can not be found.");
            return null;
        }
        ShrcConfig config = this.dbgShrcReadConfig(sharedConfig, out);
        J9SharedCacheHeaderPointer header = config.getCacheStartAddress();
        J9SharedCacheHeaderInfo helper = new J9SharedCacheHeaderInfo(header);
        return U8Pointer.cast(helper.getMetaDataEnd());
    }

    U8Pointer getSharedCacheMetadataEnd(J9JavaVMPointer vm, PrintStream out) throws CorruptDataException {
        J9SharedClassConfigPointer sharedConfig = vm.sharedClassConfig();
        if (sharedConfig.isNull()) {
            CommandUtils.dbgPrint(out, "SharedClassConfig can not be found.");
            return null;
        }
        ShrcConfig config = this.dbgShrcReadConfig(sharedConfig, out);
        J9SharedCacheHeaderPointer header = config.getCacheStartAddress();
        J9SharedCacheHeaderInfo helper = new J9SharedCacheHeaderInfo(header);
        return U8Pointer.cast(helper.getMetaDataStart().longValue() - ShcItemHdr.SIZEOF);
    }

    SharedCacheMetadata dbgReadSharedCacheMetadata(J9JavaVMPointer vm, PrintStream out) throws CorruptDataException {
        U8Pointer heapTop = this.getSharedCacheMetadataEnd(vm, out);
        U8Pointer heapBase = this.getSharedCacheMetadataStart(vm, out);
        if (heapTop.isNull() || heapBase.isNull()) {
            CommandUtils.dbgPrint(out, "SharedCache is not initialized enough to find the metadata area of the cache");
            return null;
        }
        SharedCacheMetadata metadata = new SharedCacheMetadata(heapBase, heapTop);
        if (metadata.getLength().lt(0)) {
            return null;
        }
        return metadata;
    }

    SharedCacheMetadata dbgReadSharedCacheMetadata(J9JavaVMPointer vm, U8Pointer metaStart, U8Pointer metaEnd, PrintStream out) throws CorruptDataException {
        SharedCacheMetadata metadata = new SharedCacheMetadata(metaStart, metaEnd);
        if (metadata.getLength().lt(0)) {
            return null;
        }
        return metadata;
    }

    private String getType(UDATA byteDataType) {
        long type2 = byteDataType.longValue();
        if (type2 == ShCFlags.J9SHR_DATA_TYPE_HELPER) {
            return "HELPER";
        }
        if (type2 == ShCFlags.J9SHR_DATA_TYPE_POOL) {
            return "POOL";
        }
        if (type2 == ShCFlags.J9SHR_DATA_TYPE_AOTHEADER) {
            return "AOTHEADER";
        }
        if (type2 == ShCFlags.J9SHR_DATA_TYPE_JCL) {
            return "JCL";
        }
        if (type2 == ShCFlags.J9SHR_DATA_TYPE_VM) {
            return "VM";
        }
        if (type2 == ShCFlags.J9SHR_DATA_TYPE_ROMSTRING) {
            return "ROMSTRING";
        }
        if (type2 == ShCFlags.J9SHR_DATA_TYPE_CACHELET) {
            return "CACHELET";
        }
        if (type2 == ShCFlags.J9SHR_DATA_TYPE_ZIPCACHE) {
            return "ZIPCACHE";
        }
        if (type2 == ShCFlags.J9SHR_DATA_TYPE_STARTUP_HINTS) {
            return "STARTUPHINT";
        }
        if (type2 == ShCFlags.J9SHR_DATA_TYPE_JITHINT) {
            return "JITHINT";
        }
        if (type2 == ShCFlags.J9SHR_DATA_TYPE_AOTCLASSCHAIN) {
            return "AOTCLASSCHAIN";
        }
        if (type2 == ShCFlags.J9SHR_DATA_TYPE_AOTTHUNK) {
            return "AOTTHUNK";
        }
        return "UNKNOWN(" + type2 + ")";
    }

    private String dbgShrcPrintableString(J9UTF8Pointer utf8) throws CorruptDataException {
        String stringData = J9UTF8Helper.stringValue(utf8);
        return stringData;
    }

    private boolean matchClassName(String searchName, String className, boolean prefix) {
        if (searchName == null || className == null) {
            return true;
        }
        if (prefix) {
            return className.startsWith(searchName);
        }
        return searchName.equals(className);
    }

    private boolean matchRomMethodName(String searchName, String methodName, String methodSignature, boolean prefix) {
        if (searchName == null || methodName == null || methodSignature == null) {
            return true;
        }
        String methodNameAndSig = methodName + methodSignature;
        if (prefix) {
            return methodNameAndSig.startsWith(searchName);
        }
        if (searchName.equals(methodName)) {
            return true;
        }
        return searchName.equals(methodNameAndSig);
    }

    private void dbgShrcPrintCachelet(PrintStream out, CacheletWrapperPointer cw) throws CorruptDataException {
        ShcItemPointer item = ShcItemPointer.cast(UDATA.cast(cw).sub(ShcItem.SIZEOF));
        CommandUtils.dbgPrint(out, "%d: %s CACHELET !shrc cachelet %s\n", item.jvmID().longValue(), item.getHexAddress(), cw.getHexAddress());
        UDATA numHints = cw.numHints();
        U8Pointer hints = U8Pointer.cast(CacheletWrapperHelper.CLETHINTS(cw));
        UDATA numSegments = cw.numSegments();
        CommandUtils.dbgPrint(out, "  numHints: %d at: !j9x %s\n", numHints.longValue(), hints.getHexAddress());
        CommandUtils.dbgPrint(out, "  numSegments: %d segmentStartOffset: %s lastSegmentAlloc: %s\n", numSegments.longValue(), cw.segmentStartOffset().getHexValue(), cw.lastSegmentAlloc().getHexValue());
        if (numSegments.gt(0)) {
            UDATAPointer segHints = UDATAPointer.NULL;
            U8Pointer cursor = hints;
            int i = 0;
            while (numHints.gt(i)) {
                CacheletHintsPointer hint = CacheletHintsPointer.cast(cursor);
                UDATA length = hint.length();
                UDATA dataType = hint.dataType();
                CommandUtils.dbgPrint(out, "  %s hints at: !j9x %s,%s\n", dataType.getHexValue(), UDATA.cast(hint).add(CacheletHints.SIZEOF).getHexValue(), length.getHexValue());
                cursor = cursor.add(length).add(CacheletHints.SIZEOF);
                ++i;
            }
            segHints = UDATAPointer.cast(cursor);
            CommandUtils.dbgPrint(out, "  segment hints at: !j9x %s,%s\n  ", segHints.getHexAddress(), numSegments.mult(UDATA.SIZEOF).getHexValue());
            i = 0;
            while (numSegments.gt(i)) {
                CommandUtils.dbgPrint(out, "  %s", segHints.at(i).getHexValue());
                ++i;
            }
            CommandUtils.dbgPrint(out, "\n");
        }
        J9SharedCacheHeaderPointer header = J9SharedCacheHeaderPointer.cast(CacheletWrapperHelper.CLETDATA(cw));
        CommandUtils.dbgPrint(out, "  ");
        this.dbgShrcHeaderOperations(out, header, VoidPointer.NULL, 1);
    }

    private Touple<Boolean, Long> dbgShrcHeaderOperations(PrintStream out, J9SharedCacheHeaderPointer header, VoidPointer address, int cacheletIndex) throws CorruptDataException {
        long freeBytes = 0L;
        J9SharedCacheHeaderInfo helper = new J9SharedCacheHeaderInfo(header);
        U32 totalBytes = helper.getTotalBytes();
        U32 softMaxBytes = helper.getSoftMaxBytes();
        U32 readWriteBytes = helper.getReadWriteBytes();
        UDATA segmentPtr = helper.getSegmentPtr();
        UDATA updatePtr = helper.getUpdatePtr();
        UDATA readWritePtr = helper.getReadWritePtr();
        UDATA readWriteStartAddress = helper.getReadWriteStart();
        UDATA romclassStartAddress = helper.getRomClassesStart();
        UDATA debugAreaSize = helper.getDebugAreaSize();
        UDATA metadataStartAddress = helper.getMetaDataStart();
        UDATA debugAreaStart = helper.getDebugAreaStart();
        UDATA debugAreaEnd = helper.getDebugAreaEnd();
        UDATA debugLNTNextAdd = helper.getLineNumberAreaEnd();
        UDATA debugLVTNextAdd = helper.getLocalVariableAreaEnd();
        UDATA debugLNTUsed = helper.getDebugLNTUsed();
        UDATA debugLVTUsed = helper.getDebugLVTUsed();
        UDATA debugAreaUsed = debugLNTUsed.add(debugLVTUsed);
        UDATA debugAreaPercentUsed = 0L != debugAreaSize.longValue() ? new UDATA(debugAreaUsed.longValue() * 100L / debugAreaSize.longValue()) : new UDATA(100L);
        UDATA getFreeAvailableBytes = helper.getFreeAvailableBytes();
        if (null != getFreeAvailableBytes) {
            freeBytes = getFreeAvailableBytes.longValue();
        }
        if (cacheletIndex == -1 || address.isNull()) {
            String indent;
            CommandUtils.dbgPrint(out, "!j9sharedcacheheader %s\n", header.getHexAddress());
            String string = indent = cacheletIndex >= 0 ? "    " : "";
            if (cacheletIndex > 0) {
                CommandUtils.dbgPrint(out, "    ccInitComplete: 0x%x free bytes: %d cacheFullFlags: %d\n", header.ccInitComplete().longValue(), updatePtr.sub(segmentPtr).longValue(), header.cacheFullFlags().longValue());
            } else {
                if (cacheletIndex == -1) {
                    CommandUtils.dbgPrint(out, "%scache size       : %d\n", indent, totalBytes.sub(readWriteBytes).longValue());
                    if (null != getFreeAvailableBytes) {
                        CommandUtils.dbgPrint(out, "%sfree bytes       : %d\n", indent, freeBytes);
                    }
                    if (softMaxBytes.eq(U32.MAX)) {
                        CommandUtils.dbgPrint(out, "%ssoftmx bytes     : %d\n", indent, -1);
                    } else {
                        CommandUtils.dbgPrint(out, "%ssoftmx bytes     : %d", indent, softMaxBytes.longValue());
                        try {
                            Field field = ShCFlags.class.getField("J9SHR_AVAILABLE_SPACE_FULL");
                            Long flagValue = (Long)field.get(null);
                            if (helper.getCacheFullFlags().anyBitsIn(flagValue)) {
                                CommandUtils.dbgPrint(out, " (J9SHR_AVAILABLE_SPACE_FULL is set)");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        CommandUtils.dbgPrint(out, "\n");
                    }
                }
                CommandUtils.dbgPrint(out, "%sread write area  : %s - %s size %d used %d\n", indent, readWriteStartAddress.getHexValue(), readWritePtr.getHexValue(), readWriteBytes.longValue(), readWritePtr.sub(readWriteStartAddress).longValue());
            }
            CommandUtils.dbgPrint(out, "%ssegment area     : %s - %s size %d\n", indent, romclassStartAddress.getHexValue(), segmentPtr.getHexValue(), segmentPtr.sub(romclassStartAddress).longValue());
            CommandUtils.dbgPrint(out, "%smetadata area    : %s - %s size %d\n", indent, updatePtr.getHexValue(), metadataStartAddress.getHexValue(), metadataStartAddress.sub(updatePtr).longValue());
            CommandUtils.dbgPrint(out, "%sclass debug area : %s - %s size %d used %d (%% used %d)\n", indent, debugAreaStart.getHexValue(), debugAreaEnd.getHexValue(), debugAreaSize.longValue(), debugAreaUsed.longValue(), debugAreaPercentUsed.longValue());
        }
        if (address.isNull()) {
            return new Touple<Boolean, Long>(false, freeBytes);
        }
        if (address.gte(VoidPointer.cast(header)) && address.lt(header.addOffset(J9SharedCacheHeader.SIZEOF))) {
            CommandUtils.dbgPrint(out, "\n0x%x is in the cache%s header", address.getAddress(), cacheletIndex > 0 ? "let" : "");
        } else if (address.gte(VoidPointer.cast(readWriteStartAddress)) && address.lt(VoidPointer.cast(readWritePtr))) {
            CommandUtils.dbgPrint(out, "\n0x%x is in the read write area", address.getAddress());
        } else if (address.gte(VoidPointer.cast(readWritePtr)) && address.lt(VoidPointer.cast(romclassStartAddress))) {
            CommandUtils.dbgPrint(out, "\n0x%x is in the unused part of the read write area", address.getAddress());
        } else if (address.gte(VoidPointer.cast(romclassStartAddress)) && address.lt(VoidPointer.cast(segmentPtr))) {
            CommandUtils.dbgPrint(out, "\n0x%x is in the rom class segment area", address.getAddress());
        } else if (address.gte(VoidPointer.cast(segmentPtr)) && address.lt(VoidPointer.cast(updatePtr))) {
            CommandUtils.dbgPrint(out, "\n0x%x is in unused area between class segments and metadata", address.getAddress());
        } else if (address.gte(VoidPointer.cast(updatePtr)) && address.lt(VoidPointer.cast(metadataStartAddress))) {
            CommandUtils.dbgPrint(out, "\n0x%x is in the metadata area", address.getAddress());
        } else if (!debugAreaSize.eq(0L) && address.gte(VoidPointer.cast(metadataStartAddress)) && address.lt(VoidPointer.cast(debugAreaEnd))) {
            if (address.lt(VoidPointer.cast(debugLNTNextAdd))) {
                CommandUtils.dbgPrint(out, "\n0x%x is in the line number table of the class debug area", address.getAddress());
            } else if (address.gt(VoidPointer.cast(debugLVTNextAdd))) {
                CommandUtils.dbgPrint(out, "\n0x%x is in the local variable table of the class debug area", address.getAddress());
            } else {
                CommandUtils.dbgPrint(out, "\n0x%x is in the unused part of the class debug area", address.getAddress());
            }
        } else {
            return new Touple<Boolean, Long>(false, freeBytes);
        }
        if (cacheletIndex > 0) {
            CommandUtils.dbgPrint(out, " of cachelet %d\n", cacheletIndex);
        } else if (cacheletIndex == 0) {
            CommandUtils.dbgPrint(out, " of the main cache\n");
        } else {
            CommandUtils.dbgPrint(out, "\n");
        }
        return new Touple<Boolean, Long>(true, freeBytes);
    }

    private void dbgShrcPrintClasspath(PrintStream out, ClasspathWrapperPointer cpw) throws CorruptDataException {
        ClasspathItemPointer cpi = ClasspathItemPointer.cast(ClasspathWrapperHelper.CPWDATA(cpw));
        UDATA cpiType = new UDATA(cpi.type());
        ShcItemPointer item = ShcItemPointer.cast(UDATA.cast(cpw).sub(ShcItem.SIZEOF));
        U16 jvmID = item.jvmID();
        I16 staleFromIndex = cpw.staleFromIndex();
        CommandUtils.dbgPrint(out, "%d: ", jvmID.longValue());
        if (cpiType.eq(J9GenericByID.CP_TYPE_CLASSPATH)) {
            CommandUtils.dbgPrint(out, "%s CLASSPATH", UDATA.cast(cpw).getHexValue());
        } else if (cpiType.eq(J9GenericByID.CP_TYPE_URL)) {
            CommandUtils.dbgPrint(out, "%s URL", UDATA.cast(cpw).getHexValue());
        } else if (cpiType.eq(J9GenericByID.CP_TYPE_TOKEN)) {
            CommandUtils.dbgPrint(out, "%s TOKEN", UDATA.cast(cpw).getHexValue());
        }
        if (!staleFromIndex.eq(ShcdatatypesConstants.CPW_NOT_STALE)) {
            CommandUtils.dbgPrint(out, " staleFromIndex %d", staleFromIndex.longValue());
        }
        CommandUtils.dbgPrint(out, "\n");
        IDATA itemsAdded = cpi.itemsAdded();
        IDATAPointer cpeiArrayPtr = ClasspathItemHelper.CPEI_ARRAY_PTR_FROM_CPI(cpi);
        int i = 0;
        while (itemsAdded.gt(i)) {
            ClasspathEntryItemPointer cpei = ClasspathEntryItemPointer.cast(UDATA.cast(cpi).add(cpeiArrayPtr.at(i)));
            UDATA cpeiPathLen = cpei.pathLen();
            U8Pointer cpeiPathPointer = ClasspathEntryItemHelper.CPEIPATH(cpei);
            String cpeiPath = cpeiPathPointer.getCStringAtOffset(0L, cpeiPathLen.longValue());
            CommandUtils.dbgPrint(out, "   %d)\t%s: %s \ttimestamp: %s%s\n", i, this.getProtocolName(cpei.protocol()), cpeiPath, cpei.timestamp().getHexValue(), this.isStaleCPEntry(cpei) ? " !STALE" : "");
            ++i;
        }
    }

    private boolean isStaleCPEntry(ClasspathEntryItemPointer cpei) throws CorruptDataException {
        return (cpei.flags().longValue() & SharedconstsConstants.MARKED_STALE_FLAG) != 0L;
    }

    private String getProtocolName(UDATA protocol) {
        long protocolValue = protocol.longValue();
        if (protocolValue == SharedconstsConstants.PROTO_JAR) {
            return "JAR";
        }
        if (protocolValue == SharedconstsConstants.PROTO_DIR) {
            return "DIR";
        }
        if (protocolValue == SharedconstsConstants.PROTO_TOKEN) {
            return "TOKEN";
        }
        if (protocolValue == SharedconstsConstants.PROTO_UNKNOWN) {
            return "UNKNOWN";
        }
        return protocol.getHexValue();
    }

    private void dbgShrcInCache(PrintStream out, J9JavaVMPointer vm, J9SharedClassConfigPointer sharedClassConfig, VoidPointer address) throws CorruptDataException {
        int index;
        boolean found = false;
        ShrcConfig dbgShrcReadConfig = this.dbgShrcReadConfig(sharedClassConfig, out);
        J9SharedCacheHeaderPointer cacheStartAddress = dbgShrcReadConfig.getCacheStartAddress();
        UDATA containsCachelets = cacheStartAddress.containsCachelets();
        if (!containsCachelets.eq(0L)) {
            index = 1;
            long totalFreeBytes = 0L;
            this.dbgShrcHeaderOperations(out, J9SharedCacheHeaderPointer.cast(cacheStartAddress), VoidPointer.NULL, 0);
            SharedClassMetadataIterator iterator = new SharedClassMetadataIterator(vm, ShcdatatypesConstants.TYPE_CACHELET, true, out);
            while (iterator.hasNext()) {
                ShcItemPointer it = iterator.next();
                CacheletWrapperPointer cw = CacheletWrapperPointer.cast(ShcItemHelper.ITEMDATA(it));
                J9SharedCacheHeaderPointer header = J9SharedCacheHeaderPointer.cast(CacheletWrapperHelper.CLETDATA(cw));
                CommandUtils.dbgPrint(out, "Cachelet %d !shrc cachelet %s ", index, cw.getHexAddress());
                Touple<Boolean, Long> dbgShrcHeaderOperations = this.dbgShrcHeaderOperations(out, header, VoidPointer.NULL, index);
                totalFreeBytes += dbgShrcHeaderOperations.getV2().longValue();
                ++index;
            }
            CommandUtils.dbgPrint(out, "total cache size : %d\n", cacheStartAddress.totalBytes().sub((int)J9SharedCacheHeader.SIZEOF).longValue());
            CommandUtils.dbgPrint(out, "total free bytes : %d\n", totalFreeBytes);
        } else {
            found = this.dbgShrcHeaderOperations(out, cacheStartAddress, address, -1).getV1();
        }
        if (address.isNull()) {
            return;
        }
        if (!containsCachelets.eq(0L)) {
            ShcItemPointer it;
            CacheletWrapperPointer cw;
            J9SharedCacheHeaderPointer header;
            index = 1;
            SharedClassMetadataIterator iterator = new SharedClassMetadataIterator(vm, ShcdatatypesConstants.TYPE_CACHELET, true, out);
            while (iterator.hasNext() && !(found = this.dbgShrcHeaderOperations(out, header = J9SharedCacheHeaderPointer.cast(CacheletWrapperHelper.CLETDATA(cw = CacheletWrapperPointer.cast(ShcItemHelper.ITEMDATA(it = iterator.next())))), address, index++).getV1().booleanValue())) {
            }
            if (!found) {
                found = this.dbgShrcHeaderOperations(out, cacheStartAddress, address, 0).getV1();
            }
        }
        if (!found) {
            CommandUtils.dbgPrint(out, "\n%s is not in the shared cache\n", U8Pointer.cast(address).getHexAddress());
        }
    }

    private void initTotalCacheSize(PrintStream out, J9SharedClassConfigPointer sharedClassConfig) throws CorruptDataException {
        SH_OSCachePointer osCache;
        if (0L == cacheTotalSize && (osCache = this.getOSCache(out, sharedClassConfig)).notNull()) {
            cacheTotalSize = osCache._cacheSize().longValue();
        }
    }

    class ShrcConfig {
        private final J9SharedCacheHeaderPointer cacheStartAddress;
        private final UDATA romclassStartAddress;
        private final UDATA segmentPtr;

        public ShrcConfig(J9SharedCacheHeaderPointer cacheStartAddress, UDATA romclassStartAddress, UDATA segmentPtr) {
            this.cacheStartAddress = cacheStartAddress;
            this.romclassStartAddress = romclassStartAddress;
            this.segmentPtr = segmentPtr;
        }

        public J9SharedCacheHeaderPointer getCacheStartAddress() {
            return this.cacheStartAddress;
        }

        public UDATA getRomclassStartAddress() {
            return this.romclassStartAddress;
        }

        public UDATA getSegmentPtr() {
            return this.segmentPtr;
        }
    }

    static class CacheFileOutputStream
    extends FileOutputStream {
        private String fileName;

        CacheFileOutputStream(File f) throws FileNotFoundException {
            super(f);
            this.fileName = f.getAbsolutePath();
        }

        String getFileName() {
            return this.fileName;
        }
    }

    static class J9SharedCacheHeaderInfo {
        private J9SharedCacheHeaderPointer header;

        J9SharedCacheHeaderInfo(J9SharedCacheHeaderPointer header) {
            this.header = header;
        }

        public J9SharedCacheHeaderPointer getHeader() {
            return this.header;
        }

        public void setHeader(J9SharedCacheHeaderPointer header) {
            this.header = header;
        }

        public UDATA getHeaderStart() {
            return UDATA.cast(this.header);
        }

        public U32 getTotalBytes() throws CorruptDataException {
            return new U32(this.header.totalBytes());
        }

        public U32 getSoftMaxBytes() throws CorruptDataException {
            return new U32(this.header.softMaxBytes());
        }

        public U32 getReadWriteBytes() throws CorruptDataException {
            return new U32(this.header.readWriteBytes());
        }

        public UDATA getReadWritePtr() throws CorruptDataException {
            UDATA readWriteSRP = this.header.readWriteSRP();
            return UDATA.cast(this.header).add(readWriteSRP);
        }

        public UDATA getReadWriteStart() {
            return UDATA.cast(this.header).add(J9SharedCacheHeader.SIZEOF);
        }

        public UDATA getRomClassesStart() throws CorruptDataException {
            return UDATA.cast(this.header).add(this.getReadWriteBytes());
        }

        public UDATA getRomClassesEnd() throws CorruptDataException {
            return this.getSegmentPtr();
        }

        public UDATA getSegmentPtr() throws CorruptDataException {
            UDATA segmentSRP = this.header.segmentSRP();
            return UDATA.cast(this.header).add(segmentSRP);
        }

        public UDATA getUpdatePtr() throws CorruptDataException {
            UDATA updateSRP = this.header.updateSRP();
            return UDATA.cast(this.header).add(updateSRP);
        }

        public UDATA getDebugAreaSize() throws CorruptDataException {
            return new UDATA(this.header.debugRegionSize().longValue());
        }

        public UDATA getMetaDataStart() throws CorruptDataException {
            return UDATA.cast(this.header).add(this.getTotalBytes()).sub(this.getDebugAreaSize());
        }

        public UDATA getMetaDataEnd() throws CorruptDataException {
            return this.getUpdatePtr();
        }

        public UDATA getDebugAreaStart() throws CorruptDataException {
            return UDATA.cast(this.header).add(this.getTotalBytes()).sub(this.getDebugAreaSize());
        }

        public UDATA getDebugAreaEnd() throws CorruptDataException {
            return this.getDebugAreaStart().add(this.getDebugAreaSize());
        }

        public UDATA getLineNumberAreaStart() throws CorruptDataException {
            return this.getDebugAreaStart();
        }

        public UDATA getLineNumberAreaEnd() throws CorruptDataException {
            return new UDATA(this.header.lineNumberTableNextSRPEA().longValue() + this.header.lineNumberTableNextSRP().longValue());
        }

        public UDATA getLocalVariableAreaStart() throws CorruptDataException {
            return this.getDebugAreaEnd();
        }

        public UDATA getLocalVariableAreaEnd() throws CorruptDataException {
            return new UDATA(this.header.localVariableTableNextSRPEA().longValue() + this.header.localVariableTableNextSRP().longValue());
        }

        public UDATA getDebugLVTUsed() throws CorruptDataException {
            return this.getDebugAreaEnd().sub(this.getLocalVariableAreaEnd());
        }

        public UDATA getDebugLNTUsed() throws CorruptDataException {
            return this.getLineNumberAreaEnd().sub(this.getDebugAreaStart());
        }

        public I32 getMinAOT() throws CorruptDataException {
            return new I32(this.header.minAOT());
        }

        public I32 getMinJIT() throws CorruptDataException {
            return new I32(this.header.minJIT());
        }

        public UDATA getAotBytes() throws CorruptDataException {
            return this.header.aotBytes();
        }

        public UDATA getJitBytes() throws CorruptDataException {
            return this.header.jitBytes();
        }

        public UDATA getCacheFullFlags() throws CorruptDataException {
            return this.header.cacheFullFlags();
        }

        public I32 getFreeBlockBytes() throws CorruptDataException {
            long minAOT = this.getMinAOT().longValue();
            long minJIT = this.getMinJIT().longValue();
            long aotBytes = this.getAotBytes().longValue();
            long jitBytes = this.getJitBytes().longValue();
            UDATA updatePtr = this.getUpdatePtr();
            UDATA segmentPtr = this.getSegmentPtr();
            long freeBytes = updatePtr.sub(segmentPtr).longValue();
            long retVal = -1L == minAOT && -1L == minJIT || -1L == minAOT && minJIT <= jitBytes || -1L == minJIT && minAOT <= aotBytes || minAOT <= aotBytes && minJIT <= jitBytes ? freeBytes : (minJIT > jitBytes && (-1L == minAOT || minAOT <= aotBytes) ? freeBytes - (minJIT - jitBytes) : (minAOT > aotBytes && (-1L == minJIT || minJIT <= jitBytes) ? freeBytes - (minAOT - aotBytes) : freeBytes - (minJIT - jitBytes) - (minAOT - aotBytes)));
            retVal = retVal > 0L ? retVal : 0L;
            return new I32(retVal);
        }

        public U32 getUsedBytes() throws CorruptDataException {
            long totalSize = cacheTotalSize;
            long freeBlockBytes = this.getFreeBlockBytes().longValue();
            long freeDebugSize = this.getDebugAreaSize().longValue() - this.getDebugLNTUsed().longValue() - this.getDebugLVTUsed().longValue();
            if (0L == totalSize) {
                return null;
            }
            return new U32(totalSize - freeBlockBytes - freeDebugSize);
        }

        public UDATA getFreeAvailableBytes() throws CorruptDataException {
            long ret = 0L;
            long totalSize = cacheTotalSize;
            long freeBlockBytes = this.getFreeBlockBytes().longValue();
            U32 softMaxBytes = this.getSoftMaxBytes();
            U32 usedBytes = this.getUsedBytes();
            if (null != usedBytes) {
                ret = softMaxBytes.eq(U32.MAX) ? totalSize - usedBytes.longValue() : softMaxBytes.sub(usedBytes).longValue();
                ret = freeBlockBytes < ret ? freeBlockBytes : ret;
                return new UDATA(ret);
            }
            return null;
        }
    }

    class SharedClassMetadataIterator
    implements Iterator<ShcItemPointer> {
        private ShcItemPointer next;
        private U8Pointer metaStartInCache;
        private U8Pointer metaStart;
        private U8Pointer savedMetaStart;
        private ShcItemHdrPointer entry;
        private ShcItemHdrPointer savedEntry;
        private U16 limitDataType;
        private boolean includeStale;
        private PrintStream out;

        private void init(J9JavaVMPointer vm, SharedCacheMetadata cacheMetadata, long limitDataType, boolean includeStale, PrintStream out) throws CorruptDataException {
            this.next = ShcItemPointer.NULL;
            this.metaStartInCache = ShrCCommand.this.getSharedCacheMetadataStart(vm, out);
            this.metaStart = cacheMetadata.getHeapBase();
            this.savedMetaStart = cacheMetadata.getHeapBase();
            this.entry = cacheMetadata.getFirstEntry();
            this.savedEntry = ShcItemHdrPointer.NULL;
            this.limitDataType = new U16(limitDataType);
            this.includeStale = includeStale;
            this.out = out;
        }

        public SharedClassMetadataIterator(J9JavaVMPointer vm, long limitDataType, boolean includeStale, PrintStream out) throws CorruptDataException {
            SharedCacheMetadata cacheMetadata = ShrCCommand.this.dbgReadSharedCacheMetadata(vm, out);
            this.init(vm, cacheMetadata, limitDataType, includeStale, out);
        }

        public SharedClassMetadataIterator(J9JavaVMPointer vm, U8Pointer metaRegionStart, U8Pointer metaRegionEnd, long limitDataType, boolean includeStale, PrintStream out) throws CorruptDataException {
            SharedCacheMetadata cacheMetadata = ShrCCommand.this.dbgReadSharedCacheMetadata(vm, metaRegionStart, metaRegionEnd, out);
            this.init(vm, cacheMetadata, limitDataType, includeStale, out);
        }

        @Override
        public boolean hasNext() {
            if (this.entry.notNull() && this.next.isNull()) {
                this.next = this.internalNext();
            }
            return this.next.notNull();
        }

        @Override
        public ShcItemPointer next() {
            if (this.entry.notNull() && this.next.isNull()) {
                this.next = this.internalNext();
            }
            ShcItemPointer returnValue = this.next;
            this.next = ShcItemPointer.NULL;
            return returnValue;
        }

        private ShcItemPointer internalNext() {
            try {
                ShcItemPointer current = ShcItemPointer.NULL;
                ShcItemHdrPointer nextEntry = this.entry;
                do {
                    ShcItemPointer walk;
                    U16 type2;
                    this.entry = nextEntry;
                    long itemLen = ShcItemHdrHelper.CCITEMLEN(this.entry).longValue();
                    if (itemLen == 0L) {
                        CommandUtils.dbgPrint(this.out, "\nCache header !shcitemhdr %s is corrupt because itemLen is 0\n", this.entry.getHexAddress());
                        nextEntry = ShcItemHdrPointer.NULL;
                        break;
                    }
                    nextEntry = ShcItemHdrHelper.CCITEMNEXT(this.entry);
                    if (UDATA.cast(nextEntry).lt(UDATA.cast(this.metaStartInCache.sub(ShcItemHdr.SIZEOF)))) {
                        CommandUtils.dbgPrint(this.out, "\nCache header !shcitemhdr %s is corrupt because itemLen %d is bigger than size of metadata area\n", this.entry.getHexAddress(), itemLen);
                        nextEntry = ShcItemHdrPointer.NULL;
                        break;
                    }
                    if (UDATA.cast(nextEntry).lt(UDATA.cast(this.metaStart.sub(ShcItemHdr.SIZEOF)))) {
                        nextEntry = ShcItemHdrPointer.NULL;
                    }
                    if (UDATA.cast(nextEntry).lte(UDATA.cast(this.metaStart))) {
                        if (this.savedEntry.notNull()) {
                            this.metaStart = this.savedMetaStart;
                            nextEntry = this.savedEntry;
                            this.savedEntry = ShcItemHdrPointer.NULL;
                            if (UDATA.cast(nextEntry).lte(UDATA.cast(this.metaStart))) {
                                nextEntry = ShcItemHdrPointer.NULL;
                            }
                        } else {
                            nextEntry = ShcItemHdrPointer.NULL;
                        }
                    }
                    if ((type2 = (walk = ShcItemPointer.cast(ShcItemHdrHelper.CCITEM(this.entry))).dataType()).eq(ShcdatatypesConstants.TYPE_CACHELET)) {
                        CacheletWrapperPointer cw = CacheletWrapperPointer.cast(ShcItemHelper.ITEMDATA(walk));
                        J9SharedCacheHeaderPointer header = J9SharedCacheHeaderPointer.cast(CacheletWrapperHelper.CLETDATA(cw));
                        UDATA totalBytes = header.totalBytes();
                        UDATA updatePtr = UDATA.cast(header).add(header.updateSRP());
                        UDATA metadataEnd = UDATA.cast(header).add(totalBytes);
                        if (metadataEnd.sub(ShcItemHdr.SIZEOF).gt(updatePtr)) {
                            this.savedEntry = nextEntry;
                            this.metaStart = U8Pointer.cast(updatePtr);
                            nextEntry = ShcItemHdrPointer.cast(metadataEnd.sub(ShcItemHdr.SIZEOF));
                        }
                    }
                    if (!this.limitDataType.eq(0L) && (!type2.eq(this.limitDataType) || !this.includeStale && ShcItemHdrHelper.CCITEMSTALE(this.entry))) continue;
                    current = walk;
                    break;
                } while (nextEntry.notNull());
                this.entry = nextEntry;
                return current;
            }
            catch (CorruptDataException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public void remove() {
        }
    }

    class SharedCacheMetadata {
        private final U8Pointer heapBase;
        private final U8Pointer heapTop;
        private final UDATA length;

        public SharedCacheMetadata(U8Pointer heapBase, U8Pointer heapTop) {
            this.heapBase = heapBase;
            this.heapTop = heapTop;
            this.length = new UDATA(heapTop.sub(heapBase));
        }

        public U8Pointer getHeapBase() {
            return this.heapBase;
        }

        public U8Pointer getHeapTop() {
            return this.heapTop;
        }

        public UDATA getLength() {
            return this.length;
        }

        public ShcItemHdrPointer getFirstEntry() {
            return ShcItemHdrPointer.cast(this.heapTop);
        }
    }

    class Touple<V1, V2> {
        V1 v1;
        V2 v2;

        public Touple(V1 v1, V2 v2) {
            this.v1 = v1;
            this.v2 = v2;
        }

        public V1 getV1() {
            return this.v1;
        }

        public V2 getV2() {
            return this.v2;
        }
    }
}

