/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.aix;

import com.ibm.j9ddr.corereaders.ClosingFileReader;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.aix.AIXDumpReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.stream.ImageInputStream;

class AIX32DumpReader
extends AIXDumpReader {
    private static final int CONTEXT_OFFSET_IN_THREAD = 200;
    private static final int IAR_OFFSET_IN_CONTEXT = 24;
    private static final int GPR_OFFSET_IN_CONTEXT = 208;
    private static final int GPR_COUNT = 32;
    private static final String VMID = "j9vmap32";

    public AIX32DumpReader(File file, ClosingFileReader fileReader) throws FileNotFoundException, InvalidDumpFormatException, IOException {
        this.coreFile = file;
        this.setReader(fileReader);
        this.readCore();
    }

    public AIX32DumpReader(ImageInputStream in) throws FileNotFoundException, InvalidDumpFormatException, IOException {
        this.coreFile = null;
        this.setReader(in);
        this.readCore();
    }

    public String getVMID() {
        return VMID;
    }

    @Override
    public boolean is64Bit() {
        return false;
    }

    @Override
    protected int readLoaderInfoFlags() throws IOException {
        return 0;
    }

    @Override
    protected long userInfoOffset() {
        return 1008L;
    }

    @Override
    protected int pointerSize() {
        return 32;
    }

    @Override
    protected long readAddress() throws IOException {
        return 0xFFFFFFFFL & (long)this.readInt();
    }

    @Override
    protected Map<String, Number> readRegisters(long threadOffset) throws IOException {
        TreeMap<String, Number> registers = new TreeMap<String, Number>();
        this.seek(threadOffset + 200L + 24L);
        registers.put("iar", this.readInt());
        registers.put("msr", this.readInt());
        registers.put("cr", this.readInt());
        registers.put("lr", this.readInt());
        registers.put("ctr", this.readInt());
        registers.put("xer", this.readInt());
        registers.put("mq", this.readInt());
        registers.put("tid", this.readInt());
        registers.put("fpscr", this.readInt());
        this.seek(threadOffset + 200L + 208L);
        for (int i = 0; i < 32; ++i) {
            registers.put("gpr" + i, this.readInt());
        }
        return registers;
    }

    @Override
    protected long threadSize(long threadOffset) {
        return 792L;
    }

    @Override
    protected long getStackPointerFrom(Map<String, Number> registers) {
        return (long)registers.get("gpr1").intValue() & 0xFFFFFFFFL;
    }

    @Override
    protected long getInstructionPointerFrom(Map<String, Number> registers) {
        return (long)registers.get("iar").intValue() & 0xFFFFFFFFL;
    }

    @Override
    protected long getLinkRegisterFrom(Map<String, Number> registers) {
        return (long)registers.get("lr").intValue() & 0xFFFFFFFFL;
    }

    @Override
    protected int sizeofTopOfStack() {
        return 144;
    }
}

