/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.corereaders.memory.IDetailedMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.ProtectedMemoryRange;
import java.io.IOException;
import java.util.Properties;

public class ELFMemorySource
extends ProtectedMemoryRange
implements IMemorySource,
IDetailedMemoryRange {
    private final long fileOffset;
    private final ELFFileReader reader;
    private final String name;
    private Properties props;

    ELFMemorySource(long baseAddress, long size, long fileOffset, ELFFileReader reader, String name, boolean executable) {
        super(baseAddress, size);
        this.fileOffset = fileOffset;
        this.reader = reader;
        this.name = name;
        this.executable = executable;
    }

    ELFMemorySource(long baseAddress, long size, long fileOffset, ELFFileReader reader, String name) {
        this(baseAddress, size, fileOffset, reader, name, true);
    }

    ELFMemorySource(long baseAddress, long size, long fileOffset, ELFFileReader reader) {
        this(baseAddress, size, fileOffset, reader, "");
    }

    @Override
    public int getAddressSpaceId() {
        return 0;
    }

    @Override
    public int getBytes(long address, byte[] buffer, int offset, int length) throws MemoryFault {
        if (Addresses.greaterThan(address + (long)length - 1L, this.getTopAddress())) {
            throw new MemoryFault(address + (long)length, "Address out of range of memory range (overflow): " + this.toString());
        }
        if (Addresses.lessThan(address, this.baseAddress)) {
            throw new MemoryFault(address, "Address out of range of memory range (underflow): " + this.toString());
        }
        long rangeOffset = address - this.baseAddress;
        long seekAddress = this.fileOffset + rangeOffset;
        try {
            this.reader.seek(seekAddress);
            this.reader.readFully(buffer, offset, length);
        }
        catch (IOException e) {
            throw new MemoryFault(address, "IOException accessing ELF storage in " + this.reader, e);
        }
        return length;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Properties getProperties() {
        if (this.props == null) {
            this.props = new Properties();
        }
        return this.props;
    }

    @Override
    public boolean isExecutable() {
        if (this.props == null) {
            return false;
        }
        return Boolean.TRUE.toString().equals(this.props.get("executable"));
    }

    @Override
    public boolean isReadOnly() {
        if (this.props == null) {
            return false;
        }
        return Boolean.TRUE.toString().equals(this.props.get("readable")) && !Boolean.TRUE.toString().equals(this.props.get("writable"));
    }
}

