/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.view.dtfj.DTFJCorruptDataException;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class J9DDRDTFJUtils {
    private static final String DTFJ_LOGGER_NAME = "com.ibm.dtfj.log";
    private static final Logger logger = Logger.getLogger("com.ibm.dtfj.log");

    public static Iterator emptyIterator() {
        return new LinkedList().iterator();
    }

    public static Iterator corruptIterator(CorruptData data) {
        LinkedList<CorruptData> corruptList = new LinkedList<CorruptData>();
        corruptList.add(data);
        return corruptList.iterator();
    }

    public static J9DDRCorruptData newCorruptData(IProcess process, CorruptDataException e) {
        return new J9DDRCorruptData(process, e);
    }

    public static J9DDRCorruptData newCorruptData(IProcess process) {
        return new J9DDRCorruptData(process);
    }

    public static J9DDRCorruptData newCorruptData(IProcess process, String message2) {
        return new J9DDRCorruptData(process, message2);
    }

    public static com.ibm.dtfj.image.CorruptDataException newCorruptDataException(IProcess process, CorruptDataException e) {
        return new DTFJCorruptDataException(new J9DDRCorruptData(process, e), (Throwable)e);
    }

    public static com.ibm.dtfj.image.CorruptDataException handleAllButDataUnavailAsCorruptDataException(IProcess p, Throwable t) throws DataUnavailable {
        if (t instanceof DataUnavailable) {
            throw (DataUnavailable)t;
        }
        return J9DDRDTFJUtils.handleAsCorruptDataException(p, t);
    }

    public static com.ibm.dtfj.image.CorruptDataException handleAllButMemAccExAsCorruptDataException(IProcess p, Throwable t, Class<?>[] whitelist) throws MemoryAccessException {
        if (t instanceof MemoryAccessException) {
            throw (MemoryAccessException)t;
        }
        return J9DDRDTFJUtils.handleAsCorruptDataException(p, t, whitelist);
    }

    public static com.ibm.dtfj.image.CorruptDataException handleAllButMemAccExAndDataUnavailAsCorruptDataException(IProcess p, Throwable t, Class<?>[] whitelist) throws MemoryAccessException, DataUnavailable {
        if (t instanceof MemoryAccessException) {
            throw (MemoryAccessException)t;
        }
        if (t instanceof DataUnavailable) {
            throw (DataUnavailable)t;
        }
        return J9DDRDTFJUtils.handleAsCorruptDataException(p, t, whitelist);
    }

    public static com.ibm.dtfj.image.CorruptDataException handleAsCorruptDataException(IProcess p, Throwable t, Class<?>[] whitelist) {
        Class<?> clazz;
        boolean isInWhitelist = false;
        Class<?>[] classArray = whitelist;
        int n = classArray.length;
        for (int i = 0; !(i >= n || RuntimeException.class.isAssignableFrom(clazz = classArray[i]) && (isInWhitelist = t.getClass().equals(clazz))); ++i) {
        }
        if (isInWhitelist) {
            throw (RuntimeException)t;
        }
        return J9DDRDTFJUtils.handleAsCorruptDataException(p, t);
    }

    public static com.ibm.dtfj.image.CorruptDataException handleAsCorruptDataException(IProcess p, Throwable t) {
        if (t instanceof com.ibm.dtfj.image.CorruptDataException) {
            return (com.ibm.dtfj.image.CorruptDataException)t;
        }
        if (J9DDRDTFJUtils.isErrorNotToBeIntercepted(t)) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
        if (t instanceof CorruptDataException) {
            CorruptDataException cde = (CorruptDataException)t;
            logger.log(Level.FINE, "Corrupt data encountered", t);
            return J9DDRDTFJUtils.newCorruptDataException(p, cde);
        }
        String message2 = J9DDRDTFJUtils.logError(t);
        J9DDRCorruptData cd = J9DDRDTFJUtils.newCorruptData(p, message2);
        return new DTFJCorruptDataException(cd, t);
    }

    public static CorruptData handleAsCorruptData(IProcess p, Throwable t) {
        if (J9DDRDTFJUtils.isErrorNotToBeIntercepted(t)) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
        if (t instanceof CorruptDataException) {
            CorruptDataException cde = (CorruptDataException)t;
            logger.log(Level.FINE, "Corrupt data encountered", t);
            return J9DDRDTFJUtils.newCorruptData(p, cde);
        }
        String message2 = J9DDRDTFJUtils.logError(t);
        J9DDRCorruptData cd = J9DDRDTFJUtils.newCorruptData(p, message2);
        return cd;
    }

    private static boolean isErrorNotToBeIntercepted(Throwable t) {
        return t instanceof Error && !(t instanceof NoSuchFieldError);
    }

    private static String logError(Throwable t) {
        String message2 = null;
        if (t instanceof NoSuchFieldError) {
            message2 = "DDR structures in the core file are out of sync with the code base";
        }
        if (t instanceof RuntimeException) {
            message2 = "Internal runtime exception was encountered";
        }
        if (null == message2) {
            message2 = "An unexpected exception occurred";
        }
        logger.log(Level.FINE, message2, t);
        return message2;
    }

    public static DataUnavailable handleAsDataUnavailable(Throwable t) {
        if (t instanceof DataUnavailable) {
            return (DataUnavailable)t;
        }
        if (J9DDRDTFJUtils.isErrorNotToBeIntercepted(t)) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
        if (t instanceof DataUnavailable) {
            logger.log(Level.FINE, "Data unavailable", t);
            return (DataUnavailable)t;
        }
        String message2 = J9DDRDTFJUtils.logError(t);
        DataUnavailable du = new DataUnavailable(message2);
        du.initCause(t);
        return du;
    }
}

