/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm29.structure.J9Method;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=J9Method.class)
public class J9MethodPointer
extends StructurePointer {
    public static final J9MethodPointer NULL = new J9MethodPointer(0L);

    protected J9MethodPointer(long address) {
        super(address);
    }

    public static J9MethodPointer cast(AbstractPointer structure) {
        return J9MethodPointer.cast(structure.getAddress());
    }

    public static J9MethodPointer cast(UDATA udata) {
        return J9MethodPointer.cast(udata.longValue());
    }

    public static J9MethodPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9MethodPointer(address);
    }

    @Override
    public J9MethodPointer add(long count) {
        return J9MethodPointer.cast(this.address + J9Method.SIZEOF * count);
    }

    @Override
    public J9MethodPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public J9MethodPointer addOffset(long offset) {
        return J9MethodPointer.cast(this.address + offset);
    }

    @Override
    public J9MethodPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public J9MethodPointer sub(long count) {
        return J9MethodPointer.cast(this.address - J9Method.SIZEOF * count);
    }

    @Override
    public J9MethodPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public J9MethodPointer subOffset(long offset) {
        return J9MethodPointer.cast(this.address - offset);
    }

    @Override
    public J9MethodPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public J9MethodPointer untag(long mask) {
        return J9MethodPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public J9MethodPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return J9Method.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_bytecodesOffset_", declaredType="U8*")
    public U8Pointer bytecodes() throws CorruptDataException {
        return U8Pointer.cast(this.getPointerAtOffset(J9Method._bytecodesOffset_));
    }

    public PointerPointer bytecodesEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9Method._bytecodesOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_constantPoolOffset_", declaredType="J9ConstantPool*")
    public J9ConstantPoolPointer constantPool() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9Method._constantPoolOffset_);
        return J9ConstantPoolPointer.cast(pointer);
    }

    public PointerPointer constantPoolEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9Method._constantPoolOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_extraOffset_", declaredType="void*")
    public VoidPointer extra() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9Method._extraOffset_));
    }

    public PointerPointer extraEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9Method._extraOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_methodRunAddressOffset_", declaredType="void*")
    public VoidPointer methodRunAddress() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9Method._methodRunAddressOffset_));
    }

    public PointerPointer methodRunAddressEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9Method._methodRunAddressOffset_);
    }
}

