/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.memory.BaseModule;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class Module
extends BaseModule {
    private final Collection<? extends ISymbol> symbols;
    private final Properties properties;

    public Module(IProcess process, String name, List<? extends ISymbol> symbols, Collection<? extends IMemoryRange> memoryRanges, long loadAddress, Properties properties) {
        super(process, name, memoryRanges, loadAddress);
        this.symbols = Collections.unmodifiableList(symbols);
        this.properties = properties;
    }

    @Override
    public Collection<? extends ISymbol> getSymbols() {
        return this.symbols;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.symbols == null ? 0 : this.symbols.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Module)) {
            return false;
        }
        Module other = (Module)obj;
        return !(this.symbols == null ? other.symbols != null : !this.symbols.equals(other.symbols));
    }

    @Override
    public Properties getProperties() throws DataUnavailableException {
        return this.properties;
    }
}

