/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.macho;

import com.ibm.j9ddr.corereaders.macho.LoadCommand;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.stream.ImageInputStream;

public class ThreadCommand
extends LoadCommand {
    public static final int x86_THREAD_STATE32 = 1;
    public static final int x86_FLOAT_STATE32 = 2;
    public static final int x86_EXCEPTION_STATE32 = 3;
    public static final int x86_THREAD_STATE64 = 4;
    public static final int x86_FLOAT_STATE64 = 5;
    public static final int x86_EXCEPTION_STATE64 = 6;
    public static final int x86_THREAD_STATE = 7;
    public static final int x86_FLOAT_STATE = 8;
    public static final int x86_EXCEPTION_STATE = 9;
    public static final int x86_DEBUG_STATE32 = 10;
    public static final int x86_DEBUG_STATE64 = 11;
    public static final int x86_DEBUG_STATE = 12;
    public static final int THREAD_STATE_NONE = 13;
    public static final int x86_AVX_STATE32 = 16;
    public static final int x86_AVX_STATE64 = 17;
    public static final int x86_AVX_STATE = 18;
    public static final int x86_AVX512_STATE32 = 19;
    public static final int x86_AVX512_STATE64 = 20;
    public static final int x86_AVX512_STATE = 21;
    public List<ThreadState> states = new ArrayList<ThreadState>();

    public ThreadCommand() {
    }

    public ThreadCommand(int type2, long size, long offset) {
        super(type2, size, offset);
    }

    @Override
    public ThreadCommand readCommand(ImageInputStream stream, long streamSegmentOffset) throws IOException {
        int size;
        super.readCommand(stream, streamSegmentOffset);
        for (long structOffset = 8L; structOffset < this.cmdSize; structOffset += (long)(size * 4 + 8)) {
            int flavor = stream.readInt();
            size = stream.readInt();
            byte[] data = new byte[size * 4];
            stream.readFully(data);
            this.states.add(new ThreadState(flavor, size, data, stream.getByteOrder()));
        }
        return this;
    }

    public static class ThreadState {
        int flavor;
        int sizeInUInts;
        byte[] stateBytes;
        ByteOrder endianness;
        Map<String, Number> registers;

        public ThreadState(int flavor, int size, byte[] state, ByteOrder endian) {
            this.flavor = flavor;
            this.sizeInUInts = size;
            this.stateBytes = state;
            this.endianness = endian;
            this.registers = new TreeMap<String, Number>();
            switch (flavor) {
                case 7: {
                    this.fillX86ThreadRegisters();
                    break;
                }
                case 9: {
                    this.fillX86ExceptionData();
                    break;
                }
            }
        }

        public long readLong(int start) {
            long ret = 0xFF00000000000000L & (long)this.stateBytes[start + 7] << 56 | 0xFF000000000000L & (long)this.stateBytes[start + 6] << 48 | 0xFF0000000000L & (long)this.stateBytes[start + 5] << 40 | 0xFF00000000L & (long)this.stateBytes[start + 4] << 32 | 0xFF000000L & (long)this.stateBytes[start + 3] << 24 | 0xFF0000L & (long)this.stateBytes[start + 2] << 16 | 0xFF00L & (long)this.stateBytes[start + 1] << 8 | 0xFFL & (long)this.stateBytes[start + 0];
            return this.endianness == ByteOrder.LITTLE_ENDIAN ? ret : Long.reverseBytes(ret);
        }

        public int readInt(int start) {
            int ret = 0xFF000000 & this.stateBytes[start + 3] << 24 | 0xFF0000 & this.stateBytes[start + 2] << 16 | 0xFF00 & this.stateBytes[start + 1] << 8 | 0xFF & this.stateBytes[start + 0];
            return this.endianness == ByteOrder.LITTLE_ENDIAN ? ret : Integer.reverseBytes(ret);
        }

        public short readShort(int start) {
            short ret = (short)(0xFF00 & this.stateBytes[start + 1] << 8 | 0xFF & (short)this.stateBytes[start + 0]);
            return this.endianness == ByteOrder.LITTLE_ENDIAN ? ret : Short.reverseBytes(ret);
        }

        public void fillX86ThreadRegisters() {
            this.registers.put("rax", this.readLong(0));
            this.registers.put("rbx", this.readLong(8));
            this.registers.put("rcx", this.readLong(16));
            this.registers.put("rdx", this.readLong(24));
            this.registers.put("rdi", this.readLong(32));
            this.registers.put("rsi", this.readLong(40));
            this.registers.put("rbp", this.readLong(48));
            this.registers.put("rsp", this.readLong(56));
            this.registers.put("r8", this.readLong(64));
            this.registers.put("r9", this.readLong(72));
            this.registers.put("r10", this.readLong(80));
            this.registers.put("r11", this.readLong(88));
            this.registers.put("r12", this.readLong(96));
            this.registers.put("r13", this.readLong(104));
            this.registers.put("r14", this.readLong(112));
            this.registers.put("r15", this.readLong(120));
            this.registers.put("rip", this.readLong(128));
            this.registers.put("rflags", this.readLong(136));
            this.registers.put("cs", this.readLong(144));
            this.registers.put("fs", this.readLong(152));
            this.registers.put("gs", this.readLong(160));
        }

        public void fillX86ExceptionData() {
            this.registers.put("trapno", this.readShort(0));
            this.registers.put("cpu", this.readShort(2));
            this.registers.put("err", this.readInt(4));
            this.registers.put("faultvaddr", this.readLong(8));
        }
    }
}

