/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.J9ConstantHelper;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9IdentityHashDataPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9JavaVMHelper;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9IdentityHashData;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;

public class ObjectHash {
    private static final long J9_EXTENDED_RUNTIME_POSITIVE_HASHCODE = J9ConstantHelper.getLong(J9Consts.class, "J9_EXTENDED_RUNTIME_POSITIVE_HASHCODE", 0L);

    private static U32 getSalt(J9JavaVMPointer vm, UDATA objectPointer) throws CorruptDataException {
        UDATA salt = new U32(1421595292L).bitXor(new U32(UDATA.cast(vm)));
        J9IdentityHashDataPointer hashData = vm.identityHashData();
        UDATA saltPolicy = hashData.hashSaltPolicy();
        if (saltPolicy.eq(J9IdentityHashData.J9_IDENTITY_HASH_SALT_POLICY_STANDARD)) {
            if (objectPointer.gte(hashData.hashData1()) && objectPointer.lt(hashData.hashData2())) {
                salt = hashData.hashSaltTableEA().at(0L);
            }
        } else if (saltPolicy.eq(J9IdentityHashData.J9_IDENTITY_HASH_SALT_POLICY_REGION)) {
            if (objectPointer.gte(hashData.hashData1()) && objectPointer.lt(hashData.hashData2())) {
                UDATA heapDelta = objectPointer.sub(hashData.hashData1());
                UDATA index = heapDelta.rightShift(hashData.hashData3());
                salt = hashData.hashSaltTableEA().at(index);
            }
        } else if (!saltPolicy.eq(J9IdentityHashData.J9_IDENTITY_HASH_SALT_POLICY_NONE)) {
            throw new CorruptDataException("Invalid salt policy");
        }
        return new U32(salt);
    }

    static U32 rotateLeft(U32 value, int count) {
        return value.leftShift(count).bitXor(value.rightShift(32 - count));
    }

    static U32 mix(U32 hashValue, U32 datum) {
        U32 MUL1 = new U32(-862048943L);
        U32 MUL2 = new U32(461845907L);
        U32 ADD1 = new U32(-430675100L);
        datum = datum.mult(MUL1);
        datum = ObjectHash.rotateLeft(datum, 15);
        datum = datum.mult(MUL2);
        hashValue = hashValue.bitXor(datum);
        hashValue = ObjectHash.rotateLeft(hashValue, 13);
        hashValue = hashValue.mult(5);
        hashValue = hashValue.add(ADD1);
        return hashValue;
    }

    private static I32 inlineConvertValueToHash(J9JavaVMPointer vm, UDATA objectPointer) throws CorruptDataException {
        U32 MUL1 = new U32(-2048144789L);
        U32 MUL2 = new U32(-1028477387L);
        U32 hashValue = ObjectHash.getSalt(vm, objectPointer);
        UDATA shiftedAddress = objectPointer.div(ObjectModel.getObjectAlignmentInBytes());
        U32 datum = new U32(shiftedAddress.bitAnd(-1));
        hashValue = ObjectHash.mix(hashValue, datum);
        if (J9BuildFlags.env_data64) {
            datum = new U32(shiftedAddress.rightShift(32));
            hashValue = ObjectHash.mix(hashValue, datum);
        }
        hashValue = hashValue.bitXor(UDATA.SIZEOF);
        hashValue = hashValue.bitXor(hashValue.rightShift(16));
        hashValue = hashValue.mult(MUL1);
        hashValue = hashValue.bitXor(hashValue.rightShift(13));
        hashValue = hashValue.mult(MUL2);
        hashValue = hashValue.bitXor(hashValue.rightShift(16));
        if (J9JavaVMHelper.extendedRuntimeFlagIsSet(vm, J9_EXTENDED_RUNTIME_POSITIVE_HASHCODE)) {
            hashValue = hashValue.bitAnd(Integer.MAX_VALUE);
        }
        return new I32(hashValue);
    }

    public static I32 convertObjectAddressToHash(J9JavaVMPointer vm, J9ObjectPointer object) throws CorruptDataException {
        return ObjectHash.inlineConvertValueToHash(vm, UDATA.cast(object));
    }

    public static I32 convertValueToHash(J9JavaVMPointer vm, UDATA value) throws CorruptDataException {
        return ObjectHash.inlineConvertValueToHash(vm, value);
    }
}

