/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.structure.UTF8htEntry;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=UTF8htEntry.class)
public class UTF8htEntryPointer
extends StructurePointer {
    public static final UTF8htEntryPointer NULL = new UTF8htEntryPointer(0L);

    protected UTF8htEntryPointer(long address) {
        super(address);
    }

    public static UTF8htEntryPointer cast(AbstractPointer structure) {
        return UTF8htEntryPointer.cast(structure.getAddress());
    }

    public static UTF8htEntryPointer cast(UDATA udata) {
        return UTF8htEntryPointer.cast(udata.longValue());
    }

    public static UTF8htEntryPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new UTF8htEntryPointer(address);
    }

    @Override
    public UTF8htEntryPointer add(long count) {
        return UTF8htEntryPointer.cast(this.address + UTF8htEntry.SIZEOF * count);
    }

    @Override
    public UTF8htEntryPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public UTF8htEntryPointer addOffset(long offset) {
        return UTF8htEntryPointer.cast(this.address + offset);
    }

    @Override
    public UTF8htEntryPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public UTF8htEntryPointer sub(long count) {
        return UTF8htEntryPointer.cast(this.address - UTF8htEntry.SIZEOF * count);
    }

    @Override
    public UTF8htEntryPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public UTF8htEntryPointer subOffset(long offset) {
        return UTF8htEntryPointer.cast(this.address - offset);
    }

    @Override
    public UTF8htEntryPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public UTF8htEntryPointer untag(long mask) {
        return UTF8htEntryPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public UTF8htEntryPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return UTF8htEntry.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_cachedUTFStringOffset_", declaredType="const J9UTF8*")
    public J9UTF8Pointer cachedUTFString() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(UTF8htEntry._cachedUTFStringOffset_);
        return J9UTF8Pointer.cast(pointer);
    }

    public PointerPointer cachedUTFStringEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)UTF8htEntry._cachedUTFStringOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_keyOffset_", declaredType="const U8*")
    public U8Pointer key() throws CorruptDataException {
        return U8Pointer.cast(this.getPointerAtOffset(UTF8htEntry._keyOffset_));
    }

    public PointerPointer keyEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)UTF8htEntry._keyOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_keyLenOffset_", declaredType="U16")
    public U16 keyLen() throws CorruptDataException {
        return new U16(this.getShortAtOffset(UTF8htEntry._keyLenOffset_));
    }

    public U16Pointer keyLenEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U16Pointer.cast(this.address + (long)UTF8htEntry._keyLenOffset_);
    }
}

