/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.walkers.J9MemTagIterator;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemTagPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9MemTagHelper;
import com.ibm.j9ddr.vm29.structure.J9MemTag;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.commands.WildCard;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class J9MemTagCommands
extends Command
implements IEventListener {
    public static final long SEARCH_SLAB_SIZE = 1024L;
    private static final int SORT_TYPE_DEFAULT = 1;
    private static final int SORT_TYPE_NAME = 2;
    private static final int SORT_TYPE_ALLOCSIZE = 3;
    private static final String SORT_TYPE_STRING_NAME = "name";
    private static final String SORT_TYPE_STRING_ALLOCSIZE = "allocsize";
    private static final String SORT_TYPE_PREFIX = "sort:";
    private static final String[][] commands = new String[][]{{"!findcallsite <callsite>[,start[,end]] [sort:<name|allocsize>]", "list all allocations for the specified callsite."}, {"!printallcallsites [sort:<name|allocsize>]", "list all blocks and bytes allocated by each callsite (same as !findcallsite *)."}, {"!printfreedcallsites [sort:<name|allocsize>]", "list all freed blocks and bytes allocated by each callsite. (same as !findfreedcallsite *)"}, {"!findheader", "locate the memory allocation header for the specified address."}, {"!findallcallsites [sort:<name|allocsize>]", "list a summary of blocks and bytes allocated by each callsite."}, {"!findfreedcallsites [sort:<name|allocsize>]", "list a summary of all freed blocks and bytes allocated by each callsite."}, {"!findfreedcallsite <callsite>[,start[,end]] [sort:<name|allocsize>]", "list all freed blocks for the specified callsite."}};
    private PrintStream out;

    public J9MemTagCommands() {
        this.addCommand("findcallsite", "<callsite>[,start[,end]] [sort:<name|allocsize>]", "list all allocations for the specified callsite.");
        this.addCommand("printallcallsites", "[sort:<name|allocsize>]", "list all blocks and bytes allocated by each callsite (same as !findcallsite *).");
        this.addCommand("printfreedcallsites", "[sort:<name|allocsize>]", "list all freed blocks and bytes allocated by each callsite. (same as !findfreedcallsite *)");
        this.addCommand("findheader", "", "locate the memory allocation header for the specified address.");
        this.addCommand("findallcallsites", "[sort:<name|allocsize>]", "list a summary of blocks and bytes allocated by each callsite.");
        this.addCommand("findfreedcallsites", "[sort:<name|allocsize>]", "list a summary of all freed blocks and bytes allocated by each callsite.");
        this.addCommand("findfreedcallsite", "<callsite>[,start[,end]] [sort:<name|allocsize>]", "list all freed blocks for the specified callsite.");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        command = command.toLowerCase();
        this.out = out;
        EventManager.register(this);
        try {
            if (command.endsWith("findallcallsites")) {
                this.runFindAllCallsites(command, args, context);
                return;
            }
            if (command.endsWith("findfreedcallsites")) {
                this.runFindAllFreedCallsites(command, args, context);
                return;
            }
            if (command.endsWith("findfreedcallsite")) {
                this.runFindFreedCallsite(command, args, context);
                return;
            }
            if (command.endsWith("printallcallsites")) {
                this.runPrintAllCallsites(command, args, context);
                return;
            }
            if (command.endsWith("printfreedcallsites")) {
                this.runPrintAllFreedCallsites(command, args, context);
                return;
            }
            if (command.endsWith("findheader")) {
                this.runFindHeader(command, args, context);
                return;
            }
            if (command.endsWith("findcallsite")) {
                this.runFindCallsite(command, args, context);
                return;
            }
            throw new DDRInteractiveCommandException("Unrecognized command: " + command);
        }
        finally {
            EventManager.unregister(this);
        }
    }

    private void printUsageForFindFreedCallsite() {
        this.out.println("Usage:");
        this.out.println("  !findfreedcallsite <callsite> [sort:<name|allocsize>]");
        this.out.println("  !findfreedcallsite <callsite>,<start> [sort:<name:allocsize>]");
        this.out.println("  !findfreedcallsite <callsite>,<start>,<end> [sort:<name|allocsize>]");
    }

    private void runFindFreedCallsite(String command, String[] args, Context context) throws DDRInteractiveCommandException {
        long startAddress = 0L;
        long endAddress = UDATA.MASK;
        int sortType = 1;
        if (0 == args.length) {
            this.printUsageForFindFreedCallsite();
            return;
        }
        String[] realArgs = args[0].split(",");
        String callsiteEnd = realArgs[0];
        if (realArgs.length == 2) {
            startAddress = Long.decode(realArgs[1]);
        } else if (realArgs.length == 3) {
            startAddress = Long.decode(realArgs[1]);
            endAddress = Long.decode(realArgs[2]);
        } else if (realArgs.length > 3 || args.length > 2) {
            this.out.print("Too many args:");
            for (String arg : args) {
                this.out.print(" ");
                this.out.print(arg);
            }
            this.out.println();
            this.printUsageForFindFreedCallsite();
            return;
        }
        if (args.length == 2 && (sortType = J9MemTagCommands.parseSortType(args[1])) == -1) {
            this.printUsageForFindFreedCallsite();
            return;
        }
        if (Addresses.greaterThan(startAddress, endAddress)) {
            this.out.println("Error: start address cannot be greater than end address");
            return;
        }
        StringBuffer needleBuffer = new StringBuffer();
        long matchFlags = WildCard.parseWildcard(callsiteEnd, needleBuffer);
        if (matchFlags < 0L) {
            this.out.println("Error: Invalid wildcard(s) in callsite");
            return;
        }
        String needle = needleBuffer.toString();
        J9MemTagIterator it = J9MemTagIterator.iterateFreedHeaders(startAddress, endAddress);
        if (J9BuildFlags.env_data64) {
            this.out.println("+------------------------------------------+------------------+-------------------+");
            this.out.println("|          address      |      size        |    org size      | callsite          |");
            this.out.println("+------------------------------------------+------------------+-------------------+");
        } else {
            this.out.println("+--------------------------+----------+-------------------+");
            this.out.println("|      address  |   size   | org size | callsite          |");
            this.out.println("+--------------------------+----------+-------------------+");
        }
        ArrayList<MemTagEntry> freedMemTagEntries = new ArrayList<MemTagEntry>();
        int freedCallSiteCount = 0;
        int corruptedFreedCallSiteCount = 0;
        while (it.hasNext()) {
            J9MemTagPointer header = it.next();
            if (!J9MemTagCommands.regexMatches(header, matchFlags, needle)) continue;
            ++freedCallSiteCount;
            try {
                long allocSize = header.allocSize().longValue();
                if (it.isFooterCorrupted()) {
                    ++corruptedFreedCallSiteCount;
                    J9MemTagIterator allocIte = J9MemTagIterator.iterateAllocatedHeaders(header.longValue() + J9MemTag.SIZEOF, header.add(allocSize).longValue() + J9MemTag.SIZEOF);
                    if (allocIte.hasNext()) {
                        J9MemTagPointer nextAllocHeader = allocIte.next();
                        allocSize = nextAllocHeader.longValue() - header.longValue();
                    }
                }
                MemTagEntry entry = new MemTagEntry(header, allocSize);
                if (1 == sortType) {
                    this.printMemTagForFindFreedCallSite(entry);
                    continue;
                }
                freedMemTagEntries.add(entry);
            }
            catch (CorruptDataException e) {
                e.printStackTrace(this.out);
            }
        }
        if (!freedMemTagEntries.isEmpty()) {
            Comparator<MemTagEntry> comparator = 2 == sortType ? new NameComparator() : new AllocSizeComparator();
            Iterator iterator = freedMemTagEntries.stream().sorted(comparator).iterator();
            while (iterator.hasNext()) {
                this.printMemTagForFindFreedCallSite((MemTagEntry)iterator.next());
            }
        }
        this.out.println("Freed call site count = " + freedCallSiteCount);
        this.out.println("Corrupted freed call site count = " + corruptedFreedCallSiteCount);
    }

    private void printMemTagForFindFreedCallSite(MemTagEntry freedMemTagEntry) {
        J9MemTagPointer freedHeader = freedMemTagEntry.getHeader();
        long allocSize = freedMemTagEntry.getAllocSize();
        try {
            Object callsite;
            try {
                callsite = J9MemTagCommands.getCString(freedHeader.callSite());
            }
            catch (CorruptDataException ex) {
                callsite = "<FAULT> reading callsite string: " + ex.getMessage();
            }
            long baseAddress = J9MemTagHelper.j9mem_get_memory_base(freedHeader).getAddress();
            if (J9BuildFlags.env_data64) {
                this.out.format(" !j9x 0x%016X 0x%016X ", baseAddress, allocSize);
                if (allocSize == freedHeader.allocSize().longValue()) {
                    this.out.format("%18s ", "");
                } else {
                    this.out.format("0x%16X ", freedHeader.allocSize().longValue());
                }
                this.out.format("%s", callsite);
            } else {
                this.out.format(" !j9x 0x%08X 0x%08X ", baseAddress, allocSize);
                if (allocSize != freedHeader.allocSize().longValue()) {
                    this.out.format("%12s ", "");
                } else {
                    this.out.format("0x%10X ", freedHeader.allocSize().longValue());
                }
                this.out.format("%s", callsite);
            }
            this.out.println();
        }
        catch (CorruptDataException e) {
            e.printStackTrace(this.out);
        }
    }

    private void printUsageForFindCallsite() {
        this.out.println("Usage:");
        this.out.println("  !findcallsite <callsite> [sort:<name|allocsize>]");
        this.out.println("  !findcallsite <callsite>,<start> [sort:<name|allocsize>]");
        this.out.println("  !findcallsite <callsite>,<start>,<end> [sort:<name|allocsize>]");
    }

    private void runFindCallsite(String command, String[] args, Context context) throws DDRInteractiveCommandException {
        long startAddress = 0L;
        long endAddress = UDATA.MASK;
        int sortType = 1;
        if (args.length == 0) {
            this.printUsageForFindCallsite();
            return;
        }
        String[] realArgs = args[0].split(",");
        String callsiteEnd = realArgs[0];
        if (args.length == 2 && (sortType = J9MemTagCommands.parseSortType(args[1])) == -1) {
            this.printUsageForFindCallsite();
            return;
        }
        if (realArgs.length == 2) {
            startAddress = Long.decode(realArgs[1]);
        } else if (realArgs.length == 3) {
            startAddress = Long.decode(realArgs[1]);
            endAddress = Long.decode(realArgs[2]);
        } else if (realArgs.length > 3 || args.length > 2) {
            this.out.print("Too many args:");
            for (String arg : args) {
                this.out.print(" ");
                this.out.print(arg);
            }
            this.out.println();
            this.printUsageForFindCallsite();
            return;
        }
        if (Addresses.greaterThan(startAddress, endAddress)) {
            this.out.println("Error: start address cannot be greater than end address");
            return;
        }
        StringBuffer needleBuffer = new StringBuffer();
        long matchFlags = WildCard.parseWildcard(callsiteEnd, needleBuffer);
        if (matchFlags < 0L) {
            this.out.println("Error: Invalid wildcard(s) in callsite");
            return;
        }
        String needle = needleBuffer.toString();
        J9MemTagIterator it = J9MemTagIterator.iterateAllocatedHeaders(startAddress, endAddress);
        ArrayList<MemTagEntry> memTagEntries = new ArrayList<MemTagEntry>();
        int callSiteCount = 0;
        while (it.hasNext()) {
            J9MemTagPointer header = it.next();
            if (!J9MemTagCommands.regexMatches(header, matchFlags, needle)) continue;
            ++callSiteCount;
            try {
                long allocSize = header.allocSize().longValue();
                if (1 == sortType) {
                    this.printMemTagForFindCallSite(new MemTagEntry(header, allocSize));
                    continue;
                }
                memTagEntries.add(new MemTagEntry(header, allocSize));
            }
            catch (CorruptDataException e) {
                e.printStackTrace(this.out);
            }
        }
        if (!memTagEntries.isEmpty()) {
            Comparator<MemTagEntry> comparator = 2 == sortType ? new NameComparator() : new AllocSizeComparator();
            Iterator iterator = memTagEntries.stream().sorted(comparator).iterator();
            while (iterator.hasNext()) {
                this.printMemTagForFindCallSite((MemTagEntry)iterator.next());
            }
        }
        this.out.println("Call site count = " + callSiteCount);
    }

    private void printMemTagForFindCallSite(MemTagEntry memTagEntry) {
        J9MemTagPointer header = memTagEntry.getHeader();
        try {
            Object callsite;
            try {
                callsite = J9MemTagCommands.getCString(header.callSite());
            }
            catch (CorruptDataException ex) {
                callsite = "<FAULT> reading callsite string: " + ex.getMessage();
            }
            this.out.format(" !j9x %s,%s %s%n", J9MemTagHelper.j9mem_get_memory_base(header).getHexAddress(), header.allocSize().getHexValue(), callsite);
        }
        catch (CorruptDataException e) {
            e.printStackTrace(this.out);
        }
    }

    private void runFindHeader(String command, String[] args, Context context) throws DDRInteractiveCommandException {
        long address = 0L;
        J9MemTagPointer header = null;
        if (args.length != 1) {
            this.out.println("Usage:");
            this.out.println("  !findheader <address> (e.g. !findheader 0xa2b4c6d8)");
            return;
        }
        address = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
        this.out.format("Searching memory allocation header for %s%n", U8Pointer.cast(address).getHexAddress());
        long searchBase = address - 1024L;
        block8: do {
            J9MemTagPointer potential;
            J9MemTagIterator it = J9MemTagIterator.iterateAllocatedHeaders(searchBase, searchBase + 1024L + 3L);
            while (it.hasNext() && !Addresses.greaterThan((potential = it.next()).getAddress(), address)) {
                VoidPointer end;
                VoidPointer start = J9MemTagHelper.j9mem_get_memory_base(potential);
                try {
                    end = start.addOffset(potential.allocSize().longValue());
                }
                catch (CorruptDataException e) {
                    continue;
                }
                if (!Addresses.greaterThanOrEqual(address, start.getAddress()) || !Addresses.lessThan(address, end.getAddress())) continue;
                header = potential;
                break block8;
            }
            if (Addresses.lessThan(searchBase, 1024L)) {
                searchBase = 0L;
                continue;
            }
            searchBase -= 1024L;
        } while (searchBase != 0L);
        if (header == null) {
            this.out.println("No memory allocation header found");
        } else {
            Object categoryName;
            Object callsite;
            try {
                callsite = J9MemTagCommands.getCString(header.callSite());
            }
            catch (CorruptDataException ex) {
                callsite = "<FAULT> reading callsite string: " + ex.getMessage();
            }
            try {
                categoryName = J9MemTagCommands.getCString(header.category().name());
            }
            catch (CorruptDataException ex) {
                categoryName = "<FAULT> reading category name string: " + ex.getMessage();
            }
            try {
                this.out.format("Found memory allocation header, !j9x 0x%x,0x%x%n", J9MemTagHelper.j9mem_get_memory_base(header).getAddress(), header.allocSize().longValue());
                this.out.format("J9MemTag at 0x%x {%n", header.getAddress());
                this.out.format("    U_32 eyeCatcher = 0x%x;%n", header.eyeCatcher().longValue());
                this.out.format("    U_32 sumCheck = 0x%x;%n", header.sumCheck().longValue());
                this.out.format("    UDATA allocSize = 0x%x;%n", header.allocSize().longValue());
                this.out.format("    char* callSite = %s;%n", callsite);
                this.out.format("    struct OMRMemCategory* category = !omrmemcategory 0x%x (%s);%n", header.category().longValue(), categoryName);
                this.out.println("}");
            }
            catch (CorruptDataException ex) {
                this.out.println("CDE formatting J9MemTag at " + header.getHexAddress());
            }
        }
    }

    private static int parseSortType(String sortArg) throws DDRInteractiveCommandException {
        if (sortArg.equalsIgnoreCase("sort:name")) {
            return 2;
        }
        if (sortArg.equalsIgnoreCase("sort:allocsize")) {
            return 3;
        }
        throw new DDRInteractiveCommandException("Error: Unknown argument: " + sortArg);
    }

    private void runPrintAllCallsites(String command, String[] args, Context context) throws DDRInteractiveCommandException {
        this.out.println("Searching for all memory block callsites...");
        String[] newArgs = new String[args.length + 1];
        newArgs[0] = "*";
        if (args.length == 1) {
            newArgs[1] = args[0];
        }
        this.runFindCallsite("!findcallsite", newArgs, context);
    }

    private void runPrintAllFreedCallsites(String command, String[] args, Context context) throws DDRInteractiveCommandException {
        this.out.println("Searching for all freed memory block callsites...");
        String[] newArgs = new String[args.length + 1];
        newArgs[0] = "*";
        if (args.length == 1) {
            newArgs[1] = args[0];
        }
        this.runFindFreedCallsite("!findfreedcallsite", newArgs, context);
    }

    private void runFindAllCallsites(String command, String[] args, Context context) throws DDRInteractiveCommandException {
        int sortType = args.length == 1 ? J9MemTagCommands.parseSortType(args[0]) : 3;
        J9MemTagIterator it = J9MemTagIterator.iterateAllocatedHeaders();
        this.printCallsitesTable(this.buildCallsitesTable(it, false), sortType);
    }

    private void runFindAllFreedCallsites(String command, String[] args, Context context) throws DDRInteractiveCommandException {
        this.out.println("Searching for all freed memory block callsites...");
        int sortType = args.length == 1 ? J9MemTagCommands.parseSortType(args[0]) : 3;
        J9MemTagIterator it = J9MemTagIterator.iterateFreedHeaders();
        this.printCallsitesTable(this.buildCallsitesTable(it, true), sortType);
    }

    private Map<U8Pointer, J9DbgExtMemStats> buildCallsitesTable(J9MemTagIterator it, boolean lookingForFreedCallSites) {
        LinkedHashMap<U8Pointer, J9DbgExtMemStats> callSites = new LinkedHashMap<U8Pointer, J9DbgExtMemStats>();
        while (it.hasNext()) {
            J9MemTagPointer header = it.next();
            try {
                J9MemTagIterator allocIte;
                long allocSize = header.allocSize().longValue();
                if (lookingForFreedCallSites && it.isFooterCorrupted() && (allocIte = J9MemTagIterator.iterateAllocatedHeaders(header.longValue() + J9MemTag.SIZEOF, header.add(allocSize).longValue() + J9MemTag.SIZEOF)).hasNext()) {
                    J9MemTagPointer nextAllocHeader = allocIte.next();
                    allocSize = nextAllocHeader.longValue() - header.longValue();
                }
                U8Pointer callsite = header.callSite();
                it.moveCurrentSearchAddress(allocSize);
                J9DbgExtMemStats memStats = (J9DbgExtMemStats)callSites.get(callsite);
                if (memStats == null) {
                    callSites.put(callsite, new J9DbgExtMemStats(header.allocSize().longValue()));
                    continue;
                }
                memStats.incrementTotalBlocksAllocated();
                memStats.addTotalBytesAllocated(header.allocSize().longValue());
            }
            catch (CorruptDataException e) {
                this.out.println("Unexpected CDE reading contents of " + Long.toHexString(header.getAddress()));
                e.printStackTrace(this.out);
            }
        }
        return callSites;
    }

    @Override
    public void corruptData(String message2, CorruptDataException e, boolean fatal) {
        if (e instanceof J9MemTagHelper.J9MemTagCheckError) {
            J9MemTagHelper.J9MemTagCheckError casted = (J9MemTagHelper.J9MemTagCheckError)e;
            this.out.println("J9MemTag check failed at " + Long.toHexString(casted.getAddress()) + ": " + message2 + " :" + e.getMessage());
        } else {
            e.printStackTrace(this.out);
        }
    }

    private void printCallsitesTable(Map<U8Pointer, J9DbgExtMemStats> callSites, int sortType) throws DDRInteractiveCommandException {
        Iterator<Map.Entry<U8Pointer, J9DbgExtMemStats>> siteIterator;
        this.out.println("  total alloc  | largest");
        this.out.println("blocks | bytes | bytes | callsite");
        this.out.println("-------+-------+-------+-------+-------+-------+-------+-------+-------+-------");
        final HashMap<U8Pointer, String> siteNames = new HashMap<U8Pointer, String>();
        for (U8Pointer address : callSites.keySet()) {
            String siteName = J9MemTagCommands.getCString(address);
            siteNames.put(address, siteName);
        }
        if (1 == sortType) {
            siteIterator = callSites.entrySet().iterator();
        } else {
            Comparator<Map.Entry<U8Pointer, J9DbgExtMemStats>> comparator;
            if (2 == sortType) {
                comparator = new Comparator<Map.Entry<U8Pointer, J9DbgExtMemStats>>(){

                    @Override
                    public int compare(Map.Entry<U8Pointer, J9DbgExtMemStats> o1, Map.Entry<U8Pointer, J9DbgExtMemStats> o2) {
                        String site1 = (String)siteNames.get(o1.getKey());
                        String site2 = (String)siteNames.get(o2.getKey());
                        return site1.compareTo(site2);
                    }
                };
            } else if (3 == sortType) {
                comparator = new Comparator<Map.Entry<U8Pointer, J9DbgExtMemStats>>(){

                    @Override
                    public int compare(Map.Entry<U8Pointer, J9DbgExtMemStats> o1, Map.Entry<U8Pointer, J9DbgExtMemStats> o2) {
                        long o1Bytes = o1.getValue().getTotalBytesAllocated();
                        long o2Bytes = o2.getValue().getTotalBytesAllocated();
                        return Long.compare(o2Bytes, o1Bytes);
                    }
                };
            } else {
                throw new DDRInteractiveCommandException("Unknown sort type: " + sortType);
            }
            siteIterator = callSites.entrySet().stream().sorted(comparator).iterator();
        }
        while (siteIterator.hasNext()) {
            Map.Entry<U8Pointer, J9DbgExtMemStats> entry = siteIterator.next();
            String callSite = (String)siteNames.get(entry.getKey());
            J9DbgExtMemStats memStats = entry.getValue();
            this.out.format("%7d %7d %7d %s%n", memStats.getTotalBlocksAllocated(), memStats.getTotalBytesAllocated(), memStats.getLargestBlockAllocated(), callSite);
        }
        this.out.println("-------+-------+-------+-------+-------+-------+-------+-------+-------+-------");
    }

    static String getCString(U8Pointer name) {
        try {
            return name.getCStringAtOffset(0L);
        }
        catch (CorruptDataException corruptDataException) {
            String moduleName;
            block6: {
                moduleName = "<unknown-module>";
                try {
                    long address = name.getAddress();
                    IProcess process = DataType.getProcess();
                    Collection<? extends IModule> modules = process.getModules();
                    for (IModule iModule : modules) {
                        for (IMemoryRange iMemoryRange : iModule.getMemoryRanges()) {
                            if (!iMemoryRange.contains(address)) continue;
                            moduleName = iModule.getName();
                            break block6;
                        }
                    }
                }
                catch (CorruptDataException corruptDataException2) {
                    // empty catch block
                }
            }
            return moduleName + ":" + name.getHexAddress();
        }
    }

    private static boolean regexMatches(J9MemTagPointer obj, long matchFlags, String needle) {
        U8Pointer address;
        try {
            address = obj.callSite();
        }
        catch (CorruptDataException e) {
            return false;
        }
        String callsite = J9MemTagCommands.getCString(address);
        return WildCard.wildcardMatch(matchFlags, needle, callsite);
    }

    private static final class MemTagEntry {
        private final J9MemTagPointer header;
        private final long allocSize;

        public MemTagEntry(J9MemTagPointer header, long allocSize) {
            this.header = header;
            this.allocSize = allocSize;
        }

        public J9MemTagPointer getHeader() {
            return this.header;
        }

        public long getAllocSize() {
            return this.allocSize;
        }
    }

    private static final class NameComparator
    implements Comparator<MemTagEntry> {
        private final Map<U8Pointer, String> cache = new HashMap<U8Pointer, String>();

        NameComparator() {
        }

        private String getCallSiteName(MemTagEntry entry) {
            String siteName;
            try {
                U8Pointer address = entry.getHeader().callSite();
                siteName = this.cache.get(address);
                if (siteName == null) {
                    siteName = J9MemTagCommands.getCString(address);
                    this.cache.put(address, siteName);
                }
            }
            catch (CorruptDataException e) {
                siteName = "<FAULT>";
            }
            return siteName;
        }

        @Override
        public int compare(MemTagEntry e1, MemTagEntry e2) {
            String callsite1 = this.getCallSiteName(e1);
            String callsite2 = this.getCallSiteName(e2);
            return callsite1.compareTo(callsite2);
        }
    }

    private static final class AllocSizeComparator
    implements Comparator<MemTagEntry> {
        private AllocSizeComparator() {
        }

        @Override
        public int compare(MemTagEntry e1, MemTagEntry e2) {
            return Long.compare(e2.getAllocSize(), e1.getAllocSize());
        }
    }

    private static final class J9DbgExtMemStats {
        private long totalBlocksAllocated;
        private long totalBytesAllocated;
        private long largestBlockAllocated;

        public J9DbgExtMemStats(long totalBytesAllocated) {
            this.totalBytesAllocated = totalBytesAllocated;
            this.totalBlocksAllocated = 1L;
            this.largestBlockAllocated = totalBytesAllocated;
        }

        public void incrementTotalBlocksAllocated() {
            ++this.totalBlocksAllocated;
        }

        public void addTotalBytesAllocated(long byteAmount) {
            this.totalBytesAllocated += byteAmount;
            if (byteAmount > this.largestBlockAllocated) {
                this.largestBlockAllocated = byteAmount;
            }
        }

        public long getTotalBlocksAllocated() {
            return this.totalBlocksAllocated;
        }

        public long getTotalBytesAllocated() {
            return this.totalBytesAllocated;
        }

        public long getLargestBlockAllocated() {
            return this.largestBlockAllocated;
        }
    }
}

