/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_vi extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Gi\u1edd Trung b\u00ecnh Greenwich",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Acre = new String[] {
               "Gi\u1edd Chu\u1ea9n Acre",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Acre",
               "",
               "Gi\u1edd Acre",
               "",
            };
        final String[] Apia = new String[] {
               "Gi\u1edd Chu\u1ea9n Apia",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Apia",
               "",
               "Gi\u1edd Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Gi\u1edd Chu\u1ea9n Qu\u1ea7n \u0110\u1ea3o Cook",
               "",
               "Gi\u1edd N\u1eeda M\u00f9a H\u00e8 Qu\u1ea7n \u0110\u1ea3o Cook",
               "",
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Gi\u1edd Chu\u1ea9n Cuba",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Cuba",
               "",
               "Gi\u1edd Cuba",
               "",
            };
        final String[] Fiji = new String[] {
               "Gi\u1edd Chu\u1ea9n Fiji",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Fiji",
               "",
               "Gi\u1edd Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Gi\u1edd Chu\u1ea9n V\u00f9ng V\u1ecbnh",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Gi\u1edd Chu\u1ea9n Hovd",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Hovd",
               "",
               "Gi\u1edd Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Gi\u1edd Chu\u1ea9n Iran",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Iran",
               "",
               "Gi\u1edd Iran",
               "",
            };
        final String[] Niue = new String[] {
               "Gi\u1edd Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Gi\u1edd chu\u1ea9n Omsk",
               "",
               "Gi\u1edd m\u00f9a h\u00e8 Omsk",
               "",
               "Gi\u1edd Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Gi\u1edd Chu\u1ea9n Peru",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Peru",
               "",
               "Gi\u1edd Peru",
               "",
            };
        final String[] Truk = new String[] {
               "Gi\u1edd Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Gi\u1edd \u0110\u1ea3o Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Gi\u1edd Chu\u1ea9n Chile",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Chile",
               "",
               "Gi\u1edd Chile",
               "",
            };
        final String[] China = new String[] {
               "Gi\u1edd Chu\u1ea9n Trung Qu\u1ed1c",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Trung Qu\u1ed1c",
               "",
               "Gi\u1edd Trung Qu\u1ed1c",
               "",
            };
        final String[] Cocos = new String[] {
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Gi\u1edd Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Gi\u1edd Chu\u1ea9n \u1ea4n \u0110\u1ed9",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Gi\u1edd Chu\u1ea9n Nh\u1eadt B\u1ea3n",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Nh\u1eadt B\u1ea3n",
               "",
               "Gi\u1edd Nh\u1eadt B\u1ea3n",
               "",
            };
        final String[] Korea = new String[] {
               "Gi\u1edd Chu\u1ea9n H\u00e0n Qu\u1ed1c",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 H\u00e0n Qu\u1ed1c",
               "",
               "Gi\u1edd H\u00e0n Qu\u1ed1c",
               "",
            };
        final String[] Nauru = new String[] {
               "Gi\u1edd Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Gi\u1edd Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Gi\u1edd Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Gi\u1edd Chu\u1ea9n Samoa",
               "",
               "Gi\u1edd ban ng\u00e0y Samoa",
               "",
               "Gi\u1edd Samoa",
               "",
            };
        final String[] Syowa = new String[] {
               "Gi\u1edd Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Gi\u1edd Chu\u1ea9n Tonga",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Tonga",
               "",
               "Gi\u1edd Tonga",
               "",
            };
        final String[] Alaska = new String[] {
               "Gi\u1edd Chu\u1ea9n Alaska",
               "AKST",
               "Gi\u1edd M\u00f9a H\u00e8 Alaska",
               "AKDT",
               "Gi\u1edd Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Gi\u1edd Chu\u1ea9n Amazon",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Amazon",
               "",
               "Gi\u1edd Amazon",
               "",
            };
        final String[] Anadyr = new String[] {
               "Gi\u1edd Chu\u1ea9n Anadyr",
               "",
               "Gi\u1edd m\u00f9a h\u00e8 Anadyr",
               "",
               "Gi\u1edd Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Gi\u1edd Chu\u1ea9n Azores",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Azores",
               "",
               "Gi\u1edd Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Gi\u1edd Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Gi\u1edd Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Gi\u1edd Chu\u1ea9n \u0110\u1ea3o Ph\u1ee5c Sinh",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 \u0110\u1ea3o Ph\u1ee5c Sinh",
               "",
               "Gi\u1edd \u0110\u1ea3o Ph\u1ee5c Sinh",
               "",
            };
        final String[] Guyana = new String[] {
               "Gi\u1edd Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Gi\u1edd Chu\u1ea9n Israel",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Israel",
               "",
               "Gi\u1edd Israel",
               "",
            };
        final String[] Kosrae = new String[] {
               "Gi\u1edd Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Gi\u1edd Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Gi\u1edd Chu\u1ea9n Matxc\u01a1va",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Matxc\u01a1va",
               "",
               "Gi\u1edd Matxc\u01a1va",
               "",
            };
        final String[] Ponape = new String[] {
               "Gi\u1edd Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Gi\u1edd Chu\u1ea9n Samara",
               "",
               "Gi\u1edd m\u00f9a h\u00e8 Samara",
               "",
               "Gi\u1edd Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Gi\u1edd Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Gi\u1edd Chu\u1ea9n \u0110\u00e0i B\u1eafc",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 \u0110\u00e0i B\u1eafc",
               "",
               "Gi\u1edd \u0110\u00e0i B\u1eafc",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Gi\u1edd Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Gi\u1edd Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Gi\u1edd Wallis v\u00e0 Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Gi\u1edd chu\u1ea9n \u1ea2 R\u1eadp",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 \u1ea2 R\u1eadp",
               "",
               "Gi\u1edd \u1ea2 R\u1eadp",
               "",
            };
        final String[] Armenia = new String[] {
               "Gi\u1edd Chu\u1ea9n Armenia",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Armenia",
               "",
               "Gi\u1edd Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Gi\u1edd Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Gi\u1edd Chu\u1ea9n Chatham",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Chatham",
               "",
               "Gi\u1edd Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Gi\u1edd Ph\u1ed1i h\u1ee3p Qu\u1ed1c t\u1ebf",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Gi\u1edd Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gi\u1edd Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Gi\u1edd Chu\u1ea9n Georgia",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Georgia",
               "",
               "Gi\u1edd Georgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Gi\u1edd Chu\u1ea9n Irkutsk",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Irkutsk",
               "",
               "Gi\u1edd Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Gi\u1edd Chu\u1ea9n Magadan",
               "",
               "Gi\u1edd m\u00f9a h\u00e8 Magadan",
               "",
               "Gi\u1edd Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Gi\u1edd Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Gi\u1edd Chu\u1ea9n \u0110\u1ea3o Norfolk",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 \u0110\u1ea3o Norfolk",
               "",
               "Gi\u1edd \u0110\u1ea3o Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Gi\u1edd Chu\u1ea9n Fernando de Noronha",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Fernando de Noronha",
               "",
               "Gi\u1edd Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Gi\u1edd Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Gi\u1edd Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Solomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Gi\u1edd Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Gi\u1edd Chu\u1ea9n Uruguay",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Uruguay",
               "",
               "Gi\u1edd Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Gi\u1edd Chu\u1ea9n Vanuatu",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Vanuatu",
               "",
               "Gi\u1edd Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Gi\u1edd Chu\u1ea9n Yakutsk",
               "",
               "Gi\u1edd m\u00f9a h\u00e8 Yakutsk",
               "",
               "Gi\u1edd Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Gi\u1edd Chu\u1ea9n \u0110\u1ea1i T\u00e2y D\u01b0\u01a1ng",
               "AST",
               "Gi\u1edd m\u00f9a h\u00e8 \u0110\u1ea1i T\u00e2y D\u01b0\u01a1ng",
               "ADT",
               "Gi\u1edd \u0110\u1ea1i T\u00e2y D\u01b0\u01a1ng",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Gi\u1edd Chu\u1ea9n Brasilia",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Brasilia",
               "",
               "Gi\u1edd Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Gi\u1edd Chamorro",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Gi\u1edd Chu\u1ea9n Colombia",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Colombia",
               "",
               "Gi\u1edd Colombia",
               "",
            };
        final String[] Falkland = new String[] {
               "Gi\u1edd Chu\u1ea9n Qu\u1ea7n \u0110\u1ea3o Falkland",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Qu\u1ea7n \u0110\u1ea3o Falkland",
               "",
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Falkland",
               "",
            };
        final String[] Malaysia = new String[] {
               "Gi\u1edd Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Gi\u1edd Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Gi\u1edd chu\u1ea9n Ulan Bator",
               "",
               "Gi\u1edd m\u00f9a h\u00e8 Ulan Bator",
               "",
               "Gi\u1edd Ulan Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "Gi\u1edd Chu\u1ea9n Pakistan",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Pakistan",
               "",
               "Gi\u1edd Pakistan",
               "",
            };
        final String[] Paraguay = new String[] {
               "Gi\u1edd Chu\u1ea9n Paraguay",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Paraguay",
               "",
               "Gi\u1edd Paraguay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Gi\u1edd Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Gi\u1edd Chu\u1ea9n Sakhalin",
               "",
               "Gi\u1edd m\u00f9a h\u00e8 Sakhalin",
               "",
               "Gi\u1edd Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Gi\u1edd Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Gi\u1edd Chu\u1ea9n Argentina",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Argentina",
               "",
               "Gi\u1edd Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Gi\u1edd \u0110\u1ea3o Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Gi\u1edd Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Gi\u1edd Chu\u1ea9n H\u1ed3ng K\u00f4ng",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 H\u1ed3ng K\u00f4ng",
               "",
               "Gi\u1edd H\u1ed3ng K\u00f4ng",
               "",
            };
        final String[] Indochina = new String[] {
               "Gi\u1edd \u0110\u00f4ng D\u01b0\u01a1ng",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Gi\u1edd chu\u1ea9n Petropavlovsk-Kamchatski",
               "",
               "Gi\u1edd m\u00f9a h\u00e8 Petropavlovsk-Kamchatski",
               "",
               "Gi\u1edd Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Gi\u1edd Kyrgystan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Gi\u1edd Chu\u1ea9n Lord Howe",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Lord Howe",
               "",
               "Gi\u1edd Lord Howe",
               "",
            };
        final String[] Macquarie = new String[] {
               "Gi\u1edd \u0111\u1ea3o Macquarie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marquesas = new String[] {
               "Gi\u1edd Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Gi\u1edd Chu\u1ea9n Mauritius",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Mauritius",
               "",
               "Gi\u1edd Mauritius",
               "",
            };
        final String[] Singapore = new String[] {
               "Gi\u1edd Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Gi\u1edd Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Gi\u1edd Chu\u1ea9n Volgograd",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Volgograd",
               "",
               "Gi\u1edd Volgograd",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Gi\u1edd Chu\u1ea9n Azerbaijan",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Azerbaijan",
               "",
               "Gi\u1edd Azerbaijan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Gi\u1edd Chu\u1ea9n Bangladesh",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Bangladesh",
               "",
               "Gi\u1edd Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Gi\u1edd Chu\u1ea9n Cape Verde",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Cape Verde",
               "",
               "Gi\u1edd Cape Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Gi\u1edd \u0110\u00f4ng Timor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Gi\u1edd Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Gi\u1edd Tajikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Gi\u1edd Chu\u1ea9n Uzbekistan",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Uzbekistan",
               "",
               "Gi\u1edd Uzbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Gi\u1edd Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Gi\u1edd Chu\u1ea9n Krasnoyarsk",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Krasnoyarsk",
               "",
               "Gi\u1edd Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Gi\u1edd Chu\u1ea9n New Zealand",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 New Zealand",
               "",
               "Gi\u1edd New Zealand",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Gi\u1edd chu\u1ea9n Novosibirsk",
               "",
               "Gi\u1edd m\u00f9a h\u00e8 Novosibirsk",
               "",
               "Gi\u1edd Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Gi\u1edd Chu\u1ea9n Philippin",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Philippin",
               "",
               "Gi\u1edd Philippin",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Gi\u1edd Chu\u1ea9n Vladivostok",
               "",
               "Gi\u1edd m\u00f9a h\u00e8 Vladivostok",
               "",
               "Gi\u1edd Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Gi\u1edd \u1ea4n \u0110\u1ed9 D\u01b0\u01a1ng",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Line",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Gi\u1edd Chu\u1ea9n Newfoundland",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Newfoundland",
               "",
               "Gi\u1edd Newfoundland",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Gi\u1edd Chu\u1ea9n Turkmenistan",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Turkmenistan",
               "",
               "Gi\u1edd Turkmenistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Gi\u1edd Guiana thu\u1ed9c Ph\u00e1p",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Gi\u1edd Chu\u1ea9n New Caledonia",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 New Caledonia",
               "",
               "Gi\u1edd New Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Gi\u1edd Nam Georgia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Gi\u1edd Chu\u1ea9n Yekaterinburg",
               "",
               "Gi\u1edd m\u00f9a h\u00e8 Yekaterinburg",
               "",
               "Gi\u1edd Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Gi\u1edd Trung Phi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Gi\u1edd \u0110\u00f4ng Phi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Gi\u1edd Chu\u1ea9n T\u00e2y Phi",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 T\u00e2y Phi",
               "",
               "Gi\u1edd T\u00e2y Phi",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Gi\u1edd Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Gi\u1edd chu\u1ea9n Trung \u00c2u",
               "",
               "Gi\u1edd m\u00f9a h\u00e8 Trung \u00c2u",
               "",
               "Gi\u1edd Trung \u00c2u",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Gi\u1edd chu\u1ea9n \u0110\u00f4ng \u00c2u",
               "",
               "Gi\u1edd m\u00f9a h\u00e8 \u0110\u00f4ng \u00c2u",
               "",
               "Gi\u1edd \u0110\u00f4ng \u00c2u",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Gi\u1edd Chu\u1ea9n T\u00e2y \u00c2u",
               "",
               "Gi\u1edd m\u00f9a h\u00e8 T\u00e2y \u00c2u",
               "",
               "Gi\u1edd T\u00e2y \u00c2u",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Gi\u1edd Chu\u1ea9n Th\u00e1i B\u00ecnh D\u01b0\u01a1ng Mexico",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Th\u00e1i B\u00ecnh D\u01b0\u01a1ng Mexico",
               "",
               "Gi\u1edd Th\u00e1i B\u00ecnh D\u01b0\u01a1ng Mexico",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Gi\u1edd Chu\u1ea9n Nam Phi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Central = new String[] {
               "Gi\u1edd chu\u1ea9n mi\u1ec1n Trung",
               "CST",
               "Gi\u1edd m\u00f9a h\u00e8 mi\u1ec1n Trung",
               "CDT",
               "Gi\u1edd mi\u1ec1n Trung",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Gi\u1edd chu\u1ea9n mi\u1ec1n \u0110\u00f4ng",
               "EST",
               "Gi\u1edd m\u00f9a h\u00e8 mi\u1ec1n \u0110\u00f4ng",
               "EDT",
               "Gi\u1edd mi\u1ec1n \u0110\u00f4ng",
               "ET",
            };
        final String[] America_Pacific = new String[] {
               "Gi\u1edd chu\u1ea9n Th\u00e1i B\u00ecnh D\u01b0\u01a1ng",
               "PST",
               "Gi\u1edd m\u00f9a h\u00e8 Th\u00e1i B\u00ecnh D\u01b0\u01a1ng",
               "PDT",
               "Gi\u1edd Th\u00e1i B\u00ecnh D\u01b0\u01a1ng",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Gi\u1edd Nam C\u1ef1c v\u00e0 Nam N\u01b0\u1edbc Ph\u00e1p",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Gi\u1edd Chu\u1ea9n Hawaii-Aleut",
               "HAST",
               "Gi\u1edd M\u00f9a H\u00e8 Hawaii-Aleut",
               "HADT",
               "Gi\u1edd Hawaii-Aleut",
               "HAT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Gi\u1edd Chu\u1ea9n St. Pierre v\u00e0 Miquelon",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Saint Pierre v\u00e0 Miquelon",
               "",
               "Gi\u1edd St. Pierre v\u00e0 Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Gi\u1edd chu\u1ea9n mi\u1ec1n n\u00fai",
               "MST",
               "Gi\u1edd m\u00f9a h\u00e8 mi\u1ec1n n\u00fai",
               "MDT",
               "Gi\u1edd mi\u1ec1n n\u00fai",
               "MT",
            };
        final String[] Marshall_Islands = new String[] {
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Gi\u1edd Chu\u1ea9n T\u00e2y B\u1eafc Mexico",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 T\u00e2y B\u1eafc Mexico",
               "",
               "Gi\u1edd T\u00e2y B\u1eafc Mexico",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Gi\u1edd Papua New Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Gi\u1edd Chu\u1ea9n Mi\u1ec1n Trung Australia",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Mi\u1ec1n Trung Australia",
               "",
               "Gi\u1edd Mi\u1ec1n Trung Australia",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Gi\u1edd Chu\u1ea9n Mi\u1ec1n \u0110\u00f4ng Australia",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Mi\u1ec1n \u0110\u00f4ng Australia",
               "",
               "Gi\u1edd Mi\u1ec1n \u0110\u00f4ng Australia",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Gi\u1edd Chu\u1ea9n Mi\u1ec1n T\u00e2y Australia",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Mi\u1ec1n T\u00e2y Australia",
               "",
               "Gi\u1edd Mi\u1ec1n T\u00e2y Australia",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Gi\u1edd Chu\u1ea9n Mi\u1ec1n \u0110\u00f4ng Greenland",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Mi\u1ec1n \u0110\u00f4ng Greenland",
               "",
               "Gi\u1edd Mi\u1ec1n \u0110\u00f4ng Greenland",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Gi\u1edd Chu\u1ea9n Mi\u1ec1n T\u00e2y Greenland",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Mi\u1ec1n T\u00e2y Greenland",
               "",
               "Gi\u1edd Mi\u1ec1n T\u00e2y Greenland",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Gi\u1edd Mi\u1ec1n Trung Indonesia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Gi\u1edd Mi\u1ec1n \u0110\u00f4ng Indonesia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Gi\u1edd Mi\u1ec1n T\u00e2y Indonesia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Gi\u1edd Mi\u1ec1n \u0110\u00f4ng Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Gi\u1edd Mi\u1ec1n T\u00e2y Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Gi\u1edd Chu\u1ea9n Mi\u1ec1n Trung T\u00e2y Australia",
               "",
               "Gi\u1edd M\u00f9a H\u00e8 Mi\u1ec1n Trung T\u00e2y Australia",
               "",
               "Gi\u1edd Mi\u1ec1n Trung T\u00e2y Australia",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "Gi\u1edd Chu\u1ea9n Hawaii-Aleut",
                    "HST",
                    "Gi\u1edd M\u00f9a H\u00e8 Hawaii-Aleut",
                    "HDT",
                    "Gi\u1edd Hawaii-Aleut",
                    "Gi\u1edd HST",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Eastern },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Damascus", Europe_Eastern },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Gi\u1edd Trung b\u00ecnh Greenwich",
                    "",
                    "Gi\u1edd chu\u1ea9n Ai-len",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Gi\u1edd Trung b\u00ecnh Greenwich",
                    "",
                    "Gi\u1edd M\u00f9a H\u00e8 Anh",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10",
                new String[] {
                    "Gi\u1edd Chu\u1ea9n Hawaii-Aleut",
                    "HST",
                    "Gi\u1edd M\u00f9a H\u00e8 Hawaii-Aleut",
                    "HDT",
                    "Gi\u1edd Hawaii-Aleut",
                    "Gi\u1edd HST",
                }
            },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", America_Pacific },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Gi\u1edd Trung b\u00ecnh Greenwich",
                    "",
                    "Gi\u1edd M\u00f9a H\u00e8 Anh",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Mountain },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", America_Pacific },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Asia/Oral", "Oral" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amman" },
            { "timezone.excity.Asia/Aqtau", "Aqtau" },
            { "timezone.excity.Asia/Chita", "Chita" },
            { "timezone.excity.Asia/Dhaka", "Dhaka" },
            { "timezone.excity.Asia/Dubai", "Dubai" },
            { "timezone.excity.Asia/Kabul", "Kabul" },
            { "timezone.excity.Asia/Macau", "Ma Cao" },
            { "timezone.excity.Asia/Qatar", "Qatar" },
            { "timezone.excity.Asia/Seoul", "Seoul" },
            { "timezone.excity.Asia/Tokyo", "Tokyo" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "timezone.excity.Africa/Lome", "Lome" },
            { "timezone.excity.Asia/Almaty", "Almaty" },
            { "timezone.excity.Asia/Anadyr", "Anadyr" },
            { "timezone.excity.Asia/Aqtobe", "Aqtobe" },
            { "timezone.excity.Asia/Atyrau", "Atyrau" },
            { "timezone.excity.Asia/Beirut", "Beirut" },
            { "timezone.excity.Asia/Brunei", "Brunei" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "timezone.excity.Asia/Kuwait", "Kuwait" },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "timezone.excity.Asia/Muscat", "Muscat" },
            { "timezone.excity.Asia/Riyadh", "Riyadh" },
            { "timezone.excity.Asia/Saigon", "TP H\u1ed3 Ch\u00ed Minh" },
            { "timezone.excity.Asia/Taipei", "\u0110\u00e0i B\u1eafc" },
            { "timezone.excity.Asia/Tehran", "Tehran" },
            { "timezone.excity.Asia/Urumqi", "Urumqi" },
            { "timezone.excity.Etc/Unknown", "Th\u00e0nh ph\u1ed1 Kh\u00f4ng x\u00e1c \u0111\u1ecbnh" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.Europe/Rome", "Rome" },
            { "timezone.excity.Indian/Mahe", "Mahe" },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Africa/Cairo", "Cairo" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Tunis", "Tunis" },
            { "timezone.excity.America/Adak", "Adak" },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/Nome", "Nome" },
            { "timezone.excity.Asia/Baghdad", "Baghdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrain" },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "timezone.excity.Asia/Bishkek", "Bishkek" },
            { "timezone.excity.Asia/Colombo", "Colombo" },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "timezone.excity.Asia/Jakarta", "Jakarta" },
            { "timezone.excity.Asia/Karachi", "Karachi" },
            { "timezone.excity.Asia/Kuching", "Kuching" },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Asia/Nicosia", "Nicosia" },
            { "timezone.excity.Asia/Rangoon", "Rangoon" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "timezone.excity.Asia/Yakutsk", "Yakutsk" },
            { "timezone.excity.Asia/Yerevan", "Yerevan" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "timezone.excity.Europe/Paris", "Paris" },
            { "timezone.excity.Europe/Sofia", "Sofia" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "timezone.excity.Indian/Cocos", "Cocos" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "timezone.excity.Pacific/Fiji", "Fiji" },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.America/Bahia", "Bahia" },
            { "timezone.excity.America/Belem", "Belem" },
            { "timezone.excity.America/Boise", "Boise" },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.Asia/Ashgabat", "Ashgabat" },
            { "timezone.excity.Asia/Damascus", "Damascus" },
            { "timezone.excity.Asia/Dushanbe", "Dushanbe" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "timezone.excity.Asia/Khandyga", "Khandyga" },
            { "timezone.excity.Asia/Makassar", "Makassar" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "timezone.excity.Asia/Sakhalin", "Sakhalin" },
            { "timezone.excity.Asia/Shanghai", "Th\u01b0\u1ee3ng H\u1ea3i" },
            { "timezone.excity.Asia/Tashkent", "Tashkent" },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Europe/Athens", "Athens" },
            { "timezone.excity.Europe/Berlin", "Berlin" },
            { "timezone.excity.Europe/Dublin", "Dublin" },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.Europe/Lisbon", "Lisbon" },
            { "timezone.excity.Europe/London", "London" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "timezone.excity.Europe/Monaco", "Monaco" },
            { "timezone.excity.Europe/Moscow", "M\u00e1t-xc\u01a1-va" },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "timezone.excity.Europe/Tirane", "Tirane" },
            { "timezone.excity.Europe/Vienna", "Vienna" },
            { "timezone.excity.Europe/Warsaw", "Warsaw" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "timezone.excity.Europe/Zurich", "Zurich" },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Indian/Comoro", "Comoro" },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "timezone.excity.Africa/Algiers", "Algiers" },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "timezone.excity.Africa/Tripoli", "Tripoli" },
            { "timezone.excity.America/Belize", "Belize" },
            { "timezone.excity.America/Bogota", "Bogota" },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Cayman", "Cayman" },
            { "timezone.excity.America/Cuiaba", "Cuiaba" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.America/Guyana", "Guyana" },
            { "timezone.excity.America/Havana", "Havana" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.America/Maceio", "Maceio" },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.America/Regina", "Regina" },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "timezone.excity.Asia/Hong_Kong", "H\u1ed3ng K\u00f4ng" },
            { "timezone.excity.Asia/Jerusalem", "Jerusalem" },
            { "timezone.excity.Asia/Kamchatka", "Kamchatka" },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.Asia/Pyongyang", "B\u00ecnh Nh\u01b0\u1ee1ng" },
            { "timezone.excity.Asia/Qyzylorda", "Qyzylorda" },
            { "timezone.excity.Asia/Samarkand", "Samarkand" },
            { "timezone.excity.Asia/Singapore", "Singapore" },
            { "timezone.excity.Asia/Vientiane", "Vi\u00eang Ch\u0103n" },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "timezone.excity.Europe/Tallinn", "Tallinn" },
            { "timezone.excity.Europe/Vatican", "Vatican" },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "timezone.excity.Indian/Reunion", "R\u00e9union" },
            { "timezone.excity.Pacific/Easter", "Easter" },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "timezone.excity.Pacific/Noumea", "Noumea" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Pacific/Tahiti", "Tahiti" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Africa/Djibouti", "Djibouti" },
            { "timezone.excity.Africa/El_Aaiun", "El Aaiun" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "timezone.excity.Africa/Khartoum", "Khartoum" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "timezone.excity.Africa/Ndjamena", "Ndjamena" },
            { "timezone.excity.Africa/Sao_Tome", "S\u00e3o Tom\u00e9" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Cayenne", "Cayenne" },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "timezone.excity.America/Cordoba", "Cordoba" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "timezone.excity.America/Jamaica", "Jamaica" },
            { "timezone.excity.America/Managua", "Managua" },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "timezone.excity.Asia/Choibalsan", "Choibalsan" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom Penh" },
            { "timezone.excity.Atlantic/Azores", "Azores" },
            { "timezone.excity.Atlantic/Canary", "Canary" },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "timezone.excity.Europe/Belgrade", "Belgrade" },
            { "timezone.excity.Europe/Brussels", "Brussels" },
            { "timezone.excity.Europe/Budapest", "Budapest" },
            { "timezone.excity.Europe/Busingen", "Busingen" },
            { "timezone.excity.Europe/Chisinau", "Chisinau" },
            { "timezone.excity.Europe/Guernsey", "Guernsey" },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "timezone.excity.Europe/Istanbul", "Istanbul" },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "timezone.excity.Europe/Uzhgorod", "Uzhhorod" },
            { "timezone.excity.Indian/Maldives", "Maldives" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "timezone.excity.Pacific/Gambier", "Gambier" },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "timezone.excity.Africa/Mogadishu", "Mogadishu" },
            { "timezone.excity.America/Anguilla", "Anguilla" },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.America/Dominica", "Dominica" },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.America/Eirunepe", "Eirunepe" },
            { "timezone.excity.America/Mazatlan", "Mazatlan" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "timezone.excity.America/New_York", "New York" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.America/Santarem", "Santarem" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "timezone.excity.Antarctica/Syowa", "Syowa" },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoyarsk" },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulaanbaatar" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "timezone.excity.Atlantic/Bermuda", "Bermuda" },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "timezone.excity.Australia/Sydney", "Sydney" },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Europe/Astrakhan", "Astrakhan" },
            { "timezone.excity.Europe/Bucharest", "Bucharest" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljana" },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Europe/Stockholm", "Stockholm" },
            { "timezone.excity.Europe/Ulyanovsk", "Ulyanovsk" },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Indian/Christmas", "Christmas" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelen" },
            { "timezone.excity.Indian/Mauritius", "Mauritius" },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "timezone.excity.America/Araguaina", "Araguaina" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "timezone.excity.America/Sao_Paulo", "Sao Paulo" },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznetsk" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "timezone.excity.Europe/Copenhagen", "Copenhagen" },
            { "timezone.excity.Europe/Luxembourg", "Luxembourg" },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.Europe/Zaporozhye", "Zaporozhye" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Galapagos" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "timezone.excity.Pacific/Marquesas", "Marquesas" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Ababa" },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.America/Costa_Rica", "Costa Rica" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "timezone.excity.America/Guadeloupe", "Guadeloupe" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Martinique", "Martinique" },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "timezone.excity.America/Rio_Branco", "Rio Branco" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolymsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Yekaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjavik" },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.Europe/Isle_of_Man", "\u0110\u1ea3o Man" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "timezone.excity.Africa/Johannesburg", "Johannesburg" },
            { "timezone.excity.America/El_Salvador", "El Salvador" },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "timezone.excity.America/Mexico_City", "Mexico City" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "timezone.excity.America/Puerto_Rico", "Puerto Rico" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cape Verde" },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "timezone.excity.America/St_Barthelemy", "St. Barth\u00e9lemy" },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "timezone.excity.Atlantic/South_Georgia", "Nam Georgia" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucuman" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, B\u1eafc Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, B\u1eafc Dakota" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, B\u1eafc Dakota" },
        };
        return data;
    }
}
