/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiling.snapshot;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshot;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.DataSourceRepository;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasupport.DataChangeEvent;
import org.graalvm.visualvm.core.datasupport.DataChangeListener;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.graalvm.visualvm.profiling.snapshot.ProfilerSnapshot;
import org.graalvm.visualvm.profiling.snapshot.ProfilerSnapshotsSupport;
import org.openide.util.RequestProcessor;

final class ProfilerSnapshotProvider {
    ProfilerSnapshotProvider() {
    }

    void createSnapshot(File snapshotFile, Application application, boolean openView) {
        final ProfilerSnapshot snapshot = ProfilerSnapshot.createSnapshot(snapshotFile, (DataSource)application);
        application.getRepository().addDataSource((DataSource)snapshot);
        if (openView) {
            DataSource.EVENT_QUEUE.post(new Runnable(){

                @Override
                public void run() {
                    DataSourceWindowManager.sharedInstance().openDataSource((DataSource)snapshot);
                }
            });
        }
    }

    void initialize() {
        DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)new SnapshotListener(), Snapshot.class);
        DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)new ApplicationListener(), Application.class);
    }

    private void processNewSnapshot(Snapshot snapshot) {
        if (snapshot instanceof ProfilerSnapshot) {
            return;
        }
        boolean appSnapshot = snapshot instanceof ApplicationSnapshot;
        File snapshotFile = snapshot.getFile();
        if (snapshotFile != null && snapshotFile.isDirectory()) {
            Set<ProfilerSnapshot> snapshots = this.findSnapshots(snapshotFile, (DataSource)snapshot, appSnapshot);
            snapshot.getRepository().addDataSources(snapshots);
        }
    }

    private void processNewApplication(Application application) {
        Storage storage = application.getStorage();
        if (storage.directoryExists()) {
            Set<ProfilerSnapshot> snapshots = this.findSnapshots(storage.getDirectory(), (DataSource)application, false);
            application.getRepository().addDataSources(snapshots);
        }
    }

    private Set<ProfilerSnapshot> findSnapshots(File directory, DataSource app, boolean forceClosable) {
        File[] files = directory.listFiles(ProfilerSnapshotsSupport.getInstance().getCategory().getFilenameFilter());
        if (files == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<ProfilerSnapshot> snapshots = new HashSet<ProfilerSnapshot>(files.length);
        for (File file : files) {
            ProfilerSnapshot snapshot = ProfilerSnapshot.createSnapshot(file, app);
            if (forceClosable) {
                snapshot.forceViewClosable(true);
            }
            snapshots.add(snapshot);
        }
        return snapshots;
    }

    private class ApplicationListener
    implements DataChangeListener<Application> {
        private ApplicationListener() {
        }

        public void dataChanged(DataChangeEvent<Application> event) {
            final Set applications = event.getAdded();
            if (!applications.isEmpty()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        for (Application application : applications) {
                            ProfilerSnapshotProvider.this.processNewApplication(application);
                        }
                    }
                });
            }
        }
    }

    private class SnapshotListener
    implements DataChangeListener<Snapshot> {
        private SnapshotListener() {
        }

        public void dataChanged(DataChangeEvent<Snapshot> event) {
            final Set snapshots = event.getAdded();
            if (!snapshots.isEmpty()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        for (Snapshot snapshot : snapshots) {
                            ProfilerSnapshotProvider.this.processNewSnapshot(snapshot);
                        }
                    }
                });
            }
        }
    }
}

