/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiling.snapshot;

import java.io.File;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.model.ModelProvider;
import org.graalvm.visualvm.core.snapshot.RegisteredSnapshotCategories;
import org.graalvm.visualvm.core.snapshot.SnapshotCategory;
import org.graalvm.visualvm.profiling.snapshot.ProfilerSnapshotCategory;
import org.graalvm.visualvm.profiling.snapshot.ProfilerSnapshotDescriptorProvider;
import org.graalvm.visualvm.profiling.snapshot.ProfilerSnapshotProvider;
import org.graalvm.visualvm.profiling.snapshot.ProfilerSnapshotViewProvider;

public final class ProfilerSnapshotsSupport {
    private static ProfilerSnapshotsSupport INSTANCE;
    private ProfilerSnapshotCategory category;
    private ProfilerSnapshotProvider profilerSnapshotsProvider;

    public static synchronized ProfilerSnapshotsSupport getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ProfilerSnapshotsSupport();
        }
        return INSTANCE;
    }

    public void createSnapshot(File loadedSnapshot, Application application, boolean openView) {
        this.profilerSnapshotsProvider.createSnapshot(loadedSnapshot, application, openView);
    }

    SnapshotCategory getCategory() {
        return this.category;
    }

    private ProfilerSnapshotsSupport() {
        DataSourceDescriptorFactory.getDefault().registerProvider((ModelProvider)new ProfilerSnapshotDescriptorProvider());
        new ProfilerSnapshotViewProvider().initialize();
        this.category = new ProfilerSnapshotCategory();
        RegisteredSnapshotCategories.sharedInstance().registerCategory((SnapshotCategory)this.category);
        this.profilerSnapshotsProvider = new ProfilerSnapshotProvider();
        this.profilerSnapshotsProvider.initialize();
    }
}

