/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.item;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openjdk.jmc.common.IPredicate;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemConsumer;
import org.openjdk.jmc.common.item.IItemConsumerFactory;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.IValueBuilder;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.messages.internal.Messages;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.PredicateToolkit;
import org.openjdk.jmc.common.util.StringToolkit;

public class Aggregators {
    private static final Count COUNT = new Count(Messages.getString("ItemAggregate_COUNT"), null);

    private static <V extends Comparable<V>> IAggregator<IItem, ?> minMaxItem(String name, final IAttribute<V> attribute, boolean max) {
        return new MergingAggregator<IItem, MinMaxConsumer<V>>("Item with " + name, null, UnitLookup.UNKNOWN){

            @Override
            public boolean acceptType(IType<IItem> type) {
                return attribute.getAccessor(type) != null;
            }

            @Override
            public MinMaxConsumer<V> newItemConsumer(IType<IItem> type) {
                return new MinMaxConsumer(attribute.getAccessor(type), true);
            }

            @Override
            public IItem getValue(MinMaxConsumer<V> consumer) {
                return consumer.item;
            }
        };
    }

    public static <V extends Comparable<V>> IAggregator<IItem, ?> itemWithMin(IAttribute<V> attribute) {
        String name = Aggregators.getMinName(attribute.getName(), attribute.getContentType());
        return Aggregators.minMaxItem(name, attribute, false);
    }

    public static <V extends Comparable<V>> IAggregator<IItem, ?> itemWithMax(IAttribute<V> attribute) {
        String name = Aggregators.getMaxName(attribute.getName(), attribute.getContentType());
        return Aggregators.minMaxItem(name, attribute, true);
    }

    public static <V> IAggregator<V, ?> filter(IAggregator<V, ?> aggregator, IItemFilter filter) {
        return Aggregators.filter(aggregator.getName(), aggregator.getDescription(), aggregator, filter);
    }

    public static <V, C extends IItemConsumer<C>> IAggregator<V, ?> filter(String name, String description, final IAggregator<V, C> aggregator, final IItemFilter filter) {
        return new AggregatorBase<V, FilterConsumer<C>>(name, description, aggregator.getValueType()){

            @Override
            public boolean acceptType(IType<IItem> type) {
                return aggregator.acceptType(type) && !PredicateToolkit.isFalseGuaranteed(filter.getPredicate(type));
            }

            @Override
            public FilterConsumer<C> newItemConsumer(IType<IItem> type) {
                return new FilterConsumer(filter.getPredicate(type), aggregator.newItemConsumer(type));
            }

            @Override
            public V getValue(final Iterator<FilterConsumer<C>> consumers) {
                return aggregator.getValue(new Iterator<C>(){

                    @Override
                    public boolean hasNext() {
                        return consumers.hasNext();
                    }

                    @Override
                    public C next() {
                        return ((FilterConsumer)consumers.next()).nestedConsumer;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                });
            }
        };
    }

    public static IAggregator<IQuantity, ?> sum(final IAttribute<IQuantity> attribute) {
        ContentType contentType = attribute.getContentType();
        if (contentType instanceof LinearKindOfQuantity) {
            return new Sum(Aggregators.getSumName(attribute.getName()), attribute.getDescription(), (LinearKindOfQuantity)contentType){

                @Override
                protected IMemberAccessor<IQuantity, IItem> doGetAccessor(IType<IItem> type) {
                    return attribute.getAccessor(type);
                }
            };
        }
        throw new IllegalArgumentException("Can only use LinearKindOfQuantity");
    }

    public static IAggregator<IQuantity, ?> variance(IAttribute<IQuantity> attribute) {
        return Aggregators.varianceInternal(attribute, true);
    }

    public static IAggregator<IQuantity, ?> variancep(IAttribute<IQuantity> attribute) {
        return Aggregators.varianceInternal(attribute, false);
    }

    private static IAggregator<IQuantity, ?> varianceInternal(final IAttribute<IQuantity> attribute, boolean besselCorrection) {
        ContentType contentType = attribute.getContentType();
        if (contentType instanceof LinearKindOfQuantity) {
            return new Variance(Aggregators.getVarianceName(attribute.getName(), besselCorrection), attribute.getDescription(), (LinearKindOfQuantity)contentType, besselCorrection){

                @Override
                protected IMemberAccessor<IQuantity, IItem> doGetAccessor(IType<IItem> type) {
                    return attribute.getAccessor(type);
                }
            };
        }
        throw new IllegalArgumentException("Can only use LinearKindOfQuantity");
    }

    public static IAggregator<IQuantity, ?> stddev(IAttribute<IQuantity> attribute) {
        return Aggregators.stddevInternal(attribute, true);
    }

    public static IAggregator<IQuantity, ?> stddev(String name, String description, IAttribute<IQuantity> attribute) {
        return Aggregators.stddevInternal(name, description, attribute, true);
    }

    public static IAggregator<IQuantity, ?> stddevp(IAttribute<IQuantity> attribute) {
        return Aggregators.stddevInternal(attribute, false);
    }

    public static IAggregator<IQuantity, ?> stddevp(String name, String description, IAttribute<IQuantity> attribute) {
        return Aggregators.stddevInternal(name, description, attribute, false);
    }

    private static IAggregator<IQuantity, ?> stddevInternal(IAttribute<IQuantity> attribute, boolean besselCorrection) {
        return Aggregators.stddevInternal(Aggregators.getStddevName(attribute.getName(), besselCorrection), attribute.getDescription(), attribute, besselCorrection);
    }

    private static IAggregator<IQuantity, ?> stddevInternal(String name, String description, final IAttribute<IQuantity> attribute, boolean besselCorrection) {
        ContentType contentType = attribute.getContentType();
        if (contentType instanceof LinearKindOfQuantity) {
            return new Stddev(name, description, (LinearKindOfQuantity)contentType, besselCorrection){

                @Override
                protected IMemberAccessor<IQuantity, IItem> doGetAccessor(IType<IItem> type) {
                    return attribute.getAccessor(type);
                }
            };
        }
        throw new IllegalArgumentException("Can only use LinearKindOfQuantity");
    }

    public static IAggregator<IQuantity, ?> sum(String typeId, IAttribute<IQuantity> attribute) {
        return Aggregators.sum(Aggregators.getSumName(attribute.getName()), null, typeId, attribute);
    }

    public static IAggregator<IQuantity, ?> sum(String name, String description, IAttribute<IQuantity> attribute) {
        ContentType contentType = attribute.getContentType();
        if (contentType instanceof LinearKindOfQuantity) {
            return Aggregators.sum(name, description, (LinearKindOfQuantity)contentType, attribute);
        }
        throw new IllegalArgumentException("Can only use LinearKindOfQuantity");
    }

    public static IAggregator<IQuantity, ?> sum(String name, String description, final String typeId, final IAttribute<IQuantity> attribute) {
        ContentType contentType = attribute.getContentType();
        if (contentType instanceof LinearKindOfQuantity) {
            return new Sum(name, description, (LinearKindOfQuantity)contentType){

                @Override
                protected IMemberAccessor<IQuantity, IItem> doGetAccessor(IType<IItem> type) {
                    if (type.getIdentifier().equals(typeId)) {
                        return attribute.getAccessor(type);
                    }
                    return null;
                }
            };
        }
        throw new IllegalArgumentException("Can only use LinearKindOfQuantity");
    }

    public static IAggregator<IQuantity, ?> sum(String name, String description, LinearKindOfQuantity ct, final IAccessorFactory<IQuantity> af) {
        return new Sum(name, description, ct){

            @Override
            protected IMemberAccessor<? extends IQuantity, IItem> doGetAccessor(IType<IItem> type) {
                return af.getAccessor(type);
            }
        };
    }

    public static IAggregator<IQuantity, ?> avg(final IAttribute<IQuantity> attribute) {
        return new Avg(Aggregators.getAvgName(attribute.getName()), attribute.getDescription(), attribute.getContentType()){

            @Override
            protected IMemberAccessor<IQuantity, IItem> doGetAccessor(IType<IItem> type) {
                return attribute.getAccessor(type);
            }
        };
    }

    public static IAggregator<IQuantity, ?> avg(String typeId, IAttribute<IQuantity> attribute) {
        return Aggregators.avg(Aggregators.getAvgName(attribute.getName()), null, typeId, attribute);
    }

    public static IAggregator<IQuantity, ?> avg(String name, String description, IAttribute<IQuantity> attribute) {
        ContentType contentType = attribute.getContentType();
        if (contentType instanceof KindOfQuantity) {
            return Aggregators.avg(name, description, (KindOfQuantity)contentType, attribute);
        }
        throw new IllegalArgumentException("Can only use KindOfQuantity");
    }

    public static IAggregator<IQuantity, ?> avg(String name, String description, final String typeId, final IAttribute<IQuantity> attribute) {
        ContentType contentType = attribute.getContentType();
        if (contentType instanceof KindOfQuantity) {
            return new Avg(name, description, (KindOfQuantity)contentType){

                @Override
                protected IMemberAccessor<IQuantity, IItem> doGetAccessor(IType<IItem> type) {
                    if (type.getIdentifier().equals(typeId)) {
                        return attribute.getAccessor(type);
                    }
                    return null;
                }
            };
        }
        throw new IllegalArgumentException("Can only use KindOfQuantity");
    }

    public static IAggregator<IQuantity, ?> avg(String name, String description, KindOfQuantity<?> ct, final IAccessorFactory<IQuantity> af) {
        return new Avg(name, description, ct){

            @Override
            protected IMemberAccessor<? extends IQuantity, IItem> doGetAccessor(IType<IItem> type) {
                return af.getAccessor(type);
            }
        };
    }

    public static <V extends Comparable<V>> IAggregator<V, ?> min(final IAttribute<V> attribute) {
        String name = Aggregators.getMinName(attribute.getName(), attribute.getContentType());
        return new MinMax<V>(name, attribute.getDescription(), attribute.getContentType(), false){

            @Override
            protected IMemberAccessor<V, IItem> doGetAccessor(IType<IItem> type) {
                return attribute.getAccessor(type);
            }
        };
    }

    public static <V extends Comparable<V>> IAggregator<V, ?> min(String typeId, IAttribute<V> attribute) {
        String name = Aggregators.getMinName(attribute.getName(), attribute.getContentType());
        return Aggregators.min(name, null, typeId, attribute);
    }

    public static <V extends Comparable<V>> IAggregator<V, ?> min(String name, String description, final String typeId, final IAttribute<V> attribute) {
        ContentType contentType = attribute.getContentType();
        return new MinMax<V>(name, description, contentType, false){

            @Override
            protected IMemberAccessor<V, IItem> doGetAccessor(IType<IItem> type) {
                if (type.getIdentifier().equals(typeId)) {
                    return attribute.getAccessor(type);
                }
                return null;
            }
        };
    }

    public static <V extends Comparable<V>> IAggregator<V, ?> max(final IAttribute<V> attribute) {
        String name = Aggregators.getMaxName(attribute.getName(), attribute.getContentType());
        return new MinMax<V>(name, attribute.getDescription(), attribute.getContentType(), true){

            @Override
            protected IMemberAccessor<V, IItem> doGetAccessor(IType<IItem> type) {
                return attribute.getAccessor(type);
            }
        };
    }

    public static IAggregator<IQuantity, ?> max(String typeId, IAttribute<IQuantity> attribute) {
        String name = Aggregators.getMaxName(attribute.getName(), attribute.getContentType());
        return Aggregators.max(name, null, typeId, attribute);
    }

    public static <V extends Comparable<V>> IAggregator<V, ?> max(String name, String description, final IAttribute<V> attribute) {
        ContentType contentType = attribute.getContentType();
        return new MinMax<V>(name, description, contentType, true){

            @Override
            protected IMemberAccessor<V, IItem> doGetAccessor(IType<IItem> type) {
                return attribute.getAccessor(type);
            }
        };
    }

    public static <V extends Comparable<V>> IAggregator<V, ?> max(String name, String description, final String typeId, final IAttribute<V> attribute) {
        ContentType contentType = attribute.getContentType();
        return new MinMax<V>(name, description, contentType, true){

            @Override
            protected IMemberAccessor<V, IItem> doGetAccessor(IType<IItem> type) {
                if (type.getIdentifier().equals(typeId)) {
                    return attribute.getAccessor(type);
                }
                return null;
            }
        };
    }

    public static IAggregator<IQuantity, CountConsumer> count() {
        return COUNT;
    }

    public static IAggregator<IQuantity, CountConsumer> count(String name, String description) {
        return new Count(name, description);
    }

    public static IAggregator<IQuantity, ?> count(IType<?> type) {
        return Aggregators.filter(Aggregators.getCountName(type), null, COUNT, ItemFilters.type(type.getIdentifier()));
    }

    public static IAggregator<IQuantity, ?> count(IItemFilter filter) {
        return Aggregators.filter(COUNT, filter);
    }

    public static IAggregator<IQuantity, ?> count(String name, String description, IItemFilter filter) {
        return Aggregators.filter(name, description, COUNT, filter);
    }

    public static IAggregator<Boolean, ?> and(final String typeId, final IAttribute<Boolean> attribute) {
        return new AndOr(attribute.getName(), attribute.getDescription(), UnitLookup.FLAG){

            @Override
            public AndOrConsumer newItemConsumer(IType<IItem> type) {
                return new AndOrConsumer(attribute.getAccessor(type), true);
            }

            @Override
            public boolean acceptType(IType<IItem> type) {
                return type.getIdentifier().equals(typeId);
            }

            @Override
            protected IMemberAccessor<Boolean, IItem> doGetAccessor(IType<IItem> type) {
                if (type.getIdentifier().equals(typeId)) {
                    return attribute.getAccessor(type);
                }
                return null;
            }
        };
    }

    public static IAggregator<Boolean, ?> or(final String typeId, final IAttribute<Boolean> attribute) {
        return new AndOr(attribute.getName(), attribute.getDescription(), UnitLookup.FLAG){

            @Override
            public AndOrConsumer newItemConsumer(IType<IItem> type) {
                return new AndOrConsumer(attribute.getAccessor(type), false);
            }

            @Override
            public boolean acceptType(IType<IItem> type) {
                return type.getIdentifier().equals(typeId);
            }

            @Override
            protected IMemberAccessor<Boolean, IItem> doGetAccessor(IType<IItem> type) {
                if (type.getIdentifier().equals(typeId)) {
                    return attribute.getAccessor(type);
                }
                return null;
            }
        };
    }

    public static IAggregator<String, ?> distinctAsString(String typeId, IAttribute<String> attribute) {
        return Aggregators.filter(Aggregators.distinctAsString(attribute, ", "), ItemFilters.type(typeId));
    }

    public static IAggregator<String, ?> distinctAsString(IAttribute<String> attribute, String delimiter) {
        return Aggregators.distinctAsString(attribute, delimiter, attribute.getName(), attribute.getDescription());
    }

    public static IAggregator<String, ?> distinctAsString(IAttribute<String> attribute, final String delimiter, String name, String description) {
        return Aggregators.valueBuilderAggregator(Aggregators.distinct(attribute), new IValueBuilder<String, Set<String>>(){

            @Override
            public String getValue(Set<String> source) {
                return source.isEmpty() ? null : StringToolkit.join(source, delimiter);
            }

            @Override
            public IType<? super String> getValueType() {
                return UnitLookup.PLAIN_TEXT;
            }
        }, name, description);
    }

    public static <V1, V2, C extends IItemConsumer<C>> IAggregator<V2, C> valueBuilderAggregator(final IAggregator<V1, C> aggregator, final IValueBuilder<V2, V1> valuebuilder, String name, String description) {
        return new AggregatorBase<V2, C>(name, description, valuebuilder.getValueType()){

            @Override
            public boolean acceptType(IType<IItem> type) {
                return aggregator.acceptType(type);
            }

            @Override
            public C newItemConsumer(IType<IItem> type) {
                return aggregator.newItemConsumer(type);
            }

            @Override
            public V2 getValue(Iterator<C> consumers) {
                Object val1 = aggregator.getValue(consumers);
                return val1 != null ? (Object)valuebuilder.getValue(val1) : null;
            }
        };
    }

    public static <T> IAggregator<IQuantity, ?> countDistinct(String name, String description, IAccessorFactory<T> attribute) {
        return new SetAggregator<IQuantity, T>(name, description, (IAccessorFactory)attribute, (IType)UnitLookup.NUMBER){

            @Override
            public IQuantity getValue(SetConsumer<T> consumer) {
                return UnitLookup.NUMBER_UNITY.quantity(consumer.distinct.size());
            }
        };
    }

    public static <T> IAggregator<Set<T>, ?> distinct(IAttribute<T> attribute) {
        return Aggregators.distinct(MessageFormat.format(Messages.getString("ItemAggregate_DISTINCT"), attribute.getName()), attribute);
    }

    public static <T> IAggregator<Set<T>, ?> distinct(String name, IAccessorFactory<T> attribute) {
        return new SetAggregator<Set<T>, T>(name, null, (IAccessorFactory)attribute, UnitLookup.UNKNOWN){

            @Override
            public Set<T> getValue(SetConsumer<T> consumer) {
                return consumer.distinct;
            }
        };
    }

    public static <C extends IItemConsumer<C>> IAggregator<C, C> forConsumer(IItemConsumerFactory<C> consumerFactory) {
        return Aggregators.forConsumer(consumerFactory, PredicateToolkit.truePredicate());
    }

    public static <C extends IItemConsumer<C>> IAggregator<C, C> forConsumer(final IItemConsumerFactory<C> consumerFactory, final IPredicate<IType<IItem>> acceptType) {
        return new MergingAggregator<C, C>("", null, UnitLookup.UNKNOWN){

            @Override
            public boolean acceptType(IType<IItem> type) {
                return acceptType.evaluate(type);
            }

            @Override
            public C newItemConsumer(IType<IItem> type) {
                return consumerFactory.newItemConsumer(type);
            }

            @Override
            public C getValue(C consumer) {
                return consumer;
            }
        };
    }

    private static String getCountName(IType<?> type) {
        return Messages.getString("ItemAggregate_COUNT") + " " + type.getName();
    }

    static String getSumName(String name) {
        return Messages.getString("ItemAggregate_TOTAL") + " " + name;
    }

    static String getVarianceName(String name, boolean besselCorrection) {
        return Messages.getString(besselCorrection ? "ItemAggregate_VARIANCE" : "ItemAggregate_VARIANCEP") + " " + name;
    }

    static String getStddevName(String name, boolean besselCorrection) {
        return Messages.getString(besselCorrection ? "ItemAggregate_STDDEV" : "ItemAggregate_STDDEVP") + " " + name;
    }

    static String getAvgName(String name) {
        return Messages.getString("ItemAggregate_AVERAGE") + " " + name;
    }

    static String getMaxName(String name, ContentType<?> ct) {
        if (ct == UnitLookup.TIMESPAN) {
            return Messages.getString("ItemAggregate_LONGEST") + " " + name;
        }
        if (ct == UnitLookup.TIMESTAMP) {
            return Messages.getString("ItemAggregate_LAST") + " " + name;
        }
        return Messages.getString("ItemAggregate_MAXIMUM") + " " + name;
    }

    static String getMinName(String name, ContentType<?> ct) {
        if (ct == UnitLookup.TIMESPAN) {
            return Messages.getString("ItemAggregate_SHORTEST") + " " + name;
        }
        if (ct == UnitLookup.TIMESTAMP) {
            return Messages.getString("ItemAggregate_FIRST") + " " + name;
        }
        return Messages.getString("ItemAggregate_MINIMUM") + " " + name;
    }

    public static IAggregator<IQuantity, ?> getQuantityAggregator(String name, IAttribute<IQuantity> attribute) {
        if (name == null) {
            return null;
        }
        if (name.startsWith(Messages.getString("ItemAggregate_TOTAL"))) {
            return Aggregators.sum(attribute);
        }
        if (name.startsWith(Messages.getString("ItemAggregate_AVERAGE"))) {
            return Aggregators.avg(attribute);
        }
        if (name.startsWith(Messages.getString("ItemAggregate_LONGEST"))) {
            return Aggregators.max(attribute);
        }
        if (name.startsWith(Messages.getString("ItemAggregate_LAST"))) {
            return Aggregators.max(attribute);
        }
        if (name.startsWith(Messages.getString("ItemAggregate_MAXIMUM"))) {
            return Aggregators.max(attribute);
        }
        if (name.startsWith(Messages.getString("ItemAggregate_SHORTEST"))) {
            return Aggregators.min(attribute);
        }
        if (name.startsWith(Messages.getString("ItemAggregate_FIRST"))) {
            return Aggregators.min(attribute);
        }
        if (name.startsWith(Messages.getString("ItemAggregate_MINIMUM"))) {
            return Aggregators.min(attribute);
        }
        return null;
    }

    public static IAggregator<IQuantity, ?> getQuantityAggregator(String name, IType<?> type) {
        if (type != null && name.startsWith(Messages.getString("ItemAggregate_COUNT"))) {
            return Aggregators.count(type);
        }
        if (name.startsWith(Messages.getString("ItemAggregate_COUNT"))) {
            return Aggregators.count();
        }
        return null;
    }

    public static IAggregator<IQuantity, ?> getQuantityAggregator(String name) {
        if (name.startsWith(Messages.getString("ItemAggregate_COUNT"))) {
            return Aggregators.count();
        }
        return null;
    }

    public static class AdvancedMaxAggregator<V, T extends Comparable<T>>
    extends AdvancedMinMaxAggregator<V, T> {
        public AdvancedMaxAggregator(String name, String description, IAttribute<V> attribute, IAttribute<T> comparator) {
            super(name, description, attribute, comparator, true);
        }
    }

    public static class AdvancedMinAggregator<V, T extends Comparable<T>>
    extends AdvancedMinMaxAggregator<V, T> {
        public AdvancedMinAggregator(String name, String description, IAttribute<V> attribute, IAttribute<T> comparator) {
            super(name, description, attribute, comparator, false);
        }
    }

    private static class AdvancedMinMaxAggregator<V, T extends Comparable<T>>
    extends FieldAggregatorBase<V, AdvancedMinMaxConsumer<V, T>> {
        private final boolean max;
        private final IAttribute<V> attribute;
        private final IAttribute<T> comparator;

        public AdvancedMinMaxAggregator(String name, String description, IAttribute<V> attribute, IAttribute<T> comparator, boolean max) {
            super(name, description, attribute.getContentType());
            this.attribute = attribute;
            this.comparator = comparator;
            this.max = max;
        }

        @Override
        public AdvancedMinMaxConsumer<V, T> newItemConsumer(IType<IItem> type) {
            return new AdvancedMinMaxConsumer(this.attribute.getAccessor(type), this.comparator.getAccessor(type), this.max);
        }

        @Override
        public V getValue(AdvancedMinMaxConsumer<V, T> consumer) {
            return consumer.getValue();
        }

        @Override
        protected IMemberAccessor<? extends V, IItem> doGetAccessor(IType<IItem> type) {
            return this.attribute.getAccessor(type);
        }
    }

    public static class AdvancedMinMaxConsumer<V, T extends Comparable<T>>
    implements IItemConsumer<AdvancedMinMaxConsumer<V, T>> {
        private final IMemberAccessor<? extends V, IItem> accessor;
        private final IMemberAccessor<T, IItem> comparatorAccessor;
        private final boolean max;
        private IItem item;

        public AdvancedMinMaxConsumer(IMemberAccessor<? extends V, IItem> valueAccessor, IMemberAccessor<T, IItem> comparatorAccessor, boolean max) {
            this.accessor = valueAccessor;
            this.max = max;
            this.comparatorAccessor = comparatorAccessor;
        }

        @Override
        public void consume(IItem newItem) {
            if (newItem == null) {
                return;
            }
            Comparable newOrderingValue = (Comparable)this.comparatorAccessor.getMember(newItem);
            if (newOrderingValue == null) {
                return;
            }
            if (this.item == null) {
                this.item = newItem;
            } else {
                Comparable oldOrderingValue = (Comparable)this.comparatorAccessor.getMember(this.item);
                if (newOrderingValue.compareTo(oldOrderingValue) > 0 == this.max) {
                    this.item = newItem;
                }
            }
        }

        @Override
        public AdvancedMinMaxConsumer<V, T> merge(AdvancedMinMaxConsumer<V, T> other) {
            this.consume(other.item);
            return this;
        }

        public V getValue() {
            if (this.item == null) {
                return null;
            }
            return this.accessor.getMember(this.item);
        }
    }

    private static abstract class SetAggregator<V, T>
    extends MergingAggregator<V, SetConsumer<T>> {
        private final IAccessorFactory<T> attribute;

        public SetAggregator(String name, String description, IAccessorFactory<T> attribute, IType<? super V> type) {
            super(name, description, type);
            this.attribute = attribute;
        }

        @Override
        public boolean acceptType(IType<IItem> type) {
            return this.attribute.getAccessor(type) != null;
        }

        @Override
        public SetConsumer<T> newItemConsumer(IType<IItem> itemType) {
            return new SetConsumer<T>(this.attribute.getAccessor(itemType));
        }
    }

    public static class SetConsumer<T>
    implements IItemConsumer<SetConsumer<T>> {
        Set<T> distinct = new HashSet<T>();
        private final IMemberAccessor<? extends T, IItem> accessor;

        public SetConsumer(IMemberAccessor<? extends T, IItem> accessor) {
            this.accessor = accessor;
        }

        @Override
        public void consume(IItem item) {
            T member = this.accessor.getMember(item);
            if (member != null) {
                this.distinct.add(member);
            }
        }

        @Override
        public SetConsumer<T> merge(SetConsumer<T> other) {
            this.distinct.addAll(other.distinct);
            return this;
        }
    }

    private static abstract class AndOr
    extends FieldAggregatorBase<Boolean, AndOrConsumer> {
        public AndOr(String name, String description, IType<Boolean> ct) {
            super(name, description, ct);
        }

        @Override
        public Boolean getValue(AndOrConsumer consumer) {
            return consumer.b;
        }
    }

    private static class AndOrConsumer
    implements IItemConsumer<AndOrConsumer> {
        boolean and;
        Boolean b;
        IMemberAccessor<? extends Boolean, IItem> accessor;

        public AndOrConsumer(IMemberAccessor<? extends Boolean, IItem> accessor, boolean and) {
            this.and = and;
            this.accessor = accessor;
        }

        @Override
        public void consume(IItem item) {
            this.evaluate(this.accessor.getMember(item));
        }

        void evaluate(Boolean value) {
            if (this.b == null) {
                this.b = value;
            } else if (value != null) {
                this.b = this.and ? this.b.booleanValue() && value.booleanValue() : this.b != false || value != false;
            }
        }

        @Override
        public AndOrConsumer merge(AndOrConsumer other) {
            this.evaluate(other.b);
            return this;
        }
    }

    private static class Count
    extends MergingAggregator<IQuantity, CountConsumer> {
        Count(String name, String description) {
            super(name, description, UnitLookup.NUMBER);
        }

        @Override
        public boolean acceptType(IType<IItem> type) {
            return true;
        }

        @Override
        public CountConsumer newItemConsumer(IType<IItem> type) {
            return new CountConsumer();
        }

        @Override
        public IQuantity getValue(CountConsumer consumer) {
            return UnitLookup.NUMBER_UNITY.quantity(consumer.count);
        }
    }

    private static class FilterConsumer<C extends IItemConsumer<C>>
    implements IItemConsumer<FilterConsumer<C>> {
        private final IPredicate<IItem> p;
        private final C nestedConsumer;

        public FilterConsumer(IPredicate<IItem> p, C nestedConsumer) {
            this.p = p;
            this.nestedConsumer = nestedConsumer;
        }

        @Override
        public void consume(IItem item) {
            if (this.p.evaluate(item)) {
                this.nestedConsumer.consume(item);
            }
        }

        @Override
        public FilterConsumer<C> merge(FilterConsumer<C> other) {
            this.nestedConsumer.merge(other.nestedConsumer);
            return this;
        }
    }

    public static class CountConsumer
    implements IItemConsumer<CountConsumer> {
        private int count = 0;

        @Override
        public void consume(IItem item) {
            ++this.count;
        }

        @Override
        public CountConsumer merge(CountConsumer other) {
            this.count += other.count;
            return this;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static abstract class MinMax<V extends Comparable<V>>
    extends FieldAggregatorBase<V, MinMaxConsumer<V>> {
        private final boolean max;

        MinMax(String name, String description, ContentType<V> ct, boolean max) {
            super(name, description, ct);
            this.max = max;
        }

        @Override
        public MinMaxConsumer<V> newItemConsumer(IType<IItem> type) {
            return new MinMaxConsumer(this.getAccessor(type), this.max);
        }

        @Override
        public V getValue(MinMaxConsumer<V> consumer) {
            return (V)((MinMaxConsumer)consumer).value;
        }
    }

    public static class MinMaxConsumer<V extends Comparable<V>>
    implements IItemConsumer<MinMaxConsumer<V>> {
        private final IMemberAccessor<? extends V, IItem> accessor;
        private final boolean max;
        private V value;
        private IItem item;

        public MinMaxConsumer(IMemberAccessor<? extends V, IItem> accessor, boolean max) {
            this.accessor = accessor;
            this.max = max;
        }

        @Override
        public void consume(IItem item) {
            this.add((Comparable)this.accessor.getMember(item), item);
        }

        private void add(V newValue, IItem newItem) {
            if (newValue != null && (this.value == null || newValue.compareTo(this.value) > 0 == this.max)) {
                this.value = newValue;
                this.item = newItem;
            }
        }

        @Override
        public MinMaxConsumer<V> merge(MinMaxConsumer<V> other) {
            this.add(other.value, other.item);
            return this;
        }
    }

    public static abstract class Avg
    extends FieldAggregatorBase<IQuantity, AvgConsumer> {
        public Avg(String name, String description, ContentType<IQuantity> ct) {
            super(name, description, ct);
        }

        @Override
        public AvgConsumer newItemConsumer(IType<IItem> type) {
            return new AvgConsumer(this.getAccessor(type));
        }

        @Override
        public IQuantity getValue(AvgConsumer consumer) {
            return consumer.unit == null ? null : consumer.unit.quantity(consumer.sum / (double)consumer.count);
        }
    }

    public static class AvgConsumer
    extends QuantityConsumer<AvgConsumer> {
        public double sum = 0.0;
        public IUnit unit = null;
        public int count = 0;

        public AvgConsumer(IMemberAccessor<? extends IQuantity, IItem> accessor) {
            super(accessor);
        }

        @Override
        public void consume(IItem item) {
            IQuantity fieldValue = (IQuantity)this.accessor.getMember(item);
            if (fieldValue == null) {
                ++this.count;
                return;
            }
            if (this.unit == null) {
                this.unit = fieldValue.getUnit();
            }
            this.sum += fieldValue.doubleValueIn(this.unit);
            ++this.count;
        }

        @Override
        public AvgConsumer merge(AvgConsumer other) {
            if (this.unit == null) {
                this.unit = other.unit;
            }
            if (this.unit != null) {
                if (other.unit != null) {
                    this.sum += other.unit.valueTransformTo(this.unit).targetValue(other.sum);
                    this.count += other.count;
                }
                return this;
            }
            return other;
        }
    }

    public static class VarianceConsumer
    extends QuantityConsumer<VarianceConsumer> {
        public long n = 0L;
        public double mean = 0.0;
        public double M2 = 0.0;
        public IUnit unit = null;

        public VarianceConsumer(IMemberAccessor<? extends IQuantity, IItem> accessor) {
            super(accessor);
        }

        public Number getVariance(boolean besselCorrection) {
            long divisor;
            long l = divisor = besselCorrection ? this.n - 1L : this.n;
            if (divisor < 0L) {
                return null;
            }
            if (divisor == 0L) {
                return besselCorrection ? null : Integer.valueOf(0);
            }
            return this.M2 / (double)divisor;
        }

        public Number getStddev(boolean besselCorrection) {
            Number variance = this.getVariance(besselCorrection);
            if (variance == null) {
                return null;
            }
            return Math.sqrt(variance.doubleValue());
        }

        @Override
        public void consume(IItem item) {
            IQuantity fieldValue = (IQuantity)this.accessor.getMember(item);
            ++this.n;
            if (fieldValue == null) {
                return;
            }
            if (this.unit == null) {
                this.unit = fieldValue.getUnit();
            }
            double x = fieldValue.doubleValueIn(this.unit);
            double delta = x - this.mean;
            this.mean += delta / (double)this.n;
            this.M2 += delta * (x - this.mean);
        }

        @Override
        public VarianceConsumer merge(VarianceConsumer other) {
            if (this.unit == null) {
                this.unit = other.unit;
            }
            if (this.unit != null) {
                if (other.unit != null) {
                    double otherMean = other.unit.valueTransformTo(this.unit).targetValue(other.mean);
                    double otherM2 = other.unit.valueTransformTo(this.unit).targetValue(other.M2);
                    double deltaMean = otherMean - this.mean;
                    this.mean += deltaMean * ((double)other.n / (double)(other.n + this.n));
                    this.M2 = otherM2 + this.M2 + deltaMean * deltaMean * ((double)(other.n * this.n) / (double)(this.n + other.n));
                    this.n += other.n;
                }
                return this;
            }
            return other;
        }
    }

    public static abstract class Stddev
    extends FieldAggregatorBase<IQuantity, VarianceConsumer> {
        private final boolean besselCorrection;

        public Stddev(String name, String description, LinearKindOfQuantity ct, boolean besselCorrection) {
            super(name, description, ct);
            this.besselCorrection = besselCorrection;
        }

        @Override
        public VarianceConsumer newItemConsumer(IType<IItem> type) {
            return new VarianceConsumer(this.getAccessor(type));
        }

        @Override
        public IQuantity getValue(VarianceConsumer consumer) {
            if (consumer.unit == null) {
                return null;
            }
            Number stddev = consumer.getStddev(this.besselCorrection);
            return stddev == null ? null : consumer.unit.quantity(stddev);
        }
    }

    public static abstract class Variance
    extends FieldAggregatorBase<IQuantity, VarianceConsumer> {
        private final boolean besselCorrection;

        public Variance(String name, String description, LinearKindOfQuantity ct, boolean besselCorrection) {
            super(name, description, ct);
            this.besselCorrection = besselCorrection;
        }

        @Override
        public VarianceConsumer newItemConsumer(IType<IItem> type) {
            return new VarianceConsumer(this.getAccessor(type));
        }

        @Override
        public IQuantity getValue(VarianceConsumer consumer) {
            if (consumer.unit == null) {
                return null;
            }
            Number variance = consumer.getVariance(this.besselCorrection);
            return variance == null ? null : consumer.unit.quantity(variance);
        }
    }

    public static abstract class Sum
    extends FieldAggregatorBase<IQuantity, SumConsumer> {
        public Sum(String name, String description, LinearKindOfQuantity ct) {
            super(name, description, ct);
        }

        @Override
        public SumConsumer newItemConsumer(IType<IItem> type) {
            return new SumConsumer(this.getAccessor(type));
        }

        @Override
        public IQuantity getValue(SumConsumer consumer) {
            return consumer.unit != null ? consumer.unit.quantity(consumer.sum) : null;
        }
    }

    private static class SumConsumer
    extends QuantityConsumer<SumConsumer> {
        double sum = 0.0;
        IUnit unit = null;

        SumConsumer(IMemberAccessor<? extends IQuantity, IItem> accessor) {
            super(accessor);
        }

        @Override
        public void consume(IItem item) {
            IQuantity fieldValue = (IQuantity)this.accessor.getMember(item);
            if (this.unit == null) {
                this.unit = fieldValue.getUnit();
            }
            this.sum += fieldValue.doubleValueIn(this.unit);
        }

        @Override
        public SumConsumer merge(SumConsumer other) {
            if (this.unit != null) {
                if (other.unit != null) {
                    this.sum += other.unit.valueTransformTo(this.unit).targetValue(other.sum);
                }
                return this;
            }
            return other;
        }
    }

    private static abstract class QuantityConsumer<C>
    implements IItemConsumer<C> {
        IMemberAccessor<? extends IQuantity, IItem> accessor;

        QuantityConsumer(IMemberAccessor<? extends IQuantity, IItem> accessor) {
            this.accessor = accessor;
        }
    }

    public static abstract class FieldAggregatorBase<V, C extends IItemConsumer<C>>
    extends MergingAggregator<V, C> {
        FieldAggregatorBase(String name, String description, IType<V> ct) {
            super(name, description, ct);
        }

        @Override
        public boolean acceptType(IType<IItem> type) {
            IMemberAccessor<V, IItem> a = this.doGetAccessor(type);
            return a != null;
        }

        protected abstract IMemberAccessor<? extends V, IItem> doGetAccessor(IType<IItem> var1);

        IMemberAccessor<? extends V, IItem> getAccessor(IType<IItem> type) {
            IMemberAccessor<V, IItem> ma = this.doGetAccessor(type);
            if (ma != null) {
                return ma;
            }
            throw new IllegalArgumentException("IAggregator.acceptType must be called before newValueConsumer");
        }
    }

    public static abstract class MergingAggregator<V, C extends IItemConsumer<C>>
    extends AggregatorBase<V, C> {
        public MergingAggregator(String name, String description, IType<? super V> ct) {
            super(name, description, ct);
        }

        @Override
        public V getValue(Iterator<C> consumers) {
            if (consumers.hasNext()) {
                IItemConsumer consumer = (IItemConsumer)consumers.next();
                while (consumers.hasNext()) {
                    IItemConsumer next = (IItemConsumer)consumers.next();
                    consumer = consumer.merge(next);
                }
                return this.getValue((C)consumer);
            }
            return null;
        }

        @Override
        public abstract V getValue(C var1);
    }

    public static abstract class AggregatorBase<V, C extends IItemConsumer<C>>
    implements IAggregator<V, C> {
        private final String name;
        private final String description;
        private final IType<? super V> ct;

        public AggregatorBase(String name, String description, IType<? super V> ct) {
            this.name = name;
            this.description = description;
            this.ct = ct;
        }

        @Override
        public IType<? super V> getValueType() {
            return this.ct;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

