/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jvmstat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.datasupport.DataRemovedListener;
import org.graalvm.visualvm.jvmstat.MonitoredValueImpl;
import org.graalvm.visualvm.jvmstat.Utils;
import org.graalvm.visualvm.tools.jvmstat.JvmstatListener;
import org.graalvm.visualvm.tools.jvmstat.JvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.MonitoredValue;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.event.MonitorStatusChangeEvent;
import sun.jvmstat.monitor.event.VmEvent;
import sun.jvmstat.monitor.event.VmListener;

public class JvmstatModelImpl
extends JvmstatModel
implements VmListener,
DataRemovedListener<Application> {
    private static final String Variability_CONSTANT = "Constant";
    Application application;
    MonitoredVm monitoredVm;
    Set<JvmstatListener> listeners;
    private Map<String, String> valueCache;
    private Integer pid;
    private MonitoredHost monitoredHost;

    JvmstatModelImpl(Application app, MonitoredVm vm) {
        this.application = app;
        this.pid = vm.getVmIdentifier().getLocalVmId();
        this.monitoredVm = vm;
        this.valueCache = new HashMap<String, String>();
        this.listeners = new HashSet<JvmstatListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJvmstatListener(JvmstatListener l) {
        Set<JvmstatListener> set = this.listeners;
        synchronized (set) {
            if (this.listeners.isEmpty()) {
                this.initListeners();
            }
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJvmstatListener(JvmstatListener l) {
        Set<JvmstatListener> set = this.listeners;
        synchronized (set) {
            if (!this.listeners.isEmpty()) {
                this.listeners.remove(l);
                if (this.listeners.isEmpty()) {
                    this.disableListeners();
                }
            }
        }
    }

    public String findByName(String name) {
        String value = this.valueCache.get(name);
        if (value != null) {
            return value;
        }
        try {
            Monitor mon = this.monitoredVm.findByName(name);
            if (mon != null) {
                value = mon.getValue().toString();
                if (Utils.getVariability(mon).toString().equals(Variability_CONSTANT)) {
                    this.valueCache.put(name, value);
                }
            }
            return value;
        }
        catch (MonitorException ex) {
            ErrorManager.getDefault().notify(16, (Throwable)ex);
            return null;
        }
    }

    public MonitoredValue findMonitoredValueByName(String name) {
        try {
            Monitor mon = this.monitoredVm.findByName(name);
            if (mon != null) {
                return new MonitoredValueImpl(mon);
            }
        }
        catch (MonitorException ex) {
            ErrorManager.getDefault().notify(16, (Throwable)ex);
        }
        return null;
    }

    public List<String> findByPattern(String pattern) {
        try {
            List<Monitor> monitorList = this.monitoredVm.findByPattern(pattern);
            ArrayList<String> monitorStrList = new ArrayList<String>(monitorList.size());
            for (Monitor monitor : monitorList) {
                monitorStrList.add(monitor.getValue().toString());
            }
            return monitorStrList;
        }
        catch (MonitorException ex) {
            ErrorManager.getDefault().notify(16, (Throwable)ex);
            return null;
        }
    }

    public List<MonitoredValue> findMonitoredValueByPattern(String pattern) {
        try {
            List<Monitor> monitorList = this.monitoredVm.findByPattern(pattern);
            ArrayList<MonitoredValue> monitoredValueList = new ArrayList<MonitoredValue>(monitorList.size());
            for (Monitor monitor : monitorList) {
                monitoredValueList.add(new MonitoredValueImpl(monitor));
            }
            return monitoredValueList;
        }
        catch (MonitorException ex) {
            ErrorManager.getDefault().notify(16, (Throwable)ex);
            return null;
        }
    }

    void initListeners() {
        try {
            this.monitoredHost = MonitoredHost.getMonitoredHost(this.monitoredVm.getVmIdentifier());
            this.monitoredVm.addVmListener(this);
        }
        catch (MonitorException ex) {
            ErrorManager.getDefault().notify(16, (Throwable)ex);
        }
    }

    void disableListeners() {
        try {
            this.monitoredVm.removeVmListener(this);
        }
        catch (MonitorException ex) {
            ErrorManager.getDefault().notify(16, (Throwable)ex);
        }
        this.monitoredHost = null;
    }

    @Override
    public void monitorStatusChanged(MonitorStatusChangeEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitorsUpdated(VmEvent event) {
        block8: {
            assert (event.getMonitoredVm().equals(this.monitoredVm));
            try {
                if (this.monitoredHost.activeVms().contains(this.pid)) {
                    ArrayList<JvmstatListener> listenersCopy;
                    Set<JvmstatListener> set = this.listeners;
                    synchronized (set) {
                        listenersCopy = new ArrayList<JvmstatListener>(this.listeners);
                    }
                    for (JvmstatListener listener : listenersCopy) {
                        listener.dataChanged((JvmstatModel)this);
                    }
                    break block8;
                }
                this.disableListeners();
                this.monitoredVm.detach();
            }
            catch (MonitorException ex) {
                ErrorManager.getDefault().notify(16, (Throwable)ex);
                this.disableListeners();
                this.monitoredVm.detach();
            }
        }
    }

    @Override
    public void disconnected(VmEvent event) {
        ErrorManager.getDefault().log("Disconnect " + event.getMonitoredVm().getVmIdentifier());
        this.disableListeners();
        this.monitoredVm.detach();
    }

    public void dataRemoved(Application dataSource) {
        new RequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                JvmstatModelImpl.this.disableListeners();
                JvmstatModelImpl.this.monitoredVm.detach();
            }
        });
    }

    public String getConnectionId() {
        return this.monitoredVm.getVmIdentifier().getURI().toString();
    }
}

