/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.openide.util.Parameters;

abstract class CachedHiDPIIcon
implements Icon {
    private static final double MAX_CACHE_SIZE = 10.0;
    private final int width;
    private final int height;
    private final Map<CachedImageKey, Image> cache = new LinkedHashMap<CachedImageKey, Image>(16, 0.75f, true);
    private double cacheSize = 0.0;

    protected CachedHiDPIIcon(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.width = n;
        this.height = n2;
    }

    private synchronized Image getScaledImageCached(Component component, CachedImageKey cachedImageKey) {
        Image image = this.cache.get(cachedImageKey);
        if (image != null) {
            return image;
        }
        double d = cachedImageKey.getScale();
        int n = (int)Math.ceil((double)this.getIconWidth() * d);
        int n2 = (int)Math.ceil((double)this.getIconHeight() * d);
        Image image2 = this.createImage(component, cachedImageKey.getGraphicsConfiguration(), n, n2, d);
        double d2 = cachedImageKey.getSize();
        if (d2 <= 10.0) {
            Iterator<CachedImageKey> iterator = this.cache.keySet().iterator();
            while (this.cacheSize + d2 > 10.0 && iterator.hasNext()) {
                CachedImageKey cachedImageKey2 = iterator.next();
                iterator.remove();
                this.cacheSize -= cachedImageKey2.getSize();
            }
            this.cache.put(cachedImageKey, image2);
            this.cacheSize += d2;
        }
        return image2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        CachedImageKey cachedImageKey = CachedImageKey.create(graphics2D);
        AffineTransform affineTransform = graphics2D.getTransform();
        try {
            graphics2D.translate(n, n2);
            Image image = this.getScaledImageCached(component, cachedImageKey);
            AffineTransform affineTransform2 = graphics2D.getTransform();
            graphics2D.setTransform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, (int)affineTransform2.getTranslateX(), (int)affineTransform2.getTranslateY()));
            graphics2D.drawImage(image, 0, 0, null);
        }
        finally {
            graphics2D.setTransform(affineTransform);
        }
    }

    @Override
    public final int getIconWidth() {
        return this.width;
    }

    @Override
    public final int getIconHeight() {
        return this.height;
    }

    protected abstract Image createImage(Component var1, GraphicsConfiguration var2, int var3, int var4, double var5);

    private static final class CachedImageKey {
        private final GraphicsConfiguration gconf;
        private final double scale;

        public CachedImageKey(GraphicsConfiguration graphicsConfiguration, double d) {
            Parameters.notNull((CharSequence)"gconf", (Object)graphicsConfiguration);
            if (d <= 0.0) {
                throw new IllegalArgumentException();
            }
            this.gconf = graphicsConfiguration;
            this.scale = d;
        }

        public static CachedImageKey create(Graphics2D graphics2D) {
            AffineTransform affineTransform = graphics2D.getTransform();
            int n = affineTransform.getType();
            double d = n == 2 || n == 3 ? affineTransform.getScaleX() : 1.0;
            return new CachedImageKey(graphics2D.getDeviceConfiguration(), d);
        }

        public double getScale() {
            return this.scale;
        }

        public double getSize() {
            return Math.pow(this.getScale(), 2.0);
        }

        public GraphicsConfiguration getGraphicsConfiguration() {
            return this.gconf;
        }

        public int hashCode() {
            return Objects.hash(this.gconf, this.scale);
        }

        public boolean equals(Object object) {
            if (!(object instanceof CachedImageKey)) {
                return false;
            }
            CachedImageKey cachedImageKey = (CachedImageKey)object;
            return this.gconf.equals(cachedImageKey.gconf) && this.scale == cachedImageKey.scale;
        }
    }
}

