/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hotspot.libgraal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.graal.hotspot.libgraal.LibGraalFeature;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URL;
import java.util.function.BooleanSupplier;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;

@TargetClass(className="org.graalvm.compiler.hotspot.management.libgraal.HotSpotGraalManagement", onlyWith={LibGraalFeature.IsEnabled.class, IsEnabled.class})
final class Target_org_graalvm_compiler_hotspot_management_libgraal_HotSpotGraalManagement {
    @Alias
    @ClassData(value="org.graalvm.compiler.hotspot.management.libgraal.runtime.SVMHotSpotGraalRuntimeMBean")
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ClassNameComputer.class, isFinal=true)
    private static String HS_BEAN_CLASS_NAME;
    @Alias
    @ClassData(value="org.graalvm.compiler.hotspot.management.libgraal.runtime.SVMHotSpotGraalRuntimeMBean")
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ClassDataComputer.class, isFinal=true)
    private static byte[] HS_BEAN_CLASS;
    @Alias
    @ClassData(value="org.graalvm.compiler.hotspot.management.libgraal.runtime.SVMHotSpotGraalRuntimeMBean$Factory")
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ClassNameComputer.class, isFinal=true)
    private static String HS_BEAN_FACTORY_CLASS_NAME;
    @Alias
    @ClassData(value="org.graalvm.compiler.hotspot.management.libgraal.runtime.SVMHotSpotGraalRuntimeMBean$Factory")
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ClassDataComputer.class, isFinal=true)
    private static byte[] HS_BEAN_FACTORY_CLASS;
    @Alias
    @ClassData(value="org.graalvm.compiler.hotspot.management.libgraal.runtime.SVMHotSpotGraalRuntimeMBean$PushBackIterator")
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ClassNameComputer.class, isFinal=true)
    private static String HS_PUSHBACK_ITER_CLASS_NAME;
    @Alias
    @ClassData(value="org.graalvm.compiler.hotspot.management.libgraal.runtime.SVMHotSpotGraalRuntimeMBean$PushBackIterator")
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ClassDataComputer.class, isFinal=true)
    private static byte[] HS_PUSHBACK_ITER_CLASS;
    @Alias
    @ClassData(value="org.graalvm.compiler.hotspot.management.libgraal.runtime.HotSpotToSVMCalls")
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ClassNameComputer.class, isFinal=true)
    private static String HS_SVM_CALLS_CLASS_NAME;
    @Alias
    @ClassData(value="org.graalvm.compiler.hotspot.management.libgraal.runtime.HotSpotToSVMCalls")
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ClassDataComputer.class, isFinal=true)
    private static byte[] HS_SVM_CALLS_CLASS;
    @Alias
    @ClassData(value="org.graalvm.compiler.hotspot.management.libgraal.runtime.SVMToHotSpotEntryPoints")
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ClassNameComputer.class, isFinal=true)
    private static String SVM_HS_ENTRYPOINTS_CLASS_NAME;
    @Alias
    @ClassData(value="org.graalvm.compiler.hotspot.management.libgraal.runtime.SVMToHotSpotEntryPoints")
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ClassDataComputer.class, isFinal=true)
    private static byte[] SVM_HS_ENTRYPOINTS_CLASS;

    Target_org_graalvm_compiler_hotspot_management_libgraal_HotSpotGraalManagement() {
    }

    static final class IsEnabled
    implements BooleanSupplier {
        IsEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            try {
                Class.forName("org.graalvm.compiler.hotspot.management.libgraal.HotSpotGraalManagement", false, Thread.currentThread().getContextClassLoader());
                return true;
            }
            catch (ReflectiveOperationException e) {
                return false;
            }
        }
    }

    static final class ClassNameComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        ClassNameComputer() {
        }

        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            ClassData classData = (ClassData)annotated.getAnnotation(ClassData.class);
            if (classData == null || classData.value() == null) {
                throw UserError.abort((String)"ClassData must be given");
            }
            return classData.value().replace('.', '/');
        }
    }

    static final class ClassDataComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        ClassDataComputer() {
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            ClassData classData = (ClassData)annotated.getAnnotation(ClassData.class);
            if (classData == null || classData.value() == null) {
                throw UserError.abort((String)"ClassData must be given");
            }
            URL url = Thread.currentThread().getContextClassLoader().getResource(classData.value().replace('.', '/') + ".class");
            if (url == null) {
                throw UserError.abort((String)"Cannot find SVMHotSpotGraalRuntimeMBean class");
            }
            try (InputStream in = url.openStream();){
                byte[] byArray;
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    int len;
                    byte[] buffer = new byte[4096];
                    while ((len = in.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    byArray = out.toByteArray();
                }
                return byArray;
            }
            catch (IOException ioe) {
                throw UserError.abort((String)("Cannot load SVMHotSpotGraalRuntimeMBean class due to: " + ioe.getMessage()));
            }
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface ClassData {
        public String value();
    }
}

