/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.graalvm.visualvm.lib.common.Profiler;
import org.graalvm.visualvm.lib.profiler.actions.Bundle;
import org.graalvm.visualvm.lib.profiler.api.JavaPlatform;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;

public final class JavaPlatformSelector
extends JPanel
implements ListSelectionListener,
HelpCtx.Provider {
    private static final String HELP_CTX_KEY = "JavaPlatformSelector.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("JavaPlatformSelector.HelpCtx");
    private static JavaPlatformSelector defaultPlatform;
    private JLabel noteLabel;
    private JButton okButton = new JButton(Bundle.JavaPlatformSelector_OkButtonName());
    private JCheckBox alwaysCheckBox;
    private JList list;

    private JavaPlatformSelector() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.list = new JList();
        this.list.setVisibleRowCount(6);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        this.list.getAccessibleContext().setAccessibleName(Bundle.JavaPlatformSelector_ListAccessName());
        this.noteLabel = new JLabel();
        this.noteLabel.setLabelFor(this.list);
        this.noteLabel.setFocusable(false);
        this.alwaysCheckBox = new JCheckBox(Bundle.JavaPlatformSelector_UseSelPlatformChckBoxName(), false);
        this.add((Component)new JScrollPane(this.list){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = Math.max(d.width, 400);
                return d;
            }
        }, "Center");
        this.add((Component)this.noteLabel, "North");
        this.add((Component)this.alwaysCheckBox, "South");
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public static synchronized JavaPlatformSelector getDefault() {
        if (defaultPlatform == null) {
            defaultPlatform = new JavaPlatformSelector();
        }
        return defaultPlatform;
    }

    public JavaPlatform selectPlatformForCalibration() {
        List platforms = JavaPlatform.getPlatforms();
        if (platforms.size() == 0) {
            ProfilerDialogs.displayError((String)Bundle.JavaPlatformSelector_NoSupportedPlatformMsg());
            JavaPlatform.showCustomizer();
            return null;
        }
        this.noteLabel.setText(Bundle.JavaPlatformSelector_SelectPlatformCalibrateMsg());
        this.noteLabel.getAccessibleContext().setAccessibleName(Bundle.JavaPlatformSelector_SelectPlatformCalibrateMsg());
        this.list.getAccessibleContext().setAccessibleDescription(Bundle.JavaPlatformSelector_SelectPlatformCalibrateMsg());
        this.list.setModel(new JPListModel(platforms));
        this.alwaysCheckBox.setVisible(false);
        DialogDescriptor dd = new DialogDescriptor((Object)this, Bundle.JavaPlatformSelector_SelectPlatformCalibrateDialogCaption(), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, null, null);
        this.list.setSelectedIndex(0);
        this.validateOKButton();
        Dialog selectDialog = DialogDisplayer.getDefault().createDialog(dd);
        selectDialog.getAccessibleContext().setAccessibleDescription(Bundle.JavaPlatformSelector_SelectPlatformCalibrateDialogCaption());
        selectDialog.setVisible(true);
        if (dd.getValue() == this.okButton) {
            int idx = this.list.getSelectedIndex();
            return (JavaPlatform)platforms.get(idx);
        }
        return null;
    }

    public JavaPlatform selectPlatformToUse() {
        List platforms = JavaPlatform.getPlatforms();
        if (platforms.size() == 0) {
            ProfilerDialogs.displayError((String)Bundle.JavaPlatformSelector_NoSupportedPlatformMsg());
            JavaPlatform.showCustomizer();
            return null;
        }
        this.noteLabel.setText("<html>" + Bundle.JavaPlatformSelector_CannotUsePlatform() + "<br>" + Bundle.JavaPlatformSelector_SelectPlatformProfileMsg() + "</html>");
        this.noteLabel.getAccessibleContext().setAccessibleName(Bundle.JavaPlatformSelector_CannotUsePlatform() + Bundle.JavaPlatformSelector_SelectPlatformProfileMsg());
        this.list.getAccessibleContext().setAccessibleDescription(Bundle.JavaPlatformSelector_CannotUsePlatform() + Bundle.JavaPlatformSelector_SelectPlatformCalibrateMsg());
        this.list.setModel(new JPListModel(platforms));
        this.alwaysCheckBox.setSelected(false);
        this.alwaysCheckBox.setVisible(true);
        DialogDescriptor dd = new DialogDescriptor((Object)this, Bundle.JavaPlatformSelector_SelectPlatformProfileDialogCaption(), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, null, null);
        this.list.setSelectedIndex(0);
        this.validateOKButton();
        DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
        if (dd.getValue() == this.okButton) {
            int idx = this.list.getSelectedIndex();
            JavaPlatform plat = (JavaPlatform)platforms.get(idx);
            if (this.alwaysCheckBox.isSelected()) {
                Profiler.getDefault().getGlobalProfilingSettings().setJavaPlatformForProfiling(plat == null ? null : plat.getDisplayName());
            }
            return plat;
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.validateOKButton();
    }

    private void validateOKButton() {
        this.okButton.setEnabled(this.list.getSelectedIndex() != -1);
    }

    public static class JPListModel
    extends AbstractListModel {
        private List<JavaPlatform> platforms;

        private JPListModel(List platforms) {
            this.platforms = platforms;
        }

        @Override
        public Object getElementAt(int index) {
            return this.platforms.get(index).getDisplayName();
        }

        @Override
        public int getSize() {
            return this.platforms.size();
        }
    }
}

