/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.Runner;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DefaultLoader
extends LLVMLanguage.Loader {
    private volatile List<LLVMParserResult> cachedDefaultDependencies;
    private volatile LLVMContext.ExternalLibrary[] cachedSulongLibraries;

    private synchronized void parseDefaultDependencies(Runner runner) {
        if (this.cachedDefaultDependencies == null) {
            ArrayList<LLVMParserResult> parserResults = new ArrayList<LLVMParserResult>();
            this.cachedSulongLibraries = runner.parseDefaultLibraries(parserResults);
            parserResults.trimToSize();
            this.cachedDefaultDependencies = Collections.unmodifiableList(parserResults);
        }
    }

    LLVMContext.ExternalLibrary[] getDefaultDependencies(Runner runner, List<LLVMParserResult> parserResults) {
        if (this.cachedDefaultDependencies == null) {
            this.parseDefaultDependencies(runner);
        }
        parserResults.addAll(this.cachedDefaultDependencies);
        return this.cachedSulongLibraries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallTarget load(LLVMContext context, Source source) {
        LLVMScope lLVMScope = context.getGlobalScope();
        synchronized (lLVMScope) {
            return new Runner(context, this).parse(source);
        }
    }
}

