/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.llvm.DefaultLoader;
import com.oracle.truffle.llvm.NativeConfigurationFactory;
import com.oracle.truffle.llvm.NativeToolchainConfig;
import com.oracle.truffle.llvm.parser.factories.BasicIntrinsicsProvider;
import com.oracle.truffle.llvm.parser.factories.BasicNodeFactory;
import com.oracle.truffle.llvm.parser.factories.BasicPlatformCapability;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMIntrinsicProvider;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NFIContextExtension;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.ToolchainConfig;
import com.oracle.truffle.llvm.runtime.config.Configuration;
import com.oracle.truffle.llvm.runtime.config.LLVMCapability;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.memory.LLVMNativeMemory;
import com.oracle.truffle.llvm.runtime.memory.UnsafeArrayAccess;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import java.util.ArrayList;
import java.util.List;

public final class NativeConfiguration
implements Configuration {
    private final LLVMLanguage.Loader loader = new DefaultLoader();
    private final LLVMIntrinsicProvider intrinsicProvider;
    private final PlatformCapability<?> platformCapability;

    NativeConfiguration(LLVMLanguage language, NativeConfigurationFactory.Key key) {
        this.intrinsicProvider = new BasicIntrinsicsProvider(language);
        this.platformCapability = BasicPlatformCapability.create(key.loadCxxLibraries);
    }

    @Override
    public NodeFactory createNodeFactory(LLVMContext context, DataLayout dataLayout) {
        return new BasicNodeFactory(context, dataLayout);
    }

    @Override
    public List<ContextExtension> createContextExtensions(TruffleLanguage.Env env) {
        ArrayList<ContextExtension> result = new ArrayList<ContextExtension>();
        if (((Boolean)env.getOptions().get(SulongEngineOption.ENABLE_NFI)).booleanValue()) {
            result.add(new NFIContextExtension(env));
        }
        return result;
    }

    @Override
    public <C extends LLVMCapability> C getCapability(Class<C> type) {
        if (type == LLVMMemory.class) {
            return (C)((LLVMCapability)type.cast(LLVMNativeMemory.getInstance()));
        }
        if (type == UnsafeArrayAccess.class) {
            return (C)((LLVMCapability)type.cast(UnsafeArrayAccess.getInstance()));
        }
        if (type == ToolchainConfig.class) {
            return (C)((LLVMCapability)type.cast(NativeToolchainConfig.getInstance()));
        }
        if (type == LLVMLanguage.Loader.class) {
            return (C)((LLVMCapability)type.cast(this.loader));
        }
        if (type == LLVMIntrinsicProvider.class) {
            return (C)((LLVMCapability)type.cast(this.intrinsicProvider));
        }
        if (type == PlatformCapability.class) {
            return (C)((LLVMCapability)type.cast(this.platformCapability));
        }
        return null;
    }
}

