/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.DefaultLoader;
import com.oracle.truffle.llvm.parser.LLVMParser;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.StackManager;
import com.oracle.truffle.llvm.parser.binary.BinaryParser;
import com.oracle.truffle.llvm.parser.binary.BinaryParserResult;
import com.oracle.truffle.llvm.parser.model.ModelModule;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.functions.FunctionSymbol;
import com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate.ArrayConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate.StructureConstant;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.parser.model.target.TargetDataLayout;
import com.oracle.truffle.llvm.parser.nodes.LLVMSymbolReadResolver;
import com.oracle.truffle.llvm.parser.scanner.LLVMScanner;
import com.oracle.truffle.llvm.parser.util.Pair;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.LLVMAlias;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMIntrinsicProvider;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.NFIContextExtension;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.SulongLibrary;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.memory.LLVMAllocateNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemoryOpNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMHasDatalayoutNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMVoidStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMVoidStatementNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMGlobalRootNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMStatementRootNode;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.polyglot.io.ByteSequence;

final class Runner {
    private static final String MAIN_METHOD_NAME = "main";
    private static final String START_METHOD_NAME = "_start";
    private static final String CONSTRUCTORS_VARNAME = "llvm.global_ctors";
    private static final String DESTRUCTORS_VARNAME = "llvm.global_dtors";
    private static final int LEAST_CONSTRUCTOR_PRIORITY = 65535;
    private static final Comparator<Pair<Integer, ?>> ASCENDING_PRIORITY = (p1, p2) -> (Integer)p1.getFirst() - (Integer)p2.getFirst();
    private static final Comparator<Pair<Integer, ?>> DESCENDING_PRIORITY = (p1, p2) -> (Integer)p2.getFirst() - (Integer)p1.getFirst();
    private final LLVMContext context;
    private final DefaultLoader loader;
    private final LLVMLanguage language;

    Runner(LLVMContext context, DefaultLoader loader) {
        this.context = context;
        this.loader = loader;
        this.language = context.getLanguage();
    }

    CallTarget parse(Source source) {
        LLVMContext.ExternalLibrary library;
        ByteSequence bytes;
        if (source.hasBytes()) {
            bytes = source.getBytes();
            library = source.getPath() != null ? new LLVMContext.ExternalLibrary(this.context.getEnv().getInternalTruffleFile(source.getPath()), false, source.isInternal()) : new LLVMContext.ExternalLibrary("<STREAM-" + UUID.randomUUID().toString() + ">", false, source.isInternal());
        } else if (source.hasCharacters()) {
            switch (source.getMimeType()) {
                case "application/x-llvm-ir-bitcode-base64": {
                    bytes = ByteSequence.create((byte[])Runner.decodeBase64(source.getCharacters()));
                    library = new LLVMContext.ExternalLibrary("<STREAM-" + UUID.randomUUID().toString() + ">", false, source.isInternal());
                    break;
                }
                default: {
                    throw new LLVMParserException("Character-based source with unexpected mime type: " + source.getMimeType());
                }
            }
        } else {
            throw new LLVMParserException("Should not reach here: Source is neither char-based nor byte-based!");
        }
        return this.parse(source, bytes, library);
    }

    private CallTarget parse(Source source, ByteSequence bytes, LLVMContext.ExternalLibrary library) {
        ArrayList<LLVMParserResult> parserResults = new ArrayList<LLVMParserResult>();
        ArrayDeque<LLVMContext.ExternalLibrary> dependencyQueue = new ArrayDeque<LLVMContext.ExternalLibrary>();
        this.parse(parserResults, dependencyQueue, source, library, bytes);
        assert (!library.isNative() && !parserResults.isEmpty());
        LLVMContext.ExternalLibrary[] sulongLibraries = this.parseDependencies(parserResults, dependencyQueue);
        assert (dependencyQueue.isEmpty());
        this.addExternalSymbolsToScopes(parserResults);
        this.parseFunctionsEagerly(parserResults);
        InitializationOrder initializationOrder = this.computeInitializationOrder(parserResults, sulongLibraries);
        this.overrideSulongLibraryFunctionsWithIntrinsics(initializationOrder.sulongLibraries);
        return this.createLibraryCallTarget(source.getName(), parserResults, initializationOrder);
    }

    private static void addPaddingTypes(ArrayList<Type> result, int padding) {
        int size;
        assert (padding >= 0);
        for (int remaining = padding; remaining > 0; remaining -= size) {
            size = Math.min(8, Integer.highestOneBit(remaining));
            result.add(PrimitiveType.getIntegerType(size * 8));
        }
    }

    private static int getAlignment(DataLayout dataLayout, GlobalVariable global, Type type) {
        return global.getAlign() > 0 ? 1 << global.getAlign() - 1 : type.getAlignment(dataLayout);
    }

    private static boolean isSpecialGlobalSlot(Type type) {
        return type instanceof PointerType;
    }

    LLVMContext.ExternalLibrary[] parseDefaultLibraries(List<LLVMParserResult> parserResults) {
        ArrayDeque<LLVMContext.ExternalLibrary> dependencyQueue = new ArrayDeque<LLVMContext.ExternalLibrary>();
        String[] sulongLibraryNames = this.language.getCapability(PlatformCapability.class).getSulongDefaultLibraries();
        LLVMContext.ExternalLibrary[] sulongLibraries = new LLVMContext.ExternalLibrary[sulongLibraryNames.length];
        for (int i = 0; i < sulongLibraries.length; ++i) {
            sulongLibraries[i] = this.context.addInternalLibrary(sulongLibraryNames[i], false);
        }
        List<String> externals = SulongEngineOption.getPolyglotOptionExternalLibraries(this.context.getEnv());
        for (String external : externals) {
            LLVMContext.ExternalLibrary lib = this.context.addExternalLibrary(external, true, "<command line>");
            if (lib == null) continue;
            this.parse(parserResults, dependencyQueue, lib);
        }
        LLVMParserResult[] sulongLibraryResults = new LLVMParserResult[sulongLibraries.length];
        for (int i = 0; i < sulongLibraries.length; ++i) {
            sulongLibraryResults[i] = this.parse(parserResults, dependencyQueue, sulongLibraries[i]);
            if (!sulongLibraries[i].getName().equalsIgnoreCase("libsulong")) continue;
            this.context.addLibsulongDataLayout(sulongLibraryResults[i].getDataLayout());
        }
        while (!dependencyQueue.isEmpty()) {
            LLVMContext.ExternalLibrary lib = (LLVMContext.ExternalLibrary)dependencyQueue.removeFirst();
            this.parse(parserResults, dependencyQueue, lib);
        }
        this.updateOverriddenSymbols(sulongLibraryResults);
        Runner.resolveRenamedSymbols(sulongLibraryResults);
        return sulongLibraries;
    }

    private LLVMContext.ExternalLibrary[] parseDependencies(List<LLVMParserResult> parserResults, ArrayDeque<LLVMContext.ExternalLibrary> dependencyQueue) {
        LLVMContext.ExternalLibrary lib;
        int directDependencies = dependencyQueue.size();
        for (int i = 0; i < directDependencies; ++i) {
            lib = dependencyQueue.removeFirst();
            this.parse(parserResults, dependencyQueue, lib);
        }
        LLVMContext.ExternalLibrary[] sulongLibraries = this.loader.getDefaultDependencies(this, parserResults);
        while (!dependencyQueue.isEmpty()) {
            lib = dependencyQueue.removeFirst();
            this.parse(parserResults, dependencyQueue, lib);
        }
        return sulongLibraries;
    }

    private static void resolveRenamedSymbols(LLVMParserResult[] sulongLibraryResults) {
        EconomicMap scopes = EconomicMap.create();
        for (LLVMParserResult parserResult : sulongLibraryResults) {
            scopes.put((Object)parserResult.getRuntime().getLibrary().getName(), (Object)parserResult.getRuntime().getFileScope());
        }
        for (LLVMParserResult parserResult : sulongLibraryResults) {
            ListIterator<FunctionSymbol> it = parserResult.getExternalFunctions().listIterator();
            while (it.hasNext()) {
                String lib;
                LLVMScope scope;
                int idx;
                FunctionSymbol external = it.next();
                String name = external.getName();
                if (!name.startsWith("__") || (idx = name.indexOf(95, 2)) <= 0 || (scope = (LLVMScope)scopes.get((Object)(lib = name.substring(2, idx)))) == null) continue;
                String originalName = name.substring(idx + 1);
                LLVMFunctionDescriptor originalSymbol = scope.getFunction(originalName);
                LLVMAlias alias = new LLVMAlias(parserResult.getRuntime().getLibrary(), name, originalSymbol);
                parserResult.getRuntime().getFileScope().register(alias);
                it.remove();
            }
        }
    }

    private void updateOverriddenSymbols(LLVMParserResult[] sulongLibraryResults) {
        if (sulongLibraryResults.length > 1) {
            EconomicMap<LLVMSymbol, List<LLVMAlias>> usagesInAliases = Runner.computeUsagesInAliases(sulongLibraryResults);
            LLVMParserResult strongerLib = sulongLibraryResults[0];
            for (int i = 1; i < sulongLibraryResults.length; ++i) {
                LLVMParserResult weakerLib = sulongLibraryResults[i];
                this.overrideConflictingSymbols(weakerLib, strongerLib, usagesInAliases);
                weakerLib.getRuntime().getFileScope().addMissingEntries(strongerLib.getRuntime().getFileScope());
                strongerLib = weakerLib;
            }
        }
    }

    private static EconomicMap<LLVMSymbol, List<LLVMAlias>> computeUsagesInAliases(LLVMParserResult[] sulongLibraryResults) {
        EconomicMap usages = EconomicMap.create();
        for (LLVMParserResult parserResult : sulongLibraryResults) {
            for (LLVMSymbol symbol : parserResult.getRuntime().getFileScope().values()) {
                if (!(symbol instanceof LLVMAlias)) continue;
                LLVMAlias alias = (LLVMAlias)symbol;
                LLVMSymbol target = alias.getTarget();
                ArrayList<LLVMAlias> aliases = (ArrayList<LLVMAlias>)usages.get((Object)target);
                if (aliases == null) {
                    aliases = new ArrayList<LLVMAlias>();
                    usages.put((Object)target, aliases);
                }
                aliases.add(alias);
            }
        }
        return usages;
    }

    private void overrideConflictingSymbols(LLVMParserResult currentLib, LLVMParserResult strongerLib, EconomicMap<LLVMSymbol, List<LLVMAlias>> usagesInAliases) {
        LLVMScope globalScope = this.context.getGlobalScope();
        LLVMScope weakerScope = currentLib.getRuntime().getFileScope();
        LLVMScope strongerScope = strongerLib.getRuntime().getFileScope();
        for (LLVMSymbol strongerSymbol : strongerScope.values()) {
            List affectedAliases;
            boolean shouldOverride;
            String name = strongerSymbol.getName();
            LLVMSymbol weakerSymbol = weakerScope.get(name);
            if (weakerSymbol == null || !(shouldOverride = strongerSymbol.isFunction() || strongerSymbol.isGlobalVariable() && !strongerSymbol.asGlobalVariable().isReadOnly())) continue;
            if (globalScope.get(name) == weakerSymbol) {
                globalScope.rename(name, strongerSymbol);
            }
            if ((affectedAliases = (List)usagesInAliases.get((Object)weakerSymbol)) == null) continue;
            for (LLVMAlias alias : affectedAliases) {
                alias.setTarget(strongerSymbol);
            }
        }
    }

    private LLVMParserResult parse(List<LLVMParserResult> parserResults, ArrayDeque<LLVMContext.ExternalLibrary> dependencyQueue, LLVMContext.ExternalLibrary lib) {
        Source source;
        if (lib.hasFile() && !lib.getFile().isRegularFile(new LinkOption[0]) || lib.getPath() == null || !lib.getPath().toFile().isFile()) {
            if (!lib.isNative()) {
                throw new LLVMParserException("'" + lib.getPath() + "' is not a file or does not exist.");
            }
            return null;
        }
        TruffleFile file = lib.hasFile() ? lib.getFile() : this.context.getEnv().getInternalTruffleFile(lib.getPath().toUri());
        try {
            source = Source.newBuilder((String)"llvm", (TruffleFile)file).internal(lib.isInternal()).build();
        }
        catch (IOException | OutOfMemoryError | SecurityException ex) {
            throw new LLVMParserException("Error reading file " + lib.getPath() + ".");
        }
        return this.parse(parserResults, dependencyQueue, source, lib, source.getBytes());
    }

    private LLVMParserResult parse(List<LLVMParserResult> parserResults, ArrayDeque<LLVMContext.ExternalLibrary> dependencyQueue, Source source, LLVMContext.ExternalLibrary library, ByteSequence bytes) {
        BinaryParserResult binaryParserResult = BinaryParser.parse(bytes, source, this.context);
        if (binaryParserResult != null) {
            ModelModule module = new ModelModule();
            LLVMScanner.parseBitcode(binaryParserResult.getBitcode(), module, source, this.context);
            library.setIsNative(false);
            this.context.addExternalLibrary(library);
            this.context.addLibraryPaths(binaryParserResult.getLibraryPaths());
            List<String> libraries = binaryParserResult.getLibraries();
            for (String lib : libraries) {
                LLVMContext.ExternalLibrary dependency = this.context.addExternalLibrary(lib, true, library, binaryParserResult.getLocator());
                if (dependency == null) continue;
                dependencyQueue.addLast(dependency);
            }
            TargetDataLayout layout = module.getTargetDataLayout();
            DataLayout targetDataLayout = new DataLayout(layout.getDataLayout());
            NodeFactory nodeFactory = this.context.getLanguage().getActiveConfiguration().createNodeFactory(this.context, targetDataLayout);
            LLVMScope fileScope = new LLVMScope();
            LLVMParserRuntime runtime = new LLVMParserRuntime(this.context, library, fileScope, nodeFactory);
            LLVMParser parser = new LLVMParser(source, runtime);
            LLVMParserResult parserResult = parser.parse(module, targetDataLayout);
            parserResults.add(parserResult);
            return parserResult;
        }
        if (!library.isNative()) {
            throw new LLVMParserException("The file '" + source.getName() + "' is not a bitcode file nor an ELF or Mach-O object file with an embedded bitcode section.");
        }
        LibraryLocator.traceDelegateNative(this.context, library);
        return null;
    }

    private void addExternalSymbolsToScopes(List<LLVMParserResult> parserResults) {
        LLVMScope globalScope = this.context.getGlobalScope();
        for (LLVMParserResult parserResult : parserResults) {
            LLVMSymbol globalSymbol;
            LLVMScope fileScope = parserResult.getRuntime().getFileScope();
            for (FunctionSymbol function : parserResult.getExternalFunctions()) {
                globalSymbol = globalScope.get(function.getName());
                if (globalSymbol == null) {
                    globalSymbol = this.context.createFunctionDescriptor(function.getName(), function.getType(), new LLVMFunctionDescriptor.UnresolvedFunction(), null);
                    globalScope.register(globalSymbol);
                } else if (!globalSymbol.isFunction()) {
                    assert (globalSymbol.isGlobalVariable());
                    throw new LLVMLinkerException("The function " + function.getName() + " is declared as external but its definition is shadowed by a conflicting global variable with the same name.");
                }
                if (fileScope.contains(function.getName())) continue;
                fileScope.register(globalSymbol);
            }
            for (GlobalVariable global : parserResult.getExternalGlobals()) {
                globalSymbol = globalScope.get(global.getName());
                if (globalSymbol == null) {
                    globalSymbol = LLVMGlobal.create(this.context, global.getName(), global.getType(), global.getSourceSymbol(), global.isReadOnly());
                    globalScope.register(globalSymbol);
                } else if (!globalSymbol.isGlobalVariable()) {
                    assert (globalSymbol.isFunction());
                    throw new LLVMLinkerException("The global variable " + global.getName() + " is declared as external but its definition is shadowed by a conflicting function with the same name.");
                }
                if (fileScope.contains(global.getName())) continue;
                fileScope.register(globalSymbol);
            }
        }
    }

    private static void bindGlobal(LLVMContext ctx, LLVMGlobal global, NFIContextExtension nfiContextExtension) {
        NFIContextExtension.NativePointerIntoLibrary pointerIntoLibrary;
        if (nfiContextExtension != null && (pointerIntoLibrary = nfiContextExtension.getNativeHandle(ctx, global.getName())) != null) {
            global.define(pointerIntoLibrary.getLibrary());
            global.setTarget(LLVMNativePointer.create(pointerIntoLibrary.getAddress()));
        }
        if (!global.isDefined() && !((Boolean)ctx.getEnv().getOptions().get(SulongEngineOption.PARSE_ONLY)).booleanValue()) {
            throw new LLVMLinkerException("Global variable " + global.getName() + " is declared but not defined.");
        }
    }

    private static void bindUnresolvedFunction(LLVMContext ctx, LLVMFunctionDescriptor function, NFIContextExtension nfiContextExtension, LLVMIntrinsicProvider intrinsicProvider, NodeFactory nodeFactory) {
        if (!function.getName().startsWith("llvm.")) {
            NFIContextExtension.NativeLookupResult nativeFunction;
            if (intrinsicProvider.isIntrinsified(function.getName())) {
                function.define(intrinsicProvider, nodeFactory);
            } else if (nfiContextExtension != null && (nativeFunction = nfiContextExtension.getNativeFunctionOrNull(ctx, function.getName())) != null) {
                function.define(nativeFunction.getLibrary(), new LLVMFunctionDescriptor.NativeFunction(nativeFunction.getObject()));
            }
        }
    }

    private InitializationOrder computeInitializationOrder(List<LLVMParserResult> parserResults, LLVMContext.ExternalLibrary[] defaultLibraries) {
        ArrayList<LLVMParserResult> sulongLibs = new ArrayList<LLVMParserResult>();
        ArrayList<LLVMParserResult> otherLibs = new ArrayList<LLVMParserResult>();
        List<LLVMContext.ExternalLibrary> sulongExternalLibraries = Arrays.asList(defaultLibraries);
        for (LLVMParserResult parserResult : parserResults) {
            if (sulongExternalLibraries.contains(parserResult.getRuntime().getLibrary())) {
                sulongLibs.add(parserResult);
                continue;
            }
            otherLibs.add(parserResult);
        }
        ArrayList<LLVMParserResult> otherLibsInitializationOrder = new ArrayList<LLVMParserResult>();
        EconomicSet visited = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        EconomicMap<LLVMParserResult, List<LLVMParserResult>> dependencies = this.computeDependencies(otherLibs);
        for (int i = otherLibs.size() - 1; i >= 0; --i) {
            LLVMParserResult parserResult = (LLVMParserResult)otherLibs.get(i);
            if (visited.contains((Object)parserResult)) continue;
            Runner.addToInitializationOrder(parserResult, dependencies, otherLibsInitializationOrder, (EconomicSet<LLVMParserResult>)visited);
        }
        assert (sulongLibs.size() + otherLibsInitializationOrder.size() == parserResults.size());
        return new InitializationOrder(sulongLibs, otherLibsInitializationOrder);
    }

    private static void addToInitializationOrder(LLVMParserResult current, EconomicMap<LLVMParserResult, List<LLVMParserResult>> dependencies, List<LLVMParserResult> initializationOrder, EconomicSet<LLVMParserResult> visited) {
        visited.add((Object)current);
        List currentDependencies = (List)dependencies.get((Object)current);
        for (LLVMParserResult dependency : currentDependencies) {
            if (visited.contains((Object)dependency)) continue;
            Runner.addToInitializationOrder(dependency, dependencies, initializationOrder, visited);
        }
        initializationOrder.add(current);
    }

    private EconomicMap<LLVMParserResult, List<LLVMParserResult>> computeDependencies(List<LLVMParserResult> parserResults) {
        EconomicMap dependencies = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        Map<LLVMContext.ExternalLibrary, LLVMParserResult> libsToParserResults = Runner.mapLibsToParserResults(parserResults);
        LLVMScope globalScope = this.context.getGlobalScope();
        for (LLVMParserResult parserResult : parserResults) {
            ArrayList<LLVMParserResult> currentDependencies = new ArrayList<LLVMParserResult>();
            for (LLVMContext.ExternalLibrary lib : Runner.getImportedLibraries(globalScope, parserResult)) {
                LLVMParserResult dependency;
                if (parserResult.getRuntime().getLibrary().equals(lib) || (dependency = libsToParserResults.get(lib)) == null) continue;
                currentDependencies.add(dependency);
            }
            dependencies.put((Object)parserResult, currentDependencies);
        }
        return dependencies;
    }

    private static EconomicSet<LLVMContext.ExternalLibrary> getImportedLibraries(LLVMScope globalScope, LLVMParserResult parserResult) {
        EconomicSet importedLibs = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        for (String imported : parserResult.getImportedSymbols()) {
            LLVMContext.ExternalLibrary lib = globalScope.get(imported).getLibrary();
            if (lib == null) continue;
            importedLibs.add((Object)lib);
        }
        return importedLibs;
    }

    private static Map<LLVMContext.ExternalLibrary, LLVMParserResult> mapLibsToParserResults(List<LLVMParserResult> parserResults) {
        HashMap<LLVMContext.ExternalLibrary, LLVMParserResult> map = new HashMap<LLVMContext.ExternalLibrary, LLVMParserResult>();
        for (LLVMParserResult parserResult : parserResults) {
            map.put(parserResult.getRuntime().getLibrary(), parserResult);
        }
        return map;
    }

    private static StaticInitsNode createGlobalVariableInitializer(FrameDescriptor rootFrame, LLVMParserResult parserResult) {
        LLVMParserRuntime runtime = parserResult.getRuntime();
        LLVMSymbolReadResolver symbolResolver = new LLVMSymbolReadResolver(runtime, rootFrame, GetStackSpaceFactory.createAllocaFactory(), parserResult.getDataLayout());
        ArrayList<LLVMStatementNode> globalNodes = new ArrayList<LLVMStatementNode>();
        for (GlobalVariable global : parserResult.getDefinedGlobals()) {
            LLVMStatementNode store = Runner.createGlobalInitialization(runtime, symbolResolver, global, parserResult.getDataLayout());
            if (store == null) continue;
            globalNodes.add(store);
        }
        LLVMStatementNode[] initNodes = globalNodes.toArray(LLVMStatementNode.NO_STATEMENTS);
        return new StaticInitsNode(initNodes);
    }

    private static LLVMStatementNode createGlobalInitialization(LLVMParserRuntime runtime, LLVMSymbolReadResolver symbolResolver, GlobalVariable global, DataLayout dataLayout) {
        if (global == null || global.getValue() == null) {
            return null;
        }
        LLVMExpressionNode constant = symbolResolver.resolve(global.getValue());
        if (constant != null) {
            Type type = global.getType().getPointeeType();
            int size = type.getSize(dataLayout);
            LLVMGlobal globalDescriptor = runtime.getFileScope().getGlobalVariable(global.getName());
            LLVMExpressionNode globalVarAddress = runtime.getNodeFactory().createLiteral(globalDescriptor, new PointerType(global.getType()));
            if (size != 0) {
                if (type instanceof ArrayType || type instanceof StructureType) {
                    return runtime.getNodeFactory().createStore(globalVarAddress, constant, type);
                }
                Type t = global.getValue().getType();
                return runtime.getNodeFactory().createStore(globalVarAddress, constant, t);
            }
        }
        return null;
    }

    private static StaticInitsNode createConstructor(LLVMParserResult parserResult) {
        return new StaticInitsNode(Runner.createStructor(CONSTRUCTORS_VARNAME, parserResult, ASCENDING_PRIORITY));
    }

    private RootCallTarget createDestructor(LLVMParserResult parserResult) {
        LLVMStatementNode[] destructor = Runner.createStructor(DESTRUCTORS_VARNAME, parserResult, DESCENDING_PRIORITY);
        if (destructor.length > 0) {
            LLVMStatementRootNode root = new LLVMStatementRootNode(this.language, new StaticInitsNode(destructor), StackManager.createRootFrame());
            return Truffle.getRuntime().createCallTarget((RootNode)root);
        }
        return null;
    }

    private static LLVMStatementNode[] createStructor(String name, LLVMParserResult parserResult, Comparator<Pair<Integer, ?>> priorityComparator) {
        for (GlobalVariable globalVariable : parserResult.getDefinedGlobals()) {
            if (!globalVariable.getName().equals(name)) continue;
            return Runner.resolveStructor(parserResult.getRuntime().getFileScope(), globalVariable, priorityComparator, parserResult.getDataLayout(), parserResult.getRuntime().getNodeFactory());
        }
        return LLVMStatementNode.NO_STATEMENTS;
    }

    private static LLVMStatementNode[] resolveStructor(LLVMScope fileScope, GlobalVariable globalSymbol, Comparator<Pair<Integer, ?>> priorityComparator, DataLayout dataLayout, NodeFactory nodeFactory) {
        if (!(globalSymbol.getValue() instanceof ArrayConstant)) {
            return LLVMStatementNode.NO_STATEMENTS;
        }
        LLVMGlobal global = (LLVMGlobal)fileScope.get(globalSymbol.getName());
        ArrayConstant arrayConstant = (ArrayConstant)globalSymbol.getValue();
        int elemCount = arrayConstant.getElementCount();
        StructureType elementType = (StructureType)arrayConstant.getType().getElementType();
        int elementSize = elementType.getSize(dataLayout);
        FunctionType functionType = (FunctionType)((PointerType)elementType.getElementType(1L)).getPointeeType();
        int indexedTypeLength = functionType.getAlignment(dataLayout);
        ArrayList<Pair<Integer, LLVMVoidStatementNode>> structors = new ArrayList<Pair<Integer, LLVMVoidStatementNode>>(elemCount);
        FrameDescriptor rootFrame = StackManager.createRootFrame();
        for (int i = 0; i < elemCount; ++i) {
            LLVMExpressionNode globalVarAddress = nodeFactory.createLiteral(global, new PointerType(globalSymbol.getType()));
            LLVMExpressionNode iNode = nodeFactory.createLiteral(i, PrimitiveType.I32);
            LLVMExpressionNode structPointer = nodeFactory.createTypedElementPointer(globalVarAddress, iNode, elementSize, elementType);
            LLVMLoadNode loadedStruct = CommonNodeFactory.createLoad(elementType, structPointer);
            LLVMExpressionNode oneLiteralNode = nodeFactory.createLiteral(1, PrimitiveType.I32);
            LLVMExpressionNode functionLoadTarget = nodeFactory.createTypedElementPointer(loadedStruct, oneLiteralNode, indexedTypeLength, functionType);
            LLVMLoadNode loadedFunction = CommonNodeFactory.createLoad(functionType, functionLoadTarget);
            LLVMExpressionNode[] argNodes = new LLVMExpressionNode[]{CommonNodeFactory.createFrameRead(PointerType.VOID, rootFrame.findFrameSlot((Object)"<stackpointer>"))};
            LLVMVoidStatementNode functionCall = LLVMVoidStatementNodeGen.create(CommonNodeFactory.createFunctionCall(loadedFunction, argNodes, functionType));
            StructureConstant structorDefinition = (StructureConstant)arrayConstant.getElement(i);
            SymbolImpl prioritySymbol = structorDefinition.getElement(0);
            Integer priority = LLVMSymbolReadResolver.evaluateIntegerConstant(prioritySymbol);
            structors.add(new Pair<Integer, LLVMVoidStatementNode>(priority != null ? priority : 65535, functionCall));
        }
        return (LLVMStatementNode[])structors.stream().sorted(priorityComparator).map(Pair::getSecond).toArray(LLVMStatementNode[]::new);
    }

    private static byte[] decodeBase64(CharSequence charSequence) {
        byte[] result = new byte[charSequence.length()];
        for (int i = 0; i < result.length; ++i) {
            char ch = charSequence.charAt(i);
            assert (ch >= '\u0000' && ch <= '\u007f');
            result[i] = (byte)ch;
        }
        return Base64.getDecoder().decode(result);
    }

    private CallTarget createLibraryCallTarget(String name, List<LLVMParserResult> parserResults, InitializationOrder initializationOrder) {
        RootCallTarget mainFunctionCallTarget = null;
        LLVMFunctionDescriptor mainFunctionDescriptor = Runner.findMainMethod(parserResults);
        LLVMFunctionDescriptor startFunctionDescriptor = this.findStartMethod();
        if (mainFunctionDescriptor != null && startFunctionDescriptor != null) {
            RootCallTarget startCallTarget = startFunctionDescriptor.getLLVMIRFunctionSlowPath();
            Path applicationPath = mainFunctionDescriptor.getLibrary().getPath();
            LLVMGlobalRootNode rootNode = new LLVMGlobalRootNode(this.language, StackManager.createRootFrame(), mainFunctionDescriptor, (CallTarget)startCallTarget, Objects.toString(applicationPath, ""));
            mainFunctionCallTarget = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
        }
        if (((Boolean)this.context.getEnv().getOptions().get(SulongEngineOption.PARSE_ONLY)).booleanValue()) {
            return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode((Object)0));
        }
        LLVMScope scope = Runner.combineScopes(parserResults);
        SulongLibrary lib = new SulongLibrary(name, scope, (CallTarget)mainFunctionCallTarget);
        FrameDescriptor rootFrame = StackManager.createRootFrame();
        LoadModulesNode loadModules = new LoadModulesNode(this, rootFrame, initializationOrder, lib);
        return Truffle.getRuntime().createCallTarget((RootNode)loadModules);
    }

    private static LLVMFunctionDescriptor findMainMethod(List<LLVMParserResult> parserResults) {
        for (LLVMParserResult parserResult : parserResults) {
            LLVMScope fileScope = parserResult.getRuntime().getFileScope();
            LLVMSymbol mainMethod = fileScope.get(MAIN_METHOD_NAME);
            if (mainMethod == null || !mainMethod.isFunction() || !mainMethod.isDefined() || !mainMethod.asFunction().isLLVMIRFunction()) continue;
            return mainMethod.asFunction();
        }
        return null;
    }

    private LLVMFunctionDescriptor findStartMethod() {
        LLVMSymbol startMethod = this.context.getGlobalScope().get(START_METHOD_NAME);
        if (startMethod != null && startMethod.isFunction() && startMethod.isDefined()) {
            return startMethod.asFunction();
        }
        return null;
    }

    private static LLVMScope combineScopes(List<LLVMParserResult> parserResults) {
        LLVMScope result = new LLVMScope();
        for (LLVMParserResult parserResult : parserResults) {
            LLVMScope scope = parserResult.getRuntime().getFileScope();
            result.addMissingEntries(scope);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void overrideSulongLibraryFunctionsWithIntrinsics(List<LLVMParserResult> sulongLibraries) {
        LLVMContext lLVMContext = this.context;
        synchronized (lLVMContext) {
            LLVMIntrinsicProvider intrinsicProvider = this.language.getCapability(LLVMIntrinsicProvider.class);
            for (LLVMParserResult parserResult : sulongLibraries) {
                for (LLVMSymbol symbol : parserResult.getRuntime().getFileScope().values()) {
                    if (!symbol.isFunction() || !intrinsicProvider.isIntrinsified(symbol.getName())) continue;
                    LLVMFunctionDescriptor function = symbol.asFunction();
                    function.define(intrinsicProvider, parserResult.getRuntime().getNodeFactory());
                }
            }
        }
    }

    private void parseFunctionsEagerly(List<LLVMParserResult> parserResults) {
        if (!((Boolean)this.context.getEnv().getOptions().get(SulongEngineOption.LAZY_PARSING)).booleanValue()) {
            for (LLVMParserResult parserResult : parserResults) {
                for (LLVMSymbol symbol : parserResult.getRuntime().getFileScope().values()) {
                    if (symbol instanceof LLVMFunctionDescriptor) {
                        LLVMFunctionDescriptor function = (LLVMFunctionDescriptor)symbol;
                        function.resolveIfLazyLLVMIRFunction();
                        continue;
                    }
                    if (symbol instanceof LLVMGlobal || symbol instanceof LLVMAlias) continue;
                    throw new RuntimeException("Unknown symbol: " + symbol.getClass());
                }
            }
        }
    }

    private static final class InitializationOrder {
        private final List<LLVMParserResult> sulongLibraries;
        private final List<LLVMParserResult> otherLibraries;

        private InitializationOrder(List<LLVMParserResult> sulongLibraries, List<LLVMParserResult> otherLibraries) {
            this.sulongLibraries = sulongLibraries;
            this.otherLibraries = otherLibraries;
        }
    }

    private static final class InitializeModuleNode
    extends LLVMNode
    implements LLVMHasDatalayoutNode {
        private final RootCallTarget destructor;
        private final DataLayout dataLayout;
        @Node.Child
        StaticInitsNode globalVarInit;
        @Node.Child
        LLVMMemoryOpNode protectRoData;
        @Node.Child
        StaticInitsNode constructor;

        InitializeModuleNode(Runner runner, FrameDescriptor rootFrame, LLVMParserResult parserResult) {
            this.destructor = runner.createDestructor(parserResult);
            this.dataLayout = parserResult.getDataLayout();
            this.globalVarInit = Runner.createGlobalVariableInitializer(rootFrame, parserResult);
            this.protectRoData = parserResult.getRuntime().getNodeFactory().createProtectGlobalsBlock();
            this.constructor = Runner.createConstructor(parserResult);
        }

        void execute(VirtualFrame frame, LLVMContext ctx, LLVMPointer roDataBase) {
            if (this.destructor != null) {
                ctx.registerDestructorFunctions(this.destructor);
            }
            this.globalVarInit.execute(frame);
            if (roDataBase != null) {
                this.protectRoData.execute(roDataBase);
            }
            this.constructor.execute(frame);
        }

        @Override
        public DataLayout getDatalayout() {
            return this.dataLayout;
        }
    }

    private static final class StaticInitsNode
    extends LLVMStatementNode {
        @Node.Children
        final LLVMStatementNode[] statements;

        StaticInitsNode(LLVMStatementNode[] statements) {
            this.statements = statements;
        }

        @Override
        @ExplodeLoop
        public void execute(VirtualFrame frame) {
            for (LLVMStatementNode stmt : this.statements) {
                stmt.execute(frame);
            }
        }
    }

    private static final class InitializeSymbolsNode
    extends LLVMNode {
        @Node.Child
        LLVMAllocateNode allocRoSection;
        @Node.Child
        LLVMAllocateNode allocRwSection;
        @Node.Children
        final AllocGlobalNode[] allocGlobals;
        final LLVMScope fileScope;
        private NodeFactory nodeFactory;

        InitializeSymbolsNode(LLVMParserResult res, NodeFactory nodeFactory) {
            DataLayout dataLayout = res.getDataLayout();
            this.nodeFactory = nodeFactory;
            DataSection roSection = new DataSection(dataLayout);
            DataSection rwSection = new DataSection(dataLayout);
            ArrayList<AllocGlobalNode> allocGlobalsList = new ArrayList<AllocGlobalNode>();
            for (GlobalVariable global : res.getDefinedGlobals()) {
                Type type = global.getType().getPointeeType();
                if (Runner.isSpecialGlobalSlot(type)) {
                    allocGlobalsList.add(new AllocPointerGlobalNode(global));
                    continue;
                }
                if (type.getSize(dataLayout) == 0) {
                    type = PrimitiveType.getIntegerType(8);
                }
                allocGlobalsList.add(new AllocOtherGlobalNode(global, type, roSection, rwSection));
            }
            this.allocRoSection = roSection.getAllocateNode(nodeFactory, "roglobals_struct", true);
            this.allocRwSection = rwSection.getAllocateNode(nodeFactory, "rwglobals_struct", false);
            this.allocGlobals = allocGlobalsList.toArray(AllocGlobalNode.EMPTY);
            this.fileScope = res.getRuntime().getFileScope();
        }

        public boolean shouldInitialize(LLVMContext ctx) {
            return !ctx.isScopeLoaded(this.fileScope);
        }

        public LLVMPointer execute(LLVMContext ctx) {
            LLVMPointer roBase = InitializeSymbolsNode.allocOrNull(this.allocRoSection);
            LLVMPointer rwBase = InitializeSymbolsNode.allocOrNull(this.allocRwSection);
            this.allocGlobals(ctx, roBase, rwBase);
            if (this.allocRoSection != null) {
                ctx.registerReadOnlyGlobals(roBase, this.nodeFactory);
            }
            if (this.allocRwSection != null) {
                ctx.registerGlobals(rwBase, this.nodeFactory);
            }
            this.bindUnresolvedSymbols(ctx);
            ctx.registerScope(this.fileScope);
            return roBase;
        }

        @ExplodeLoop
        private void allocGlobals(LLVMContext ctx, LLVMPointer roBase, LLVMPointer rwBase) {
            for (AllocGlobalNode allocGlobal : this.allocGlobals) {
                LLVMGlobal descriptor = this.fileScope.getGlobalVariable(allocGlobal.name);
                if (descriptor.isInitialized()) continue;
                LLVMPointer ref = allocGlobal.allocate(roBase, rwBase);
                descriptor.setTarget(ref);
                ctx.registerGlobalReverseMap(descriptor, ref);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private void bindUnresolvedSymbols(LLVMContext ctx) {
            NFIContextExtension nfiContextExtension = ctx.getLanguage().getContextExtensionOrNull(NFIContextExtension.class);
            LLVMIntrinsicProvider intrinsicProvider = ctx.getLanguage().getCapability(LLVMIntrinsicProvider.class);
            LLVMContext lLVMContext = ctx;
            synchronized (lLVMContext) {
                for (LLVMSymbol symbol : this.fileScope.values()) {
                    if (symbol.isDefined()) continue;
                    if (symbol instanceof LLVMGlobal) {
                        LLVMGlobal global = (LLVMGlobal)symbol;
                        Runner.bindGlobal(ctx, global, nfiContextExtension);
                        continue;
                    }
                    if (symbol instanceof LLVMFunctionDescriptor) {
                        LLVMFunctionDescriptor function = (LLVMFunctionDescriptor)symbol;
                        Runner.bindUnresolvedFunction(ctx, function, nfiContextExtension, intrinsicProvider, this.nodeFactory);
                        continue;
                    }
                    if (symbol instanceof LLVMAlias) continue;
                    CompilerDirectives.transferToInterpreter();
                    throw new IllegalStateException("Unknown symbol: " + symbol.getClass());
                }
            }
        }

        private static LLVMPointer allocOrNull(LLVMAllocateNode allocNode) {
            if (allocNode != null) {
                return allocNode.executeWithTarget();
            }
            return null;
        }
    }

    private static final class DataSection {
        final DataLayout dataLayout;
        final ArrayList<Type> types = new ArrayList();
        private int offset = 0;

        DataSection(DataLayout dataLayout) {
            this.dataLayout = dataLayout;
        }

        long add(GlobalVariable global, Type type) {
            int alignment = Runner.getAlignment(this.dataLayout, global, type);
            int padding = Type.getPadding(this.offset, alignment);
            Runner.addPaddingTypes(this.types, padding);
            this.offset += padding;
            long ret = this.offset;
            this.types.add(type);
            this.offset += type.getSize(this.dataLayout);
            return ret;
        }

        LLVMAllocateNode getAllocateNode(NodeFactory factory, String typeName, boolean readOnly) {
            if (this.offset > 0) {
                StructureType structType = new StructureType(typeName, true, this.types.toArray(Type.EMPTY_ARRAY));
                return factory.createAllocateGlobalsBlock(structType, readOnly);
            }
            return null;
        }
    }

    private static final class AllocOtherGlobalNode
    extends AllocGlobalNode {
        final boolean readOnly;
        final long offset;

        AllocOtherGlobalNode(GlobalVariable global, Type type, DataSection roSection, DataSection rwSection) {
            super(global);
            this.readOnly = global.isReadOnly();
            DataSection dataSection = this.readOnly ? roSection : rwSection;
            this.offset = dataSection.add(global, type);
        }

        @Override
        LLVMPointer allocate(LLVMPointer roBase, LLVMPointer rwBase) {
            LLVMPointer base = this.readOnly ? roBase : rwBase;
            return base.increment(this.offset);
        }
    }

    private static final class AllocPointerGlobalNode
    extends AllocGlobalNode {
        AllocPointerGlobalNode(GlobalVariable global) {
            super(global);
        }

        @Override
        LLVMPointer allocate(LLVMPointer roBase, LLVMPointer rwBase) {
            return LLVMManagedPointer.create(new LLVMGlobalContainer());
        }
    }

    private static abstract class AllocGlobalNode
    extends LLVMNode {
        static final AllocGlobalNode[] EMPTY = new AllocGlobalNode[0];
        final String name;

        AllocGlobalNode(GlobalVariable global) {
            this.name = global.getName();
        }

        abstract LLVMPointer allocate(LLVMPointer var1, LLVMPointer var2);
    }

    private static class LoadModulesNode
    extends RootNode {
        final SulongLibrary sulongLibrary;
        final FrameSlot stackPointerSlot;
        @CompilerDirectives.CompilationFinal
        TruffleLanguage.ContextReference<LLVMContext> ctxRef;
        final int initContextBefore;
        @Node.Child
        LLVMStatementNode initContext;
        @Node.Children
        final InitializeSymbolsNode[] initSymbols;
        @Node.Children
        final InitializeModuleNode[] initModules;

        LoadModulesNode(Runner runner, FrameDescriptor rootFrame, InitializationOrder order, SulongLibrary sulongLibrary) {
            super((TruffleLanguage)runner.language, rootFrame);
            this.sulongLibrary = sulongLibrary;
            this.stackPointerSlot = rootFrame.findFrameSlot((Object)"<stackpointer>");
            this.initContextBefore = order.sulongLibraries.size();
            this.initContext = runner.context.createInitializeContextNode(rootFrame);
            int libCount = order.sulongLibraries.size() + order.otherLibraries.size();
            this.initSymbols = new InitializeSymbolsNode[libCount];
            this.initModules = new InitializeModuleNode[libCount];
            LoadModulesNode.createNodes(runner, rootFrame, order.sulongLibraries, 0, this.initSymbols, this.initModules);
            LoadModulesNode.createNodes(runner, rootFrame, order.otherLibraries, this.initContextBefore, this.initSymbols, this.initModules);
        }

        private static void createNodes(Runner runner, FrameDescriptor rootFrame, List<LLVMParserResult> parserResults, int offset, InitializeSymbolsNode[] initSymbols, InitializeModuleNode[] initModules) {
            for (int i = 0; i < parserResults.size(); ++i) {
                LLVMParserResult res = parserResults.get(i);
                initSymbols[offset + i] = new InitializeSymbolsNode(res, res.getRuntime().getNodeFactory());
                initModules[offset + i] = new InitializeModuleNode(runner, rootFrame, res);
            }
        }

        public Object execute(VirtualFrame frame) {
            if (this.ctxRef == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.ctxRef = this.lookupContextReference(LLVMLanguage.class);
            }
            LLVMContext ctx = (LLVMContext)this.ctxRef.get();
            try (LLVMStack.StackPointer stackPointer = ((LLVMContext)this.ctxRef.get()).getThreadingStack().getStack().newFrame();){
                frame.setObject(this.stackPointerSlot, (Object)stackPointer);
                BitSet shouldInit = this.createBitset();
                LLVMPointer[] roSections = new LLVMPointer[this.initSymbols.length];
                this.doInitSymbols(ctx, shouldInit, roSections);
                this.doInitModules(frame, ctx, shouldInit, roSections, 0, this.initContextBefore);
                this.initContext.execute(frame);
                this.doInitModules(frame, ctx, shouldInit, roSections, this.initContextBefore, this.initModules.length);
                SulongLibrary sulongLibrary = this.sulongLibrary;
                return sulongLibrary;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private BitSet createBitset() {
            return new BitSet(this.initSymbols.length);
        }

        @ExplodeLoop
        private void doInitSymbols(LLVMContext ctx, BitSet shouldInit, LLVMPointer[] roSections) {
            for (int i = 0; i < this.initSymbols.length; ++i) {
                if (!this.initSymbols[i].shouldInitialize(ctx)) continue;
                shouldInit.set(i);
                roSections[i] = this.initSymbols[i].execute(ctx);
            }
        }

        @ExplodeLoop
        private void doInitModules(VirtualFrame frame, LLVMContext ctx, BitSet shouldInit, LLVMPointer[] roSections, int from, int to) {
            for (int i = from; i < to; ++i) {
                if (!shouldInit.get(i)) continue;
                this.initModules[i].execute(frame, ctx, roSections[i]);
            }
        }
    }
}

