/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.asm.amd64;

import com.oracle.truffle.llvm.asm.amd64.AsmOperand;
import com.oracle.truffle.llvm.asm.amd64.AsmParseException;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;

class AsmMemoryOperand
implements AsmOperand {
    public static final int SCALE_1 = 1;
    public static final int SCALE_2 = 2;
    public static final int SCALE_4 = 4;
    public static final int SCALE_8 = 8;
    private final String segment;
    private final String displacement;
    private final AsmOperand base;
    private final AsmOperand offset;
    private final int scale;

    AsmMemoryOperand(String segment, String displacement, AsmOperand base, AsmOperand offset, int scale) {
        this.segment = segment;
        this.displacement = displacement;
        this.base = base;
        this.offset = offset;
        this.scale = scale;
    }

    public String getSegment() {
        return this.segment;
    }

    public int getDisplacement() {
        if (this.displacement == null) {
            return 0;
        }
        return Integer.decode(this.displacement);
    }

    public AsmOperand getBase() {
        return this.base;
    }

    public AsmOperand getOffset() {
        return this.offset;
    }

    public int getScale() {
        return this.scale;
    }

    public int getShift() {
        switch (this.scale) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
        }
        throw new AsmParseException("invalid scale: " + this.scale);
    }

    @Override
    public Type getType() {
        return new PointerType(PrimitiveType.I8);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.segment != null) {
            b.append(this.segment).append(':');
        }
        if (this.displacement != null) {
            b.append(this.displacement);
        }
        if (this.base != null || this.offset != null) {
            b.append("(");
            if (this.base != null) {
                b.append(this.base);
            }
            if (this.offset != null) {
                b.append(",");
                b.append(this.offset);
                if (this.scale != 1) {
                    b.append(",");
                    b.append(this.scale);
                }
            }
            b.append(")");
        }
        return b.toString();
    }
}

