/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.llvm.parser.LLVMLivenessAnalysis;
import com.oracle.truffle.llvm.parser.LLVMPhiManager;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.SourceVariable;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.Instruction;
import com.oracle.truffle.llvm.parser.model.visitors.FunctionVisitor;
import com.oracle.truffle.llvm.parser.nodes.LLVMBitcodeInstructionVisitor;
import com.oracle.truffle.llvm.parser.nodes.LLVMRuntimeDebugInformation;
import com.oracle.truffle.llvm.parser.nodes.LLVMSymbolReadResolver;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

final class LLVMBitcodeFunctionVisitor
implements FunctionVisitor {
    private final LLVMContext context;
    private final LLVMContext.ExternalLibrary library;
    private final FrameDescriptor frame;
    private final LLVMStack.UniquesRegion uniquesRegion;
    private final List<LLVMStatementNode> blocks;
    private final Map<InstructionBlock, List<LLVMPhiManager.Phi>> phis;
    private final LLVMSymbolReadResolver symbols;
    private final int argCount;
    private final FunctionDefinition function;
    private final LLVMLivenessAnalysis.LLVMLivenessAnalysisResult liveness;
    private final List<FrameSlot> notNullable;
    private final LLVMRuntimeDebugInformation dbgInfoHandler;
    private boolean initDebugValues;
    private final DataLayout dataLayout;
    private final NodeFactory nodeFactory;

    LLVMBitcodeFunctionVisitor(LLVMContext context, LLVMContext.ExternalLibrary library, FrameDescriptor frame, LLVMStack.UniquesRegion uniquesRegion, Map<InstructionBlock, List<LLVMPhiManager.Phi>> phis, int argCount, LLVMSymbolReadResolver symbols, FunctionDefinition functionDefinition, LLVMLivenessAnalysis.LLVMLivenessAnalysisResult liveness, List<FrameSlot> notNullable, LLVMRuntimeDebugInformation dbgInfoHandler, DataLayout dataLayout, NodeFactory nodeFactory) {
        this.context = context;
        this.library = library;
        this.frame = frame;
        this.uniquesRegion = uniquesRegion;
        this.phis = phis;
        this.symbols = symbols;
        this.argCount = argCount;
        this.function = functionDefinition;
        this.liveness = liveness;
        this.notNullable = notNullable;
        this.dbgInfoHandler = dbgInfoHandler;
        this.blocks = new ArrayList<LLVMStatementNode>();
        this.initDebugValues = dbgInfoHandler.isEnabled();
        this.dataLayout = dataLayout;
        this.nodeFactory = nodeFactory;
    }

    public List<LLVMStatementNode> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    public FunctionDefinition getFunction() {
        return this.function;
    }

    @Override
    public void visit(InstructionBlock block) {
        List<LLVMPhiManager.Phi> blockPhis = this.phis.get(block);
        ArrayList<LLVMLivenessAnalysis.NullerInformation> blockNullerInfos = this.liveness.getNullableWithinBlock()[block.getBlockIndex()];
        LLVMBitcodeInstructionVisitor visitor = LLVMBitcodeInstructionVisitor.create(this.frame, this.uniquesRegion, blockPhis, this.argCount, this.symbols, this.context, this.library, blockNullerInfos, this.notNullable, this.dbgInfoHandler, this.dataLayout, this.nodeFactory);
        if (this.initDebugValues) {
            for (SourceVariable variable : this.function.getSourceFunction().getVariables()) {
                LLVMStatementNode initNode = this.dbgInfoHandler.createInitializer(variable);
                if (initNode == null) continue;
                visitor.addInstructionUnchecked(initNode);
            }
            this.initDebugValues = false;
        }
        for (int i = 0; i < block.getInstructionCount(); ++i) {
            Instruction instruction = block.getInstruction(i);
            visitor.setInstructionIndex(i);
            instruction.accept(visitor);
        }
        this.blocks.add(CommonNodeFactory.createBasicBlockNode(visitor.getInstructions(), visitor.getControlFlowNode(), block.getBlockIndex(), block.getName(), this.context));
    }
}

