/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser;

import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;

public final class LLVMParserRuntime {
    private final LLVMContext context;
    private final LLVMContext.ExternalLibrary library;
    private final LLVMScope fileScope;
    private final NodeFactory nodeFactory;

    public LLVMParserRuntime(LLVMContext context, LLVMContext.ExternalLibrary library, LLVMScope fileScope, NodeFactory nodeFactory) {
        this.context = context;
        this.library = library;
        this.fileScope = fileScope;
        this.nodeFactory = nodeFactory;
    }

    public LLVMContext.ExternalLibrary getLibrary() {
        return this.library;
    }

    public LLVMContext getContext() {
        return this.context;
    }

    public LLVMScope getFileScope() {
        return this.fileScope;
    }

    public LLVMScope getGlobalScope() {
        return this.context.getGlobalScope();
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public LLVMFunctionDescriptor lookupFunction(String name, boolean preferGlobalScope) {
        LLVMSymbol symbol = this.lookupSymbolImpl(name, preferGlobalScope);
        if (symbol != null && symbol.isFunction()) {
            return symbol.asFunction();
        }
        throw new IllegalStateException("Unknown function: " + name);
    }

    public LLVMGlobal lookupGlobal(String name, boolean preferGlobalScope) {
        LLVMSymbol symbol = this.lookupSymbolImpl(name, preferGlobalScope);
        if (symbol != null && symbol.isGlobalVariable()) {
            return symbol.asGlobalVariable();
        }
        throw new IllegalStateException("Unknown global: " + name);
    }

    public LLVMSymbol lookupSymbol(String name, boolean preferGlobalScope) {
        LLVMSymbol symbol = this.lookupSymbolImpl(name, preferGlobalScope);
        if (symbol != null) {
            return symbol;
        }
        throw new IllegalStateException("Unknown symbol: " + name);
    }

    private LLVMSymbol lookupSymbolImpl(String name, boolean preferGlobalScope) {
        LLVMSymbol symbol = null;
        if (preferGlobalScope) {
            symbol = this.getGlobalScope().get(name);
        }
        if (symbol == null) {
            symbol = this.fileScope.get(name);
        }
        return symbol;
    }
}

