/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.parser.LLVMBitcodeFunctionVisitor;
import com.oracle.truffle.llvm.parser.LLVMLivenessAnalysis;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.LLVMPhiManager;
import com.oracle.truffle.llvm.parser.StackManager;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.DebugInfoFunctionProcessor;
import com.oracle.truffle.llvm.parser.model.attributes.Attribute;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.functions.FunctionParameter;
import com.oracle.truffle.llvm.parser.model.functions.LazyFunctionParser;
import com.oracle.truffle.llvm.parser.nodes.LLVMBitcodeInstructionVisitor;
import com.oracle.truffle.llvm.parser.nodes.LLVMRuntimeDebugInformation;
import com.oracle.truffle.llvm.parser.nodes.LLVMSymbolReadResolver;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceFunctionType;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.graalvm.options.OptionValues;

public class LazyToTruffleConverterImpl
implements LLVMFunctionDescriptor.LazyToTruffleConverter {
    private final LLVMParserRuntime runtime;
    private final FunctionDefinition method;
    private final Source source;
    private final LazyFunctionParser parser;
    private final DebugInfoFunctionProcessor diProcessor;
    private final DataLayout dataLayout;
    private RootCallTarget resolved;

    LazyToTruffleConverterImpl(LLVMParserRuntime runtime, FunctionDefinition method, Source source, LazyFunctionParser parser, DebugInfoFunctionProcessor diProcessor, DataLayout dataLayout) {
        this.runtime = runtime;
        this.method = method;
        this.source = source;
        this.parser = parser;
        this.diProcessor = diProcessor;
        this.resolved = null;
        this.dataLayout = dataLayout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RootCallTarget convert() {
        CompilerAsserts.neverPartOfCompilation();
        LazyToTruffleConverterImpl lazyToTruffleConverterImpl = this;
        synchronized (lazyToTruffleConverterImpl) {
            if (this.resolved == null) {
                this.resolved = this.generateCallTarget();
            }
            return this.resolved;
        }
    }

    private RootCallTarget generateCallTarget() {
        this.parser.parse(this.diProcessor, this.source, this.runtime);
        Map<InstructionBlock, List<LLVMPhiManager.Phi>> phis = LLVMPhiManager.getPhis(this.method);
        FrameDescriptor frame = StackManager.createFrame(this.method);
        LLVMStack.UniquesRegion uniquesRegion = new LLVMStack.UniquesRegion();
        GetStackSpaceFactory getStackSpaceFactory = GetStackSpaceFactory.createGetUniqueStackSpaceFactory(uniquesRegion);
        OptionValues options = this.runtime.getContext().getEnv().getOptions();
        PrintStream logLivenessStream = SulongEngineOption.isTrue((String)options.get(SulongEngineOption.PRINT_LIFE_TIME_ANALYSIS_STATS)) ? SulongEngineOption.getStream((String)options.get(SulongEngineOption.PRINT_LIFE_TIME_ANALYSIS_STATS)) : null;
        LLVMLivenessAnalysis.LLVMLivenessAnalysisResult liveness = LLVMLivenessAnalysis.computeLiveness(frame, phis, this.method, logLivenessStream);
        LLVMSymbolReadResolver symbols = new LLVMSymbolReadResolver(this.runtime, frame, getStackSpaceFactory, this.dataLayout);
        ArrayList<FrameSlot> notNullable = new ArrayList<FrameSlot>();
        LLVMRuntimeDebugInformation dbgInfoHandler = new LLVMRuntimeDebugInformation(frame, this.runtime.getContext(), notNullable, symbols);
        dbgInfoHandler.registerStaticDebugSymbols(this.method);
        LLVMBitcodeFunctionVisitor visitor = new LLVMBitcodeFunctionVisitor(this.runtime.getContext(), this.runtime.getLibrary(), frame, uniquesRegion, phis, this.method.getParameters().size(), symbols, this.method, liveness, notNullable, dbgInfoHandler, this.dataLayout, this.runtime.getNodeFactory());
        this.method.accept(visitor);
        FrameSlot[][] nullableBeforeBlock = LazyToTruffleConverterImpl.getNullableFrameSlots(liveness.getFrameSlots(), liveness.getNullableBeforeBlock(), notNullable);
        FrameSlot[][] nullableAfterBlock = LazyToTruffleConverterImpl.getNullableFrameSlots(liveness.getFrameSlots(), liveness.getNullableAfterBlock(), notNullable);
        LLVMSourceLocation location = this.method.getLexicalScope();
        List<LLVMStatementNode> copyArgumentsToFrame = this.copyArgumentsToFrame(frame);
        LLVMStatementNode[] copyArgumentsToFrameArray = copyArgumentsToFrame.toArray(LLVMStatementNode.NO_STATEMENTS);
        LLVMExpressionNode body = this.runtime.getNodeFactory().createFunctionBlockNode(frame.findFrameSlot((Object)"<function exception value>"), visitor.getBlocks(), uniquesRegion.build(), nullableBeforeBlock, nullableAfterBlock, copyArgumentsToFrameArray, location, frame);
        RootNode rootNode = this.runtime.getNodeFactory().createFunctionStartNode(body, frame, this.method.getName(), this.method.getSourceName(), this.method.getParameters().size(), this.source, location);
        this.method.onAfterParse();
        return Truffle.getRuntime().createCallTarget(rootNode);
    }

    @Override
    public LLVMSourceFunctionType getSourceType() {
        this.convert();
        return this.method.getSourceFunction().getSourceType();
    }

    private static FrameSlot[][] getNullableFrameSlots(FrameSlot[] frameSlots, BitSet[] nullablePerBlock, List<FrameSlot> notNullable) {
        FrameSlot[][] result = new FrameSlot[nullablePerBlock.length][];
        for (int i = 0; i < nullablePerBlock.length; ++i) {
            BitSet nullable = nullablePerBlock[i];
            int bitIndex = -1;
            ArrayList<FrameSlot> nullableSlots = new ArrayList<FrameSlot>();
            while ((bitIndex = nullable.nextSetBit(bitIndex + 1)) >= 0) {
                FrameSlot frameSlot = frameSlots[bitIndex];
                if (notNullable.contains(frameSlot)) continue;
                nullableSlots.add(frameSlot);
            }
            if (nullableSlots.size() > 0) {
                result[i] = nullableSlots.toArray(LLVMBitcodeInstructionVisitor.NO_SLOTS);
                continue;
            }
            assert (result[i] == null);
        }
        return result;
    }

    private List<LLVMStatementNode> copyArgumentsToFrame(FrameDescriptor frame) {
        List<FunctionParameter> parameters = this.method.getParameters();
        ArrayList<LLVMStatementNode> formalParamInits = new ArrayList<LLVMStatementNode>();
        LLVMExpressionNode stackPointerNode = this.runtime.getNodeFactory().createFunctionArgNode(0, PrimitiveType.I64);
        formalParamInits.add(this.runtime.getNodeFactory().createFrameWrite(PointerType.VOID, stackPointerNode, frame.findFrameSlot((Object)"<stackpointer>")));
        int argIndex = 1;
        if (this.method.getType().getReturnType() instanceof StructureType) {
            ++argIndex;
        }
        for (FunctionParameter parameter : parameters) {
            LLVMExpressionNode parameterNode = this.runtime.getNodeFactory().createFunctionArgNode(argIndex++, parameter.getType());
            FrameSlot slot = frame.findFrameSlot((Object)parameter.getName());
            if (LazyToTruffleConverterImpl.isStructByValue(parameter)) {
                Type type = ((PointerType)parameter.getType()).getPointeeType();
                formalParamInits.add(this.runtime.getNodeFactory().createFrameWrite(parameter.getType(), this.runtime.getNodeFactory().createCopyStructByValue(type, GetStackSpaceFactory.createAllocaFactory(), parameterNode), slot));
                continue;
            }
            formalParamInits.add(this.runtime.getNodeFactory().createFrameWrite(parameter.getType(), parameterNode, slot));
        }
        return formalParamInits;
    }

    private static boolean isStructByValue(FunctionParameter parameter) {
        if (parameter.getType() instanceof PointerType && parameter.getParameterAttribute() != null) {
            for (Attribute a : parameter.getParameterAttribute().getAttributes()) {
                if (!(a instanceof Attribute.KnownAttribute) || ((Attribute.KnownAttribute)a).getAttr() != Attribute.Kind.BYVAL) continue;
                return true;
            }
        }
        return false;
    }
}

