/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.functions.FunctionParameter;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.FunctionVisitor;
import com.oracle.truffle.llvm.parser.model.visitors.ValueInstructionVisitor;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class StackManager {
    private StackManager() {
    }

    public static FrameDescriptor createRootFrame() {
        FrameDescriptor rootFrame = new FrameDescriptor();
        rootFrame.addFrameSlot((Object)"<stackpointer>", (Object)PointerType.VOID, FrameSlotKind.Object);
        return rootFrame;
    }

    public static FrameDescriptor createFrame(FunctionDefinition function) {
        FrameDescriptor frame = new FrameDescriptor();
        frame.addFrameSlot((Object)"<function exception value>", null, FrameSlotKind.Object);
        frame.addFrameSlot((Object)"<stackpointer>", (Object)PointerType.VOID, FrameSlotKind.Object);
        for (FunctionParameter parameter : function.getParameters()) {
            Type type = parameter.getType();
            frame.addFrameSlot((Object)parameter.getName(), (Object)type, Type.getFrameSlotKind(type));
        }
        StackAllocationFunctionVisitor functionVisitor = new StackAllocationFunctionVisitor(frame);
        function.accept(functionVisitor);
        return frame;
    }

    private static final class StackAllocationFunctionVisitor
    extends ValueInstructionVisitor
    implements FunctionVisitor {
        private final FrameDescriptor frame;

        private StackAllocationFunctionVisitor(FrameDescriptor frame) {
            this.frame = frame;
        }

        @Override
        public void visitValueInstruction(ValueInstruction valueInstruction) {
            Type type = valueInstruction.getType();
            this.frame.addFrameSlot((Object)valueInstruction.getName(), (Object)type, Type.getFrameSlotKind(type));
        }

        @Override
        public void visit(InstructionBlock block) {
            block.accept(this);
        }
    }
}

